/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet;

import java.util.ArrayList;
import javax.swing.text.Segment;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.ide.config.Preferences;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.ScriptRunnerAbstractTextBuffer;
import oracle.javatools.data.PropertyStorage;

public class AppendQuickTextBuffer
extends ScriptRunnerAbstractTextBuffer {
    private static final int DEFAULT_INIT_SIZE = 51200;
    private static final float DEFAULT_GAP_SIZE = 0.2f;
    private static final int MINIMUM_GAP_SIZE = 64;
    private static final int MAXIMUM_GAP_SIZE = 512;
    private static final int MAXIMUM_OVERHEAD = 2048;
    private char[] gapBuffer;
    private int dataSize;
    private int gapOffset;
    private int gapSize;
    private ArrayList<Integer> chunkIndexes = new ArrayList();
    private int maxLines = 0;
    private boolean isLast = false;

    public AppendQuickTextBuffer(ReadWriteLock readWriteLock) {
        super(readWriteLock);
        this.init(51200);
    }

    private void init(int n) {
        this.gapSize = n;
        this.gapBuffer = new char[this.gapSize];
        this.dataSize = 0;
        this.gapOffset = 0;
        this.chunkIndexes = new ArrayList();
        Preferences preferences = Preferences.getPreferences();
        DBConfig dBConfig = DBConfig.getInstance((PropertyStorage)preferences);
        this.maxLines = dBConfig.getInt("MAXSCRIPTLINES");
    }

    private int calculateGapSize(int n) {
        int n2 = (int)((float)n * 0.2f);
        n2 = Math.max(n2, 64);
        return n2;
    }

    @Override
    public int getLength() {
        return this.dataSize;
    }

    @Override
    public char getChar(int n) throws IndexOutOfBoundsException {
        return n < this.gapOffset ? this.gapBuffer[n] : this.gapBuffer[n + this.gapSize];
    }

    @Override
    public char[] getCharsImpl(int n, int n2) throws IndexOutOfBoundsException {
        this.checkOffsets(n, n2);
        char[] cArray = new char[n2];
        int n3 = n;
        int n4 = n + n2;
        if (n4 <= this.gapOffset) {
            System.arraycopy(this.gapBuffer, n3, cArray, 0, n2);
        } else if (this.gapOffset <= n3) {
            System.arraycopy(this.gapBuffer, n3 + this.gapSize, cArray, 0, n2);
        } else {
            int n5 = this.gapOffset - n3;
            int n6 = n4 - this.gapOffset;
            System.arraycopy(this.gapBuffer, n3, cArray, 0, n5);
            System.arraycopy(this.gapBuffer, this.gapOffset + this.gapSize, cArray, n5, n6);
        }
        return cArray;
    }

    @Override
    protected String getStringImpl(int n, int n2) throws IndexOutOfBoundsException {
        if (n2 == 0) {
            if (n < 0) {
                throw new StringIndexOutOfBoundsException(n);
            }
            if (n > this.getLength()) {
                throw new StringIndexOutOfBoundsException(n);
            }
            return "";
        }
        this.checkOffsets(n, n2);
        int n3 = n;
        int n4 = n + n2;
        if (n4 <= this.gapOffset) {
            return new String(this.gapBuffer, n3, n2);
        }
        if (this.gapOffset <= n3) {
            return new String(this.gapBuffer, n3 + this.gapSize, n2);
        }
        char[] cArray = this.getCharsImpl(n, n2);
        return new String(cArray);
    }

    @Override
    public void getTextImpl(int n, int n2, Segment segment) throws IndexOutOfBoundsException {
        int n3 = n;
        int n4 = n + n2;
        if (n4 <= this.gapOffset) {
            segment.array = this.gapBuffer;
            segment.offset = n;
            segment.count = n2;
        } else if (this.gapOffset <= n3) {
            segment.array = this.gapBuffer;
            segment.offset = n + this.gapSize;
            segment.count = n2;
        } else {
            char[] cArray = this.getChars(n, n2);
            segment.array = cArray;
            segment.offset = 0;
            segment.count = n2;
        }
    }

    @Override
    protected int insertImpl(int n, char[] cArray, int n2, int n3) {
        if (n > this.dataSize) {
            throw new IndexOutOfBoundsException("insertImpl out ofbounds:  dataSize: " + this.dataSize + " offset: " + n);
        }
        this.chunkIndexes.add(n3);
        int n4 = this.dataSize + this.gapSize;
        int n5 = n3;
        int n6 = n5 + this.dataSize;
        char[] cArray2 = this.gapBuffer;
        int n7 = n4;
        int n8 = this.gapSize;
        int n9 = this.gapOffset;
        int n10 = n;
        int n11 = Math.min(n9, n10);
        int n12 = Math.max(n9, n10);
        if (this.isLastInsert() && this.getLineCount() > this.maxLines) {
            int n13 = this.getLineCount() - this.maxLines;
            int n14 = this.getLineMap().getLineEndOffset(n13);
            int n15 = this.shiftCharsLeftToMakeSpace(n14);
            this.isLast = false;
            return this.insertImpl(n - n15, cArray, n2, n3);
        }
        if (n5 > this.gapSize) {
            if (this.getLineCount() > this.maxLines && this.dataSize > n3) {
                int n16 = this.shiftCharsLeftToMakeSpace(n3);
                return this.insertImpl(n - n16, cArray, n2, n3);
            }
            n8 = this.calculateGapSize(n6) + n5;
            n7 = n8 + this.dataSize;
            cArray2 = new char[n7];
            System.arraycopy(this.gapBuffer, 0, cArray2, 0, n11);
            System.arraycopy(this.gapBuffer, n12 + this.gapSize, cArray2, n12 + n8, this.dataSize - n12);
        }
        if (n9 != n10) {
            int n17 = n12 - n11;
            if (n9 < n10) {
                System.arraycopy(this.gapBuffer, n11 + this.gapSize, cArray2, n11, n17);
            } else {
                System.arraycopy(this.gapBuffer, n11, cArray2, n11 + n8, n17);
            }
            this.gapOffset = n;
        }
        if (cArray != null) {
            System.arraycopy(cArray, n2, cArray2, this.gapOffset, n5);
        }
        this.gapOffset += n5;
        this.gapSize = n8 - n5;
        this.gapBuffer = cArray2;
        this.dataSize = n6;
        return n;
    }

    private int shiftCharsLeftToMakeSpace(int n) {
        int n2;
        char[] cArray = this.gapBuffer;
        for (n2 = 0; n2 < n; n2 += this.chunkIndexes.get(0).intValue()) {
            this.chunkIndexes.remove(0);
        }
        this.shiftCharsLeft(n2);
        return n2;
    }

    private int shiftCharsLeft(int n) {
        char[] cArray = this.gapBuffer;
        System.arraycopy(cArray, n, cArray, 0, cArray.length - n);
        this.removeFromLineMap(n);
        int n2 = this.gapOffset - n;
        this.gapOffset -= n;
        this.dataSize -= n;
        this.gapSize = this.gapSize + n - 1;
        for (int i = n2; i < this.gapBuffer.length; ++i) {
            this.gapBuffer[i] = '\u0000';
        }
        this.chunkIndexes.remove(this.chunkIndexes.size() - 1);
        return n;
    }

    @Override
    protected void removeImpl(int n, int n2) {
        this.checkOffsets(n, 1);
        int n3 = this.dataSize + this.gapSize;
        int n4 = n2;
        int n5 = this.gapOffset;
        int n6 = this.gapSize;
        int n7 = n;
        int n8 = n + n4;
        if (n8 < n5) {
            System.arraycopy(this.gapBuffer, n8, this.gapBuffer, n8 + n6, n5 - n8);
        } else if (n5 < n7) {
            System.arraycopy(this.gapBuffer, n5 + n6, this.gapBuffer, n5, n7 - n5);
        }
        this.gapOffset = n7;
        this.gapSize += n4;
        this.dataSize -= n4;
    }

    private void checkOffsets(int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > this.getLength()) {
            throw new IndexOutOfBoundsException("out of bounds: dataSize: " + this.getLength() + " offset: " + n + " length: " + n2);
        }
    }

    public void finish() {
        this.isLast = true;
    }

    private boolean isLastInsert() {
        return this.isLast;
    }
}

