/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jdesktop.animation.timing.interpolation.KeyValuesColor;
import org.jdesktop.animation.timing.interpolation.KeyValuesDimension;
import org.jdesktop.animation.timing.interpolation.KeyValuesDouble;
import org.jdesktop.animation.timing.interpolation.KeyValuesFloat;
import org.jdesktop.animation.timing.interpolation.KeyValuesInt;
import org.jdesktop.animation.timing.interpolation.KeyValuesPoint;
import org.jdesktop.animation.timing.interpolation.KeyValuesRectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KeyValues<T> {
    protected ArrayList<T> values = new ArrayList();
    protected Object startValue;

    protected KeyValues() {
    }

    protected KeyValues(Object[] values) {
        if (values.length == 1) {
            this.values.add(null);
        }
    }

    protected KeyValues(float[] values) {
        if (values.length == 1) {
            this.values.add(null);
        }
    }

    protected KeyValues(int[] values) {
        if (values.length == 1) {
            this.values.add(null);
        }
    }

    protected KeyValues(double[] values) {
        if (values.length == 1) {
            this.values.add(null);
        }
    }

    public int getSize() {
        return this.values.size();
    }

    public static KeyValues createKeyValues(int ... values) {
        return new KeyValuesInt(values);
    }

    public static KeyValues createKeyValues(float ... values) {
        return new KeyValuesFloat(values);
    }

    public static KeyValues createKeyValues(double ... values) {
        return new KeyValuesDouble(values);
    }

    public static KeyValues createKeyValues(Point ... values) {
        return new KeyValuesPoint(values);
    }

    public static KeyValues createKeyValues(Dimension ... values) {
        return new KeyValuesDimension(values);
    }

    public static KeyValues createKeyValues(Rectangle ... values) {
        return new KeyValuesRectangle(values);
    }

    public static KeyValues createKeyValues(Color ... values) {
        return new KeyValuesColor(values);
    }

    public abstract Class<?> getType();

    public void setStartValue(Object startValue) {
        if (this.isToAnimation()) {
            this.startValue = startValue;
        }
    }

    boolean isToAnimation() {
        return this.values.get(0) == null;
    }

    public abstract void setValue(Object var1, Method var2, int var3, int var4, float var5);

    public abstract void setValue(Object var1, Method var2, int var3);
}

