/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.util;

import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseContainer;
import oracle.bali.jle.tool.undo.MoveUndo;
import oracle.bali.jle.tool.undo.ResizeUndo;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.ewt.undo.CompoundEdit;
import oracle.ewt.undo.UndoableEdit;
import oracle.ewt.undo.UndoableEditEvent;

public class AlignmentUtils {
    private static LevelComparator _sComparator = new LevelComparator();
    static /* synthetic */ Class class$oracle$bali$jle$util$AlignmentUtils;

    private AlignmentUtils() {
    }

    public static void alignLeft(LayoutItem[] layoutItemArray) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        if (layoutItemArray.length <= 1) {
            return;
        }
        LayoutItem layoutItem = null;
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < layoutItemArray.length) {
            Rectangle2D rectangle2D;
            double d2;
            LayoutItem layoutItem2;
            LayoutItem layoutItem3 = layoutItemArray[n];
            if (layoutItem3 != null && (layoutItem2 = layoutItem3.getItemParent()) != null && (d2 = (rectangle2D = ItemUtils.itemToDeviceDouble(layoutItem2, layoutItem3.getItemBounds())).getX()) < d) {
                d = d2;
                layoutItem = layoutItem3;
            }
            ++n;
        }
        if (layoutItem != null) {
            AlignmentUtils.alignLeft(layoutItemArray, layoutItem);
        }
    }

    public static void alignLeft(LayoutItem[] layoutItemArray, LayoutItem layoutItem) {
        if (layoutItemArray == null || layoutItem == null) {
            throw new IllegalArgumentException();
        }
        LayoutItem layoutItem2 = layoutItem.getItemParent();
        JLECanvas jLECanvas = layoutItem.getCanvas();
        boolean bl = jLECanvas.hasUndoableEditListeners();
        if (layoutItem2 == null) {
            return;
        }
        Rectangle2D rectangle2D = ItemUtils.itemToDeviceDouble(layoutItem2, layoutItem.getItemBounds());
        double d = rectangle2D.getX();
        layoutItemArray = AlignmentUtils._sortByLevel(layoutItemArray);
        CompoundEdit compoundEdit = bl && layoutItemArray.length > 1 ? new CompoundEdit() : null;
        int n = 0;
        while (n < layoutItemArray.length) {
            LayoutItem layoutItem3 = layoutItemArray[n];
            if (layoutItem3 != layoutItem) {
                LayoutItem layoutItem4 = layoutItem3.getItemParent();
                Point2D point2D = layoutItem3.getItemLocation();
                Point2D point2D2 = ItemUtils.deviceToItem(layoutItem4, d, point2D.getY());
                layoutItem3.setItemLocation(point2D2.getX(), point2D.getY());
                if (compoundEdit != null) {
                    compoundEdit = AlignmentUtils._addToMoveUndo((UndoableEdit)compoundEdit, layoutItem3, layoutItemArray.length > 1, point2D2.getX() - point2D.getX(), 0.0);
                }
            }
            ++n;
        }
        AlignmentUtils._postEditAndCleanup(bl, (UndoableEdit)compoundEdit, layoutItemArray.length > 1, jLECanvas);
    }

    public static void alignRight(LayoutItem[] layoutItemArray) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        if (layoutItemArray.length <= 1) {
            return;
        }
        LayoutItem layoutItem = null;
        double d = Double.MIN_VALUE;
        int n = 0;
        while (n < layoutItemArray.length) {
            Rectangle2D rectangle2D;
            double d2;
            LayoutItem layoutItem2;
            LayoutItem layoutItem3 = layoutItemArray[n];
            if (layoutItem3 != null && (layoutItem2 = layoutItem3.getItemParent()) != null && (d2 = (rectangle2D = ItemUtils.itemToDeviceDouble(layoutItem2, layoutItem3.getItemBounds())).getX() + rectangle2D.getWidth()) > d) {
                d = d2;
                layoutItem = layoutItem3;
            }
            ++n;
        }
        if (layoutItem != null) {
            AlignmentUtils.alignRight(layoutItemArray, layoutItem);
        }
    }

    public static void alignRight(LayoutItem[] layoutItemArray, LayoutItem layoutItem) {
        if (layoutItemArray == null || layoutItem == null) {
            throw new IllegalArgumentException();
        }
        LayoutItem layoutItem2 = layoutItem.getItemParent();
        JLECanvas jLECanvas = layoutItem.getCanvas();
        boolean bl = jLECanvas.hasUndoableEditListeners();
        if (layoutItem2 == null) {
            return;
        }
        Rectangle2D rectangle2D = ItemUtils.itemToDeviceDouble(layoutItem2, layoutItem.getItemBounds());
        double d = rectangle2D.getX() + rectangle2D.getWidth();
        layoutItemArray = AlignmentUtils._sortByLevel(layoutItemArray);
        CompoundEdit compoundEdit = bl && layoutItemArray.length > 1 ? new CompoundEdit() : null;
        int n = 0;
        while (n < layoutItemArray.length) {
            LayoutItem layoutItem3 = layoutItemArray[n];
            if (layoutItem3 != layoutItem) {
                LayoutItem layoutItem4 = layoutItem3.getItemParent();
                Point2D point2D = layoutItem3.getItemLocation();
                Dimension2D dimension2D = ItemUtils.itemToDeviceDouble(layoutItem4, layoutItem3.getItemSize());
                Point2D point2D2 = ItemUtils.deviceToItem(layoutItem4, d - dimension2D.getWidth(), 0.0);
                layoutItem3.setItemLocation(point2D2.getX(), point2D.getY());
                if (compoundEdit != null) {
                    compoundEdit = AlignmentUtils._addToMoveUndo((UndoableEdit)compoundEdit, layoutItem3, layoutItemArray.length > 1, point2D2.getX() - point2D.getX(), 0.0);
                }
            }
            ++n;
        }
        AlignmentUtils._postEditAndCleanup(bl, (UndoableEdit)compoundEdit, layoutItemArray.length > 1, jLECanvas);
    }

    public static void alignHorizontalCenter(LayoutItem[] layoutItemArray) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        if (layoutItemArray.length <= 1) {
            return;
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        int n = 0;
        while (n < layoutItemArray.length) {
            LayoutItem layoutItem;
            LayoutItem layoutItem2 = layoutItemArray[n];
            if (layoutItem2 != null && (layoutItem = layoutItem2.getItemParent()) != null) {
                double d3;
                Rectangle2D rectangle2D = ItemUtils.itemToDeviceDouble(layoutItem, layoutItem2.getItemBounds());
                double d4 = rectangle2D.getX();
                if (d4 < d) {
                    d = d4;
                }
                if ((d3 = rectangle2D.getX() + rectangle2D.getWidth()) > d2) {
                    d2 = d3;
                }
            }
            ++n;
        }
        AlignmentUtils.alignHorizontalCenter(layoutItemArray, (d + d2) / 2.0);
    }

    public static void alignHorizontalCenter(LayoutItem[] layoutItemArray, double d) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        JLECanvas jLECanvas = layoutItemArray[0].getCanvas();
        boolean bl = jLECanvas.hasUndoableEditListeners();
        layoutItemArray = AlignmentUtils._sortByLevel(layoutItemArray);
        CompoundEdit compoundEdit = bl && layoutItemArray.length > 1 ? new CompoundEdit() : null;
        int n = 0;
        while (n < layoutItemArray.length) {
            LayoutItem layoutItem = layoutItemArray[n];
            LayoutItem layoutItem2 = layoutItem.getItemParent();
            Rectangle2D rectangle2D = layoutItem.getItemBounds();
            Rectangle2D rectangle2D2 = ItemUtils.itemToDeviceDouble(layoutItem2, rectangle2D);
            double d2 = d - (rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0);
            Point2D point2D = ItemUtils.deviceToItem(layoutItem2, rectangle2D2.getX() + d2, 0.0);
            layoutItem.setItemLocation(point2D.getX(), rectangle2D.getY());
            if (compoundEdit != null) {
                compoundEdit = AlignmentUtils._addToMoveUndo((UndoableEdit)compoundEdit, layoutItem, layoutItemArray.length > 1, point2D.getX() - rectangle2D.getX(), 0.0);
            }
            ++n;
        }
        AlignmentUtils._postEditAndCleanup(bl, (UndoableEdit)compoundEdit, layoutItemArray.length > 1, jLECanvas);
    }

    public static void alignTop(LayoutItem[] layoutItemArray) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        if (layoutItemArray.length <= 1) {
            return;
        }
        LayoutItem layoutItem = null;
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < layoutItemArray.length) {
            Rectangle2D rectangle2D;
            double d2;
            LayoutItem layoutItem2;
            LayoutItem layoutItem3 = layoutItemArray[n];
            if (layoutItem3 != null && (layoutItem2 = layoutItem3.getItemParent()) != null && (d2 = (rectangle2D = ItemUtils.itemToDeviceDouble(layoutItem2, layoutItem3.getItemBounds())).getY()) < d) {
                d = d2;
                layoutItem = layoutItem3;
            }
            ++n;
        }
        if (layoutItem != null) {
            AlignmentUtils.alignTop(layoutItemArray, layoutItem);
        }
    }

    public static void alignTop(LayoutItem[] layoutItemArray, LayoutItem layoutItem) {
        if (layoutItemArray == null || layoutItem == null) {
            throw new IllegalArgumentException();
        }
        LayoutItem layoutItem2 = layoutItem.getItemParent();
        JLECanvas jLECanvas = layoutItem.getCanvas();
        boolean bl = jLECanvas.hasUndoableEditListeners();
        if (layoutItem2 == null) {
            return;
        }
        Rectangle2D rectangle2D = ItemUtils.itemToDeviceDouble(layoutItem2, layoutItem.getItemBounds());
        double d = rectangle2D.getY();
        layoutItemArray = AlignmentUtils._sortByLevel(layoutItemArray);
        CompoundEdit compoundEdit = bl && layoutItemArray.length > 1 ? new CompoundEdit() : null;
        int n = 0;
        while (n < layoutItemArray.length) {
            LayoutItem layoutItem3 = layoutItemArray[n];
            if (layoutItem3 != layoutItem) {
                LayoutItem layoutItem4 = layoutItem3.getItemParent();
                Point2D point2D = layoutItem3.getItemLocation();
                Point2D point2D2 = ItemUtils.deviceToItem(layoutItem4, point2D.getX(), d);
                layoutItem3.setItemLocation(point2D.getX(), point2D2.getY());
                if (compoundEdit != null) {
                    compoundEdit = AlignmentUtils._addToMoveUndo((UndoableEdit)compoundEdit, layoutItem3, layoutItemArray.length > 1, 0.0, point2D2.getY() - point2D.getY());
                }
            }
            ++n;
        }
        AlignmentUtils._postEditAndCleanup(bl, (UndoableEdit)compoundEdit, layoutItemArray.length > 1, jLECanvas);
    }

    public static void alignBottom(LayoutItem[] layoutItemArray) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        if (layoutItemArray.length <= 1) {
            return;
        }
        LayoutItem layoutItem = null;
        double d = Double.MIN_VALUE;
        int n = 0;
        while (n < layoutItemArray.length) {
            Rectangle2D rectangle2D;
            double d2;
            LayoutItem layoutItem2;
            LayoutItem layoutItem3 = layoutItemArray[n];
            if (layoutItem3 != null && (layoutItem2 = layoutItem3.getItemParent()) != null && (d2 = (rectangle2D = ItemUtils.itemToDeviceDouble(layoutItem2, layoutItem3.getItemBounds())).getY() + rectangle2D.getHeight()) > d) {
                d = d2;
                layoutItem = layoutItem3;
            }
            ++n;
        }
        if (layoutItem != null) {
            AlignmentUtils.alignBottom(layoutItemArray, layoutItem);
        }
    }

    public static void alignBottom(LayoutItem[] layoutItemArray, LayoutItem layoutItem) {
        if (layoutItemArray == null || layoutItem == null) {
            throw new IllegalArgumentException();
        }
        LayoutItem layoutItem2 = layoutItem.getItemParent();
        JLECanvas jLECanvas = layoutItem.getCanvas();
        boolean bl = jLECanvas.hasUndoableEditListeners();
        if (layoutItem2 == null) {
            return;
        }
        Rectangle2D rectangle2D = ItemUtils.itemToDeviceDouble(layoutItem2, layoutItem.getItemBounds());
        double d = rectangle2D.getY() + rectangle2D.getHeight();
        layoutItemArray = AlignmentUtils._sortByLevel(layoutItemArray);
        CompoundEdit compoundEdit = bl && layoutItemArray.length > 1 ? new CompoundEdit() : null;
        int n = 0;
        while (n < layoutItemArray.length) {
            LayoutItem layoutItem3 = layoutItemArray[n];
            if (layoutItem3 != layoutItem) {
                LayoutItem layoutItem4 = layoutItem3.getItemParent();
                Point2D point2D = layoutItem3.getItemLocation();
                Dimension2D dimension2D = ItemUtils.itemToDeviceDouble(layoutItem4, layoutItem3.getItemSize());
                Point2D point2D2 = ItemUtils.deviceToItem(layoutItem4, 0.0, d - dimension2D.getHeight());
                layoutItem3.setItemLocation(point2D.getX(), point2D2.getY());
                if (compoundEdit != null) {
                    compoundEdit = AlignmentUtils._addToMoveUndo((UndoableEdit)compoundEdit, layoutItem3, layoutItemArray.length > 1, 0.0, point2D2.getY() - point2D.getY());
                }
            }
            ++n;
        }
        AlignmentUtils._postEditAndCleanup(bl, (UndoableEdit)compoundEdit, layoutItemArray.length > 1, jLECanvas);
    }

    public static void alignVerticalCenter(LayoutItem[] layoutItemArray) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        if (layoutItemArray.length <= 1) {
            return;
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        int n = 0;
        while (n < layoutItemArray.length) {
            LayoutItem layoutItem;
            LayoutItem layoutItem2 = layoutItemArray[n];
            if (layoutItem2 != null && (layoutItem = layoutItem2.getItemParent()) != null) {
                double d3;
                Rectangle2D rectangle2D = ItemUtils.itemToDeviceDouble(layoutItem, layoutItem2.getItemBounds());
                double d4 = rectangle2D.getY();
                if (d4 < d) {
                    d = d4;
                }
                if ((d3 = rectangle2D.getY() + rectangle2D.getHeight()) > d2) {
                    d2 = d3;
                }
            }
            ++n;
        }
        AlignmentUtils.alignVerticalCenter(layoutItemArray, (d + d2) / 2.0);
    }

    public static void alignVerticalCenter(LayoutItem[] layoutItemArray, double d) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        JLECanvas jLECanvas = layoutItemArray[0].getCanvas();
        boolean bl = jLECanvas.hasUndoableEditListeners();
        layoutItemArray = AlignmentUtils._sortByLevel(layoutItemArray);
        CompoundEdit compoundEdit = bl && layoutItemArray.length > 1 ? new CompoundEdit() : null;
        int n = 0;
        while (n < layoutItemArray.length) {
            LayoutItem layoutItem = layoutItemArray[n];
            LayoutItem layoutItem2 = layoutItem.getItemParent();
            Rectangle2D rectangle2D = layoutItem.getItemBounds();
            Rectangle2D rectangle2D2 = ItemUtils.itemToDeviceDouble(layoutItem2, rectangle2D);
            double d2 = d - (rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0);
            Point2D point2D = ItemUtils.deviceToItem(layoutItem2, 0.0, rectangle2D2.getY() + d2);
            layoutItem.setItemLocation(rectangle2D.getX(), point2D.getY());
            if (compoundEdit != null) {
                compoundEdit = AlignmentUtils._addToMoveUndo((UndoableEdit)compoundEdit, layoutItem, layoutItemArray.length > 1, 0.0, point2D.getY() - rectangle2D.getY());
            }
            ++n;
        }
        AlignmentUtils._postEditAndCleanup(bl, (UndoableEdit)compoundEdit, layoutItemArray.length > 1, jLECanvas);
    }

    public static void resizeSmallestWidth(LayoutItem[] layoutItemArray) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        JLECanvas jLECanvas = layoutItemArray[0].getCanvas();
        boolean bl = jLECanvas.hasUndoableEditListeners();
        CompoundEdit compoundEdit = bl && layoutItemArray.length > 1 ? new CompoundEdit() : null;
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < layoutItemArray.length) {
            double d2;
            LayoutItem layoutItem;
            LayoutItem layoutItem2 = layoutItemArray[n];
            if (layoutItem2 != null && (layoutItem = layoutItem2.getItemParent()) != null && (d2 = ItemUtils.itemToDeviceDouble(layoutItem, layoutItem2.getItemSize()).getWidth()) < d) {
                d = d2;
            }
            ++n;
        }
        compoundEdit = AlignmentUtils._resizeAndAddToEdit((UndoableEdit)compoundEdit, layoutItemArray, d, Double.MAX_VALUE);
        AlignmentUtils._postEditAndCleanup(bl, (UndoableEdit)compoundEdit, layoutItemArray.length > 1, jLECanvas);
    }

    public static void resizeLargestWidth(LayoutItem[] layoutItemArray) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        JLECanvas jLECanvas = layoutItemArray[0].getCanvas();
        boolean bl = jLECanvas.hasUndoableEditListeners();
        CompoundEdit compoundEdit = bl && layoutItemArray.length > 1 ? new CompoundEdit() : null;
        double d = Double.MIN_VALUE;
        int n = 0;
        while (n < layoutItemArray.length) {
            double d2;
            LayoutItem layoutItem;
            LayoutItem layoutItem2 = layoutItemArray[n];
            if (layoutItem2 != null && (layoutItem = layoutItem2.getItemParent()) != null && (d2 = ItemUtils.itemToDeviceDouble(layoutItem, layoutItem2.getItemSize()).getWidth()) > d) {
                d = d2;
            }
            ++n;
        }
        compoundEdit = AlignmentUtils._resizeAndAddToEdit((UndoableEdit)compoundEdit, layoutItemArray, d, Double.MAX_VALUE);
        AlignmentUtils._postEditAndCleanup(bl, (UndoableEdit)compoundEdit, layoutItemArray.length > 1, jLECanvas);
    }

    public static void resizeAverageWidth(LayoutItem[] layoutItemArray) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        JLECanvas jLECanvas = layoutItemArray[0].getCanvas();
        boolean bl = jLECanvas.hasUndoableEditListeners();
        CompoundEdit compoundEdit = bl && layoutItemArray.length > 1 ? new CompoundEdit() : null;
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < layoutItemArray.length) {
            LayoutItem layoutItem;
            LayoutItem layoutItem2 = layoutItemArray[n2];
            if (layoutItem2 != null && (layoutItem = layoutItem2.getItemParent()) != null) {
                double d2 = ItemUtils.itemToDeviceDouble(layoutItem, layoutItem2.getItemSize()).getWidth();
                d += d2;
                ++n;
            }
            ++n2;
        }
        compoundEdit = AlignmentUtils._resizeAndAddToEdit((UndoableEdit)compoundEdit, layoutItemArray, d /= (double)n, Double.MAX_VALUE);
        AlignmentUtils._postEditAndCleanup(bl, (UndoableEdit)compoundEdit, layoutItemArray.length > 1, jLECanvas);
    }

    public static void resizeSmallestHeight(LayoutItem[] layoutItemArray) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        JLECanvas jLECanvas = layoutItemArray[0].getCanvas();
        boolean bl = jLECanvas.hasUndoableEditListeners();
        CompoundEdit compoundEdit = bl && layoutItemArray.length > 1 ? new CompoundEdit() : null;
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < layoutItemArray.length) {
            double d2;
            LayoutItem layoutItem;
            LayoutItem layoutItem2 = layoutItemArray[n];
            if (layoutItem2 != null && (layoutItem = layoutItem2.getItemParent()) != null && (d2 = ItemUtils.itemToDeviceDouble(layoutItem, layoutItem2.getItemSize()).getHeight()) < d) {
                d = d2;
            }
            ++n;
        }
        compoundEdit = AlignmentUtils._resizeAndAddToEdit((UndoableEdit)compoundEdit, layoutItemArray, Double.MAX_VALUE, d);
        AlignmentUtils._postEditAndCleanup(bl, (UndoableEdit)compoundEdit, layoutItemArray.length > 1, jLECanvas);
    }

    public static void resizeLargestHeight(LayoutItem[] layoutItemArray) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        JLECanvas jLECanvas = layoutItemArray[0].getCanvas();
        boolean bl = jLECanvas.hasUndoableEditListeners();
        CompoundEdit compoundEdit = bl && layoutItemArray.length > 1 ? new CompoundEdit() : null;
        double d = Double.MIN_VALUE;
        int n = 0;
        while (n < layoutItemArray.length) {
            double d2;
            LayoutItem layoutItem;
            LayoutItem layoutItem2 = layoutItemArray[n];
            if (layoutItem2 != null && (layoutItem = layoutItem2.getItemParent()) != null && (d2 = ItemUtils.itemToDeviceDouble(layoutItem, layoutItem2.getItemSize()).getHeight()) > d) {
                d = d2;
            }
            ++n;
        }
        compoundEdit = AlignmentUtils._resizeAndAddToEdit((UndoableEdit)compoundEdit, layoutItemArray, Double.MAX_VALUE, d);
        AlignmentUtils._postEditAndCleanup(bl, (UndoableEdit)compoundEdit, layoutItemArray.length > 1, jLECanvas);
    }

    public static void resizeAverageHeight(LayoutItem[] layoutItemArray) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        JLECanvas jLECanvas = layoutItemArray[0].getCanvas();
        boolean bl = jLECanvas.hasUndoableEditListeners();
        CompoundEdit compoundEdit = bl && layoutItemArray.length > 1 ? new CompoundEdit() : null;
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < layoutItemArray.length) {
            LayoutItem layoutItem;
            LayoutItem layoutItem2 = layoutItemArray[n2];
            if (layoutItem2 != null && (layoutItem = layoutItem2.getItemParent()) != null) {
                double d2 = ItemUtils.itemToDeviceDouble(layoutItem, layoutItem2.getItemSize()).getHeight();
                d += d2;
                ++n;
            }
            ++n2;
        }
        compoundEdit = AlignmentUtils._resizeAndAddToEdit((UndoableEdit)compoundEdit, layoutItemArray, Double.MAX_VALUE, d /= (double)n);
        AlignmentUtils._postEditAndCleanup(bl, (UndoableEdit)compoundEdit, layoutItemArray.length > 1, jLECanvas);
    }

    public static void moveToFront(LayoutItem layoutItem) {
        if (layoutItem == null) {
            return;
        }
        LayoutItem layoutItem2 = layoutItem.getItemParent();
        if (layoutItem2 == null) {
            return;
        }
        layoutItem2.removeItem(layoutItem);
        layoutItem2.addItem(layoutItem, 0);
    }

    public static void moveToBack(LayoutItem layoutItem) {
        if (layoutItem == null) {
            return;
        }
        LayoutItem layoutItem2 = layoutItem.getItemParent();
        if (layoutItem2 == null) {
            return;
        }
        layoutItem2.removeItem(layoutItem);
        layoutItem2.addItem(layoutItem, -1);
    }

    public static void moveForward(LayoutItem layoutItem) {
        if (layoutItem == null) {
            return;
        }
        LayoutItem layoutItem2 = layoutItem.getItemParent();
        if (layoutItem2 == null) {
            return;
        }
        int n = ItemUtils.getItemIndex(layoutItem, layoutItem2);
        if (n <= 0) {
            return;
        }
        layoutItem2.removeItem(layoutItem);
        layoutItem2.addItem(layoutItem, n - 1);
    }

    public static void moveBackward(LayoutItem layoutItem) {
        int n;
        if (layoutItem == null) {
            return;
        }
        LayoutItem layoutItem2 = layoutItem.getItemParent();
        if (layoutItem2 == null) {
            return;
        }
        int n2 = ItemUtils.getItemIndex(layoutItem, layoutItem2);
        if (n2 >= (n = layoutItem2.getItemCount()) - 1) {
            return;
        }
        layoutItem2.removeItem(layoutItem);
        layoutItem2.addItem(layoutItem, n2 + 1);
    }

    private static UndoableEdit _addToMoveUndo(UndoableEdit object, LayoutItem layoutItem, boolean bl, double d, double d2) {
        MoveUndo moveUndo = new MoveUndo(layoutItem, d, d2, null);
        if (bl) {
            object.addEdit((UndoableEdit)moveUndo);
        } else {
            object = moveUndo;
        }
        return object;
    }

    private static UndoableEdit _resizeAndAddToEdit(UndoableEdit object, LayoutItem[] layoutItemArray, double d, double d2) {
        boolean bl = d != Double.MAX_VALUE;
        boolean bl2 = d2 != Double.MAX_VALUE;
        int n = 0;
        while (n < layoutItemArray.length) {
            LayoutItem layoutItem;
            LayoutItem layoutItem2 = layoutItemArray[n];
            if (layoutItem2 != null && (layoutItem = layoutItem2.getItemParent()) != null) {
                Dimension2D dimension2D = layoutItem2.getItemSize();
                Dimension2D dimension2D2 = ItemUtils.deviceToItem(layoutItem, new Dimension2D.Double(bl ? d : dimension2D.getWidth(), bl2 ? d2 : dimension2D.getHeight()));
                layoutItem2.setItemSize(bl ? dimension2D2.getWidth() : dimension2D.getWidth(), bl2 ? dimension2D2.getHeight() : dimension2D.getHeight());
                ResizeUndo resizeUndo = new ResizeUndo(layoutItem2, dimension2D);
                if (layoutItemArray.length > 1) {
                    object.addEdit((UndoableEdit)resizeUndo);
                } else {
                    object = resizeUndo;
                }
            }
            ++n;
        }
        return object;
    }

    private static void _postEditAndCleanup(boolean bl, UndoableEdit undoableEdit, boolean bl2, JLECanvas jLECanvas) {
        if (bl) {
            if (bl2) {
                ((CompoundEdit)undoableEdit).end();
            }
            if (undoableEdit != null) {
                jLECanvas.processUndoableEditEvent(new UndoableEditEvent((Object)(class$oracle$bali$jle$util$AlignmentUtils == null ? (class$oracle$bali$jle$util$AlignmentUtils = AlignmentUtils.class$("oracle.bali.jle.util.AlignmentUtils")) : class$oracle$bali$jle$util$AlignmentUtils), undoableEdit));
            }
        }
        jLECanvas.repaintInterior();
    }

    private static LayoutItem[] _sortByLevel(LayoutItem[] layoutItemArray) {
        Object object;
        Object[] objectArray = new ItemLevel[layoutItemArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < layoutItemArray.length) {
            if (layoutItemArray[n2] != null && ((ItemLevel)(object = new ItemLevel(layoutItemArray[n2]))).getLevel() >= 0) {
                objectArray[n] = object;
                ++n;
            }
            ++n2;
        }
        Sort.qSort((Object[])objectArray, (int)n, (Comparator)_sComparator);
        object = new LayoutItem[n];
        int n3 = 0;
        while (n3 < n) {
            object[n3] = ((ItemLevel)objectArray[n3]).getItem();
            ++n3;
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ItemLevel {
        LayoutItem _item;
        int _level;

        ItemLevel(LayoutItem layoutItem) {
            this._item = layoutItem;
            BaseContainer baseContainer = layoutItem.getCanvas().getContentItem();
            int n = 0;
            while (layoutItem != baseContainer && layoutItem != null) {
                layoutItem = layoutItem.getItemParent();
                ++n;
            }
            this._level = layoutItem == null ? -1 : n;
        }

        LayoutItem getItem() {
            return this._item;
        }

        int getLevel() {
            return this._level;
        }
    }

    static class LevelComparator
    implements Comparator {
        LevelComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2 = ((ItemLevel)object).getLevel();
            if (n2 < (n = ((ItemLevel)object2).getLevel())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }
    }
}

