/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool.undo;

import java.awt.Rectangle;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.tool.BoundsPainter;
import oracle.bali.jle.tool.BoundsTool;
import oracle.bali.jle.tool.ControlPoint;
import oracle.bali.jle.tool.undo.LocalizedEdit;
import oracle.bali.jle.util.ItemUtils;

public class ResizeUndo
extends LocalizedEdit {
    private LayoutItem _resized;
    private double _dx;
    private double _dy;
    private ControlPoint _undoPoint;
    private ControlPoint _redoPoint;
    private BoundsTool _tool;
    private Dimension2D _size;

    public ResizeUndo(LayoutItem layoutItem, double d, double d2, ControlPoint controlPoint, BoundsTool boundsTool) {
        this(layoutItem, d, d2, controlPoint, controlPoint, boundsTool);
    }

    public ResizeUndo(LayoutItem layoutItem, double d, double d2, ControlPoint controlPoint, ControlPoint controlPoint2, BoundsTool boundsTool) {
        if (layoutItem == null || boundsTool == null) {
            throw new IllegalArgumentException();
        }
        this._resized = layoutItem;
        this._dx = d;
        this._dy = d2;
        this._undoPoint = controlPoint;
        this._redoPoint = controlPoint2;
        this._tool = boundsTool;
    }

    public ResizeUndo(LayoutItem layoutItem, Dimension2D dimension2D) {
        this._resized = layoutItem;
        this._size = dimension2D;
    }

    public void undo() {
        super.undo();
        if (this._tool != null) {
            Rectangle rectangle = ItemUtils.parentToDevice(this._resized, this._resized.getItemBounds());
            this._tool.processResize(this._resized, -this._dx, -this._dy, this._undoPoint);
            this._repaintOldLocation(rectangle);
        } else {
            Dimension2D dimension2D = this._resized.getItemSize();
            this._resized.setItemSize(this._size.getWidth(), this._size.getHeight());
            this._size = dimension2D;
            this._resized.getCanvas().repaintInterior();
        }
    }

    public void redo() {
        super.redo();
        if (this._tool != null) {
            Rectangle rectangle = ItemUtils.parentToDevice(this._resized, this._resized.getItemBounds());
            this._tool.processResize(this._resized, this._dx, this._dy, this._redoPoint);
            this._repaintOldLocation(rectangle);
        } else {
            Dimension2D dimension2D = this._resized.getItemSize();
            this._resized.setItemSize(this._size.getWidth(), this._size.getHeight());
            this._size = dimension2D;
            this._resized.getCanvas().repaintInterior();
        }
    }

    public void die() {
        super.die();
        this._resized = null;
        this._undoPoint = null;
        this._redoPoint = null;
        this._tool = null;
        this._size = null;
    }

    public String getBaseKey() {
        return "RESIZE";
    }

    public LayoutItem getResizedItem() {
        return this._resized;
    }

    private void _repaintOldLocation(Rectangle rectangle) {
        BoundsPainter boundsPainter = this._tool.getBoundsPainter();
        int n = boundsPainter.getControlPointWidth() / 2 + 1;
        int n2 = boundsPainter.getControlPointHeight() / 2 + 1;
        this._tool.getCanvas().repaintInterior(rectangle.x - n, rectangle.y - n2, rectangle.width + n * 2, rectangle.height + n2 * 2);
    }
}

