/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.jle.JLEAutoScroller;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.DefaultLinkPort;
import oracle.bali.jle.item.LinkItem;
import oracle.bali.jle.item.LinkPort;
import oracle.bali.jle.item.TwoPortLinkItem;
import oracle.bali.jle.tool.BaseTool;
import oracle.bali.jle.tool.LinkToolEvent;
import oracle.bali.jle.tool.LinkToolListener;
import oracle.bali.jle.tool.LinkToolValidateEvent;
import oracle.bali.jle.tool.undo.LinkUndo;
import oracle.bali.jle.util.GeometryUtils;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.collection.StringKey;
import oracle.ewt.event.Cancelable;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.undo.UndoableEdit;
import oracle.ewt.undo.UndoableEditEvent;

public class LinkTool
extends BaseTool {
    public static final Object REJECT_LINK_KEY = new StringKey("REJECT_LINK_KEY");
    public static final Object LINK_PORTS_KEY = new StringKey("LINK_PORTS_KEY");
    private double _startX;
    private double _startY;
    private double _endX;
    private double _endY;
    private boolean _linking;
    private LayoutItem _source;
    private Point2D _srcPt;
    private ListenerManager _listeners;
    private boolean _postUndo;
    private boolean _autoscrolling;

    public void drawHighlight(Graphics graphics) {
        if (this._linking && !this._autoscrolling) {
            JLECanvas jLECanvas = this.getCanvas();
            Point point = jLECanvas.contentToDevice(this._startX, this._startY);
            Point point2 = jLECanvas.contentToDevice(this._endX, this._endY);
            Color color = graphics.getColor();
            graphics.setColor(Color.black);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
            graphics.setColor(color);
        }
    }

    public long getDefaultEnabledEvents() {
        return 56L;
    }

    public void pickup(JLECanvas jLECanvas, JLEEventSource jLEEventSource) {
        super.pickup(jLECanvas, jLEEventSource);
        this._endY = 0.0;
        this._startY = 0.0;
        this._endX = 0.0;
        this._startX = 0.0;
        this._autoscrolling = false;
        this._linking = false;
        this._postUndo = jLECanvas.hasUndoableEditListeners();
    }

    public void drop() {
        this._autoscrolling = false;
        this._postUndo = false;
        JLEAutoScroller.getJLEAutoScroller().cancel();
        super.drop();
    }

    protected void processMousePressed(JLEEvent jLEEvent) {
        if (!this.isPrimaryMouseEvent(jLEEvent)) {
            return;
        }
        JLECanvas jLECanvas = this.getCanvas();
        this._startX = this._endX = jLEEvent.getX();
        this._startY = this._endY = jLEEvent.getY();
        LayoutItem layoutItem = jLECanvas.getHitItem(this._startX, this._startY);
        if (layoutItem != null) {
            this._srcPt = jLECanvas.contentToDeviceDouble(this._startX, this._startY);
            this._srcPt = ItemUtils.deviceToItem(layoutItem, this._srcPt);
            if (!this.isValidLinkSource(layoutItem, this._srcPt)) {
                return;
            }
            this._source = layoutItem;
            jLEEvent.consume();
        }
    }

    protected void processMouseReleased(JLEEvent jLEEvent) {
        JLEAutoScroller.getJLEAutoScroller().cancel();
        this._autoscrolling = false;
        JLECanvas jLECanvas = this.getCanvas();
        if (this._source != null) {
            LayoutItem layoutItem = jLECanvas.getHitItem(this._endX, this._endY);
            while (layoutItem != null && !LinkTool.isLinkable(layoutItem)) {
                layoutItem = layoutItem.getItemParent();
            }
            if (layoutItem != null && layoutItem != this._source && layoutItem.getItemParent() != null) {
                boolean bl;
                Point2D point2D = jLECanvas.contentToDeviceDouble(this._endX, this._endY);
                if (this.isValidLinkDestination(layoutItem, point2D = ItemUtils.deviceToItem(layoutItem, point2D), this._source, this._srcPt) && (bl = this.fireLinkToolEvent(1, null, this._source, this._srcPt, layoutItem, point2D))) {
                    LinkItem linkItem = this.processLink(this._source, layoutItem, this._srcPt, point2D);
                    if (this._postUndo) {
                        LinkUndo linkUndo = new LinkUndo(linkItem, this._source, this._srcPt, layoutItem, point2D, this);
                        jLECanvas.processUndoableEditEvent(new UndoableEditEvent((Object)this, (UndoableEdit)linkUndo));
                    }
                    this.fireLinkToolEvent(2, linkItem, this._source, this._srcPt, layoutItem, point2D);
                    linkItem.repaintItem();
                }
            }
        }
        this._linking = false;
        this._source = null;
        this._srcPt = null;
        this._endY = 0.0;
        this._endX = 0.0;
        this._startY = 0.0;
        this._startX = 0.0;
        this.updateImmediately();
    }

    protected void processMouseDragged(JLEEvent jLEEvent) {
        Object object;
        if (!this.isPrimaryMouseEvent(jLEEvent)) {
            return;
        }
        this._linking = this._source != null;
        this._endX = jLEEvent.getX();
        this._endY = jLEEvent.getY();
        if (this._linking && this._listeners != null) {
            object = this.getCanvas();
            this._autoscrolling = JLEAutoScroller.getJLEAutoScroller().checkAutoScroll((JLECanvas)object, jLEEvent);
            LayoutItem layoutItem = ((JLECanvas)object).getHitItem(this._endX, this._endY);
            Point2D point2D = null;
            if (layoutItem != null && layoutItem != this._source) {
                point2D = ((JLECanvas)object).contentToDeviceDouble(this._endX, this._endY);
                point2D = ItemUtils.deviceToItem(layoutItem, point2D);
            }
            this.fireLinkToolEvent(3, null, this._source, this._srcPt, layoutItem, point2D);
        }
        object = GeometryUtils.getDrawRect(this._startX, this._startY, this._endX, this._endY);
        this.addImmediateRect((Rectangle2D)object);
        this.updateImmediately();
    }

    protected void processKeyPressed(JLEEvent jLEEvent) {
        super.processKeyPressed(jLEEvent);
        if (jLEEvent.isConsumed()) {
            return;
        }
        int n = jLEEvent.getKeyCode();
        switch (n) {
            case 27: {
                if (this._source == null) break;
                this._linking = false;
                this._source = null;
                this._endY = 0.0;
                this._endX = 0.0;
                this._startY = 0.0;
                this._startX = 0.0;
                this.updateImmediately();
            }
        }
    }

    public static LinkItem attachLinkItem(LayoutItem layoutItem, LayoutItem layoutItem2) {
        if (layoutItem == null || layoutItem2 == null) {
            throw new IllegalArgumentException();
        }
        LinkPort linkPort = LinkTool.getClosestPort(layoutItem2, layoutItem);
        LinkPort linkPort2 = LinkTool.getClosestPort(linkPort, layoutItem2);
        return LinkTool.attachLinkItem(linkPort, linkPort2);
    }

    public static LinkItem attachLinkItem(LinkPort linkPort, LinkPort linkPort2) {
        if (linkPort == null || linkPort2 == null) {
            throw new IllegalArgumentException();
        }
        TwoPortLinkItem twoPortLinkItem = new TwoPortLinkItem(linkPort, linkPort2);
        LayoutItem layoutItem = ItemUtils.getSharedAncestor(linkPort.getItem(), linkPort2.getItem());
        while (layoutItem != null && !layoutItem.allowsChildren()) {
            layoutItem = layoutItem.getItemParent();
        }
        if (layoutItem == null) {
            return null;
        }
        layoutItem.addItem(twoPortLinkItem, 0);
        return twoPortLinkItem;
    }

    public static LinkPort[] getLinkPorts(LayoutItem layoutItem) {
        if (layoutItem == null) {
            throw new IllegalArgumentException();
        }
        Object object = layoutItem.getProperty(REJECT_LINK_KEY);
        if (object != PropertyManager.NOT_FOUND_OBJECT) {
            return new LinkPort[0];
        }
        object = layoutItem.getProperty(LINK_PORTS_KEY);
        if (object != PropertyManager.NOT_FOUND_OBJECT) {
            return (LinkPort[])object;
        }
        return LinkTool._createDefaultPorts(layoutItem);
    }

    public static void setLinkPorts(LayoutItem layoutItem, LinkPort[] linkPortArray) {
        if (layoutItem == null) {
            throw new IllegalArgumentException();
        }
        Object object = layoutItem.removeProperty(LINK_PORTS_KEY);
        if (object != PropertyManager.NOT_FOUND_OBJECT) {
            LinkPort[] linkPortArray2 = (LinkPort[])object;
            int n = 0;
            while (n < linkPortArray2.length) {
                linkPortArray2[n].die();
                ++n;
            }
        }
        if (linkPortArray == null) {
            return;
        }
        layoutItem.putProperty(LINK_PORTS_KEY, linkPortArray);
    }

    public static boolean isLinkable(LayoutItem layoutItem) {
        if (layoutItem == null) {
            return false;
        }
        Object object = layoutItem.getProperty(REJECT_LINK_KEY);
        return object == PropertyManager.NOT_FOUND_OBJECT;
    }

    public static void setLinkable(LayoutItem layoutItem, boolean bl) {
        if (bl) {
            layoutItem.removeProperty(REJECT_LINK_KEY);
        } else {
            layoutItem.putProperty(REJECT_LINK_KEY, null);
        }
    }

    public static LinkPort getClosestPort(LinkPort linkPort, LayoutItem layoutItem) {
        Point2D point2D = LinkItem.getPortInDeviceDouble(linkPort);
        return LinkTool._findClosestPort(point2D, layoutItem);
    }

    public static LinkPort getClosestPort(LayoutItem layoutItem, LayoutItem layoutItem2) {
        Rectangle2D rectangle2D = ItemUtils.itemToDeviceDouble(layoutItem.getItemParent(), layoutItem.getItemBounds());
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
        return LinkTool._findClosestPort(double_, layoutItem2);
    }

    public LinkItem processLink(LayoutItem layoutItem, LayoutItem layoutItem2, Point2D point2D, Point2D point2D2) {
        return LinkTool.attachLinkItem(layoutItem, layoutItem2);
    }

    public void addLinkToolListener(LinkToolListener linkToolListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)linkToolListener);
    }

    public void removeBoundsToolListener(LinkToolListener linkToolListener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)linkToolListener);
        }
    }

    protected boolean isValidLinkSource(LayoutItem layoutItem, Point2D point2D) {
        return LinkTool.isLinkable(layoutItem);
    }

    protected boolean isValidLinkDestination(LayoutItem layoutItem, Point2D point2D, LayoutItem layoutItem2, Point2D point2D2) {
        return LinkTool.isLinkable(layoutItem);
    }

    protected boolean fireLinkToolEvent(int n, LinkItem linkItem, LayoutItem layoutItem, Point2D point2D, LayoutItem layoutItem2, Point2D point2D2) {
        LinkToolEvent linkToolEvent;
        Enumeration enumeration;
        Enumeration enumeration2 = enumeration = this._listeners == null ? null : this._listeners.getListeners();
        if (enumeration == null) {
            return true;
        }
        boolean bl = false;
        switch (n) {
            case 1: {
                linkToolEvent = new LinkToolValidateEvent(this, n, linkItem, layoutItem, point2D, layoutItem2, point2D2);
                bl = true;
                break;
            }
            default: {
                linkToolEvent = new LinkToolEvent(this, n, linkItem, layoutItem, point2D, layoutItem2, point2D2);
                break;
            }
        }
        while (enumeration.hasMoreElements()) {
            LinkToolListener linkToolListener = (LinkToolListener)enumeration.nextElement();
            switch (n) {
                case 1: {
                    linkToolListener.linkCreating(linkToolEvent);
                    break;
                }
                case 2: {
                    linkToolListener.linkCreated(linkToolEvent);
                    break;
                }
                case 3: {
                    linkToolListener.linkPositioning(linkToolEvent);
                }
            }
        }
        return bl ? !((Cancelable)linkToolEvent).isCancelled() : true;
    }

    private static LinkPort _findClosestPort(Point2D point2D, LayoutItem layoutItem) {
        LinkPort[] linkPortArray = LinkTool.getLinkPorts(layoutItem);
        if (linkPortArray.length == 0) {
            return null;
        }
        LinkPort linkPort = linkPortArray[0];
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < linkPortArray.length) {
            LinkPort linkPort2 = linkPortArray[n];
            Point2D point2D2 = ItemUtils.itemToDevice(layoutItem, linkPort2.getX(), linkPort2.getY());
            double d2 = GeometryUtils.segmentLength(point2D2.getX(), point2D2.getY(), point2D.getX(), point2D.getY());
            if (d2 < d) {
                d = d2;
                linkPort = linkPort2;
            }
            ++n;
        }
        return linkPort;
    }

    private static LinkPort[] _createDefaultPorts(LayoutItem layoutItem) {
        LinkPort[] linkPortArray = new LinkPort[]{new DefaultLinkPort(layoutItem, 0), new DefaultLinkPort(layoutItem, 1), new DefaultLinkPort(layoutItem, 2), new DefaultLinkPort(layoutItem, 4), new DefaultLinkPort(layoutItem, 5), new DefaultLinkPort(layoutItem, 6), new DefaultLinkPort(layoutItem, 8), new DefaultLinkPort(layoutItem, 9), new DefaultLinkPort(layoutItem, 10)};
        layoutItem.getPropertyManager().put(LINK_PORTS_KEY, linkPortArray);
        return linkPortArray;
    }
}

