/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Component;
import java.awt.Cursor;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.item.BaseItem;
import oracle.bali.jle.tool.BaseTool;
import oracle.bali.jle.util.ItemUtils;

public class EventPassthroughTool
extends BaseTool {
    private long _mask;
    private long _actualMask;
    private LayoutItem _mouseItem;
    private LayoutItem _dragItem;
    private Cursor _cursor;
    private Cursor _defaultCursor;
    private LayoutItem[] _targets;
    private boolean _mouseConsume;
    private boolean _restoreCaching = true;

    public EventPassthroughTool() {
        this(60L);
    }

    public EventPassthroughTool(long l) {
        long l2 = this._mask = l;
        if ((l & 0x10L) != 0L) {
            l2 |= 0x20L;
        }
        if ((l & 0x20L) != 0L) {
            l2 |= 0x10L;
        }
        this._actualMask = l2;
    }

    public void pickup(JLECanvas jLECanvas, JLEEventSource jLEEventSource) {
        super.pickup(jLECanvas, jLEEventSource);
        this._defaultCursor = ((Component)((Object)jLECanvas.getGlassComponent())).getCursor();
        boolean bl = this._restoreCaching = BaseItem.isZoomCachingAllowed() && this.isEnabled();
        if (this._restoreCaching) {
            BaseItem.setZoomCachingAllowed(false);
        }
    }

    public void drop() {
        JLECanvas jLECanvas = this.getCanvas();
        super.drop();
        if (this._restoreCaching) {
            BaseItem.setZoomCachingAllowed(true);
        }
        if (jLECanvas != null) {
            ((Component)((Object)jLECanvas.getGlassComponent())).requestFocus();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this._restoreCaching) {
            BaseItem.setZoomCachingAllowed(!bl);
        }
    }

    public long getDefaultEnabledEvents() {
        return this._actualMask;
    }

    public void setTargetItems(LayoutItem[] layoutItemArray) {
        if (layoutItemArray == null || layoutItemArray.length == 0) {
            this._targets = null;
        } else {
            LayoutItem[] layoutItemArray2 = new LayoutItem[layoutItemArray.length];
            System.arraycopy(layoutItemArray, 0, layoutItemArray2, 0, layoutItemArray2.length);
            this._targets = layoutItemArray2;
        }
    }

    public void addTargetItem(LayoutItem layoutItem) {
        if (layoutItem == null) {
            throw new IllegalArgumentException();
        }
        if (this._targets == null) {
            this._targets = new LayoutItem[]{layoutItem};
        } else {
            LayoutItem[] layoutItemArray = new LayoutItem[this._targets.length + 1];
            System.arraycopy(this._targets, 0, layoutItemArray, 0, this._targets.length);
            layoutItemArray[this._targets.length] = layoutItem;
            this._targets = layoutItemArray;
        }
    }

    public void removeTargetItem(LayoutItem layoutItem) {
        if (layoutItem == null || this._targets == null) {
            throw new IllegalArgumentException();
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this._targets.length) {
            if (this._targets[n2] == layoutItem) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n < 0) {
            throw new IllegalArgumentException("not a target: " + layoutItem);
        }
        if (this._targets.length == 1) {
            this._targets = null;
            return;
        }
        LayoutItem[] layoutItemArray = new LayoutItem[this._targets.length - 1];
        System.arraycopy(this._targets, 0, layoutItemArray, 0, n);
        if (n < layoutItemArray.length) {
            System.arraycopy(this._targets, n + 1, layoutItemArray, n, layoutItemArray.length - n);
        }
        this._targets = layoutItemArray;
    }

    public LayoutItem[] getTargetItems() {
        if (this._targets != null) {
            LayoutItem[] layoutItemArray = new LayoutItem[this._targets.length];
            System.arraycopy(this._targets, 0, layoutItemArray, 0, layoutItemArray.length);
            return layoutItemArray;
        }
        return null;
    }

    public void setForcedMouseConsumption(boolean bl) {
        this._mouseConsume = bl;
    }

    public boolean hasForcedMouseConsumption() {
        return this._mouseConsume;
    }

    public void processJLEEvent(JLEEvent jLEEvent) {
        switch (jLEEvent.getID()) {
            case 500: {
                this.mouseClicked(jLEEvent);
                break;
            }
            case 501: {
                this.mousePressed(jLEEvent);
                break;
            }
            case 502: {
                this.mouseReleased(jLEEvent);
                break;
            }
            case 504: {
                this.mouseEntered(jLEEvent);
                break;
            }
            case 505: {
                this.mouseExited(jLEEvent);
                break;
            }
            case 503: {
                this.mouseMoved(jLEEvent);
                break;
            }
            case 506: {
                this.mouseDragged(jLEEvent);
                break;
            }
            case 400: {
                this.keyTyped(jLEEvent);
                break;
            }
            case 401: {
                this.keyPressed(jLEEvent);
                break;
            }
            case 402: {
                this.keyReleased(jLEEvent);
                break;
            }
            case 1004: {
                this.focusGained(jLEEvent);
                break;
            }
            case 1005: {
                this.focusLost(jLEEvent);
            }
        }
    }

    protected void processMouseClicked(JLEEvent jLEEvent) {
        if (!this.isEnabled()) {
            return;
        }
        LayoutItem layoutItem = this._checkTarget(jLEEvent);
        if (layoutItem != null) {
            this._redispatchMouseEvent(jLEEvent, layoutItem, jLEEvent.getID());
        }
    }

    protected void processMousePressed(JLEEvent jLEEvent) {
        if (!this.isEnabled()) {
            return;
        }
        LayoutItem layoutItem = this._checkTarget(jLEEvent);
        if (layoutItem != null) {
            this._redispatchMouseEvent(jLEEvent, layoutItem, jLEEvent.getID());
            this._dragItem = layoutItem;
        }
    }

    protected void processMouseReleased(JLEEvent jLEEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this._dragItem != null) {
            this._redispatchMouseEvent(jLEEvent, this._dragItem, jLEEvent.getID());
            this._dragItem = null;
        }
    }

    protected void processMouseEntered(JLEEvent jLEEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this._checkTarget(jLEEvent);
    }

    protected void processMouseExited(JLEEvent jLEEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this._checkTarget(jLEEvent);
    }

    protected void processMouseDragged(JLEEvent jLEEvent) {
        if (!this.isEnabled() || this._dragItem == null) {
            return;
        }
        this._checkTarget(jLEEvent);
        this._redispatchMouseEvent(jLEEvent, this._dragItem, jLEEvent.getID());
    }

    protected void processMouseMoved(JLEEvent jLEEvent) {
        if (!this.isEnabled()) {
            return;
        }
        LayoutItem layoutItem = this._mouseItem;
        LayoutItem layoutItem2 = this._checkTarget(jLEEvent);
        if (layoutItem == layoutItem2) {
            this._redispatchMouseEvent(jLEEvent, layoutItem2, jLEEvent.getID());
        }
        if (layoutItem2 != null) {
            Cursor cursor;
            Object object = layoutItem2.getProperty(LayoutItem.CURSOR_KEY);
            Cursor cursor2 = cursor = object != PropertyManager.NOT_FOUND_OBJECT ? (Cursor)object : this._defaultCursor;
            if (cursor != this._cursor) {
                this._cursor = cursor;
                ((Component)((Object)this.getCanvas().getGlassComponent())).setCursor(cursor);
            }
        }
    }

    protected void processKeyTyped(JLEEvent jLEEvent) {
        if (!this.isEnabled()) {
            return;
        }
        LayoutItem layoutItem = this.getCanvas().getFocusedItem();
        if (layoutItem != null) {
            JLEEvent jLEEvent2 = new JLEEvent(layoutItem, 400, jLEEvent.getWhen(), jLEEvent.getModifiers(), jLEEvent.getKeyCode(), jLEEvent.getKeyChar());
            layoutItem.processEvent(jLEEvent2);
            if (jLEEvent2.isConsumed()) {
                jLEEvent.consume();
            }
        }
        if (!jLEEvent.isConsumed()) {
            super.processKeyTyped(jLEEvent);
        }
    }

    protected void processKeyPressed(JLEEvent jLEEvent) {
        if (!this.isEnabled()) {
            return;
        }
        JLECanvas jLECanvas = this.getCanvas();
        if (jLECanvas == null) {
            return;
        }
        LayoutItem layoutItem = jLECanvas.getFocusedItem();
        if (layoutItem != null) {
            JLEEvent jLEEvent2 = new JLEEvent(layoutItem, 401, jLEEvent.getWhen(), jLEEvent.getModifiers(), jLEEvent.getKeyCode(), jLEEvent.getKeyChar());
            layoutItem.processEvent(jLEEvent2);
            if (jLEEvent2.isConsumed() || this._targets != null) {
                jLEEvent.consume();
            }
        }
        if (!jLEEvent.isConsumed()) {
            super.processKeyPressed(jLEEvent);
        }
    }

    protected void processKeyReleased(JLEEvent jLEEvent) {
        if (!this.isEnabled()) {
            return;
        }
        LayoutItem layoutItem = this.getCanvas().getFocusedItem();
        if (layoutItem != null) {
            JLEEvent jLEEvent2 = new JLEEvent(layoutItem, 402, jLEEvent.getWhen(), jLEEvent.getModifiers(), jLEEvent.getKeyCode(), jLEEvent.getKeyChar());
            layoutItem.processEvent(jLEEvent2);
            if (jLEEvent2.isConsumed()) {
                jLEEvent.consume();
            }
        }
        if (!jLEEvent.isConsumed()) {
            super.processKeyReleased(jLEEvent);
        }
    }

    private void _redispatchMouseEvent(JLEEvent jLEEvent, LayoutItem layoutItem, int n) {
        if (layoutItem == null) {
            return;
        }
        JLECanvas jLECanvas = this.getCanvas();
        Point2D point2D = ItemUtils.transformPoint(jLECanvas.getDeviceTransform(), new Point2D.Double(jLEEvent.getX(), jLEEvent.getY()), false);
        Point2D point2D2 = ItemUtils.deviceToItem(layoutItem, point2D);
        JLEEvent jLEEvent2 = new JLEEvent(layoutItem, n, jLEEvent.getWhen(), jLEEvent.getModifiers(), point2D2.getX(), point2D2.getY(), jLEEvent.getClickCount());
        layoutItem.processEvent(jLEEvent2);
        if (jLEEvent2.isConsumed() || this._mouseConsume) {
            jLEEvent.consume();
            if (jLEEvent.getID() == 501) {
                this.getCanvas().getGlassComponent().skipFocusGrab();
            }
        }
    }

    private LayoutItem _checkTarget(JLEEvent jLEEvent) {
        JLECanvas jLECanvas = this.getCanvas();
        LayoutItem layoutItem = null;
        if (jLEEvent.getID() != 505) {
            layoutItem = this._findItem(jLEEvent);
            if (this._targets != null) {
                boolean bl = false;
                int n = 0;
                while (n < this._targets.length) {
                    if (layoutItem == this._targets[n]) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    layoutItem = null;
                }
            }
        }
        if (layoutItem != this._mouseItem) {
            if (this._mouseItem != null && (this._dragItem == null || this._dragItem == this._mouseItem)) {
                this._redispatchMouseEvent(jLEEvent, this._mouseItem, 505);
                this._mouseItem = null;
            }
            if (layoutItem != null && (this._dragItem == null || this._dragItem == layoutItem)) {
                this._redispatchMouseEvent(jLEEvent, layoutItem, 504);
                this._mouseItem = layoutItem;
            }
        }
        return layoutItem;
    }

    private LayoutItem _findItem(JLEEvent jLEEvent) {
        LayoutItem layoutItem = this.getCanvas().getItemAt(jLEEvent.getX(), jLEEvent.getY());
        return layoutItem;
    }
}

