/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import oracle.bali.jle.JLEAutoScroller;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.TransformException;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseItem;
import oracle.bali.jle.item.GridSnap;
import oracle.bali.jle.tool.BoundsPainter;
import oracle.bali.jle.tool.BoundsToolEvent;
import oracle.bali.jle.tool.BoundsToolListener;
import oracle.bali.jle.tool.BoundsToolValidateEvent;
import oracle.bali.jle.tool.ControlPoint;
import oracle.bali.jle.tool.ControlPointSet;
import oracle.bali.jle.tool.ControlPointTable;
import oracle.bali.jle.tool.DefaultBoundsPainter;
import oracle.bali.jle.tool.SelectionTool;
import oracle.bali.jle.tool.undo.MoveUndo;
import oracle.bali.jle.tool.undo.ResizeUndo;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.collection.StringKey;
import oracle.ewt.event.Cancelable;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.undo.CompoundEdit;
import oracle.ewt.undo.UndoableEdit;
import oracle.ewt.undo.UndoableEditEvent;

public class BoundsTool
extends SelectionTool {
    public static final Object REJECT_MOVE_KEY = new StringKey("REJECT_MOVE_KEY");
    public static final Object REJECT_RESIZE_KEY = new StringKey("REJECT_RESIZE_KEY");
    public static final Object MINIMUM_SIZE_KEY = new StringKey("MINIMUM_SIZE_KEY");
    public static final int RESIZE_FLIP = 0;
    public static final int RESIZE_MINIMUM_CONSTRAINED = 1;
    public static final int CONSTRAIN_TO_PARENT = 2;
    public static final int CONSTRAIN_TO_CHILDREN = 8;
    public static final int CONSTRAIN_TO_ITEM_MIN = 16;
    public static final int CONSTRAIN_TO_PARENT_TOPLEFT = 32;
    protected static final Object CONTROL_POINT_SET_KEY = new StringKey("CONTROL_POINT_SET_KEY");
    private ControlPointTable _cpTable = new ControlPointTable();
    private BoundsPainter _painter;
    private double _startX;
    private double _startY;
    private double _endX;
    private double _endY;
    private transient boolean _autoscrolling;
    private transient int _oldCount;
    private transient ControlPoint _dragCandidate;
    private transient ControlPoint _dragged;
    private transient ControlPoint _undoPoint;
    private transient boolean _dragRejected = false;
    private transient boolean _dragChecked = false;
    private transient boolean _gotPress;
    private int _cpXOff;
    private int _cpYOff;
    private double _cpNearX;
    private double _cpNearY;
    private int _keyMove = 1;
    private transient boolean _didDrag;
    private boolean _postUndo;
    private boolean _constrain;
    private JLECanvas _cursorComp;
    private ListenerManager _listeners;
    private Vector _notMoved;
    private Vector _notResized;
    private int _mode = 0;
    private double _minWidth = 5.0;
    private double _minHeight = 5.0;
    private double _padLeft;
    private double _padRight;
    private double _padUp;
    private double _padDown;
    private boolean _padDirty = true;

    public static boolean isMovable(LayoutItem layoutItem) {
        Object object = layoutItem.getProperty(REJECT_MOVE_KEY);
        return object == PropertyManager.NOT_FOUND_OBJECT;
    }

    public static void setMovable(LayoutItem layoutItem, boolean bl) {
        if (bl) {
            layoutItem.removeProperty(REJECT_MOVE_KEY);
        } else {
            layoutItem.putProperty(REJECT_MOVE_KEY, null);
        }
    }

    public static boolean isResizable(LayoutItem layoutItem) {
        Object object = layoutItem.getProperty(REJECT_RESIZE_KEY);
        return object == PropertyManager.NOT_FOUND_OBJECT;
    }

    public static void setResizable(LayoutItem layoutItem, boolean bl) {
        if (bl) {
            layoutItem.removeProperty(REJECT_RESIZE_KEY);
        } else {
            layoutItem.putProperty(REJECT_RESIZE_KEY, null);
        }
    }

    public static Dimension2D getMinimumSize(LayoutItem layoutItem) {
        Object object = layoutItem.getProperty(MINIMUM_SIZE_KEY);
        return object == PropertyManager.NOT_FOUND_OBJECT ? null : (Dimension2D)object;
    }

    public static void setMinimumSize(LayoutItem layoutItem, double d, double d2) {
        layoutItem.putProperty(MINIMUM_SIZE_KEY, new Dimension2D.Double(d, d2));
    }

    public void drawHighlight(Graphics graphics) {
        int n;
        super.drawHighlight(graphics);
        JLECanvas jLECanvas = this.getCanvas();
        ControlPoint controlPoint = this._cpTable.firstElement();
        while (controlPoint != null) {
            Point point = jLECanvas.contentToDevice(controlPoint.getX(), controlPoint.getY());
            this._painter.drawControlPoint(graphics, controlPoint, point.x - this._cpXOff, point.y - this._cpYOff);
            controlPoint = this._cpTable.nextElement();
        }
        if (this._dragged != null && !this._autoscrolling && (n = this.getSelectedItemCount()) > 0) {
            LayoutItem[] layoutItemArray = this.getSelectedItems();
            boolean bl = this._dragged.getType() == 5;
            int n2 = 0;
            while (n2 < layoutItemArray.length) {
                LayoutItem layoutItem = layoutItemArray[n2];
                boolean bl2 = true;
                boolean bl3 = true;
                if (bl && this._notMoved != null) {
                    if (this._notMoved.contains(layoutItem)) {
                        bl2 = false;
                    }
                } else if (this._notResized != null && this._notResized.contains(layoutItem)) {
                    bl3 = false;
                }
                if (bl2 || bl3) {
                    Rectangle rectangle = ItemUtils.itemToDevice(layoutItem.getItemParent(), layoutItem.getItemBounds());
                    int n3 = (int)Math.round((this._endX - this._startX) * jLECanvas.getZoomX() / jLECanvas.getEngineUnitsPerPixelX());
                    int n4 = (int)Math.round((this._endY - this._startY) * jLECanvas.getZoomY() / jLECanvas.getEngineUnitsPerPixelY());
                    if (bl) {
                        rectangle.x += n3;
                        rectangle.y += n4;
                        this._painter.drawMove(graphics, layoutItem, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    } else {
                        if (this._dragged.isUpper()) {
                            rectangle.y += n4;
                            rectangle.height -= n4;
                        } else if (this._dragged.isLower()) {
                            rectangle.height += n4;
                        }
                        if (this._dragged.isLeft()) {
                            rectangle.x += n3;
                            rectangle.width -= n3;
                        } else if (this._dragged.isRight()) {
                            rectangle.width += n3;
                        }
                        this._painter.drawResize(graphics, layoutItem, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                }
                ++n2;
            }
        }
    }

    public void drop() {
        int n;
        LayoutItem[] layoutItemArray;
        JLECanvas jLECanvas = this.getCanvas();
        try {
            jLECanvas.freezeRepaints();
            layoutItemArray = this.getSelectedItems();
            n = 0;
            while (n < layoutItemArray.length) {
                this.processDeselect(layoutItemArray[n]);
                ++n;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            jLECanvas.unfreezeRepaints();
            throw throwable;
        }
        jLECanvas.unfreezeRepaints();
        this._cpTable.removeAll();
        layoutItemArray = this.getSelectedItems();
        n = 0;
        while (n < layoutItemArray.length) {
            layoutItemArray[n].removeProperty(CONTROL_POINT_SET_KEY);
            ++n;
        }
        this._cursorComp = null;
        jLECanvas.removePropertyChangeListener(this);
        JLEAutoScroller.getJLEAutoScroller().cancel();
        this._autoscrolling = false;
        super.drop();
        this._postUndo = false;
    }

    public void pickup(JLECanvas jLECanvas, JLEEventSource jLEEventSource) {
        super.pickup(jLECanvas, jLEEventSource);
        this._postUndo = jLECanvas.hasUndoableEditListeners();
        this._painter = this.getBoundsPainter();
        int n = this._painter.getControlPointWidth();
        int n2 = this._painter.getControlPointHeight();
        this._cpXOff = n / 2;
        this._cpYOff = n2 / 2;
        this._cpNearX = (double)this._cpXOff * jLECanvas.getEngineUnitsPerPixelX();
        this._cpNearY = (double)this._cpYOff * jLECanvas.getEngineUnitsPerPixelY();
        this._oldCount = 0;
        this._autoscrolling = false;
        jLECanvas.addPropertyChangeListener(this);
        this._clearPad();
    }

    protected void processMousePressed(JLEEvent jLEEvent) {
        if (!this.isPrimaryMouseEvent(jLEEvent)) {
            if (this._dragged != null) {
                this._dragRejected = true;
                this._dragCandidate = null;
                this._dragged = null;
                this._didDrag = false;
                this.updateImmediately();
                jLEEvent.consume();
            }
        } else {
            this._gotPress = true;
        }
        if (jLEEvent.isConsumed() || !this.isPrimaryMouseEvent(jLEEvent)) {
            return;
        }
        this._oldCount = this.getSelectedItemCount();
        this._didDrag = false;
        double d = jLEEvent.getX();
        double d2 = jLEEvent.getY();
        ControlPoint controlPoint = this._cpTable.lookup(d, d2, this._cpNearX, this._cpNearY);
        LayoutItem layoutItem = this.getCanvas().getHitItem(d, d2);
        if (!(controlPoint != null || layoutItem != null && SelectionTool.isSelected(layoutItem))) {
            super.processMousePressed(jLEEvent);
            if (this.getSelectedItemCount() == 0) {
                this._dragged = null;
                this._dragCandidate = null;
                return;
            }
        }
        this._startX = this._endX = d;
        this._startY = this._endY = d2;
        if (controlPoint == null) {
            controlPoint = new ControlPoint(5, d, d2, layoutItem);
        }
        this._dragCandidate = controlPoint;
        jLEEvent.consume();
    }

    protected void processMouseReleased(JLEEvent jLEEvent) {
        Object object;
        JLEAutoScroller.getJLEAutoScroller().cancel();
        this._autoscrolling = false;
        double d = jLEEvent.getX();
        double d2 = jLEEvent.getY();
        if (this._oldCount == this.getSelectedItemCount() && !this._didDrag && !this._dragRejected) {
            boolean bl;
            LayoutItem layoutItem = SelectionTool.getSelectedItemAt(this.getCanvas(), d, d2);
            boolean bl2 = bl = (jLEEvent.getModifiers() & 3) != 0;
            if (bl) {
                if (layoutItem != null) {
                    this.toggleSelection(layoutItem);
                }
            } else {
                LayoutItem[] layoutItemArray = this.getSelectedItems();
                int n = 0;
                while (n < layoutItemArray.length) {
                    object = layoutItemArray[n];
                    if (object != layoutItem) {
                        this.processDeselect((LayoutItem)object);
                    }
                    ++n;
                }
            }
        }
        if (this._dragged != null && this._didDrag) {
            this._endX = d;
            this._endY = d2;
            double d3 = this._endX - this._startX;
            double d4 = this._endY - this._startY;
            if (this.getSelectedItemCount() > 0) {
                Object object2;
                object = this.getSelectedItems();
                if (d3 < 0.0) {
                    if (d3 < -this._padLeft) {
                        d3 = -this._padLeft;
                        this._endX = this._startX + d3;
                    }
                } else if (d3 > this._padRight) {
                    d3 = this._padRight;
                    this._endX = this._startX + d3;
                }
                if (d4 < 0.0) {
                    if (d4 < -this._padUp) {
                        d4 = -this._padUp;
                        this._endY = this._startY + d4;
                    }
                } else if (d4 > this._padDown) {
                    d4 = this._padDown;
                    this._endY = this._startY + d4;
                }
                CompoundEdit compoundEdit = object2 = this._postUndo && ((LayoutItem[])object).length > 1 ? new CompoundEdit() : null;
                if (this._dragged.getType() == 5) {
                    object = ItemUtils.removeChildren(this.getCanvas(), object);
                    int n = 0;
                    while (n < ((LayoutItem[])object).length) {
                        LayoutItem layoutItem = object[n];
                        boolean bl = BoundsTool.processMove(layoutItem, d3, d4, this);
                        if (this._postUndo && bl) {
                            MoveUndo moveUndo = new MoveUndo(layoutItem, d3, d4, this);
                            if (((LayoutItem[])object).length > 1) {
                                object2.addEdit((UndoableEdit)moveUndo);
                            } else {
                                object2 = moveUndo;
                            }
                        }
                        ++n;
                    }
                } else {
                    int n = 0;
                    while (n < ((LayoutItem[])object).length) {
                        LayoutItem layoutItem = object[n];
                        this._undoPoint = this._dragged;
                        boolean bl = this.processResize(layoutItem, d3, d4, this._dragged);
                        if (this._postUndo && bl) {
                            ResizeUndo resizeUndo = new ResizeUndo(layoutItem, d3, d4, this._undoPoint, this._dragged, this);
                            if (((LayoutItem[])object).length > 1) {
                                object2.addEdit((UndoableEdit)resizeUndo);
                            } else {
                                object2 = resizeUndo;
                            }
                        }
                        ++n;
                    }
                }
                if (this._postUndo) {
                    if (((LayoutItem[])object).length > 1) {
                        object2.end();
                    }
                    if (object2 != null) {
                        this.getCanvas().processUndoableEditEvent(new UndoableEditEvent((Object)this, (UndoableEdit)object2));
                    }
                }
            }
        }
        this._undoPoint = null;
        this._dragCandidate = null;
        this._dragged = null;
        this._dragRejected = false;
        this._dragChecked = false;
        this._clearPad();
        super.processMouseReleased(jLEEvent);
    }

    protected void processMouseDragged(JLEEvent jLEEvent) {
        if (jLEEvent.isConsumed() || !this.isPrimaryMouseEvent(jLEEvent) || !this._gotPress) {
            return;
        }
        if (this._dragRejected) {
            return;
        }
        if (this._dragCandidate != null) {
            this._dragged = this._dragCandidate;
            this._dragCandidate = null;
        }
        this._didDrag = true;
        if (this._dragged != null) {
            this._autoscrolling = JLEAutoScroller.getJLEAutoScroller().checkAutoScroll(this.getCanvas(), jLEEvent);
            this._endX = jLEEvent.getX();
            this._endY = jLEEvent.getY();
            double d = this._endX - this._startX;
            double d2 = this._endY - this._startY;
            LayoutItem[] layoutItemArray = this.getSelectedItems();
            if (this._padDirty) {
                this._calculatePad(layoutItemArray);
            }
            if (d < 0.0) {
                if (d < -this._padLeft) {
                    d = -this._padLeft;
                    this._endX = this._startX + d;
                }
            } else if (d > this._padRight) {
                d = this._padRight;
                this._endX = this._startX + d;
            }
            if (d2 < 0.0) {
                if (d2 < -this._padUp) {
                    d2 = -this._padUp;
                    this._endY = this._startY + d2;
                }
            } else if (d2 > this._padDown) {
                d2 = this._padDown;
                this._endY = this._startY + d2;
            }
            if (this._dragged.getType() == 5) {
                if (!this._dragChecked) {
                    if (!this._checkDragRejection(1, layoutItemArray)) {
                        this._dragRejected = true;
                        this._didDrag = false;
                        return;
                    }
                    this._dragChecked = true;
                }
                JLECanvas jLECanvas = this.getCanvas();
                Cursor cursor = this.getBoundsPainter().getMoveCursor();
                if (cursor != null && ((Component)((Object)jLECanvas)).getCursor() != cursor) {
                    ((Component)((Object)this._cursorComp.getGlassComponent())).setCursor(cursor);
                }
                int n = 0;
                while (n < layoutItemArray.length) {
                    LayoutItem layoutItem = layoutItemArray[n];
                    this.fireBoundsToolEvent(5, layoutItem, d, d2);
                    Rectangle2D rectangle2D = ItemUtils.parentToContent(layoutItem, layoutItem.getItemBounds());
                    this.addImmediateRect(rectangle2D.getX() + d, rectangle2D.getY() + d2, rectangle2D.getWidth(), rectangle2D.getHeight());
                    ++n;
                }
            } else {
                if (!this._dragChecked) {
                    if (!this._checkDragRejection(3, layoutItemArray)) {
                        this._dragRejected = true;
                        this._didDrag = false;
                        return;
                    }
                    this._dragChecked = true;
                }
                int n = 0;
                while (n < layoutItemArray.length) {
                    LayoutItem layoutItem = layoutItemArray[n];
                    this.fireBoundsToolEvent(6, layoutItem, d, d2);
                    Rectangle2D rectangle2D = ItemUtils.parentToContent(layoutItem, layoutItem.getItemBounds());
                    double d3 = rectangle2D.getX();
                    double d4 = rectangle2D.getY();
                    double d5 = rectangle2D.getWidth();
                    double d6 = rectangle2D.getHeight();
                    if (this._dragged.isUpper()) {
                        d4 += d2;
                        d6 -= d2;
                    } else if (this._dragged.isLower()) {
                        d6 += d2;
                    }
                    if (this._dragged.isLeft()) {
                        d3 += d;
                        d5 -= d;
                    } else if (this._dragged.isRight()) {
                        d5 += d;
                    }
                    if (d5 < 0.0) {
                        d3 += d5;
                        d5 = -d5;
                    }
                    if (d6 < 0.0) {
                        d4 += d6;
                        d6 = -d6;
                    }
                    this.addImmediateRect(d3, d4, d5, d6);
                    ++n;
                }
            }
            this.updateImmediately();
        } else {
            super.processMouseDragged(jLEEvent);
        }
    }

    protected void processMouseMoved(JLEEvent jLEEvent) {
        if (this._cursorComp == null) {
            this._cursorComp = this.getCanvas();
            Object object = this._cursorComp;
            while (object != null) {
                if ((object = ((Component)object).getParent()) == null || !(object instanceof JLECanvas)) continue;
                this._cursorComp = (JLECanvas)object;
            }
        }
        int n = 0;
        ControlPoint controlPoint = this._cpTable.lookup(jLEEvent.getX(), jLEEvent.getY(), this._cpNearX, this._cpNearY);
        if (controlPoint != null) {
            switch (controlPoint.getType()) {
                case 0: {
                    n = 6;
                    break;
                }
                case 1: {
                    n = 8;
                    break;
                }
                case 2: {
                    n = 7;
                    break;
                }
                case 4: {
                    n = 10;
                    break;
                }
                case 6: {
                    n = 11;
                    break;
                }
                case 8: {
                    n = 4;
                    break;
                }
                case 9: {
                    n = 9;
                    break;
                }
                case 10: {
                    n = 5;
                    break;
                }
            }
        }
        ((Component)((Object)this._cursorComp.getGlassComponent())).setCursor(Cursor.getPredefinedCursor(n));
    }

    protected void processKeyPressed(JLEEvent jLEEvent) {
        super.processKeyPressed(jLEEvent);
        if (jLEEvent.isConsumed()) {
            return;
        }
        int n = jLEEvent.getKeyCode();
        switch (n) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                if (!this._processMoveKey(jLEEvent)) break;
                jLEEvent.consume();
                break;
            }
            case 27: {
                if (this._dragged == null) break;
                this._dragRejected = true;
                this._dragCandidate = null;
                this._dragged = null;
                this._didDrag = false;
                this.updateImmediately();
                jLEEvent.consume();
            }
        }
    }

    public boolean processSelect(LayoutItem layoutItem, EventObject eventObject) {
        if (!super.processSelect(layoutItem, eventObject)) {
            return false;
        }
        if (!BoundsTool.isMovable(layoutItem)) {
            if (this._notMoved == null) {
                this._notMoved = new Vector();
            }
            this._notMoved.addElement(layoutItem);
        }
        if (!BoundsTool.isResizable(layoutItem)) {
            if (this._notResized == null) {
                this._notResized = new Vector();
            }
            this._notResized.addElement(layoutItem);
        }
        this.refreshSelection(layoutItem);
        return true;
    }

    public boolean processDeselect(LayoutItem layoutItem, EventObject eventObject) {
        if (!super.processDeselect(layoutItem, eventObject)) {
            return false;
        }
        if (!BoundsTool.isMovable(layoutItem)) {
            this._notMoved.removeElement(layoutItem);
        }
        if (!BoundsTool.isResizable(layoutItem)) {
            this._notResized.removeElement(layoutItem);
        }
        this.clearControlPointSet(layoutItem);
        this.repaintWithControl(layoutItem, 0, 0);
        return true;
    }

    public static boolean processMove(LayoutItem layoutItem, double d, double d2, BoundsTool boundsTool) {
        if (!BoundsTool.isMovable(layoutItem)) {
            return false;
        }
        JLECanvas jLECanvas = layoutItem.getCanvas();
        AffineTransform affineTransform = layoutItem.getItemTransform();
        Dimension2D dimension2D = jLECanvas.contentToDevice(new Dimension2D.Double(d, d2));
        dimension2D = ItemUtils.deviceToItem(layoutItem.getItemParent(), dimension2D);
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(dimension2D.getWidth(), dimension2D.getHeight());
        affineTransform2.concatenate(affineTransform);
        try {
            layoutItem.setItemTransform(affineTransform2);
        }
        catch (TransformException transformException) {
            return false;
        }
        if (boundsTool != null) {
            boundsTool.fireBoundsToolEvent(2, layoutItem, d, d2);
        }
        return true;
    }

    public boolean processResize(LayoutItem layoutItem, double d, double d2, ControlPoint controlPoint) {
        if (!BoundsTool.isResizable(layoutItem)) {
            return false;
        }
        JLECanvas jLECanvas = this.getCanvas();
        Dimension2D dimension2D = new Dimension2D.Double(d, d2);
        dimension2D = ItemUtils.deviceToItem(layoutItem, jLECanvas.contentToDevice(dimension2D));
        Rectangle2D rectangle2D = layoutItem.getItemBounds();
        double d3 = dimension2D.getHeight();
        double d4 = dimension2D.getWidth();
        double d5 = rectangle2D.getX();
        double d6 = rectangle2D.getY();
        double d7 = rectangle2D.getWidth();
        double d8 = rectangle2D.getHeight();
        boolean bl = false;
        if (controlPoint.isUpper()) {
            d6 += d3;
            d8 -= d3;
            bl = true;
        } else if (controlPoint.isLower()) {
            d8 += d3;
        }
        if (controlPoint.isLeft()) {
            d5 += d4;
            d7 -= d4;
            bl = true;
        } else if (controlPoint.isRight()) {
            d7 += d4;
        }
        if (this._dragged != null) {
            this._undoPoint = this._adjustUndoControlPoint(d7, d8, this._dragged);
        }
        if (layoutItem instanceof BaseItem) {
            BaseItem baseItem = (BaseItem)layoutItem;
            baseItem.setItemBounds(d5, d6, d7, d8);
        } else {
            if (bl && d7 >= 0.0 && d8 >= 0.0) {
                layoutItem.setItemLocation(d5, d6);
            }
            layoutItem.setItemSize(d7, d8);
        }
        this.fireBoundsToolEvent(4, layoutItem, d, d2);
        return true;
    }

    public int getMode() {
        return this._mode;
    }

    public void setMode(int n) {
        this._mode = n;
    }

    public BoundsPainter getBoundsPainter() {
        if (this._painter == null) {
            this._painter = DefaultBoundsPainter.getPainter();
        }
        return this._painter;
    }

    public void setBoundsPainter(BoundsPainter boundsPainter) {
        this._painter = boundsPainter;
    }

    public void setKeyMoveInterval(int n) {
        this._keyMove = n;
    }

    public int getKeyMoveInterval() {
        return this._keyMove;
    }

    public Dimension2D getMinimumResize() {
        return new Dimension2D.Double(this._minWidth, this._minHeight);
    }

    public void setMinimumResize(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this._minWidth = d;
        this._minHeight = d2;
    }

    public void addBoundsToolListener(BoundsToolListener boundsToolListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)boundsToolListener);
    }

    public void removeBoundsToolListener(BoundsToolListener boundsToolListener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)boundsToolListener);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (JLECanvas.VIEWPORT_LOC_PROPERTY_KEY.equals((Object)string) && this._dragged != null) {
            Point2D point2D = (Point2D)propertyChangeEvent.getNewValue();
        }
        super.propertyChange(propertyChangeEvent);
    }

    protected boolean fireBoundsToolEvent(int n, LayoutItem layoutItem, double d, double d2) {
        BoundsToolEvent boundsToolEvent;
        Enumeration enumeration;
        Enumeration enumeration2 = enumeration = this._listeners == null ? null : this._listeners.getListeners();
        if (enumeration == null) {
            return true;
        }
        boolean bl = false;
        switch (n) {
            case 1: 
            case 3: {
                boundsToolEvent = new BoundsToolValidateEvent(this, n, layoutItem);
                bl = true;
                break;
            }
            default: {
                boundsToolEvent = new BoundsToolEvent(this, n, layoutItem, d, d2);
                break;
            }
        }
        while (enumeration.hasMoreElements()) {
            BoundsToolListener boundsToolListener = (BoundsToolListener)enumeration.nextElement();
            switch (n) {
                case 1: {
                    boundsToolListener.itemMoving(boundsToolEvent);
                    break;
                }
                case 2: {
                    boundsToolListener.itemMoved(boundsToolEvent);
                    break;
                }
                case 3: {
                    boundsToolListener.itemResizing(boundsToolEvent);
                    break;
                }
                case 4: {
                    boundsToolListener.itemResized(boundsToolEvent);
                    break;
                }
                case 5: {
                    boundsToolListener.itemMovePositioning(boundsToolEvent);
                    break;
                }
                case 6: {
                    boundsToolListener.itemResizePositioning(boundsToolEvent);
                }
            }
        }
        return bl ? !((Cancelable)boundsToolEvent).isCancelled() : true;
    }

    protected final boolean fireBoundsToolEvent(int n, LayoutItem layoutItem) {
        return this.fireBoundsToolEvent(n, layoutItem, Double.NaN, Double.NaN);
    }

    protected void refreshSelection(LayoutItem layoutItem) {
        super.refreshSelection(layoutItem);
        if (!BoundsTool.isResizable(layoutItem)) {
            return;
        }
        this.clearControlPointSet(layoutItem);
        ControlPointSet controlPointSet = this.fetchControlPointSet(layoutItem);
        layoutItem.putProperty(CONTROL_POINT_SET_KEY, controlPointSet);
        Enumeration enumeration = controlPointSet.getControlPoints();
        while (enumeration.hasMoreElements()) {
            ControlPoint controlPoint = (ControlPoint)enumeration.nextElement();
            this._cpTable.insert(controlPoint);
        }
        this.repaintWithControl(layoutItem, 0, 0);
    }

    protected ControlPointSet fetchControlPointSet(LayoutItem layoutItem) {
        ControlPoint[] controlPointArray = new ControlPoint[8];
        Rectangle2D rectangle2D = ItemUtils.parentToContent(layoutItem, layoutItem.getItemBounds());
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            int n3 = 0;
            while (n3 < 3) {
                if (n2 != 1 || n3 != 1) {
                    controlPointArray[n] = new ControlPoint(1 * n2 + 4 * n3, rectangle2D.getX() + (double)n2 * rectangle2D.getWidth() / 2.0, rectangle2D.getY() + (double)n3 * rectangle2D.getHeight() / 2.0, layoutItem);
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        return new ControlPointSet(controlPointArray);
    }

    protected final boolean clearControlPointSet(LayoutItem layoutItem) {
        Object object = layoutItem.removeProperty(CONTROL_POINT_SET_KEY);
        if (object == PropertyManager.NOT_FOUND_OBJECT) {
            return false;
        }
        ControlPointSet controlPointSet = (ControlPointSet)object;
        Enumeration enumeration = controlPointSet.getControlPoints();
        while (enumeration.hasMoreElements()) {
            this._cpTable.remove((ControlPoint)enumeration.nextElement());
        }
        return true;
    }

    protected final ControlPointTable getControlPointTable() {
        return this._cpTable;
    }

    protected final void repaintWithControl(LayoutItem layoutItem, int n, int n2) {
        Rectangle rectangle = ItemUtils.parentToDevice(layoutItem, layoutItem.getItemBounds());
        JLECanvas jLECanvas = layoutItem.getCanvas();
        if (jLECanvas == null && (jLECanvas = this.getCanvas()) == null) {
            return;
        }
        int n3 = (int)Math.ceil((double)(n + this._cpXOff) * jLECanvas.getZoomX());
        int n4 = (int)Math.ceil((double)(n2 + this._cpYOff) * jLECanvas.getZoomY());
        rectangle.x -= n3;
        rectangle.y -= n4;
        rectangle.width += 2 * n3 + 1;
        rectangle.height += 2 * n4 + 1;
        jLECanvas.repaintCanvas(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private boolean _processMoveKey(JLEEvent jLEEvent) {
        LayoutItem[] layoutItemArray = this.getSelectedItems();
        int n = this._keyMove;
        int n2 = this._keyMove;
        boolean bl = false;
        if (layoutItemArray.length > 0) {
            double d;
            JLECanvas jLECanvas = this.getCanvas();
            double d2 = jLECanvas.getEngineUnitsPerPixelX();
            double d3 = jLECanvas.getEngineUnitsPerPixelY();
            int n3 = jLEEvent.getKeyCode();
            double d4 = n3 == 38 || n3 == 40 ? 0.0 : (d = n3 == 37 ? (double)n * -d2 : (double)n * d2);
            double d5 = n3 == 37 || n3 == 39 ? 0.0 : (n3 == 38 ? (double)n2 * -d3 : (double)n2 * d3);
            Object object = this._postUndo && layoutItemArray.length > 1 ? new CompoundEdit() : null;
            int n4 = 0;
            while (n4 < layoutItemArray.length) {
                LayoutItem layoutItem = layoutItemArray[n4];
                LayoutItem layoutItem2 = layoutItem.getItemParent();
                double d6 = d;
                double d7 = d5;
                GridSnap gridSnap = GridSnap.getGridSnap(layoutItem2);
                if (gridSnap != null) {
                    Dimension2D dimension2D = gridSnap.getGridInterval();
                    dimension2D = ItemUtils.itemToDeviceDouble(layoutItem2, dimension2D);
                    if (d6 < 0.0) {
                        d6 = dimension2D.getWidth() * -d2;
                    } else if (d6 > 0.0) {
                        d6 = dimension2D.getWidth() * d2;
                    }
                    if (d7 < 0.0) {
                        d7 = dimension2D.getHeight() * -d3;
                    } else if (d7 > 0.0) {
                        d7 = dimension2D.getHeight() * d3;
                    }
                    n = (int)Math.round(dimension2D.getWidth());
                    n2 = (int)Math.round(dimension2D.getHeight());
                }
                boolean bl2 = BoundsTool.processMove(layoutItem, d6, d7, this);
                bl |= bl2;
                if (bl2) {
                    this.repaintWithControl(layoutItem, n3 == 38 || n3 == 40 ? 0 : n, n3 == 37 || n3 == 39 ? 0 : n2);
                    if (this._postUndo) {
                        MoveUndo moveUndo = new MoveUndo(layoutItem, d6, d7, this);
                        if (layoutItemArray.length > 1) {
                            object.addEdit((UndoableEdit)moveUndo);
                        } else {
                            object = moveUndo;
                        }
                    }
                }
                ++n4;
            }
            if (this._postUndo) {
                if (layoutItemArray.length > 1) {
                    object.end();
                }
                jLECanvas.processUndoableEditEvent(new UndoableEditEvent((Object)this, (UndoableEdit)object));
            }
        }
        return bl;
    }

    private boolean _checkDragRejection(int n, LayoutItem[] layoutItemArray) {
        if (n == 1) {
            layoutItemArray = ItemUtils.removeChildren(this.getCanvas(), layoutItemArray);
        }
        int n2 = 0;
        while (n2 < layoutItemArray.length) {
            if (!this.fireBoundsToolEvent(n, layoutItemArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void _clearPad() {
        this._padDirty = true;
        this._padDown = Double.MAX_VALUE;
        this._padUp = Double.MAX_VALUE;
        this._padRight = Double.MAX_VALUE;
        this._padLeft = Double.MAX_VALUE;
    }

    private void _reducePadFromRectangle(double d, double d2, double d3, double d4) {
        double d5 = d - d3;
        double d6 = d2 - d4;
        ControlPoint controlPoint = this._dragged;
        if (controlPoint.isLeft()) {
            if (d5 < this._padRight) {
                this._padRight = d5;
            }
        } else if (controlPoint.isRight() && d5 < this._padLeft) {
            this._padLeft = d5;
        }
        if (controlPoint.isUpper()) {
            if (d6 < this._padDown) {
                this._padDown = d6;
            }
        } else if (controlPoint.isLower() && d6 < this._padUp) {
            this._padUp = d6;
        }
    }

    private void _padConstrainToParent(LayoutItem[] layoutItemArray) {
        ControlPoint controlPoint = this._dragged;
        boolean bl = controlPoint.getType() == 5;
        int n = 0;
        while (n < layoutItemArray.length) {
            double d;
            LayoutItem layoutItem = layoutItemArray[n];
            Rectangle2D rectangle2D = layoutItem.getItemBounds();
            Dimension2D dimension2D = layoutItem.getItemParent().getItemSize();
            double d2 = rectangle2D.getX();
            double d3 = rectangle2D.getY();
            double d4 = rectangle2D.getRight();
            double d5 = rectangle2D.getBottom();
            if ((bl || controlPoint.isLeft()) && d2 < this._padLeft) {
                this._padLeft = d2;
            }
            if ((bl || controlPoint.isRight()) && (d = dimension2D.getWidth() - d4) < this._padRight) {
                this._padRight = d;
            }
            if ((bl || controlPoint.isUpper()) && d3 < this._padUp) {
                this._padUp = d3;
            }
            if ((bl || controlPoint.isLower()) && (d = dimension2D.getHeight() - d5) < this._padDown) {
                this._padDown = d;
            }
            ++n;
        }
    }

    private void _padConstrainToParentTopLeft(LayoutItem[] layoutItemArray) {
        ControlPoint controlPoint = this._dragged;
        boolean bl = controlPoint.getType() == 5;
        int n = 0;
        while (n < layoutItemArray.length) {
            LayoutItem layoutItem = layoutItemArray[n];
            Rectangle2D rectangle2D = layoutItem.getItemBounds();
            Dimension2D dimension2D = layoutItem.getItemParent().getItemSize();
            double d = rectangle2D.getX();
            double d2 = rectangle2D.getY();
            double d3 = rectangle2D.getRight();
            double d4 = rectangle2D.getBottom();
            if ((bl || controlPoint.isLeft()) && d < this._padLeft) {
                this._padLeft = d;
            }
            if ((bl || controlPoint.isUpper()) && d2 < this._padUp) {
                this._padUp = d2;
            }
            ++n;
        }
    }

    private void _padConstrainToChildren(LayoutItem[] layoutItemArray) {
        int n = 0;
        while (n < layoutItemArray.length) {
            LayoutItem layoutItem = layoutItemArray[n];
            if (layoutItem.getItemCount() >= 1) {
                LayoutItem[] layoutItemArray2 = layoutItem.getItems();
                Dimension2D dimension2D = layoutItem.getItemSize();
                Rectangle2D rectangle2D = layoutItemArray2[0].getItemBounds();
                int n2 = 1;
                while (n2 < layoutItemArray2.length) {
                    rectangle2D.add(layoutItemArray2[n2].getItemBounds());
                    ++n2;
                }
                this._reducePadFromRectangle(dimension2D.getWidth(), dimension2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
            }
            ++n;
        }
    }

    private void _padConstrainToItem(LayoutItem[] layoutItemArray) {
        int n = 0;
        while (n < layoutItemArray.length) {
            LayoutItem layoutItem = layoutItemArray[n];
            Dimension2D dimension2D = BoundsTool.getMinimumSize(layoutItem);
            if (dimension2D != null) {
                Dimension2D dimension2D2 = layoutItem.getItemSize();
                this._reducePadFromRectangle(dimension2D2.getWidth(), dimension2D2.getHeight(), dimension2D.getWidth(), dimension2D.getHeight());
            }
            ++n;
        }
    }

    private void _padConstrainToGlobalMin(LayoutItem[] layoutItemArray) {
        int n = 0;
        while (n < layoutItemArray.length) {
            LayoutItem layoutItem = layoutItemArray[n];
            Dimension2D dimension2D = layoutItem.getItemSize();
            this._reducePadFromRectangle(dimension2D.getWidth(), dimension2D.getHeight(), this._minWidth, this._minHeight);
            ++n;
        }
    }

    private void _calculatePad(LayoutItem[] layoutItemArray) {
        if ((this._mode & 2) != 0) {
            this._padConstrainToParent(layoutItemArray);
        }
        if ((this._mode & 0x20) != 0) {
            this._padConstrainToParentTopLeft(layoutItemArray);
        }
        if ((this._mode & 1) != 0) {
            if ((this._mode & 8) != 0) {
                this._padConstrainToChildren(layoutItemArray);
            }
            if ((this._mode & 0x10) != 0) {
                this._padConstrainToItem(layoutItemArray);
            }
            this._padConstrainToGlobalMin(layoutItemArray);
        }
        this._padDirty = false;
    }

    private ControlPoint _adjustUndoControlPoint(double d, double d2, ControlPoint controlPoint) {
        boolean bl;
        boolean bl2 = d < 0.0;
        boolean bl3 = bl = d2 < 0.0;
        if (!bl2 && !bl) {
            return controlPoint;
        }
        int n = 0;
        switch (controlPoint.getType()) {
            case 5: {
                break;
            }
            case 4: {
                if (!bl2) break;
                n = 6;
                break;
            }
            case 6: {
                if (!bl2) break;
                n = 4;
                break;
            }
            case 9: {
                if (!bl) break;
                n = 1;
                break;
            }
            case 1: {
                if (!bl) break;
                n = 9;
                break;
            }
            case 8: {
                n = bl2 ? (bl ? 2 : 10) : 0;
                break;
            }
            case 10: {
                n = bl2 ? (bl ? 0 : 8) : 2;
                break;
            }
            case 0: {
                n = bl2 ? (bl ? 10 : 2) : 8;
                break;
            }
            case 2: {
                n = bl2 ? (bl ? 8 : 0) : 10;
            }
        }
        return new ControlPoint(n, 0.0, 0.0, null);
    }
}

