/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.item.LinkItem;
import oracle.bali.jle.item.LinkPort;
import oracle.bali.jle.tool.LinkTool;
import oracle.bali.jle.util.GeometryUtils;
import oracle.bali.jle.util.ItemUtils;

public class TwoPortLinkItem
extends LinkItem {
    private LinkPort _source;
    private LinkPort _destination;
    private LinkPort[] _sourcePorts;
    private LinkPort[] _destPorts;
    private boolean _sourceLocked = false;
    private boolean _destLocked = false;

    public TwoPortLinkItem(LinkPort linkPort, LinkPort linkPort2) {
        if (linkPort == null || linkPort2 == null) {
            throw new IllegalArgumentException();
        }
        this._setSourcePort(linkPort, false);
        this.setDestinationPort(linkPort2);
    }

    public TwoPortLinkItem(LinkPort[] linkPortArray, LinkPort[] linkPortArray2) {
        if (linkPortArray == null || linkPortArray2 == null || linkPortArray.length < 1 || linkPortArray2.length < 1) {
            throw new IllegalArgumentException();
        }
        this._sourcePorts = new LinkPort[linkPortArray.length];
        this._destPorts = new LinkPort[linkPortArray2.length];
        System.arraycopy(linkPortArray, 0, this._sourcePorts, 0, this._sourcePorts.length);
        System.arraycopy(linkPortArray2, 0, this._destPorts, 0, this._destPorts.length);
        this.setPorts(new LinkPort[]{this._sourcePorts[0], this._destPorts[0]});
        this.updatePorts(null);
    }

    public void setPorts(LinkPort[] linkPortArray) {
        if (linkPortArray == null || linkPortArray.length < 2) {
            throw new IllegalArgumentException();
        }
        this._setSourcePort(linkPortArray[0], false);
        this.setDestinationPort(linkPortArray[1]);
    }

    public LinkPort[] getPorts() {
        LinkPort[] linkPortArray = new LinkPort[]{this._source, this._destination};
        return linkPortArray;
    }

    public int getPortCount() {
        return 2;
    }

    public void setSourcePort(LinkPort linkPort) {
        this._setSourcePort(linkPort, true);
    }

    public void setDestinationPort(LinkPort linkPort) {
        if (linkPort == null) {
            throw new IllegalArgumentException();
        }
        if (this._destination != null) {
            this._destination.removeLinkPortListener(this);
        }
        this._destination = linkPort;
        this._destination.addLinkPortListener(this);
        this.updateBounds();
        this.repaintItem();
    }

    public LinkPort getSourcePort() {
        return this._source;
    }

    public LinkPort getDestinationPort() {
        return this._destination;
    }

    public void lockPort(LinkPort linkPort) {
        if (linkPort == this._destination) {
            this._destLocked = true;
        } else if (linkPort == this._source) {
            this._sourceLocked = true;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void unlockPort(LinkPort linkPort) {
        if (linkPort == this._destination) {
            this._destLocked = false;
        } else if (linkPort == this._source) {
            this._sourceLocked = false;
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected LinkPort[] updatePorts(LinkPort linkPort) {
        Object object;
        LinkPort linkPort2;
        LinkPort[] linkPortArray;
        LinkPort[] linkPortArray2;
        LinkPort[] linkPortArray3;
        LinkPort linkPort3 = this._source;
        LinkPort linkPort4 = this._destination;
        if (this._sourceLocked) {
            LinkPort[] linkPortArray4 = new LinkPort[1];
            linkPortArray3 = linkPortArray4;
            linkPortArray4[0] = this._source;
        } else {
            linkPortArray3 = linkPortArray2 = this._sourcePorts != null ? this._sourcePorts : LinkTool.getLinkPorts(this.getSourcePort().getItem());
        }
        if (this._destLocked) {
            LinkPort[] linkPortArray5 = new LinkPort[1];
            linkPortArray = linkPortArray5;
            linkPortArray5[0] = this._destination;
        } else {
            linkPortArray = this._destPorts != null ? this._destPorts : LinkTool.getLinkPorts(this.getDestinationPort().getItem());
        }
        LinkPort[] linkPortArray6 = linkPortArray;
        Point2D[] point2DArray = new Point2D[linkPortArray2.length];
        Point2D[] point2DArray2 = new Point2D[linkPortArray6.length];
        int n = 0;
        while (n < point2DArray.length) {
            linkPort2 = linkPortArray2[n];
            point2DArray[n] = linkPort2.isDead() ? null : ItemUtils.itemToDevice(linkPort2.getItem(), linkPort2.getX(), linkPort2.getY());
            ++n;
        }
        int n2 = 0;
        while (n2 < point2DArray2.length) {
            linkPort2 = linkPortArray6[n2];
            point2DArray2[n2] = linkPort2.isDead() ? null : ItemUtils.itemToDevice(linkPort2.getItem(), linkPort2.getX(), linkPort2.getY());
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        double d = Double.MAX_VALUE;
        int n5 = 0;
        while (n5 < point2DArray.length) {
            object = point2DArray[n5];
            if (object != null) {
                int n6 = 0;
                while (n6 < point2DArray2.length) {
                    double d2;
                    Point2D point2D = point2DArray2[n6];
                    if (point2D != null && (d2 = GeometryUtils.segmentLength(((Point2D)object).getX(), ((Point2D)object).getY(), point2D.getX(), point2D.getY())) < d) {
                        d = d2;
                        n3 = n5;
                        n4 = n6;
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        object = new LinkPort[]{linkPortArray2[n3], linkPortArray6[n4]};
        if (object[0] != linkPort3 || object[1] != linkPort4) {
            this.setPorts((LinkPort[])object);
        } else {
            this.updateBounds();
        }
        this.repaintItem();
        return object;
    }

    private void _setSourcePort(LinkPort linkPort, boolean bl) {
        if (linkPort == null) {
            throw new IllegalArgumentException();
        }
        if (this._source != null) {
            this._source.removeLinkPortListener(this);
        }
        this._source = linkPort;
        this._source.addLinkPortListener(this);
        if (bl) {
            this.updateBounds();
            this.repaintItem();
        }
    }
}

