/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseItem;
import oracle.bali.jle.item.DefaultLinkPainter;
import oracle.bali.jle.item.GridSnap;
import oracle.bali.jle.item.LinkPainter;
import oracle.bali.jle.item.LinkPort;
import oracle.bali.jle.item.LinkPortEvent;
import oracle.bali.jle.item.LinkPortListener;
import oracle.bali.jle.tool.BoundsTool;
import oracle.bali.jle.tool.LinkTool;
import oracle.bali.jle.util.ItemUtils;

public abstract class LinkItem
extends BaseItem
implements LinkPortListener {
    private LinkPort[] _ports;
    private String _label;
    private Vector _lockedPorts;
    private LinkPainter _painter;
    private static Vector _sLinkCollector;

    public LinkItem() {
        BoundsTool.setMovable(this, false);
        BoundsTool.setResizable(this, false);
        GridSnap.setGridSnapOverride(this, true);
    }

    public static Point getPortInDevice(LinkPort linkPort) {
        LayoutItem layoutItem = linkPort.getItem();
        return ItemUtils.itemToDevice(layoutItem, linkPort.getLocation());
    }

    public static Point2D getPortInDeviceDouble(LinkPort linkPort) {
        LayoutItem layoutItem = linkPort.getItem();
        return ItemUtils.itemToDevice(layoutItem, linkPort.getX(), linkPort.getY());
    }

    public static LayoutItem[] getAttachedItems(LayoutItem layoutItem) {
        Object[] objectArray;
        LinkPort[] linkPortArray = LinkTool.getLinkPorts(layoutItem);
        if (linkPortArray.length < 1) {
            return new LayoutItem[0];
        }
        if (_sLinkCollector == null) {
            _sLinkCollector = new Vector();
        }
        int n = 0;
        while (n < linkPortArray.length) {
            objectArray = linkPortArray[n].getLinkPortListeners();
            int n2 = 0;
            while (n2 < objectArray.length) {
                Object object = objectArray[n2];
                if (object instanceof LayoutItem && !_sLinkCollector.contains(object)) {
                    _sLinkCollector.addElement(object);
                }
                ++n2;
            }
            ++n;
        }
        objectArray = new LayoutItem[_sLinkCollector.size()];
        _sLinkCollector.copyInto(objectArray);
        _sLinkCollector.removeAllElements();
        return objectArray;
    }

    public abstract void setPorts(LinkPort[] var1);

    public abstract LinkPort[] getPorts();

    public abstract int getPortCount();

    public void setLinkPainter(LinkPainter linkPainter) {
        if (linkPainter != null && linkPainter != this._painter) {
            this._painter = linkPainter;
            this.updateBounds();
            this.repaintItem();
        }
    }

    public LinkPainter getLinkPainter() {
        if (this._painter == null) {
            this._painter = DefaultLinkPainter.getLinkPainter();
        }
        return this._painter;
    }

    public void portMoved(LinkPortEvent linkPortEvent) {
        this.updatePorts(linkPortEvent.getLinkPort());
    }

    public void portDead(LinkPortEvent linkPortEvent) {
        LinkPort linkPort = linkPortEvent.getLinkPort();
        linkPort.removeLinkPortListener(this);
        this.updatePorts(linkPort);
    }

    public void paintItemImpl(Graphics graphics, AffineTransform affineTransform) {
        this.getLinkPainter().paintLink(this, graphics, affineTransform);
    }

    public void paintItemZoomed(Graphics graphics, AffineTransform affineTransform, double d, double d2) {
        this.getLinkPainter().paintLink(this, graphics, affineTransform);
    }

    public boolean hitTest(double d, double d2) {
        return this.getLinkPainter().hitTest(this, d, d2);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void setItemParent(LayoutItem layoutItem) {
        super.setItemParent(layoutItem);
        if (this.getItemParent() == null) {
            LinkPort[] linkPortArray = this.getPorts();
            int n = 0;
            while (n < linkPortArray.length) {
                linkPortArray[n].removeLinkPortListener(this);
                ++n;
            }
        } else {
            this.updateBounds();
        }
    }

    protected abstract LinkPort[] updatePorts(LinkPort var1);

    protected void updateBounds() {
        Rectangle2D rectangle2D = this.getLinkPainter().getLinkBounds(this);
        if (rectangle2D == null) {
            return;
        }
        this.setItemBounds(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }
}

