/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.LinkItem;
import oracle.bali.jle.item.LinkPainter;
import oracle.bali.jle.item.LinkPort;
import oracle.bali.jle.tool.SelectionTool;
import oracle.bali.jle.util.GeometryUtils;
import oracle.bali.jle.util.ItemUtils;

public class DefaultLinkPainter
implements LinkPainter {
    private static DefaultLinkPainter _sPainter;
    private Color _selectionColor = Color.red;
    private Color _normalColor = Color.black;
    private static int _sMINIMUM_DIM;
    private static int _sBOUNDS_INC;
    private static int _sHitWidth;
    private static int _sArrowHeight;

    public static DefaultLinkPainter getLinkPainter() {
        if (_sPainter == null) {
            _sPainter = new DefaultLinkPainter();
        }
        return _sPainter;
    }

    private DefaultLinkPainter() {
    }

    public Rectangle2D getLinkBounds(LinkItem linkItem) {
        if (linkItem.getItemParent() == null) {
            return null;
        }
        LinkPort[] linkPortArray = linkItem.getPorts();
        Point2D point2D = ItemUtils.itemToDevice(linkPortArray[0].getItem(), linkPortArray[0].getX(), linkPortArray[0].getY());
        Rectangle2D rectangle2D = new Rectangle2D.Double(point2D.getX(), point2D.getY(), _sMINIMUM_DIM, _sMINIMUM_DIM);
        int n = linkItem.getPortCount();
        int n2 = 1;
        while (n2 < n) {
            LinkPort linkPort = linkPortArray[n2];
            Point2D point2D2 = ItemUtils.itemToDevice(linkPort.getItem(), linkPort.getX(), linkPort.getY());
            rectangle2D.add(point2D2);
            ++n2;
        }
        rectangle2D = ItemUtils.deviceToItem(linkItem.getItemParent(), rectangle2D);
        return new Rectangle2D.Double(rectangle2D.getX() - (double)_sBOUNDS_INC, rectangle2D.getY() - (double)_sBOUNDS_INC, rectangle2D.getWidth() + (double)(2 * _sBOUNDS_INC), rectangle2D.getHeight() + (double)(2 * _sBOUNDS_INC));
    }

    public void paintLink(LinkItem linkItem, Graphics graphics, AffineTransform affineTransform) {
        double d;
        boolean bl;
        LinkPort[] linkPortArray = linkItem.getPorts();
        LinkPort linkPort = linkPortArray[0];
        LinkPort linkPort2 = linkPortArray[linkPortArray.length - 1];
        Point2D point2D = LinkItem.getPortInDeviceDouble(linkPort);
        Point2D point2D2 = LinkItem.getPortInDeviceDouble(linkPort2);
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = point2D2.getX();
        double d5 = point2D2.getY();
        double d6 = Math.abs(d3 - d5);
        boolean bl2 = bl = d6 >= (d = Math.abs(d2 - d4));
        double d7 = bl ? (d3 <= d5 ? d3 + d6 / 2.0 : d5 + d6 / 2.0) : (d2 <= d4 ? d2 + d / 2.0 : d4 + d / 2.0);
        Point point = null;
        Point point2 = null;
        Point point3 = GeometryUtils.toPoint(point2D);
        Point point4 = GeometryUtils.toPoint(point2D2);
        Color color = graphics.getColor();
        if (SelectionTool.isSelected(linkItem)) {
            graphics.setColor(this._selectionColor);
        } else {
            graphics.setColor(this._normalColor);
        }
        if (bl) {
            point = new Point(point3.x, (int)Math.round(d7));
            point2 = new Point(point4.x, (int)Math.round(d7));
            if (linkPort2.isLower()) {
                this._paintVertArrow(graphics, point4, true);
            } else {
                this._paintVertArrow(graphics, point4, false);
            }
        } else {
            point = new Point((int)Math.round(d7), point3.y);
            point2 = new Point((int)Math.round(d7), point4.y);
            if (linkPort2.isRight()) {
                this._paintHorizArrow(graphics, point4, true);
            } else {
                this._paintHorizArrow(graphics, point4, false);
            }
        }
        graphics.drawLine(point3.x, point3.y, point.x, point.y);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        graphics.drawLine(point2.x, point2.y, point4.x, point4.y);
        graphics.setColor(color);
    }

    public boolean hitTest(LinkItem linkItem, double d, double d2) {
        double d3;
        boolean bl;
        Point2D point2D = ItemUtils.itemToDevice(linkItem, d, d2);
        LinkPort[] linkPortArray = linkItem.getPorts();
        LinkPort linkPort = linkPortArray[0];
        LinkPort linkPort2 = linkPortArray[linkPortArray.length - 1];
        Point2D point2D2 = LinkItem.getPortInDeviceDouble(linkPortArray[0]);
        Point2D point2D3 = LinkItem.getPortInDeviceDouble(linkPortArray[linkPortArray.length - 1]);
        double d4 = point2D2.getX();
        double d5 = point2D2.getY();
        double d6 = point2D3.getX();
        double d7 = point2D3.getY();
        double d8 = point2D.getX();
        double d9 = point2D.getY();
        double d10 = Math.abs(d5 - d7);
        boolean bl2 = bl = d10 >= (d3 = Math.abs(d4 - d6));
        double d11 = bl ? (d5 <= d7 ? d5 + d10 / 2.0 : d7 + d10 / 2.0) : (d4 <= d6 ? d4 + d3 / 2.0 : d6 + d3 / 2.0);
        Point point = null;
        Point point2 = null;
        Point point3 = GeometryUtils.toPoint(point2D2);
        Point point4 = GeometryUtils.toPoint(point2D3);
        if (bl) {
            Point point5;
            point = new Point(point3.x, (int)Math.round(d11));
            point2 = new Point(point4.x, (int)Math.round(d11));
            Point point6 = point3.y <= point4.y ? point3 : point4;
            Point point7 = point6 == point3 ? point4 : point3;
            Point point8 = point.x <= point2.x ? point : point2;
            Point point9 = point5 = point8 == point ? point2 : point;
            if (d9 >= (double)point6.y && d9 <= (double)point8.y && d8 >= (double)(point6.x - _sHitWidth) && d8 <= (double)(point6.x + _sHitWidth)) {
                return true;
            }
            if (d8 >= (double)point8.x && d8 <= (double)point5.x && d9 >= (double)(point8.y - _sHitWidth) && d9 <= (double)(point8.y + _sHitWidth)) {
                return true;
            }
            if (d9 <= (double)point7.y && d9 >= (double)point8.y && d8 >= (double)(point7.x - _sHitWidth) && d8 <= (double)(point7.x + _sHitWidth)) {
                return true;
            }
        } else {
            Point point10;
            point = new Point((int)Math.round(d11), point3.y);
            point2 = new Point((int)Math.round(d11), point4.y);
            Point point11 = point.y <= point2.y ? point : point;
            Point point12 = point11 == point ? point2 : point;
            Point point13 = point3.x <= point4.x ? point3 : point4;
            Point point14 = point10 = point13 == point3 ? point4 : point3;
            if (d8 >= (double)point13.x && d8 <= (double)point11.x && d9 >= (double)(point13.y - _sHitWidth) && d9 <= (double)(point13.y + _sHitWidth)) {
                return true;
            }
            if (d9 >= (double)point11.y && d9 <= (double)point12.y && d8 >= (double)(point11.x - _sHitWidth) && d8 <= (double)(point11.x + _sHitWidth)) {
                return true;
            }
            if (d8 >= (double)point11.x && d8 <= (double)point10.x && d9 >= (double)(point10.y - _sHitWidth) && d9 <= (double)(point10.y + _sHitWidth)) {
                return true;
            }
        }
        return false;
    }

    public Color getSelectionColor() {
        return this._selectionColor;
    }

    public Color getLinkColor() {
        return this._normalColor;
    }

    public void setSelectionColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this._selectionColor = color;
    }

    public void setLinkColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this._normalColor = color;
    }

    private void _paintVertArrow(Graphics graphics, Point point, boolean bl) {
        int n = point.x;
        int n2 = point.y;
        int n3 = bl ? 1 : -1;
        int n4 = 0;
        while (n4 < _sArrowHeight) {
            graphics.drawLine(n - n4, n2, n + n4, n2);
            n2 += n3;
            ++n4;
        }
    }

    private void _paintHorizArrow(Graphics graphics, Point point, boolean bl) {
        int n = point.x;
        int n2 = point.y;
        int n3 = bl ? 1 : -1;
        int n4 = 0;
        while (n4 < _sArrowHeight) {
            graphics.drawLine(n, n2 - n4, n, n2 + n4);
            n += n3;
            ++n4;
        }
    }

    static {
        _sMINIMUM_DIM = 1;
        _sBOUNDS_INC = 1;
        _sHitWidth = 4;
        _sArrowHeight = 5;
    }
}

