/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.event.JLEEvent;
import oracle.ewt.timer.Timer;

public final class JLEAutoScroller
implements Runnable {
    private static int _INITIAL_SCROLLING_DELAY = 100;
    private static int _REPEAT_SCROLLING_DELAY = 50;
    private static final int _MULTIPLE_DIVISOR = 10;
    private static final int _MULTIPLE_MAX = 3;
    private static int _SCROLL_INTERVAL = 10;
    private static int _SCROLL_MARGIN = 5;
    private static JLEAutoScroller _sAutoScroller;
    private JLECanvas _canvas;
    private Timer _timer = new Timer((Runnable)this, "JLEAutoScroller");
    private int _scrollX;
    private int _scrollY;
    private boolean _cancelled;

    private JLEAutoScroller() {
    }

    public static JLEAutoScroller getJLEAutoScroller() {
        if (_sAutoScroller == null) {
            _sAutoScroller = new JLEAutoScroller();
        }
        return _sAutoScroller;
    }

    public static int getInitialScrollingDelay() {
        return _INITIAL_SCROLLING_DELAY;
    }

    public static void setInitialScrollingDelay(int n) {
        _INITIAL_SCROLLING_DELAY = n;
    }

    public static int getRepeatScrollingDelay() {
        return _REPEAT_SCROLLING_DELAY;
    }

    public static void setRepeatScrollingDelay(int n) {
        _REPEAT_SCROLLING_DELAY = n;
    }

    public static int getScrollInterval() {
        return _SCROLL_INTERVAL;
    }

    public static void setScrollInterval(int n) {
        _SCROLL_INTERVAL = n;
    }

    public static int getScrollMargin() {
        return _SCROLL_MARGIN;
    }

    public static void setScrollMargin(int n) {
        _SCROLL_MARGIN = n;
    }

    public void schedule(JLECanvas jLECanvas, int n, int n2) {
        this._canvas = jLECanvas;
        this._cancelled = false;
        this._scrollX = n;
        this._scrollY = n2;
        this._timer.schedule((long)_INITIAL_SCROLLING_DELAY);
    }

    public void run() {
        if (this._cancelled) {
            return;
        }
        int n = this._scrollX;
        int n2 = this._scrollY;
        Rectangle rectangle = this._canvas.getCanvasBounds();
        Rectangle rectangle2 = this._canvas.getInnerBounds();
        int n3 = 0;
        int n4 = 0;
        if (n != 0) {
            n3 = n / 10;
            n3 = n < 0 ? --n3 : ++n3;
            if (n3 > 3) {
                n3 = 3;
            } else if (n3 < -3) {
                n3 = -3;
            }
            n3 *= _SCROLL_INTERVAL;
        }
        if (n2 != 0) {
            n4 = this._scrollY / 10;
            n4 = n2 < 0 ? --n4 : ++n4;
            if (n4 > 3) {
                n4 = 3;
            } else if (n4 < -3) {
                n4 = -3;
            }
            n4 *= _SCROLL_INTERVAL;
        }
        try {
            this._canvas.freezeRepaints();
            this._canvas.setCanvasOrigin(rectangle.x - n3, rectangle.y - n4);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this._canvas.unfreezeRepaints();
            throw throwable;
        }
        this._canvas.unfreezeRepaints();
        this._timer.schedule((long)_REPEAT_SCROLLING_DELAY);
    }

    public void cancel() {
        this._cancelled = true;
        this._timer.cancel();
    }

    public void cancel(JLECanvas jLECanvas) {
        if (this._canvas == jLECanvas) {
            this.cancel();
        }
    }

    public boolean checkAutoScroll(JLECanvas jLECanvas, JLEEvent jLEEvent) {
        Rectangle rectangle = jLECanvas.getCanvasBounds();
        Dimension dimension = jLECanvas.getInnerSize();
        Point point = jLECanvas.contentToDevice(jLEEvent.getX(), jLEEvent.getY());
        int n = point.x + rectangle.x;
        n = n < _SCROLL_MARGIN && rectangle.x < 0 ? (n - _SCROLL_MARGIN) / _SCROLL_MARGIN - 1 : (n > dimension.width - _SCROLL_MARGIN ? (n - (dimension.width - _SCROLL_MARGIN)) / _SCROLL_MARGIN + 1 : 0);
        int n2 = point.y + rectangle.y;
        n2 = n2 < _SCROLL_MARGIN && rectangle.y < 0 ? (n2 - _SCROLL_MARGIN) / _SCROLL_MARGIN - 1 : (n2 > dimension.height - _SCROLL_MARGIN ? (n2 - (dimension.height - _SCROLL_MARGIN)) / _SCROLL_MARGIN + 1 : 0);
        if (n != 0 || n2 != 0) {
            JLEAutoScroller.getJLEAutoScroller().schedule(jLECanvas, n, n2);
            return true;
        }
        JLEAutoScroller.getJLEAutoScroller().cancel();
        return false;
    }
}

