/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sqlserver7;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.metadata.persistence.PrepareClobHelper;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.core.MigrationContext;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.sqlserver7.SQLServer7CaptureQueries;
import oracle.dbtools.migration.workbench.sqlserver7.SQLServer7CapturerColumnInfo;
import oracle.dbtools.migration.workbench.sqlserver7.SQLServer7CapturerColumnsBySelect;
import oracle.dbtools.migration.workbench.sqlserver7.SQLServerMessages;

public abstract class SQLServer7AbstractCapturer {
    protected Connection m_repositoryConnection = null;
    protected MigrationStorer m_storer = null;
    public static final String MY_LANGUAGE_ID = "MSTSQL";
    public static final String NEWID_FUNCTION = "(newid())";
    public static final String DDL_NOT_ACCESSIBLE = "/* ddl not accessible */";
    protected boolean m_online = true;
    public static int OfflineDbId;
    public static String[] s_sqlServerDatabasesToSkip;
    private static String s_sqlServerDatabaseToUse;
    private static SQLServer7CaptureQueries s_captureQueries;

    public static String getSqlServerDatabaseToUse() {
        return s_sqlServerDatabaseToUse;
    }

    public static void setSqlServerDatabaseToUse(String string) {
        s_sqlServerDatabaseToUse = string;
    }

    protected abstract String getShowUsersInDatabase(String var1);

    protected abstract String andExistsTablesOrProcedures(String var1);

    protected String getXTypeWhere() {
        return " a2.xtype = 'U' ";
    }

    protected String getXTypeWhereInIndex() {
        return " o.xtype = 'U' ";
    }

    protected String getForCaptureIndex() {
        return " i.reserved > 0 ";
    }

    protected String getWhereForStoredPrograms() {
        return " ( a.xtype = 'P' OR a.xtype = 'FN' OR a.xtype = 'TF' OR a.xtype = 'IF') ";
    }

    protected abstract String getDatabasesString();

    protected abstract String getTablesString(String var1);

    protected abstract String getColumnsString(String var1, int var2);

    protected abstract String getBaseTypeString(String var1, int var2);

    protected abstract String getColumnDefaultString(String var1, int var2);

    protected abstract String getCaptureIndexString(String var1);

    protected abstract String getPrimaryKeyString(String var1);

    protected abstract String getIndexString(String var1, int var2, int var3);

    protected abstract String captureUniqueAndPrimaryKeysString(String var1);

    protected abstract String captureForeignKeysStringString(String var1);

    protected abstract String getTableNameAndUserString(String var1, int var2);

    protected abstract String captureTableLevelCheckConstraintString(String var1);

    protected abstract String captureColumnLevelCheckConstraintString(String var1);

    protected abstract String captureRulesString(String var1);

    protected abstract String captureRulesTextString(String var1);

    protected abstract String captureViewOuterString(String var1);

    protected abstract String captureViewInnerString(String var1);

    protected abstract String captureStoredProgramOuterString(String var1);

    protected abstract String captureStoredProgramInnerString(String var1, String var2);

    protected abstract String captureCommentsString();

    protected abstract String captureTriggersString(String var1);

    protected abstract String captureRolesString(String var1);

    protected abstract String getColumnNameString(String var1);

    protected abstract void capturePrivileges(Connection var1, MigrationStorer var2, CaptureContext var3, ArrayList<MdGroup> var4, MdGroup var5, MdUser var6) throws SQLException, PersistenceException;

    protected abstract void captureRoleMembership(Connection var1, MigrationStorer var2, CaptureContext var3, ArrayList<MdGroup> var4) throws SQLException, PersistenceException;

    public CaptureQueries getCaptureQueries() {
        if (s_captureQueries == null) {
            s_captureQueries = new SQLServer7CaptureQueries();
        }
        return s_captureQueries;
    }

    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        try {
            int n = 0;
            if (string.equals("MD_CATALOGS")) {
                this.captureCatalog(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_SCHEMAS")) {
                this.captureSchema(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_USERS")) {
                this.captureUser(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_TABLES")) {
                this.captureTable(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_COLUMNS")) {
                ++n;
            } else if (string.equals("MD_INDEXES")) {
                this.captureIndex(captureContext);
            } else if (string.equals("MD_INDEX_DETAILS")) {
                ++n;
            } else if (string.equals("MD_CONSTRAINTS")) {
                this.captureUniqueAndPrimaryKeys(captureContext);
                this.captureForeignKeys(captureContext);
                this.captureTableLevelCheckConstraint(captureContext);
                this.captureColumnLevelCheckConstraint(captureContext);
                this.captureRules(captureContext);
            } else if (string.equals("MD_CONSTRAINT_DETAILS")) {
                ++n;
            } else if (string.equals("MD_VIEWS")) {
                this.captureView(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_STORED_PROGRAMS")) {
                this.captureStoredProgram(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_TRIGGERS")) {
                this.captureTriggers(captureContext);
            } else if (string.equals("MD_GROUPS")) {
                this.captureRoles(captureContext, migrationObjectFilter);
            }
        }
        catch (SQLException sQLException) {
            throw new CaptureException((Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureCatalog(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        SQLServer7CapturerColumnsBySelect.clearHashSet();
        try {
            String string = this.getDatabasesString();
            HashSet<String> hashSet = null;
            if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals("MD_CATALOGS")) {
                throw new IllegalArgumentException(SQLServerMessages.getString("SQLServer7AbstractCapturer.12") + migrationObjectFilter.getObjectType());
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                string = string + " and name " + migrationObjectFilter.getWhereClause();
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
                hashSet = new HashSet<String>();
                for (String mdCatalog : migrationObjectFilter.getObjectNames()) {
                    hashSet.add(mdCatalog);
                }
            }
            String[] stringArray = (String[])captureContext.getContextVariable("CONNECTIONID");
            preparedStatement = this.getRepositoryConnection().prepareStatement(string);
            if (!this.m_online) {
                preparedStatement.setInt(1, OfflineDbId);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2;
                String string22 = null;
                string22 = resultSet.getString(1);
                int n = 0;
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string2 = string22)) {
                    n = 1;
                }
                for (String string3 : s_sqlServerDatabasesToSkip) {
                    if (!string22.toLowerCase().equals(string3)) continue;
                    n = 1;
                    break;
                }
                if (SQLServer7AbstractCapturer.getSqlServerDatabaseToUse() != null && !string22.toLowerCase().equals(SQLServer7AbstractCapturer.getSqlServerDatabaseToUse().toLowerCase())) {
                    n = 1;
                }
                if (n != 0) continue;
                MdCatalog mdCatalog = new MdCatalog((DBObjectId)stringArray);
                mdCatalog.setCatalogName(string22);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CATALOGS"), mdCatalog.getCatalogName());
                captureContext.getAudience().fireListeners(captureEvent);
                MdCatalog mdCatalog2 = (MdCatalog)this.getStorer().storeObject((PersistableObject)mdCatalog);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
                bl = true;
            }
            if (!bl) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "SQLSERVER.NO_CATALOGS", s_sqlServerDatabasesToSkip);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(preparedStatement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureSchema(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        MdCatalog mdCatalog = (MdCatalog)captureContext.getContextVariable("CATALOG");
        try {
            String string = mdCatalog.getCatalogName();
            String string2 = this.getShowUsersInDatabase(this.getDatabase((MigrationContext)captureContext)) + " " + this.andExistsTablesOrProcedures(this.getDatabase((MigrationContext)captureContext));
            HashSet<String> hashSet = null;
            if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals("MD_SCHEMAS")) {
                throw new IllegalArgumentException(SQLServerMessages.getString("SQLServer7AbstractCapturer.16") + migrationObjectFilter.getObjectType());
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                string2 = string2 + " and u.name " + migrationObjectFilter.getWhereClause();
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
                hashSet = new HashSet<String>();
                for (String string3 : migrationObjectFilter.getObjectNames()) {
                    hashSet.add(string3);
                }
            }
            preparedStatement = this.getRepositoryConnection().prepareStatement(string2);
            if (!this.m_online) {
                preparedStatement.setString(1, this.getDatabase((MigrationContext)captureContext));
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3;
                String string4 = resultSet.getString(1);
                String string5 = resultSet.getString(2);
                int n = 1;
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string5)) {
                    n = 0;
                }
                if (n == 0) continue;
                string3 = new MdSchema(mdCatalog.getKey());
                string3.setName(string5);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_SCHEMAS"), string5);
                captureContext.getAudience().fireListeners(captureEvent);
                AdditionalProperty additionalProperty = new AdditionalProperty("Login", string4);
                string3.addProperty(additionalProperty, mdCatalog.getConnectionId());
                string3 = (MdSchema)this.getStorer().storeObject((PersistableObject)string3);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
            CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
        }
        catch (SQLException sQLException) {
            MigrationLogUtil.logThrowable((String)sQLException.getLocalizedMessage(), (String)"Capture", (Throwable)sQLException);
        }
        finally {
            CloseableResultSet.close(preparedStatement, resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureUser(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        MdSchema mdSchema = (MdSchema)captureContext.getContextVariable("SCHEMAOBJ");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = "select ? name ";
            HashSet<String> hashSet = null;
            if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals("MD_USERS")) {
                throw new IllegalArgumentException(SQLServerMessages.getString("SQLServer7AbstractCapturer.21") + migrationObjectFilter.getObjectType());
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                string = string + " where name " + migrationObjectFilter.getWhereClause();
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
                hashSet = new HashSet<String>();
                for (String string2 : migrationObjectFilter.getObjectNames()) {
                    hashSet.add(string2);
                }
            }
            boolean bl = false;
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                preparedStatement = this.getRepositoryConnection().prepareStatement(string);
                preparedStatement.setString(1, mdSchema.getName());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            int n = 1;
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(mdSchema.getName())) {
                n = 0;
            }
            if (n != 0 && bl) {
                String string2;
                MdUser mdUser = new MdUser(mdSchema.getKey(), mdSchema.getName());
                string2 = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_USER"), mdSchema.getName());
                captureContext.getAudience().fireListeners((CaptureEvent)string2);
                mdUser = (MdUser)this.getStorer().storeObject((PersistableObject)mdUser);
                string2.setEventId(4);
                captureContext.getAudience().fireListeners((CaptureEvent)string2);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(preparedStatement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close((Statement)preparedStatement, resultSet);
    }

    protected void captureTable(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        MdSchema mdSchema = null;
        mdSchema = (MdSchema)captureContext.getContextVariable("SCHEMAOBJ");
        this.mapTable(mdSchema, captureContext, migrationObjectFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void mapTable(MdSchema mdSchema, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException {
        block53: {
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
            String string = this.getDatabase((MigrationContext)captureContext);
            PreparedStatement preparedStatement = null;
            PreparedStatement preparedStatement2 = null;
            ResultSet resultSet = null;
            ResultSet resultSet2 = null;
            try {
                String string2 = this.getTablesString(string);
                HashSet<String> hashSet = null;
                if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals("MD_TABLES")) {
                    throw new IllegalArgumentException(SQLServerMessages.getString("SQLServer7AbstractCapturer.23") + migrationObjectFilter.getObjectType());
                }
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                    string2 = string2 + " and a.name " + migrationObjectFilter.getWhereClause();
                }
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
                    hashSet = new HashSet<String>();
                    for (String string3 : migrationObjectFilter.getObjectNames()) {
                        hashSet.add(string3);
                    }
                }
                preparedStatement2 = this.getRepositoryConnection().prepareStatement(string2);
                if (!this.m_online) {
                    preparedStatement2.setString(1, string);
                    preparedStatement2.setString(2, mdSchema.getName());
                } else {
                    preparedStatement2.setString(1, mdSchema.getName());
                }
                String string4 = "";
                int n = 0;
                resultSet = preparedStatement2.executeQuery();
                while (resultSet.next()) {
                    String string5 = resultSet.getString(1);
                    n = resultSet.getInt(2);
                    int n2 = 1;
                    if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string5)) {
                        n2 = 0;
                    }
                    if (n2 == 0) continue;
                    int n3 = 1;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    resultSet2 = null;
                    try {
                        String string6 = this.getColumnsString(string, n);
                        preparedStatement = this.getRepositoryConnection().prepareStatement(string6);
                        if (!this.m_online) {
                            preparedStatement.setString(1, string);
                        }
                        resultSet2 = preparedStatement.executeQuery();
                        boolean bl = false;
                        MdTable mdTable = null;
                        while (resultSet2.next()) {
                            Object object;
                            Object object2;
                            Object object3;
                            Object object4;
                            if (!bl) {
                                Object object5;
                                void var12_17;
                                bl = true;
                                object4 = "[" + string + "].[" + mdSchema.getName() + "].[" + (String)var12_17 + "]";
                                mdTable = new MdTable(mdSchema.getKey(), (String)var12_17, (String)object4);
                                object3 = null;
                                object2 = null;
                                String string7 = this.captureCommentsString();
                                if (string7 != null) {
                                    try {
                                        object3 = this.getRepositoryConnection().prepareStatement(string7);
                                        object3.setInt(1, n);
                                        object3.setInt(2, 0);
                                        object2 = object3.executeQuery();
                                        if (object2.next()) {
                                            object5 = object2.getString(1);
                                            mdTable.setComments((String)object5);
                                        }
                                    }
                                    catch (SQLException sQLException) {
                                        MigrationLogUtil.logThrowable((String)sQLException.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturer.11"), (Throwable)sQLException);
                                    }
                                    finally {
                                        CloseableResultSet.close((Statement)object3, (ResultSet)object2);
                                    }
                                }
                                object5 = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_TABLES"), (String)var12_17);
                                captureContext.getAudience().fireListeners(object5);
                                mdTable = (MdTable)this.getStorer().storeObject((PersistableObject)mdTable);
                                object5.setEventId(4);
                                captureContext.getAudience().fireListeners(object5);
                            }
                            object4 = new SQLServer7CapturerColumnInfo();
                            String string8 = resultSet2.getString(1);
                            object2 = object3 = resultSet2.getString(5);
                            ((SQLServer7CapturerColumnInfo)object4).setNativeColumnName(resultSet2.getString(3));
                            ((SQLServer7CapturerColumnInfo)object4).setColumnOrder(resultSet2.getInt(4));
                            ((SQLServer7CapturerColumnInfo)object4).setNativeColumnType((String)object3);
                            int n7 = resultSet2.getInt(6);
                            boolean bl2 = resultSet2.wasNull();
                            if (bl2) {
                                ((SQLServer7CapturerColumnInfo)object4).setNativeColumnLength(null);
                            } else {
                                ((SQLServer7CapturerColumnInfo)object4).setNativeColumnLength(n7);
                            }
                            int n8 = resultSet2.getInt(7);
                            boolean bl3 = resultSet2.wasNull();
                            int n9 = resultSet2.getInt(8);
                            if (resultSet2.wasNull()) {
                                ((SQLServer7CapturerColumnInfo)object4).setNativeColumnScale(null);
                            } else {
                                ((SQLServer7CapturerColumnInfo)object4).setNativeColumnScale(n9);
                            }
                            if (resultSet2.getInt(9) == 16) {
                                ((SQLServer7CapturerColumnInfo)object4).setStatus(0);
                            } else {
                                ((SQLServer7CapturerColumnInfo)object4).setStatus(resultSet2.getInt(9));
                            }
                            n4 = resultSet2.getInt(10);
                            n5 = resultSet2.getInt(11);
                            n6 = resultSet2.getInt(12);
                            String string9 = this.baseType(n5, string);
                            ((SQLServer7CapturerColumnInfo)object4).setColumnDefaultText(this.columnDefault(n6, string, string9));
                            if (n4 > 256) {
                                ((SQLServer7CapturerColumnInfo)object4).setNativeColumnType(string9);
                            }
                            if (((String)(object3 = ((SQLServer7CapturerColumnInfo)object4).getNativeColumnType())).equalsIgnoreCase("varchar") || ((String)object3).equalsIgnoreCase("nvarchar") || ((String)object3).equalsIgnoreCase("nchar") || ((String)object3).equalsIgnoreCase("char") || ((String)object3).equalsIgnoreCase("varbinary") || ((String)object3).equalsIgnoreCase("binary")) {
                                if (bl2) {
                                    ((SQLServer7CapturerColumnInfo)object4).setNativeColumnPrecision(null);
                                } else if (((String)object3).equalsIgnoreCase("nvarchar") || ((String)object3).equalsIgnoreCase("nchar")) {
                                    ((SQLServer7CapturerColumnInfo)object4).setNativeColumnPrecision(n7 / 2);
                                } else {
                                    ((SQLServer7CapturerColumnInfo)object4).setNativeColumnPrecision(n7);
                                }
                            } else if (bl3) {
                                ((SQLServer7CapturerColumnInfo)object4).setNativeColumnPrecision(null);
                            } else {
                                ((SQLServer7CapturerColumnInfo)object4).setNativeColumnPrecision(n8);
                            }
                            Integer[] integerArray = SQLServer7CapturerColumnsBySelect.getPrecisionScaleIdentity(((SQLServer7CapturerColumnInfo)object4).getNativeColumnType(), ((SQLServer7CapturerColumnInfo)object4).getNativeColumnPrecision(), ((SQLServer7CapturerColumnInfo)object4).getNativeColumnScale());
                            ((SQLServer7CapturerColumnInfo)object4).setNativeColumnPrecision(integerArray[0]);
                            ((SQLServer7CapturerColumnInfo)object4).setNativeColumnScale(integerArray[1]);
                            Object object6 = null;
                            object6 = ((SQLServer7CapturerColumnInfo)object4).getStatus() == 128 ? new MdIdentityColumn(mdTable.getKey(), ((SQLServer7CapturerColumnInfo)object4).getNativeColumnName(), Integer.valueOf(n3), 1L, dBObjectId) : new MdColumn(mdTable.getKey(), ((SQLServer7CapturerColumnInfo)object4).getNativeColumnName(), Integer.valueOf(n3));
                            object6.setColumnType(((SQLServer7CapturerColumnInfo)object4).getNativeColumnType());
                            object6.setDefaultValue(((SQLServer7CapturerColumnInfo)object4).getColumnDefaultText());
                            if (((SQLServer7CapturerColumnInfo)object4).getColumnDefaultText().equalsIgnoreCase(NEWID_FUNCTION)) {
                                object6.addProperty(NEWID_FUNCTION, "Y", dBObjectId);
                            }
                            if (((SQLServer7CapturerColumnInfo)object4).getStatus() == 0) {
                                object6.setNullable("N");
                            } else {
                                object6.setNullable("Y");
                            }
                            object6.setPrecision(((SQLServer7CapturerColumnInfo)object4).getNativeColumnPrecision());
                            object6.setScale(((SQLServer7CapturerColumnInfo)object4).getNativeColumnScale());
                            PreparedStatement preparedStatement3 = null;
                            ResultSet resultSet3 = null;
                            String string10 = this.captureCommentsString();
                            if (string10 != null) {
                                try {
                                    preparedStatement3 = this.getRepositoryConnection().prepareStatement(string10);
                                    preparedStatement3.setInt(1, n);
                                    preparedStatement3.setInt(2, n3);
                                    resultSet3 = preparedStatement3.executeQuery();
                                    if (resultSet3.next()) {
                                        object = resultSet3.getString(1);
                                        object6.setComments((String)object);
                                    }
                                    CloseableResultSet.close((Statement)preparedStatement3, (ResultSet)resultSet3);
                                }
                                catch (SQLException sQLException) {
                                    MigrationLogUtil.logThrowable((String)sQLException.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturer.11"), (Throwable)sQLException);
                                }
                                finally {
                                    CloseableResultSet.close((Statement)preparedStatement3, resultSet3);
                                }
                            }
                            object = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_COLUMNS"), ((SQLServer7CapturerColumnInfo)object4).getNativeColumnName());
                            captureContext.getAudience().fireListeners(object);
                            object6 = (MdColumn)this.getStorer().storeObject((PersistableObject)object6);
                            object.setEventId(4);
                            captureContext.getAudience().fireListeners(object);
                            if (n4 > 256) {
                                SQLServer7CapturerColumnsBySelect.registerUserDefinedType(this.getStorer(), (String)object2, mdSchema, (SQLServer7CapturerColumnInfo)object4, object6);
                            }
                            ++n3;
                        }
                        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet2);
                    }
                    catch (SQLException sQLException) {
                        MigrationLogUtil.logThrowable((String)sQLException.getLocalizedMessage(), (String)"Capture", (Throwable)sQLException);
                        CloseableResultSet.close((Statement)preparedStatement, resultSet2);
                    }
                }
                CloseableResultSet.close(preparedStatement, resultSet2);
            }
            catch (Exception exception) {
                MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)"Capture", (Throwable)exception);
                break block53;
            }
            finally {
                CloseableResultSet.close(preparedStatement, resultSet2);
                CloseableResultSet.close(preparedStatement2, resultSet);
            }
            CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String baseType(int n, String string) {
        String string2 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getRepositoryConnection().prepareStatement(this.getBaseTypeString(string, n));
            if (!this.m_online) {
                preparedStatement.setString(1, string);
            }
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            string2 = resultSet.getString(1);
        }
        catch (SQLException sQLException) {
            try {
                MigrationLogUtil.logThrowable((String)sQLException.getLocalizedMessage(), (String)"Capture", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(preparedStatement, resultSet);
                throw throwable;
            }
            CloseableResultSet.close((Statement)preparedStatement, resultSet);
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String columnDefault(int n, String string, String string2) {
        String string3 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getRepositoryConnection().prepareStatement(this.getColumnDefaultString(string, n));
            if (!this.m_online) {
                preparedStatement.setString(1, string);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string3 = resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                MigrationLogUtil.logThrowable((String)sQLException.getLocalizedMessage(), (String)"Capture", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(preparedStatement, resultSet);
                throw throwable;
            }
            CloseableResultSet.close((Statement)preparedStatement, resultSet);
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void captureIndex(CaptureContext captureContext) throws SQLException, PersistenceException {
        String string = this.getDatabase((MigrationContext)captureContext);
        String string2 = this.getCaptureIndexString(string);
        String string3 = (String)captureContext.getContextVariable("TABLE");
        String string4 = (String)captureContext.getContextVariable("SCHEMA");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getRepositoryConnection().prepareStatement(string2);
            if (!this.m_online) {
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string4);
                preparedStatement.setString(3, string3);
            } else {
                preparedStatement.setString(1, string4);
                preparedStatement.setString(2, string3);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ResultSet resultSet2;
                PreparedStatement preparedStatement2;
                block16: {
                    int n = resultSet.getInt(2);
                    String string5 = resultSet.getString(3);
                    int n2 = resultSet.getInt(4);
                    int n3 = resultSet.getInt(6);
                    preparedStatement2 = null;
                    resultSet2 = null;
                    try {
                        preparedStatement2 = this.getRepositoryConnection().prepareStatement(this.getPrimaryKeyString(string));
                        if (!this.m_online) {
                            preparedStatement2.setString(1, string);
                            preparedStatement2.setString(2, string5);
                        } else {
                            preparedStatement2.setString(1, string5);
                        }
                        resultSet2 = preparedStatement2.executeQuery();
                        if (resultSet2.next()) {
                            int n4 = 1;
                            ++n4;
                            break block16;
                        }
                        MdIndexe mdIndexe = new MdIndexe((DBObjectId)captureContext.getContextVariable("TABLEID"));
                        mdIndexe.setIndexName(string5);
                        if ((n2 & 2) == 2) {
                            mdIndexe.setIndexType("UNIQUE");
                        } else {
                            mdIndexe.setIndexType("NON_UNIQUE");
                        }
                        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEXES"), string5);
                        captureContext.getAudience().fireListeners(captureEvent);
                        mdIndexe = (MdIndexe)this.getStorer().storeObject((PersistableObject)mdIndexe);
                        captureEvent.setEventId(4);
                        captureContext.getAudience().fireListeners(captureEvent);
                        PreparedStatement preparedStatement3 = null;
                        ResultSet resultSet3 = null;
                        try {
                            String string6 = this.getIndexString(string, n3, n);
                            preparedStatement3 = this.getRepositoryConnection().prepareStatement(string6);
                            if (!this.m_online) {
                                preparedStatement3.setString(1, string);
                            }
                            resultSet3 = preparedStatement3.executeQuery();
                            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
                            while (resultSet3.next()) {
                                MdIndexDetail mdIndexDetail = new MdIndexDetail(mdIndexe.getKey(), persistenceUtility.getIdForColumn(mdIndexe.getTableId(), resultSet3.getString(2)), Integer.valueOf(resultSet3.getInt(1)));
                                captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEX_DETAILS"), mdIndexe.getIndexName());
                                captureContext.getAudience().fireListeners(captureEvent);
                                mdIndexDetail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)mdIndexDetail);
                                captureEvent.setEventId(4);
                                captureContext.getAudience().fireListeners(captureEvent);
                            }
                        }
                        catch (Throwable throwable) {
                            CloseableResultSet.close(preparedStatement3, resultSet3);
                            throw throwable;
                        }
                        CloseableResultSet.close((Statement)preparedStatement3, (ResultSet)resultSet3);
                    }
                    catch (Throwable throwable) {
                        CloseableResultSet.close(preparedStatement2, resultSet2);
                        throw throwable;
                    }
                }
                CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet2);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close((Statement)preparedStatement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureUniqueAndPrimaryKeys(CaptureContext captureContext) throws SQLException, PersistenceException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            string = this.getDatabase((MigrationContext)captureContext);
            boolean bl = true;
            long l = 0L;
            String string2 = this.captureUniqueAndPrimaryKeysString(string);
            preparedStatement = this.getRepositoryConnection().prepareStatement(string2);
            String string3 = (String)captureContext.getContextVariable("TABLE");
            String string4 = (String)captureContext.getContextVariable("SCHEMA");
            if (!this.m_online) {
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string3);
                preparedStatement.setString(3, string4);
            } else {
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string4);
            }
            resultSet = preparedStatement.executeQuery();
            MdConstraint mdConstraint = null;
            int n = 1;
            while (resultSet.next()) {
                MdConstraintDetail mdConstraintDetail;
                String string5;
                if (bl || resultSet.getLong(3) != l) {
                    bl = false;
                    l = resultSet.getLong(3);
                    string5 = resultSet.getString(8);
                    mdConstraint = new MdConstraint((DBObjectId)captureContext.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                    if (string5.trim().equals("PK")) {
                        string5 = "PK";
                    } else if (string5.trim().equals("UQ")) {
                        string5 = "UNIQUE";
                    }
                    mdConstraint.setConstraintType(string5);
                    mdConstraint.setName(resultSet.getString(1));
                    mdConstraintDetail = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                    captureContext.getAudience().fireListeners((CaptureEvent)mdConstraintDetail);
                    mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                    n = 1;
                    mdConstraintDetail.setEventId(4);
                    captureContext.getAudience().fireListeners((CaptureEvent)mdConstraintDetail);
                }
                string5 = resultSet.getString(5);
                mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n++));
                mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(mdConstraint.getTableId(), string5));
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(preparedStatement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureForeignKeys(CaptureContext captureContext) throws SQLException, CaptureException, PersistenceException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            string = this.getDatabase((MigrationContext)captureContext);
            String string2 = this.captureForeignKeysStringString(string);
            preparedStatement = this.getRepositoryConnection().prepareStatement(string2);
            String string3 = (String)captureContext.getContextVariable("TABLE");
            String string4 = (String)captureContext.getContextVariable("SCHEMA");
            if (!this.m_online) {
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string3);
                preparedStatement.setString(3, string4);
            } else {
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string4);
            }
            resultSet = preparedStatement.executeQuery();
            MdConstraint mdConstraint = null;
            int n = 1;
            while (resultSet.next()) {
                MdConstraintDetail mdConstraintDetail;
                int n2;
                int n3;
                DBObjectId dBObjectId;
                String string5;
                String string6;
                ResultSet resultSet2;
                PreparedStatement preparedStatement2;
                block15: {
                    mdConstraint = new MdConstraint((DBObjectId)captureContext.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                    mdConstraint.setConstraintType("FOREIGN KEY");
                    mdConstraint.setName(resultSet.getString(1));
                    String string7 = this.getTableNameAndUserString(string, resultSet.getInt(3));
                    preparedStatement2 = null;
                    resultSet2 = null;
                    string6 = null;
                    string5 = null;
                    try {
                        preparedStatement2 = this.getRepositoryConnection().prepareStatement(string7);
                        if (!this.m_online) {
                            preparedStatement2.setString(1, string);
                        }
                        if (!(resultSet2 = preparedStatement2.executeQuery()).next()) break block15;
                        string6 = resultSet2.getString(1);
                        string5 = resultSet2.getString(2);
                    }
                    catch (SQLException sQLException) {
                        try {
                            throw sQLException;
                        }
                        catch (Throwable throwable) {
                            CloseableResultSet.close((Statement)preparedStatement2, resultSet2);
                            throw throwable;
                        }
                    }
                }
                CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet2);
                continue;
                CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet2);
                DBObjectId dBObjectId2 = persistenceUtility.getIdForSchema((DBObjectId)captureContext.getContextVariable("CATALOGID"), string5);
                if (dBObjectId2 == null) continue;
                try {
                    dBObjectId = persistenceUtility.getIdForTable(dBObjectId2, string6);
                    if (dBObjectId == null) {
                        Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "Capture.CONSTRAINTSKIPPED", new String[]{mdConstraint.getName(), string6});
                    }
                }
                catch (PersistenceException persistenceException) {}
                continue;
                mdConstraint.setReftableId(dBObjectId);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                n = 1;
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
                for (n3 = 0; n3 < 16; ++n3) {
                    n2 = resultSet.getInt(n3 + 5);
                    if (n2 == 0) continue;
                    mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n++));
                    mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(mdConstraint.getTableId(), this.getColumnName(string, string4, string3, n2)));
                    captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
                    captureContext.getAudience().fireListeners(captureEvent);
                    mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                }
                for (n3 = 0; n3 < 16; ++n3) {
                    n2 = resultSet.getInt(21 + n3);
                    if (n2 == 0) continue;
                    mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n++));
                    mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(dBObjectId, this.getColumnName(string, string5, string6, n2)));
                    mdConstraintDetail.setRefFlag("Y");
                    captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
                    captureContext.getAudience().fireListeners(captureEvent);
                    mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                }
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(preparedStatement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureTableLevelCheckConstraint(CaptureContext captureContext) throws SQLException, PersistenceException, CaptureException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            string = this.getDatabase((MigrationContext)captureContext);
            String string2 = this.captureTableLevelCheckConstraintString(string);
            preparedStatement = this.getRepositoryConnection().prepareStatement(string2);
            String string3 = (String)captureContext.getContextVariable("TABLE");
            String string4 = (String)captureContext.getContextVariable("SCHEMA");
            if (!this.m_online) {
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string3);
                preparedStatement.setString(3, string4);
            } else {
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string4);
            }
            resultSet = preparedStatement.executeQuery();
            MdConstraint mdConstraint = null;
            while (resultSet.next()) {
                String string5 = "CHECK";
                mdConstraint = new MdConstraint((DBObjectId)captureContext.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                mdConstraint.setConstraintType(string5);
                mdConstraint.setName(resultSet.getString(1));
                mdConstraint.setConstraintText(resultSet.getString(2));
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(preparedStatement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureColumnLevelCheckConstraint(CaptureContext captureContext) throws SQLException, PersistenceException, CaptureException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            string = this.getDatabase((MigrationContext)captureContext);
            String string2 = this.captureColumnLevelCheckConstraintString(string);
            preparedStatement = this.getRepositoryConnection().prepareStatement(string2);
            String string3 = (String)captureContext.getContextVariable("TABLE");
            String string4 = (String)captureContext.getContextVariable("SCHEMA");
            if (!this.m_online) {
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string3);
                preparedStatement.setString(3, string4);
            } else {
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string4);
            }
            resultSet = preparedStatement.executeQuery();
            MdConstraint mdConstraint = null;
            while (resultSet.next()) {
                String string5 = resultSet.getString(1);
                int n = resultSet.getInt(3);
                String string6 = resultSet.getString(4);
                String string7 = "CHECK";
                mdConstraint = new MdConstraint((DBObjectId)captureContext.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                mdConstraint.setConstraintType(string7);
                mdConstraint.setName(string5);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
                MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(1));
                CloseableIterator closeableIterator = persistenceUtility.getColumnsForTableId((DBObjectId)captureContext.getContextVariable("TABLEID"));
                DBObjectId dBObjectId = null;
                while (closeableIterator.hasNext()) {
                    MdColumn mdColumn = (MdColumn)closeableIterator.next();
                    if (mdColumn.getColumnOrder() != n) continue;
                    dBObjectId = mdColumn.getKey();
                }
                mdConstraintDetail.setColumnId(dBObjectId);
                mdConstraintDetail.setConstraintText(string6);
                captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(preparedStatement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void captureRules(CaptureContext captureContext) throws SQLException, PersistenceException, CaptureException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            string = this.getDatabase((MigrationContext)captureContext);
            String string2 = this.captureRulesString(string);
            preparedStatement = this.getRepositoryConnection().prepareStatement(string2);
            String string3 = (String)captureContext.getContextVariable("TABLE");
            String string4 = (String)captureContext.getContextVariable("SCHEMA");
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
            if (!this.m_online) {
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string3);
                preparedStatement.setString(3, string4);
            } else {
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string4);
            }
            resultSet = preparedStatement.executeQuery();
            MdConstraint mdConstraint = null;
            while (resultSet.next()) {
                String string5 = resultSet.getString(2);
                int n = resultSet.getInt(3);
                int n2 = resultSet.getInt(4);
                String string6 = "CHECK";
                if (n2 == 0) continue;
                String string7 = "rul_" + string3 + "_" + string5;
                PreparedStatement preparedStatement2 = null;
                ResultSet resultSet2 = null;
                String string8 = "";
                String string9 = this.captureRulesTextString(string);
                try {
                    preparedStatement2 = this.getRepositoryConnection().prepareStatement(string9);
                    if (!this.m_online) {
                        preparedStatement2.setString(1, string);
                        preparedStatement2.setInt(2, n2);
                    } else {
                        preparedStatement2.setInt(1, n2);
                    }
                    resultSet2 = preparedStatement2.executeQuery();
                    while (resultSet2.next()) {
                        string8 = string8 + resultSet2.getString(1);
                    }
                    mdConstraint = new MdConstraint((DBObjectId)captureContext.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                    mdConstraint.setConstraintType(string6);
                    mdConstraint.setName(string7);
                    mdConstraint.addProperty("TYPE", "RULE", dBObjectId);
                    CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                    captureContext.getAudience().fireListeners(captureEvent);
                    mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                    MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(1));
                    CloseableIterator closeableIterator = persistenceUtility.getColumnsForTableId((DBObjectId)captureContext.getContextVariable("TABLEID"));
                    DBObjectId dBObjectId2 = null;
                    while (closeableIterator.hasNext()) {
                        MdColumn mdColumn = (MdColumn)closeableIterator.next();
                        if (mdColumn.getColumnOrder() != n) continue;
                        dBObjectId2 = mdColumn.getKey();
                    }
                    mdConstraintDetail.setColumnId(dBObjectId2);
                    mdConstraintDetail.setConstraintText(string8);
                    captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
                    captureContext.getAudience().fireListeners(captureEvent);
                    mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close((Statement)preparedStatement2, resultSet2);
                    throw throwable;
                }
                CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet2);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(preparedStatement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureView(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException, CaptureException {
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        String string = null;
        PrepareClobHelper prepareClobHelper = null;
        try {
            string = this.getDatabase((MigrationContext)captureContext);
            String string2 = "";
            HashSet<String> hashSet = null;
            if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals("MD_VIEWS")) {
                throw new IllegalArgumentException(SQLServerMessages.getString("SQLServer7AbstractCapturer.47") + migrationObjectFilter.getObjectType());
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                string2 = " AND a.name " + migrationObjectFilter.getWhereClause();
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
                hashSet = new HashSet<String>();
                for (String n : migrationObjectFilter.getObjectNames()) {
                    hashSet.add(n);
                }
            }
            String string3 = this.captureViewOuterString(string) + string2;
            String string4 = this.captureViewInnerString(string);
            preparedStatement2 = this.getRepositoryConnection().prepareStatement(string3);
            String string5 = (String)captureContext.getContextVariable("SCHEMA");
            if (!this.m_online) {
                preparedStatement2.setString(1, string);
                preparedStatement2.setString(2, string5);
            } else {
                preparedStatement2.setString(1, string5);
            }
            resultSet2 = preparedStatement2.executeQuery();
            while (resultSet2.next()) {
                block29: {
                    String sQLException;
                    ResultSet resultSet3;
                    PreparedStatement exception;
                    MdView mdView;
                    String string6;
                    block28: {
                        String string7;
                        int n = resultSet2.getInt(1);
                        string6 = resultSet2.getString(2);
                        if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string6)) continue;
                        preparedStatement = this.getRepositoryConnection().prepareStatement(string4);
                        if (!this.m_online) {
                            preparedStatement.setString(1, string);
                            preparedStatement.setInt(2, n);
                        } else {
                            preparedStatement.setInt(1, n);
                        }
                        resultSet = preparedStatement.executeQuery();
                        mdView = null;
                        prepareClobHelper = new PrepareClobHelper();
                        boolean bl = false;
                        while (resultSet.next()) {
                            bl = true;
                            string6 = resultSet.getString(1);
                            string7 = null;
                            try {
                                string7 = resultSet.getString(3);
                            }
                            catch (Exception exception2) {
                                string7 = "";
                            }
                            prepareClobHelper.append(string7);
                        }
                        if (!bl) break block29;
                        mdView = new MdView((DBObjectId)captureContext.getContextVariable("SCHEMAID"), MY_LANGUAGE_ID);
                        mdView.setViewName(string6);
                        string7 = prepareClobHelper.getClobHelper();
                        if (string7 == null || string7.getLength() == 0L) {
                            prepareClobHelper = new PrepareClobHelper();
                            prepareClobHelper.append(DDL_NOT_ACCESSIBLE);
                            string7 = prepareClobHelper.getClobHelper();
                        }
                        mdView.setNativeSql((ClobHelper)string7);
                        exception = null;
                        resultSet3 = null;
                        try {
                            sQLException = this.captureCommentsString();
                            exception = this.getRepositoryConnection().prepareStatement(sQLException);
                            exception.setInt(1, n);
                            exception.setInt(2, 0);
                            resultSet3 = exception.executeQuery();
                            if (!resultSet3.next()) break block28;
                            String string8 = resultSet3.getString(1);
                            mdView.setComments(string8);
                        }
                        catch (SQLException sQLException2) {
                            try {
                                MigrationLogUtil.logThrowable((String)sQLException2.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturer.11"), (Throwable)sQLException2);
                            }
                            catch (Throwable throwable) {
                                CloseableResultSet.close(exception, resultSet3);
                                throw throwable;
                            }
                            CloseableResultSet.close((Statement)exception, resultSet3);
                        }
                    }
                    CloseableResultSet.close((Statement)exception, (ResultSet)resultSet3);
                    sQLException = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_VIEWS"), string6);
                    captureContext.getAudience().fireListeners((CaptureEvent)sQLException);
                    mdView = (MdView)this.getStorer().storeObject((PersistableObject)mdView);
                    sQLException.setEventId(4);
                    captureContext.getAudience().fireListeners((CaptureEvent)sQLException);
                }
                if (prepareClobHelper != null) {
                    prepareClobHelper.close();
                }
                CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
            }
            CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet2);
        }
        catch (IOException iOException) {
            try {
                throw new CaptureException((Throwable)iOException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(preparedStatement, resultSet);
                CloseableResultSet.close(preparedStatement2, resultSet2);
                if (prepareClobHelper != null) {
                    try {
                        prepareClobHelper.close();
                    }
                    catch (Exception exception) {
                        MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturer.11"), (Throwable)exception);
                    }
                }
                throw throwable;
            }
        }
        CloseableResultSet.close(preparedStatement, resultSet);
        CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet2);
        if (prepareClobHelper != null) {
            try {
                prepareClobHelper.close();
            }
            catch (Exception exception) {
                MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturer.11"), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureStoredProgram(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException, CaptureException {
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        String string = null;
        PrepareClobHelper prepareClobHelper = null;
        try {
            string = this.getDatabase((MigrationContext)captureContext);
            String string2 = "";
            HashSet<String> hashSet = null;
            if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals("MD_STORED_PROGRAMS")) {
                throw new IllegalArgumentException(SQLServerMessages.getString("SQLServer7AbstractCapturer.52") + migrationObjectFilter.getObjectType());
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                string2 = " AND a.name " + migrationObjectFilter.getWhereClause();
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
                hashSet = new HashSet<String>();
                for (String string3 : migrationObjectFilter.getObjectNames()) {
                    hashSet.add(string3);
                }
            }
            String string4 = this.captureStoredProgramOuterString(string) + string2;
            String string5 = (String)captureContext.getContextVariable("SCHEMA");
            preparedStatement2 = this.getRepositoryConnection().prepareStatement(string4);
            if (!this.m_online) {
                preparedStatement2.setString(1, string);
                preparedStatement2.setString(2, string5);
            } else {
                preparedStatement2.setString(1, string5);
            }
            resultSet2 = preparedStatement2.executeQuery();
            while (resultSet2.next()) {
                block37: {
                    String sQLException;
                    ResultSet resultSet3;
                    PreparedStatement preparedStatement3;
                    String string6;
                    MdStoredProgram mdStoredProgram;
                    block36: {
                        Object object;
                        String string3;
                        if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && hashSet.contains(resultSet2.getString(1))) continue;
                        int n = resultSet2.getInt(2);
                        string3 = this.captureStoredProgramInnerString(string, string2);
                        preparedStatement = this.getRepositoryConnection().prepareStatement(string3);
                        if (!this.m_online) {
                            preparedStatement.setString(1, string);
                            preparedStatement.setInt(2, n);
                        } else {
                            preparedStatement.setInt(1, n);
                        }
                        resultSet = preparedStatement.executeQuery();
                        mdStoredProgram = null;
                        string6 = "";
                        String string7 = "";
                        boolean bl = false;
                        prepareClobHelper = new PrepareClobHelper();
                        while (resultSet.next()) {
                            string6 = resultSet.getString(1);
                            object = null;
                            try {
                                object = resultSet.getString(4);
                            }
                            catch (Exception exception) {
                                object = "";
                            }
                            prepareClobHelper.append((String)object);
                            string7 = resultSet.getString(5);
                            bl = true;
                        }
                        if (!bl) break block37;
                        object = prepareClobHelper.getClobHelper();
                        if (object == null || object.getLength() == 0L) {
                            prepareClobHelper = new PrepareClobHelper();
                            prepareClobHelper.append(DDL_NOT_ACCESSIBLE);
                            object = prepareClobHelper.getClobHelper();
                        }
                        mdStoredProgram = new MdStoredProgram((DBObjectId)captureContext.getContextVariable("SCHEMAID"), MY_LANGUAGE_ID);
                        mdStoredProgram.setName(string6);
                        mdStoredProgram.setNativeSql(object);
                        String exception = string7;
                        if (string7.trim().equals("P")) {
                            exception = "PROCEDURE";
                            string7 = "PROCEDURE";
                        } else if (string7.equals("FN")) {
                            exception = "SCALAR FUNCTION";
                            string7 = "FUNCTION";
                        } else if (string7.equals("TF")) {
                            exception = "TABLE FUNCTION";
                            string7 = "FUNCTION";
                        } else if (string7.equals("IF")) {
                            exception = "INLINED T. FUNCTION";
                            string7 = "FUNCTION";
                        } else {
                            string7 = "PROCEDURE";
                        }
                        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
                        mdStoredProgram.addProperty("TYPE", exception, dBObjectId);
                        mdStoredProgram.setProgramtype(string7);
                        preparedStatement3 = null;
                        resultSet3 = null;
                        try {
                            sQLException = this.captureCommentsString();
                            preparedStatement3 = this.getRepositoryConnection().prepareStatement(sQLException);
                            preparedStatement3.setInt(1, n);
                            preparedStatement3.setInt(2, 0);
                            resultSet3 = preparedStatement3.executeQuery();
                            if (!resultSet3.next()) break block36;
                            String string8 = resultSet3.getString(1);
                            mdStoredProgram.setComments(string8);
                        }
                        catch (SQLException sQLException2) {
                            try {
                                MigrationLogUtil.logThrowable((String)sQLException2.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturer.61"), (Throwable)sQLException2);
                            }
                            catch (Throwable throwable) {
                                CloseableResultSet.close(preparedStatement3, resultSet3);
                                throw throwable;
                            }
                            CloseableResultSet.close((Statement)preparedStatement3, resultSet3);
                        }
                    }
                    CloseableResultSet.close((Statement)preparedStatement3, (ResultSet)resultSet3);
                    sQLException = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_STORED_PROGRAMS"), string6);
                    captureContext.getAudience().fireListeners((CaptureEvent)sQLException);
                    mdStoredProgram = (MdStoredProgram)this.getStorer().storeObject((PersistableObject)mdStoredProgram);
                    sQLException.setEventId(4);
                    captureContext.getAudience().fireListeners((CaptureEvent)sQLException);
                }
                if (prepareClobHelper != null) {
                    prepareClobHelper.close();
                }
                CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
            }
            CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet2);
        }
        catch (IOException iOException) {
            try {
                throw new CaptureException((Throwable)iOException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(preparedStatement, resultSet);
                CloseableResultSet.close(preparedStatement2, resultSet2);
                if (prepareClobHelper != null) {
                    try {
                        prepareClobHelper.close();
                    }
                    catch (Exception exception) {
                        MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturer.61"), (Throwable)exception);
                    }
                }
                throw throwable;
            }
        }
        CloseableResultSet.close(preparedStatement, resultSet);
        CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet2);
        if (prepareClobHelper != null) {
            try {
                prepareClobHelper.close();
            }
            catch (Exception exception) {
                MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturer.61"), (Throwable)exception);
            }
        }
    }

    protected void captureTriggers(CaptureContext captureContext) throws SQLException, PersistenceException, CaptureException {
        PrepareClobHelper prepareClobHelper;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block22: {
            DBObjectId dBObjectId;
            String string;
            preparedStatement = null;
            resultSet = null;
            String string2 = null;
            prepareClobHelper = null;
            String string3 = (String)captureContext.getContextVariable("PER_CONTEXT");
            String string4 = null;
            if (string3.equals("MD_TABLES")) {
                string = "T";
                dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
                string4 = (String)captureContext.getContextVariable("TABLE");
            } else {
                string = "V";
                dBObjectId = (DBObjectId)captureContext.getContextVariable("VIEWID");
                string4 = (String)captureContext.getContextVariable("VIEW");
            }
            try {
                CaptureEvent captureEvent;
                Object object;
                string2 = this.getDatabase((MigrationContext)captureContext);
                String string5 = this.captureTriggersString(string2);
                preparedStatement = this.getRepositoryConnection().prepareStatement(string5);
                String string6 = (String)captureContext.getContextVariable("SCHEMA");
                if (!this.m_online) {
                    preparedStatement.setString(1, string2);
                    preparedStatement.setString(2, string6);
                    preparedStatement.setString(3, string4);
                } else {
                    preparedStatement.setString(1, string6);
                    preparedStatement.setString(2, string4);
                }
                resultSet = preparedStatement.executeQuery();
                MdTrigger mdTrigger = null;
                boolean bl = true;
                String string7 = "";
                while (resultSet.next()) {
                    if (bl || !string7.equals(resultSet.getString(1))) {
                        if (!bl) {
                            mdTrigger.setTriggerName(string7);
                            object = prepareClobHelper.getClobHelper();
                            if (object == null || object.getLength() == 0L) {
                                prepareClobHelper = new PrepareClobHelper();
                                prepareClobHelper.append(DDL_NOT_ACCESSIBLE);
                                object = prepareClobHelper.getClobHelper();
                            }
                            mdTrigger.setNativeSql(object);
                            captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_TRIGGERS"), string7);
                            captureContext.getAudience().fireListeners(captureEvent);
                            mdTrigger = (MdTrigger)this.getStorer().storeObject((PersistableObject)mdTrigger);
                            captureEvent.setEventId(4);
                            captureContext.getAudience().fireListeners(captureEvent);
                        }
                        if (prepareClobHelper != null) {
                            prepareClobHelper.close();
                        }
                        prepareClobHelper = new PrepareClobHelper();
                        string7 = resultSet.getString(1);
                        bl = false;
                        mdTrigger = new MdTrigger(dBObjectId, string, MY_LANGUAGE_ID);
                    }
                    object = "";
                    try {
                        object = resultSet.getString(4);
                    }
                    catch (Exception exception) {
                        object = "";
                    }
                    prepareClobHelper.append((String)object);
                }
                if (mdTrigger == null) break block22;
                mdTrigger.setTriggerName(string7);
                object = prepareClobHelper.getClobHelper();
                if (object == null || object.getLength() == 0L) {
                    prepareClobHelper = new PrepareClobHelper();
                    prepareClobHelper.append(DDL_NOT_ACCESSIBLE);
                    object = prepareClobHelper.getClobHelper();
                }
                mdTrigger.setNativeSql(object);
                captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_TRIGGERS"), string7);
                captureContext.getAudience().fireListeners(captureEvent);
                mdTrigger = (MdTrigger)this.getStorer().storeObject((PersistableObject)mdTrigger);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
            catch (IOException iOException) {
                try {
                    throw new CaptureException((Throwable)iOException);
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close(preparedStatement, resultSet);
                    if (prepareClobHelper != null) {
                        try {
                            prepareClobHelper.close();
                        }
                        catch (Exception exception) {
                            MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturer.65"), (Throwable)exception);
                        }
                    }
                    throw throwable;
                }
            }
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
        if (prepareClobHelper != null) {
            try {
                prepareClobHelper.close();
            }
            catch (Exception exception) {
                MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturer.65"), (Throwable)exception);
            }
        }
    }

    protected void captureRoles(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException, CaptureException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        PrepareClobHelper prepareClobHelper = null;
        ArrayList<MdGroup> arrayList = new ArrayList<MdGroup>();
        try {
            String string4;
            String string2 = this.getDatabase((MigrationContext)captureContext);
            String string3 = this.captureRolesString(string2);
            HashSet<String> hashSet = null;
            if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals("MD_GROUPS")) {
                throw new IllegalArgumentException(SQLServerMessages.getString("SQLServer7AbstractCapturer.66") + migrationObjectFilter.getObjectType());
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                string3 = string3 + " where b.name " + migrationObjectFilter.getWhereClause();
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
                hashSet = new HashSet<String>();
                for (String string4 : migrationObjectFilter.getObjectNames()) {
                    hashSet.add(string4);
                }
            }
            preparedStatement = this.getRepositoryConnection().prepareStatement(string3);
            if (!this.m_online) {
                preparedStatement.setString(1, this.getDatabase((MigrationContext)captureContext));
            }
            resultSet = preparedStatement.executeQuery();
            MdGroup mdGroup = null;
            while (resultSet.next()) {
                String string5;
                String string6;
                block21: {
                    string6 = resultSet.getString(1);
                    if (hashSet != null && hashSet.contains(string6)) continue;
                    string5 = resultSet.getString(2);
                    prepareClobHelper = new PrepareClobHelper();
                    try {
                        string4 = persistenceUtility.getIdForSchema((DBObjectId)captureContext.getContextVariable("CATALOGID"), string5);
                        if (string4 != null) break block21;
                        string5 = "dbo";
                        string4 = persistenceUtility.getIdForSchema((DBObjectId)captureContext.getContextVariable("CATALOGID"), string5);
                        if (string4 == null) {
                        }
                    }
                    catch (PersistenceException persistenceException) {}
                    continue;
                }
                prepareClobHelper.append("sp_addrole " + string6 + ", " + string5);
                mdGroup = new MdGroup((DBObjectId)string4);
                mdGroup.setGroupFlag("R");
                mdGroup.setGroupName(string6);
                mdGroup.setNativeSql(prepareClobHelper.getClobHelper());
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_GROUP"), string6);
                captureContext.getAudience().fireListeners(captureEvent);
                mdGroup = (MdGroup)this.getStorer().storeObject((PersistableObject)mdGroup);
                captureEvent.setEventId(4);
                this.capturePrivileges(this.getRepositoryConnection(), this.getStorer(), captureContext, arrayList, mdGroup, null);
                arrayList.add(mdGroup);
                captureContext.getAudience().fireListeners(captureEvent);
                prepareClobHelper.close();
            }
            this.captureRoleMembership(this.getRepositoryConnection(), this.getStorer(), captureContext, arrayList);
            CloseableIterator closeableIterator = persistenceUtility.getSchemasforCatalogId((DBObjectId)captureContext.getContextVariable("CATALOGID"));
            while (closeableIterator.hasNext()) {
                CloseableIterator closeableIterator2 = persistenceUtility.getUsersforSchemaId(((MdSchema)closeableIterator.next()).getKey());
                while (closeableIterator2.hasNext()) {
                    string4 = (MdUser)closeableIterator2.next();
                    this.capturePrivileges(this.getRepositoryConnection(), this.getStorer(), captureContext, arrayList, null, (MdUser)string4);
                }
            }
        }
        catch (IOException iOException) {
            try {
                throw new CaptureException((Throwable)iOException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(preparedStatement, resultSet);
                if (prepareClobHelper != null) {
                    try {
                        prepareClobHelper.close();
                    }
                    catch (Exception exception) {
                        MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturer.71"), (Throwable)exception);
                    }
                }
                throw throwable;
            }
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
        if (prepareClobHelper != null) {
            try {
                prepareClobHelper.close();
            }
            catch (Exception exception) {
                MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServerMessages.getString("SQLServer7AbstractCapturer.71"), (Throwable)exception);
            }
        }
    }

    protected String getColumnName(String string, String string2, String string3, int n) throws SQLException, CaptureException {
        block5: {
            String string4;
            PreparedStatement preparedStatement = null;
            String string5 = this.getColumnNameString(string);
            ResultSet resultSet = null;
            try {
                preparedStatement = this.getRepositoryConnection().prepareStatement(string5);
                if (!this.m_online) {
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string2);
                    preparedStatement.setString(3, string3);
                    preparedStatement.setInt(4, n);
                } else {
                    preparedStatement.setString(1, string2);
                    preparedStatement.setString(2, string3);
                    preparedStatement.setInt(3, n);
                }
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block5;
                string4 = resultSet.getString(1);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close((Statement)preparedStatement, resultSet);
                throw throwable;
            }
            CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
            return string4;
        }
        throw new CaptureException((Throwable)new Exception(SQLServerMessages.getString("SQLServer7AbstractCapturer.72") + string3));
    }

    protected String getDatabase(MigrationContext migrationContext) throws SQLException {
        String string = null;
        MdCatalog mdCatalog = (MdCatalog)migrationContext.getContextVariable("CATALOG");
        string = mdCatalog.getCatalogName();
        return string;
    }

    public String getModelName() throws CaptureException {
        return null;
    }

    public String getSourceURL() throws CaptureException {
        return "/tmp/sqlserver7";
    }

    public void setStorer(MigrationStorer migrationStorer) {
        this.m_storer = migrationStorer;
    }

    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    public Connection getRepositoryConnection() {
        return this.m_repositoryConnection;
    }

    public void setRepositoryConnection(Connection connection) {
        this.m_repositoryConnection = connection;
    }

    static {
        s_sqlServerDatabasesToSkip = new String[]{"master", "msdb", "tempdb", "model"};
        s_sqlServerDatabaseToUse = null;
    }
}

