/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sqlserver2005;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.GenerateDSMLFormattedFiles;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.MetadataFileParser;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.ObjectStatusList;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.OracleDatatypeIdentifiers;

public class SQLServer2005DoOfflineCaptureLoad
implements OracleDatatypeIdentifiers {
    private HashMap<File, ArrayList<File>> _dbXMLMetadataList = new HashMap();
    private HashMap<File, ObjectStatusList> m_dSMLMap = null;
    private String _currentTableName = null;
    private int _currentDbId = 0;
    public String currValue = "";
    private HashMap<String, String[]> m_tableTypes = new HashMap();
    private Connection m_conn = null;
    private static String m_encoding = null;

    public SQLServer2005DoOfflineCaptureLoad(Connection connection) {
        this.m_conn = connection;
        this.populateTableTypes();
    }

    public void loadSourceModel(HashMap<File, ObjectStatusList> hashMap) throws OfflineCaptureException {
        this.m_dSMLMap = hashMap;
        Statement statement = null;
        Connection connection = null;
        Object var4_4 = null;
        try {
            connection = this.m_conn;
            statement = connection.createStatement();
            GenerateDSMLFormattedFiles generateDSMLFormattedFiles = new GenerateDSMLFormattedFiles(this.m_dSMLMap, SQLServer2005DoOfflineCaptureLoad.getEncoding());
            this._dbXMLMetadataList = generateDSMLFormattedFiles.getDSMLFormattedFilesTable();
            File file = this.getDbFile("MASTER");
            if (file == null) {
                throw new OfflineCaptureException(new Exception());
            }
            this._currentDbId = 1;
            this.populateSourceModel(connection, file, 1);
            for (File file2 : this._dbXMLMetadataList.keySet()) {
                int n;
                if (file2.getName().equalsIgnoreCase("MASTER")) continue;
                this._currentDbId = n = this.getDbId(connection, file2.getName());
                if (n == 0) continue;
                this.populateSourceModel(connection, file2, n);
            }
            SQLServer2005DoOfflineCaptureLoad.sourceModelIndexCreate(connection);
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new OfflineCaptureException((Exception)sQLException);
        }
        catch (Exception exception) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new OfflineCaptureException(exception);
        }
    }

    File getDbFile(String string) {
        File file = null;
        for (File file2 : this.m_dSMLMap.keySet()) {
            String string2 = file2.getName();
            if (!string2.equalsIgnoreCase(string)) continue;
            file = file2;
            break;
        }
        return file;
    }

    int getDbId(Connection connection, String string) throws OfflineCaptureException {
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            statement = connection.createStatement();
            String string2 = " SELECT database_id FROM SS2K5_DATABASES  WHERE UPPER(NAME) = '" + string.toUpperCase() + "' ";
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            return n;
        }
        catch (SQLException sQLException) {
            throw new OfflineCaptureException((Exception)sQLException);
        }
    }

    public void populateSourceModel(Connection connection, File file, int n) throws OfflineCaptureException {
        try {
            ArrayList<File> arrayList = this._dbXMLMetadataList.get(file);
            Iterator<File> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                File file2;
                File file3 = file2 = iterator.next();
                this._currentTableName = GenerateDSMLFormattedFiles.getUnqualifiedName(file3.getName());
                String[] stringArray = this.getFieldTypes(this._currentTableName);
                if (stringArray == null) continue;
                MetadataFileParser metadataFileParser = new MetadataFileParser(n, SQLServer2005DoOfflineCaptureLoad.fileToURL(file3), this._currentTableName);
                metadataFileParser.createPrepardStatement(connection, stringArray);
                int n2 = metadataFileParser.loadData();
            }
        }
        catch (Exception exception) {
            throw new OfflineCaptureException(exception);
        }
    }

    private String[] getFieldTypes(String string) {
        String[] stringArray = null;
        for (String string2 : this.m_tableTypes.keySet()) {
            if (!string.equalsIgnoreCase(string2)) continue;
            stringArray = this.m_tableTypes.get(string2.toUpperCase());
            break;
        }
        return stringArray;
    }

    private void populateTableTypes() {
        String[] stringArray = new String[]{"3", "1", "3"};
        this.m_tableTypes.put("SS2K5_DATABASES", stringArray);
        String[] stringArray2 = new String[]{"3", "1", "1"};
        this.m_tableTypes.put("SS2K5_SCHEMATA", stringArray2);
        String[] stringArray3 = new String[]{"3", "1", "1", "1", "1", "1", "1"};
        this.m_tableTypes.put("SS2K5_TABLE_PRIVILEGES", stringArray3);
        String[] stringArray4 = new String[]{"3", "3", "3", "4"};
        this.m_tableTypes.put("SS2K5_CHECK_CONSTRAINTS", stringArray4);
        String[] stringArray5 = new String[]{"3", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K5_COLUMNS", stringArray5);
        String[] stringArray6 = new String[]{"3", "1", "8", "3", "3", "1", "6"};
        this.m_tableTypes.put("SS2K5_DATABASE_PRINCIPALS", stringArray6);
        String[] stringArray7 = new String[]{"3", "3", "3"};
        this.m_tableTypes.put("SS2K5_DATABASE_ROLE_MEMBERS", stringArray7);
        String[] stringArray8 = new String[]{"3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K5_FOREIGN_KEY_COLUMNS", stringArray8);
        String[] stringArray9 = new String[]{"3", "1", "3"};
        this.m_tableTypes.put("SS2K5_FOREIGN_KEYS", stringArray9);
        String[] stringArray10 = new String[]{"3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K5_IDENTITY_COLUMNS", stringArray10);
        String[] stringArray11 = new String[]{"3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K5_INDEX_COLUMNS", stringArray11);
        String[] stringArray12 = new String[]{"3", "3", "3", "1", "3", "3"};
        this.m_tableTypes.put("SS2K5_INDEXES", stringArray12);
        String[] stringArray13 = new String[]{"3", "3", "3", "1", "8", "3", "3"};
        this.m_tableTypes.put("SS2K5_OBJECTS", stringArray13);
        String[] stringArray14 = new String[]{"3", "3", "1"};
        this.m_tableTypes.put("SS2K5_SCHEMAS", stringArray14);
        String[] stringArray15 = new String[]{"3", "1", "6", "8"};
        this.m_tableTypes.put("SS2K5_SERVER_PRINCIPALS", stringArray15);
        String[] stringArray16 = new String[]{"3", "4", "3"};
        this.m_tableTypes.put("SS2K5_SQL_MODULES", stringArray16);
        String[] stringArray17 = new String[]{"3", "1", "3", "3", "8"};
        this.m_tableTypes.put("SS2K5_TABLES", stringArray17);
        String[] stringArray18 = new String[]{"3", "1", "3", "3"};
        this.m_tableTypes.put("SS2K5_TYPES", stringArray18);
        String[] stringArray19 = new String[]{"3", "4", "3"};
        this.m_tableTypes.put("SS2K5_DEFAULT_CONSTRAINTS", stringArray19);
        String[] stringArray20 = new String[]{"3", "3", "3", "1", "1"};
        this.m_tableTypes.put("SS7_SYSPROPERTIES", stringArray20);
    }

    private static URL fileToURL(File file) {
        String string = file.getAbsolutePath();
        String string2 = System.getProperty("file.separator");
        if (string2 != null && string2.length() == 1) {
            string = string.replace(string2.charAt(0), '/');
        }
        if (string.length() > 0 && string.charAt(0) != '/') {
            string = '/' + string;
        }
        try {
            return new URL("file", null, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("EXCEPTION :SQLServer2KDisconnSourceModelLoad.fileToURL(): " + malformedURLException.toString());
            throw new Error("Unexpected MalformedURLException");
        }
    }

    public static void sourceModelIndexCreate(Connection connection) throws OfflineCaptureException {
        Statement statement = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            arrayList.add("CREATE INDEX SS2K5_DATABASES_DB_ID ON SS2K5_DATABASES (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_DATABASES_NAME ON SS2K5_DATABASES (\"NAME\")");
            arrayList.add("CREATE INDEX SS2K5_DATABASES_DATABASE_ID ON SS2K5_DATABASES (\"DATABASE_ID\")");
            arrayList.add("CREATE INDEX SS2K5_SCHEMATA_DB_ID ON SS2K5_SCHEMATA (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_SCHEMATA_SCHEMA_NAME ON SS2K5_SCHEMATA (\"SCHEMA_NAME\")");
            arrayList.add("CREATE INDEX SS2K5_TABLE_PRIVILEGES_DB_ID ON SS2K5_TABLE_PRIVILEGES (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_T_P_TABLE_SCHEMA ON SS2K5_TABLE_PRIVILEGES  (\"TABLE_SCHEMA\")");
            arrayList.add("CREATE INDEX SS2K5_T_P_TABLE_NAME ON SS2K5_TABLE_PRIVILEGES (\"TABLE_NAME\")");
            arrayList.add("CREATE INDEX SS2K5_CHECK_CONSTRAINTS_DB_ID ON SS2K5_CHECK_CONSTRAINTS (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_C_C_OBJECT_ID ON SS2K5_CHECK_CONSTRAINTS (\"OBJECT_ID\")");
            arrayList.add("CREATE INDEX SS2K5_COLUMNS_DB_ID ON SS2K5_COLUMNS (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_COLUMNS_COLUMN_ID ON SS2K5_COLUMNS (\"COLUMN_ID\")");
            arrayList.add("CREATE INDEX SS2K5_D_P_DB_ID ON SS2K5_DATABASE_PRINCIPALS (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_D_P_SID ON SS2K5_DATABASE_PRINCIPALS (\"SID\")");
            arrayList.add("CREATE INDEX SS2K5_D_P_DEFAULT_SCHEMA_NAME  ON SS2K5_DATABASE_PRINCIPALS (\"DEFAULT_SCHEMA_NAME\")");
            arrayList.add("CREATE INDEX SS2K5_D_R_M_DB_ID ON SS2K5_DATABASE_ROLE_MEMBERS (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_D_R_M_MEMBER_P_ID  ON SS2K5_DATABASE_ROLE_MEMBERS (\"MEMBER_PRINCIPAL_ID\")");
            arrayList.add("CREATE INDEX SS2K5_D_R_M_ROLE_PRINCIPAL_ID  ON SS2K5_DATABASE_ROLE_MEMBERS (\"ROLE_PRINCIPAL_ID\")");
            arrayList.add("CREATE INDEX SS2K5_F_K_C_DB_ID ON SS2K5_FOREIGN_KEY_COLUMNS (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_F_K_C_PARENT_OBJECT_ID  ON SS2K5_FOREIGN_KEY_COLUMNS (\"PARENT_OBJECT_ID\")");
            arrayList.add("CREATE INDEX SS2K5_F_K_C_R_O_ID  ON SS2K5_FOREIGN_KEY_COLUMNS (\"REFERENCED_OBJECT_ID\")");
            arrayList.add("CREATE INDEX SS2K5_FOREIGN_KEYS_DB_ID ON SS2K5_FOREIGN_KEYS (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_FOREIGN_KEYS_OBJECT_ID ON SS2K5_FOREIGN_KEYS (\"OBJECT_ID\")");
            arrayList.add("CREATE INDEX SS2K5_IDENTITY_COLUMNS_DB_ID ON SS2K5_IDENTITY_COLUMNS (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_I_C_OBJECT_ID ON SS2K5_IDENTITY_COLUMNS (\"OBJECT_ID\")");
            arrayList.add("CREATE INDEX SS2K5_INDEX_COLUMNS_DB_ID ON SS2K5_INDEX_COLUMNS (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_INDEX_COLUMNS_OBJECT_ID ON SS2K5_INDEX_COLUMNS (\"OBJECT_ID\")");
            arrayList.add("CREATE INDEX SS2K5_INDEXES_DB_ID ON SS2K5_INDEXES (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_INDEXES_OBJECT_ID ON SS2K5_INDEXES (\"OBJECT_ID\")");
            arrayList.add("CREATE INDEX SS2K5_OBJECTS_DB_ID ON SS2K5_OBJECTS (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_OBJECTS_OBJECT_ID ON SS2K5_OBJECTS (\"OBJECT_ID\")");
            arrayList.add("CREATE INDEX SS2K5_OBJECTS_SCHEMA_ID ON SS2K5_OBJECTS (\"SCHEMA_ID\")");
            arrayList.add("CREATE INDEX SS2K5_SCHEMAS_DB_ID ON SS2K5_SCHEMAS (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_SCHEMAS_NAME ON SS2K5_SCHEMAS (\"NAME\")");
            arrayList.add("CREATE INDEX SS2K5_SERVER_PRINCIPALS_DB_ID ON SS2K5_SERVER_PRINCIPALS (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_SERVER_PRINCIPALS_NAME ON SS2K5_SERVER_PRINCIPALS (\"NAME\")");
            arrayList.add("CREATE INDEX SS2K5_SERVER_PRINCIPALS_SID ON SS2K5_SERVER_PRINCIPALS (\"SID\")");
            arrayList.add("CREATE INDEX SS2K5_SQL_MODULES_DB_ID ON SS2K5_SQL_MODULES (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_SQL_MODULES_OBJECT_ID ON SS2K5_SQL_MODULES (\"OBJECT_ID\")");
            arrayList.add("CREATE INDEX SS2K5_DEFAULT_DB_ID ON SS2K5_DEFAULT_CONSTRAINTS (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_DEFAULT_OBJECT_ID ON SS2K5_DEFAULT_CONSTRAINTS (\"OBJECT_ID\")");
            arrayList.add("CREATE INDEX SS2K5_TABLES_DB_ID ON SS2K5_TABLES (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_TABLES_OBJECT_ID ON SS2K5_TABLES (\"OBJECT_ID\")");
            arrayList.add("CREATE INDEX SS2K5_TABLES_SCHEMA_ID ON SS2K5_TABLES (\"SCHEMA_ID\")");
            arrayList.add("CREATE INDEX SS2K5_TYPES_DB_ID ON SS2K5_TYPES (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K5_TYPES_SYSTEM_TYPE_ID ON SS2K5_TYPES (\"SYSTEM_TYPE_ID\")");
            arrayList.add("CREATE INDEX SS2K5_TYPES_USER_TYPE_ID ON SS2K5_TYPES (\"USER_TYPE_ID\")");
            arrayList.add("CREATE INDEX SS2K5_COLUMNS_OBJID ON SS2K5_COLUMNS (\"OBJECT_ID\", \"COLUMN_ID\")");
            statement = connection.createStatement();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = (String)iterator.next();
                try {
                    statement.execute(string2);
                }
                catch (SQLException sQLException) {
                    throw new OfflineCaptureException((Exception)sQLException);
                }
            }
            statement.close();
            arrayList.clear();
        }
        catch (SQLException sQLException) {
            throw new OfflineCaptureException((Exception)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public void convertBcpDumpToXML(HashMap<File, ObjectStatusList> hashMap) {
        this.m_dSMLMap = hashMap;
        Statement statement = null;
        Connection connection = null;
        Object var4_4 = null;
        connection = this.m_conn;
        try {
            statement = connection.createStatement();
            GenerateDSMLFormattedFiles generateDSMLFormattedFiles = new GenerateDSMLFormattedFiles(this.m_dSMLMap, SQLServer2005DoOfflineCaptureLoad.getEncoding());
            this._dbXMLMetadataList = generateDSMLFormattedFiles.getDSMLFormattedFilesTable();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (OfflineCaptureException offlineCaptureException) {
            offlineCaptureException.printStackTrace();
        }
    }

    public static void setEncoding(String string) {
        m_encoding = string;
    }

    public static String getEncoding() {
        return m_encoding;
    }
}

