/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.WeakHashMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlIdentifier;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSearchException;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.util.ModelUtil;

public class PlSqlInterrogator {
    private PlSqlTokenizer m_tokenizer;
    private PlSqlFragment m_rootFrag;
    private PlSqlToken m_firstToken;
    private PlSqlToken m_nameToken;
    private PlSqlFragment m_triggerBaseItemFragment;
    private String m_source;
    private String m_objType;
    private String m_schemaName;
    private int m_schemaDotNameStart;
    private String m_userDefTypeTypeCode = "";
    private String m_userDefTypeCollectionType = "";
    private boolean m_newStatementBlockReqd;
    private boolean m_fullInterrogation;
    private boolean m_isUserDefType;
    private boolean m_isUserDefTypeSepc;
    private boolean m_isSourceWrapped = false;
    private boolean m_evolvedType = false;
    private Boolean m_containsTodo = null;
    private String[] m_sourceByLines = null;
    private PlsqlError[] m_errors = null;
    private ArrayList<PlSqlToken> m_optionalNews;
    private PlSqlSearch m_methodTailSearch = null;
    private PlSqlSearch m_alterSubClauseSearch = null;
    private static HashSet<String> s_knownTypes = new HashSet();
    private static final String OBJECT_TYPECODE = "OBJECT";
    private static final String COLLECTION_TYPECODE = "COLLECTION";
    private static final String TABLE_TYPE = "TABLE";
    private static final String VARRAY_TYPE = "VARYING ARRAY";
    private static final String TYPE_BODY = "TYPE BODY";
    private static final String PACKAGE_BODY = "PACKAGE BODY";
    private static WeakHashMap<String, WeakReference<PlSqlInterrogator>> s_cache = new WeakHashMap();
    private static int s_invocations = 0;
    private static final String EMPTY_STRING = "";
    private static final String KW_ADD = "ADD";
    private static final String KW_AFTER = "AFTER";
    private static final String KW_ALTER = "ALTER";
    private static final String KW_AS = "AS";
    private static final String KW_BEFORE = "BEFORE";
    private static final String KW_BEGIN = "BEGIN";
    private static final String KW_BODY = "BODY";
    private static final String KW_CALL = "CALL";
    private static final String KW_CASE = "CASE";
    private static final String KW_CONSTRUCTOR = "CONSTRUCTOR";
    private static final String KW_CREATE = "CREATE";
    private static final String KW_DECLARE = "DECLARE";
    private static final String KW_DROP = "DROP";
    private static final String KW_EACH = "EACH";
    private static final String KW_ELSE = "ELSE";
    private static final String KW_ELSIF = "ELSIF";
    private static final String KW_END = "END";
    private static final String KW_EXCEPTION = "EXCEPTION";
    private static final String KW_FINAL = "FINAL";
    private static final String KW_FOR = "FOR";
    private static final String KW_FUNCTION = "FUNCTION";
    private static final String KW_IF = "IF";
    private static final String KW_INSTANTIABLE = "INSTANTIABLE";
    private static final String KW_INSTEAD = "INSTEAD";
    private static final String KW_IS = "IS";
    private static final String KW_LOOP = "LOOP";
    private static final String KW_MAP = "MAP";
    private static final String KW_MEMBER = "MEMBER";
    private static final String KW_MODIFY = "MODIFY";
    private static final String KW_NESTED = "NESTED";
    private static final String KW_NOT = "NOT";
    private static final String KW_OBJECT = "OBJECT";
    private static final String KW_OF = "OF";
    private static final String KW_ON = "ON";
    private static final String KW_OPAQUE = "OPAQUE";
    private static final String KW_OR = "OR";
    private static final String KW_ORDER = "ORDER";
    private static final String KW_OVERRIDING = "OVERRIDING";
    private static final String KW_PACKAGE = "PACKAGE";
    private static final String KW_PRAGMA = "PRAGMA";
    private static final String KW_PROCEDURE = "PROCEDURE";
    private static final String KW_REFERENCING = "REFERENCING";
    private static final String KW_REPLACE = "REPLACE";
    private static final String KW_ROW = "ROW";
    private static final String KW_STATIC = "STATIC";
    private static final String KW_TABLE = "TABLE";
    private static final String KW_THEN = "THEN";
    private static final String KW_TRIGGER = "TRIGGER";
    private static final String KW_TYPE = "TYPE";
    private static final String KW_UNDER = "UNDER";
    private static final String KW_UPDATE = "UPDATE";
    private static final String KW_VARRAY = "VARRAY";
    private static final String KW_VARYING = "VARYING";
    private static final String KW_WHEN = "WHEN";
    private static final String KW_WHILE = "WHILE";
    private static final String KW_WRAPPED = "WRAPPED";
    private static final String PUNC_COMMA = ",";
    private static final String PUNC_DBL_LCHEV = "<<";
    private static final String PUNC_DBL_RCHEV = ">>";
    private static final String PUNC_DOT = ".";
    private static final String PUNC_LPAREN = "(";
    private static final String PUNC_RPAREN = ")";
    private static final String PUNC_SEMICOLON = ";";

    public static PlSqlInterrogator findOrCreate(String source) {
        WeakReference<PlSqlInterrogator> piRef;
        PlSqlInterrogator retval = null;
        if (s_invocations++ > 1000) {
            ArrayList<String> keysToRemove = new ArrayList<String>();
            for (String s : s_cache.keySet()) {
                WeakReference<PlSqlInterrogator> piRef2 = s_cache.get(s);
                if (piRef2 == null) {
                    keysToRemove.add(s);
                    continue;
                }
                if (piRef2.get() != null) continue;
                keysToRemove.add(s);
            }
            if (keysToRemove.size() > 0) {
                for (int i = 0; i < keysToRemove.size(); ++i) {
                    s_cache.remove(keysToRemove.get(i));
                }
            }
            s_invocations = 0;
        }
        if ((piRef = s_cache.get(source)) != null) {
            retval = (PlSqlInterrogator)piRef.get();
        }
        if (retval == null) {
            retval = new PlSqlInterrogator();
            retval.setSource(source);
            piRef = new WeakReference<PlSqlInterrogator>(retval);
            s_cache.put(source, piRef);
        }
        return retval;
    }

    public PlSqlInterrogator(String source) {
        this.setSource(source);
    }

    private PlSqlInterrogator() {
    }

    static PlSqlIdentifier getPlSqlIdentifier(String source, String schemaName, boolean force) {
        PlSqlInterrogator pi = new PlSqlInterrogator();
        pi.setSource(source, true);
        return pi.getPlSqlIdentifier(schemaName, force);
    }

    public PlSqlIdentifier getPlSqlIdentifier(String schemaName) {
        return this.getPlSqlIdentifier(schemaName, false);
    }

    public PlSqlIdentifier getPlSqlIdentifier(String schemaName, boolean force) {
        String name = null;
        String schema = null;
        PlSqlIdentifier.PlSqlType plsqlType = null;
        if (this.m_nameToken != null) {
            name = this.m_nameToken.getSource(true);
        }
        schema = ModelUtil.hasLength((String)this.m_schemaName) && !force ? this.m_schemaName : schemaName;
        if (ModelUtil.hasLength((String)this.m_objType)) {
            try {
                plsqlType = PlSqlIdentifier.PlSqlType.valueOf(this.m_objType.replaceAll(" ", "_"));
            }
            catch (Exception e) {
                throw new IllegalStateException("Unknown type " + this.m_objType);
            }
        }
        return new PlSqlIdentifier(name, schema, plsqlType);
    }

    private void setSource(String source) {
        this.setSource(source, false);
    }

    private void setSource(String source, boolean justBasics) {
        if (this.m_methodTailSearch == null) {
            try {
                this.m_methodTailSearch = new PlSqlSearch("[RETURN {SELF AS RESULT|?%} [EXTERNAL [VARIABLE] NAME ? ] ] [{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME?     | C [NAME ?] LIBRARY ?.       [AGENT IN ({^)}...) ]       [WITH CONTEXT]       [PARAMETERS ({^)}...) ]     } ]");
            }
            catch (PlSqlSearchException e) {
                // empty catch block
            }
        }
        if (this.m_alterSubClauseSearch == null) {
            try {
                this.m_alterSubClauseSearch = new PlSqlSearch("[ALTER TYPE ?.] <action {ADD|DROP|MODIFY} [ATTRIBUTE]> {^{LIMIT|ELEMENT}}");
            }
            catch (PlSqlSearchException e) {
                // empty catch block
            }
        }
        this.m_source = source;
        this.m_objType = EMPTY_STRING;
        this.m_schemaName = null;
        this.m_userDefTypeTypeCode = EMPTY_STRING;
        this.m_userDefTypeCollectionType = EMPTY_STRING;
        this.m_tokenizer = new PlSqlTokenizer(this.m_source, new String[0]);
        this.m_firstToken = this.m_tokenizer.getFirst();
        this.m_rootFrag = null;
        this.m_nameToken = null;
        this.m_triggerBaseItemFragment = null;
        this.m_errors = null;
        this.m_newStatementBlockReqd = false;
        this.m_fullInterrogation = true;
        this.m_isUserDefType = false;
        this.m_isUserDefTypeSepc = false;
        this.m_isSourceWrapped = false;
        this.m_sourceByLines = null;
        this.m_evolvedType = false;
        this.m_containsTodo = null;
        this.m_optionalNews = new ArrayList();
        if (this.m_firstToken != null) {
            this.interrogateBasics();
            if (justBasics) {
                return;
            }
            this.m_rootFrag = new PlSqlFragment(this);
            this.m_rootFrag.setFragmentType(PlSqlFragment.Type.ROOT);
            this.m_rootFrag.setFirstToken(this.m_firstToken);
            if (this.m_fullInterrogation) {
                if (this.m_firstToken.matches(KW_BEGIN) || this.m_firstToken.matches(KW_DECLARE)) {
                    this.buildFragmentTree(this.m_firstToken, this.m_rootFrag, InterrogateState.PLSQL_BLOCK);
                } else {
                    this.buildFragmentTree(this.m_firstToken, this.m_rootFrag, InterrogateState.DECLARATIVE_SECTION);
                }
            } else {
                PlSqlFragment typeFrag = new PlSqlFragment(this, this.m_rootFrag);
                if (this.m_objType.equals(KW_PROCEDURE)) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE);
                } else if (this.m_objType.equals(KW_FUNCTION)) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.FUNCTION);
                } else if (this.m_objType.equals(KW_TYPE)) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.PACKAGE_SPEC);
                } else if (this.m_objType.equals(PACKAGE_BODY)) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.PACKAGE_BODY);
                } else if (this.m_objType.equals(KW_TYPE)) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.TYPE_SPEC);
                } else if (this.m_objType.equals(TYPE_BODY)) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.TYPE_BODY);
                } else {
                    typeFrag.setFragmentType(PlSqlFragment.Type.UNKNOWN);
                }
                typeFrag.setFirstToken(this.m_firstToken);
                typeFrag.setLastToken(this.m_tokenizer.getEndMarker().getPrevCodeToken());
                PlSqlFragment statementFrag = new PlSqlFragment(this, typeFrag);
                statementFrag.setFragmentType(PlSqlFragment.Type.DECLARATION);
                statementFrag.setFirstToken(this.m_firstToken);
                statementFrag.setLastToken(this.m_tokenizer.getEndMarker().getPrevCodeToken());
                this.m_rootFrag.setLastToken(this.m_tokenizer.getEndMarker().getPrevCodeToken());
            }
        }
    }

    public PlSqlFragment getRoot() {
        return this.m_rootFrag;
    }

    public String getType() {
        return this.m_objType;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public String getName() {
        return this.m_nameToken == null ? EMPTY_STRING : this.m_nameToken.getSource();
    }

    public String getTypeCode() {
        return this.m_userDefTypeTypeCode;
    }

    public String getCollectionType() {
        return this.m_userDefTypeCollectionType;
    }

    public boolean isWrapped() {
        return this.m_isSourceWrapped;
    }

    private void interrogateBasics() {
        this.m_fullInterrogation = true;
        this.m_isUserDefTypeSepc = false;
        this.m_userDefTypeTypeCode = EMPTY_STRING;
        this.m_userDefTypeCollectionType = EMPTY_STRING;
        this.m_isSourceWrapped = false;
        PlSqlToken tk = this.m_firstToken;
        if (!tk.isCode() && tk.getType() != PlSqlToken.Type.END_MARKER) {
            tk = tk.getNextCodeToken();
        }
        while (tk.matches(KW_CREATE) || tk.matches(KW_OR) || tk.matches(KW_REPLACE)) {
            tk = tk.getNextCodeToken();
        }
        this.m_firstToken = tk;
        this.m_objType = tk.getSource();
        if (this.m_objType != null && s_knownTypes.contains(this.m_objType.toUpperCase())) {
            if (tk.getNextCodeToken().matches(KW_BODY)) {
                this.m_objType = this.m_objType + " BODY";
                tk = tk.getNextCodeToken();
            }
            this.m_objType = this.m_objType.toUpperCase();
            if (this.m_objType.equals(KW_TYPE)) {
                this.m_isUserDefType = true;
                this.m_fullInterrogation = false;
                this.m_isUserDefTypeSepc = true;
                while (!(tk.matches(KW_IS) || tk.matches(KW_AS) || tk.matches(PUNC_SEMICOLON) || tk.matches(KW_UNDER) || tk.matches(KW_WRAPPED) || tk == this.m_tokenizer.getEndMarker())) {
                    tk = tk.getNextCodeToken();
                }
                if (tk.matches(KW_WRAPPED)) {
                    this.m_isSourceWrapped = true;
                } else if (tk != this.m_tokenizer.getEndMarker()) {
                    if (tk.matches(KW_IS) || tk.matches(KW_AS)) {
                        if ((tk = tk.getNextCodeToken()).matches("OBJECT") || tk.matches(KW_OPAQUE)) {
                            this.m_fullInterrogation = true;
                            this.m_userDefTypeTypeCode = "OBJECT";
                            this.m_userDefTypeCollectionType = EMPTY_STRING;
                        } else if (tk.matches("TABLE")) {
                            this.m_fullInterrogation = true;
                            this.m_userDefTypeTypeCode = COLLECTION_TYPECODE;
                            this.m_userDefTypeCollectionType = "TABLE";
                        } else if (tk.matches(KW_VARRAY) || tk.matches(KW_VARYING)) {
                            this.m_fullInterrogation = true;
                            this.m_userDefTypeTypeCode = COLLECTION_TYPECODE;
                            this.m_userDefTypeCollectionType = VARRAY_TYPE;
                        }
                    } else if (tk.matches(KW_UNDER)) {
                        this.m_fullInterrogation = true;
                        this.m_userDefTypeTypeCode = "OBJECT";
                    }
                }
                tk = this.m_firstToken;
            }
        } else {
            this.m_objType = EMPTY_STRING;
        }
        if (!this.m_objType.equals(EMPTY_STRING)) {
            this.m_nameToken = tk = tk.getNextCodeToken();
            if (tk == null || tk.getType() == PlSqlToken.Type.END_MARKER) {
                return;
            }
            this.m_schemaDotNameStart = tk.getStart();
            if (tk.getNextCodeToken().matches(PUNC_DOT)) {
                tk = tk.getNextCodeToken().getNextCodeToken();
                this.m_schemaName = this.m_nameToken.getSource();
                this.m_nameToken = tk;
            }
            if ((tk = tk.getNextCodeToken()).matches(KW_WRAPPED)) {
                this.m_fullInterrogation = false;
                this.m_isUserDefType = false;
                this.m_isUserDefTypeSepc = false;
                this.m_isSourceWrapped = true;
            }
        }
    }

    private PlSqlToken buildFragmentTree(PlSqlToken startToken, PlSqlFragment currentFrag, InterrogateState parseState) {
        return this.buildFragmentTree(startToken, currentFrag, parseState, null);
    }

    private PlSqlToken buildFragmentTree(PlSqlToken startToken, PlSqlFragment currentFrag, InterrogateState parseState, PlSqlFragment.AlterSubType alterSubType) {
        PlSqlToken tk = startToken;
        this.m_newStatementBlockReqd = false;
        PlSqlToken lastTk = null;
        try {
            if (currentFrag.getFirstToken() == null) {
                currentFrag.setFirstToken(startToken);
            }
            while (tk != null && tk.getType() != PlSqlToken.Type.END_MARKER) {
                if (lastTk == tk) {
                    return tk;
                }
                lastTk = tk;
                switch (parseState) {
                    case PROCEDURE: 
                    case FUNCTION: {
                        PlSqlFragment childFrag;
                        if (this.m_isUserDefTypeSepc) {
                            while (!(tk.matches(PUNC_COMMA) || tk.matches(PUNC_LPAREN) || tk.matches(PUNC_RPAREN) || tk.matches(KW_ALTER) || tk.getType() == PlSqlToken.Type.END_MARKER)) {
                                tk = tk.getNextCodeToken();
                            }
                            if (tk.matches(PUNC_LPAREN)) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.PARAMETER_LIST);
                                childFrag.setFirstToken(tk);
                                tk = tk.getNextCodeToken();
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PARAMETER_LIST);
                            }
                            if (this.m_methodTailSearch.matches(tk)) {
                                tk = this.m_methodTailSearch.getEndToken();
                                tk = tk.getNextCodeToken();
                            }
                            while (!(tk.matches(PUNC_COMMA) || tk.matches(PUNC_RPAREN) || tk.matches(KW_ALTER) || tk.getType() == PlSqlToken.Type.END_MARKER)) {
                                tk = tk.getNextCodeToken();
                            }
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.PROCEDURE) {
                                currentFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE_FD);
                            } else {
                                currentFrag.setFragmentType(PlSqlFragment.Type.FUNCTION_FD);
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            currentFrag.setAlterSubType(alterSubType);
                            if (tk.matches(PUNC_COMMA)) {
                                tk = tk.getNextCodeToken();
                            }
                            return tk;
                        }
                        while (!(tk.matches(KW_IS) || tk.matches(KW_AS) || tk.matches(PUNC_SEMICOLON) || tk.matches(PUNC_LPAREN))) {
                            tk = tk.getNextCodeToken();
                        }
                        if (tk.matches(PUNC_LPAREN)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PARAMETER_LIST);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PARAMETER_LIST);
                            while (!(tk.matches(KW_IS) || tk.matches(KW_AS) || tk.matches(PUNC_SEMICOLON))) {
                                tk = tk.getNextCodeToken();
                            }
                        }
                        if (tk.matches(PUNC_SEMICOLON)) {
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.PROCEDURE) {
                                currentFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE_FD);
                            } else {
                                currentFrag.setFragmentType(PlSqlFragment.Type.FUNCTION_FD);
                            }
                            currentFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            return tk;
                        }
                        tk = tk.getNextCodeToken();
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFirstToken(tk);
                        childFrag.setFragmentType(PlSqlFragment.Type.PLSQL_BLOCK);
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PLSQL_BLOCK);
                        currentFrag.replaceChildWithGrandChildren(childFrag);
                        return tk;
                    }
                    case TRIGGER: {
                        PlSqlFragment childFrag;
                        if (tk.matches(KW_BEFORE) || tk.matches(KW_AFTER) || tk.matches(KW_INSTEAD) && tk.getNextCodeToken().matches(KW_OF)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_TIMING);
                            childFrag.setFirstToken(tk);
                            if (tk.matches(KW_INSTEAD)) {
                                tk = tk.getNextCodeToken();
                            }
                            childFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            if (tk.matches(KW_ON) || tk.matches(KW_FOR) || tk.matches(KW_REFERENCING) || tk.matches(KW_WHEN) || tk.matches(KW_DECLARE) || tk.matches(KW_BEGIN) || tk.matches(KW_CALL)) break;
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_EVENTS);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER_EVENTS);
                            break;
                        }
                        if (tk.matches(KW_ON)) {
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.TRIGGER) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_TABLE);
                                this.m_triggerBaseItemFragment = childFrag;
                                tk = tk.getNextCodeToken();
                                childFrag.setFirstToken(tk);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER);
                                break;
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            return tk;
                        }
                        if (tk.matches(KW_WHEN)) {
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.TRIGGER) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_WHEN);
                                tk = tk.getNextCodeToken();
                                childFrag.setFirstToken(tk);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER);
                                break;
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            return tk;
                        }
                        if (tk.matches(KW_REFERENCING)) {
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.TRIGGER) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_REFERENCING);
                                tk = tk.getNextCodeToken();
                                childFrag.setFirstToken(tk);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER);
                                break;
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            return tk;
                        }
                        if (tk.matches(KW_FOR) && tk.getNextCodeToken().matches(KW_EACH) && tk.getNextCodeToken(2).matches(KW_ROW)) {
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.TRIGGER) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_ROW_LEVEL);
                                childFrag.setFirstToken(tk);
                                tk = tk.getNextCodeToken();
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER);
                                break;
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            return tk;
                        }
                        if (tk.matches(KW_DECLARE) || tk.matches(KW_BEGIN)) {
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.TRIGGER) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.PLSQL_BLOCK);
                                childFrag.setFirstToken(tk);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PLSQL_BLOCK);
                                break;
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            return tk;
                        }
                        if (currentFrag.getFramentType() == PlSqlFragment.Type.TRIGGER_TABLE && tk.matches(KW_NESTED)) {
                            while (!tk.matches(KW_OF)) {
                                tk = tk.getNextCodeToken();
                            }
                            if ((tk = tk.getNextCodeToken()).getNextCodeToken().matches(PUNC_DOT)) {
                                tk = tk.getNextCodeToken(2);
                            }
                            tk = tk.getNextCodeToken();
                            break;
                        }
                        tk = tk.getNextCodeToken();
                        break;
                    }
                    case TRIGGER_EVENTS: {
                        PlSqlFragment childFrag;
                        while (!(tk.matches(KW_ON) || tk.matches(KW_FOR) || tk.matches(KW_REFERENCING) || tk.matches(KW_WHEN) || tk.matches(KW_DECLARE) || tk.matches(KW_BEGIN) || tk.matches(KW_CALL))) {
                            if (tk.matches(KW_UPDATE) && tk.getNextCodeToken().matches(KW_OF)) {
                                tk = tk.getNextCodeToken();
                                tk = tk.getNextCodeToken();
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_COLUMNS);
                                childFrag.setFirstToken(tk);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER_COLUMNS);
                                continue;
                            }
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk.getPrevCodeToken());
                        return tk;
                    }
                    case TRIGGER_COLUMNS: {
                        while (tk.matches(PUNC_COMMA) || tk.getNextCodeToken().matches(PUNC_COMMA)) {
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk);
                        tk = tk.getNextCodeToken();
                        return tk;
                    }
                    case PLSQL_BLOCK: {
                        PlSqlFragment childFrag;
                        if (tk.matches(KW_BEGIN)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.BEGIN);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            if (tk.matches(KW_EXCEPTION)) break;
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            return tk;
                        }
                        if (tk.matches(KW_EXCEPTION)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.EXCEPTION);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.EXCEPTION_BLOCK);
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            return tk;
                        }
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.DECLARE);
                        childFrag.setFirstToken(tk);
                        if (tk.matches(KW_DECLARE)) {
                            tk = tk.getNextCodeToken();
                        }
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.DECLARATIVE_SECTION);
                        break;
                    }
                    case DECLARATIVE_SECTION: {
                        PlSqlFragment childFrag;
                        if (tk.matches(KW_END) && (currentFrag.getFramentType() == PlSqlFragment.Type.PACKAGE_BODY || currentFrag.getFramentType() == PlSqlFragment.Type.PACKAGE_SPEC || currentFrag.getFramentType() == PlSqlFragment.Type.TYPE_BODY)) {
                            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                                tk = tk.getNextCodeToken();
                            }
                            return tk;
                        }
                        if (tk.matches(KW_PACKAGE)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFirstToken(tk);
                            if (tk.getNextCodeToken().matches(KW_BODY)) {
                                childFrag.setFragmentType(PlSqlFragment.Type.PACKAGE_BODY);
                                tk = tk.getNextCodeToken();
                            } else {
                                childFrag.setFragmentType(PlSqlFragment.Type.PACKAGE_SPEC);
                            }
                            while (!tk.matches(KW_IS) && !tk.matches(KW_AS)) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.DECLARATIVE_SECTION);
                            break;
                        }
                        if (tk.matches(KW_TYPE) && currentFrag.getFramentType() == PlSqlFragment.Type.ROOT) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFirstToken(tk);
                            if (tk.getNextCodeToken().matches(KW_BODY)) {
                                childFrag.setFragmentType(PlSqlFragment.Type.TYPE_BODY);
                                while (!tk.matches(KW_IS) && !tk.matches(KW_AS)) {
                                    tk = tk.getNextCodeToken();
                                }
                                tk = tk.getNextCodeToken();
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.DECLARATIVE_SECTION);
                                break;
                            }
                            childFrag.setFragmentType(PlSqlFragment.Type.TYPE_SPEC);
                            while (!tk.matches(PUNC_LPAREN)) {
                                if (!(tk = tk.getNextCodeToken()).matches(PUNC_LPAREN) || !tk.getPrevCodeToken().matches(KW_VARYING) || !tk.getNextCodeToken().matches("*") || !tk.getNextCodeToken(2).matches(PUNC_RPAREN)) continue;
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            if (!(tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TYPE_SPEC)).matches(KW_ALTER)) break;
                            this.m_evolvedType = true;
                            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                                if (tk.matches(KW_ALTER) && tk.firstCodeTokenOnLine()) {
                                    childFrag.setLastToken(tk.getPrevCodeToken());
                                    childFrag = new PlSqlFragment(this, currentFrag);
                                    childFrag.setFirstToken(tk);
                                    childFrag.setFragmentType(PlSqlFragment.Type.TYPE_ALTER_STATEMENT);
                                    boolean buildingSubclauses = false;
                                    while (this.m_alterSubClauseSearch.matches(tk)) {
                                        buildingSubclauses = true;
                                        PlSqlFragment.AlterSubType subType = null;
                                        String alterSubTypeStr = this.m_alterSubClauseSearch.getNamedMatch("action", true);
                                        if ("ADD ATTRIBUTE".equals(alterSubTypeStr)) {
                                            subType = PlSqlFragment.AlterSubType.ADD_ATTRIBUTE;
                                        } else if ("DROP ATTRIBUTE".equals(alterSubTypeStr)) {
                                            subType = PlSqlFragment.AlterSubType.DROP_ATTRIBUTE;
                                        } else if ("MODIFY ATTRIBUTE".equals(alterSubTypeStr)) {
                                            subType = PlSqlFragment.AlterSubType.MODIFY_ATTRIBUTE;
                                        } else if (KW_ADD.equals(alterSubTypeStr)) {
                                            subType = PlSqlFragment.AlterSubType.ADD_METHOD;
                                        } else if (KW_DROP.equals(alterSubTypeStr)) {
                                            subType = PlSqlFragment.AlterSubType.DROP_METHOD;
                                        }
                                        tk = this.m_alterSubClauseSearch.getEndToken();
                                        if (!(tk = this.buildFragmentTree(tk, childFrag, InterrogateState.DECLARATIVE_SECTION, subType)).matches(KW_ALTER)) continue;
                                        break;
                                    }
                                    if (!buildingSubclauses) {
                                        for (tk = tk.getNextCodeToken(); !tk.matches(KW_ALTER) && tk != this.m_tokenizer.getEndMarker(); tk = tk.getNextCodeToken()) {
                                        }
                                    }
                                }
                                if (tk.matches(KW_ALTER) || tk == this.m_tokenizer.getEndMarker()) continue;
                                tk = tk.getNextCodeToken();
                            }
                            childFrag.setLastToken(tk.getPrevCodeToken());
                            return tk;
                        }
                        if (tk.matches(KW_BEGIN)) {
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.DECLARE) {
                                currentFrag.setLastToken(tk.getPrevCodeToken());
                                return tk;
                            }
                            if (currentFrag.getFramentType() != PlSqlFragment.Type.PACKAGE_BODY) break;
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PLSQL_BLOCK);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PLSQL_BLOCK);
                            break;
                        }
                        if (tk.matches(KW_FUNCTION)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.FUNCTION);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.FUNCTION);
                            break;
                        }
                        if (tk.matches(KW_PROCEDURE)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PROCEDURE);
                            break;
                        }
                        if (tk.matches(KW_TRIGGER)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER);
                            break;
                        }
                        if (tk.matches(KW_PRAGMA)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PRAGMA);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.SIMPLE_STATEMENT);
                            break;
                        }
                        if (tk.matches(PUNC_DBL_LCHEV)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.LABEL);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.LABEL);
                            break;
                        }
                        if (this.m_isUserDefType && (tk.matches(KW_NOT) || tk.matches(KW_OVERRIDING) || tk.matches(KW_FINAL) || tk.matches(KW_INSTANTIABLE) || tk.matches(KW_MEMBER) || tk.matches(KW_STATIC) || tk.matches(KW_CONSTRUCTOR) || tk.matches(KW_MAP) || tk.matches(KW_ORDER) || tk.matches(KW_PROCEDURE) || tk.matches(KW_FUNCTION))) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_PROCEDURE) && !tk.matches(KW_FUNCTION)) {
                                tk = tk.getNextCodeToken();
                            }
                            if (tk.matches(KW_PROCEDURE)) {
                                childFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PROCEDURE, alterSubType);
                            } else {
                                childFrag.setFragmentType(PlSqlFragment.Type.FUNCTION);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.FUNCTION, alterSubType);
                            }
                            if (!tk.matches(KW_ALTER) && !tk.matches(KW_ADD) && !tk.matches(KW_DROP) && !tk.matches(KW_MODIFY)) break;
                            return tk;
                        }
                        if (tk.matches(PUNC_SEMICOLON)) break;
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.DECLARATION);
                        childFrag.setFirstToken(tk);
                        if (this.m_isUserDefTypeSepc && (currentFrag.getFramentType() == PlSqlFragment.Type.TYPE_SPEC || currentFrag.getFramentType() == PlSqlFragment.Type.TYPE_ALTER_STATEMENT)) {
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.ORACLE_TYPE_DECLN);
                            childFrag.setAlterSubType(alterSubType);
                            if (!tk.matches(KW_ALTER) && !tk.matches(KW_ADD) && !tk.matches(KW_DROP) && !tk.matches(KW_MODIFY)) break;
                            return tk;
                        }
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.SIMPLE_STATEMENT);
                        break;
                    }
                    case STATEMENT_BLOCK: {
                        PlSqlFragment childFrag;
                        if (tk.matches(KW_END)) {
                            while (!tk.matches(PUNC_SEMICOLON)) {
                                tk = tk.getNextCodeToken();
                            }
                            currentFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            return tk;
                        }
                        if (tk.matches(KW_WHEN) && (currentFrag.getFramentType() == PlSqlFragment.Type.EX_WHEN || currentFrag.getFramentType() == PlSqlFragment.Type.CASE_WHEN)) {
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            return tk;
                        }
                        if (tk.matches(KW_DECLARE) || tk.matches(KW_BEGIN)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PLSQL_BLOCK);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PLSQL_BLOCK);
                            break;
                        }
                        if (tk.matches(KW_EXCEPTION)) {
                            if (currentFrag.getFramentType() != PlSqlFragment.Type.PLSQL_BLOCK) {
                                currentFrag.setLastToken(tk.getPrevCodeToken());
                                return tk;
                            }
                            tk = tk.getNextCodeToken();
                            break;
                        }
                        if (tk.matches(KW_IF)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.IF);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_THEN)) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches(KW_ELSIF)) {
                            if (!(currentFrag.getFramentType() != PlSqlFragment.Type.IF && currentFrag.getFramentType() != PlSqlFragment.Type.ELSIF || this.m_newStatementBlockReqd)) {
                                currentFrag.setLastToken(tk.getPrevCodeToken());
                                this.m_newStatementBlockReqd = true;
                                return tk;
                            }
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.ELSIF);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_THEN)) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches(KW_ELSE)) {
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.CASE_WHEN && !this.m_newStatementBlockReqd) {
                                currentFrag.setLastToken(tk.getPrevCodeToken());
                                return tk;
                            }
                            if (!(currentFrag.getFramentType() != PlSqlFragment.Type.IF && currentFrag.getFramentType() != PlSqlFragment.Type.ELSIF || this.m_newStatementBlockReqd)) {
                                currentFrag.setLastToken(tk.getPrevCodeToken());
                                this.m_newStatementBlockReqd = true;
                                return tk;
                            }
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.ELSE);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches(KW_LOOP)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.LOOP);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches(KW_FOR)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.FOR_LOOP);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_LOOP)) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches(KW_WHILE)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.WHILE_LOOP);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_LOOP)) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches(KW_CASE)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.CASE);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_WHEN)) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.CASE_STATEMENT);
                            break;
                        }
                        if (tk.matches(PUNC_DBL_LCHEV)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.LABEL);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.LABEL);
                            break;
                        }
                        if (!tk.matches(PUNC_SEMICOLON)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.STATEMENT);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.SIMPLE_STATEMENT);
                            break;
                        }
                        if (!tk.matches(PUNC_SEMICOLON)) break;
                        currentFrag.setLastToken(tk);
                        return tk;
                    }
                    case CASE_STATEMENT: {
                        PlSqlFragment childFrag;
                        if (tk.matches(KW_END)) {
                            PlSqlToken tempTk = tk;
                            while (!tk.matches(PUNC_SEMICOLON)) {
                                tk = tk.getNextCodeToken();
                            }
                            currentFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            return tempTk;
                        }
                        if (tk.matches(KW_WHEN)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.CASE_WHEN);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_THEN)) {
                                tk = tk.getNextCodeToken();
                            }
                            currentFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (!tk.matches(KW_ELSE)) break;
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.CASE_ELSE);
                        childFrag.setFirstToken(tk);
                        currentFrag.setLastToken(tk);
                        tk = tk.getNextCodeToken();
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                        break;
                    }
                    case EXCEPTION_BLOCK: {
                        if (tk.matches(KW_END)) {
                            PlSqlToken tempTk = tk;
                            while (!tk.matches(PUNC_SEMICOLON)) {
                                tk = tk.getNextCodeToken();
                            }
                            currentFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            return tempTk;
                        }
                        if (!tk.matches(KW_WHEN)) break;
                        PlSqlFragment childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.EX_WHEN);
                        childFrag.setFirstToken(tk);
                        while (!tk.matches(KW_THEN)) {
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk);
                        tk = tk.getNextCodeToken();
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                        break;
                    }
                    case TYPE_SPEC: {
                        PlSqlFragment childFrag;
                        if (tk.matches(PUNC_RPAREN)) {
                            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                                if (tk.matches(KW_ALTER) && tk.firstCodeTokenOnLine()) {
                                    return tk;
                                }
                                tk = tk.getNextCodeToken();
                            }
                            return tk;
                        }
                        if (tk.matches(KW_NOT) || tk.matches(KW_OVERRIDING) || tk.matches(KW_FINAL) || tk.matches(KW_INSTANTIABLE) || tk.matches(KW_MEMBER) || tk.matches(KW_STATIC) || tk.matches(KW_CONSTRUCTOR) || tk.matches(KW_MAP) || tk.matches(KW_ORDER) || tk.matches(KW_PROCEDURE) || tk.matches(KW_FUNCTION)) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches(KW_PROCEDURE) && !tk.matches(KW_FUNCTION)) {
                                tk = tk.getNextCodeToken();
                            }
                            if (tk.matches(KW_PROCEDURE)) {
                                childFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PROCEDURE);
                                break;
                            }
                            childFrag.setFragmentType(PlSqlFragment.Type.FUNCTION);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.FUNCTION);
                            break;
                        }
                        if (tk.matches(PUNC_SEMICOLON)) break;
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.DECLARATION);
                        childFrag.setFirstToken(tk);
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.ORACLE_TYPE_DECLN);
                        break;
                    }
                    case ORACLE_TYPE_DECLN: {
                        int parens = 0;
                        while (!(tk == null || tk == this.m_tokenizer.getEndMarker() || parens == 0 && (tk.matches(PUNC_COMMA) || tk.matches(PUNC_SEMICOLON) || tk.matches(PUNC_RPAREN) || tk.matches(KW_ALTER)))) {
                            if (tk.matches(PUNC_LPAREN)) {
                                ++parens;
                            } else if (tk.matches(PUNC_RPAREN)) {
                                --parens;
                            }
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk.getPrevCodeToken());
                        if (tk != null && tk != this.m_tokenizer.getEndMarker() && !tk.matches(PUNC_RPAREN) && !tk.matches(KW_ALTER)) {
                            tk = tk.getNextCodeToken();
                        }
                        return tk;
                    }
                    case SIMPLE_STATEMENT: {
                        while (tk != null && tk != this.m_tokenizer.getEndMarker() && !tk.matches(PUNC_SEMICOLON)) {
                            if (tk.matches("new") && tk.getPrevCodeToken() != null && tk.getPrevCodeToken().matches(":=") && tk.getNextCodeToken() != null && !tk.getNextCodeToken().matches(PUNC_SEMICOLON)) {
                                this.m_optionalNews.add(tk);
                            }
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk);
                        tk = tk.getNextCodeToken();
                        return tk;
                    }
                    case LABEL: {
                        while (tk != null && tk != this.m_tokenizer.getEndMarker() && !tk.matches(PUNC_DBL_RCHEV)) {
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk);
                        tk = tk.getNextCodeToken();
                        return tk;
                    }
                    case PARAMETER_LIST: {
                        if (tk.matches(PUNC_RPAREN)) {
                            currentFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            return tk;
                        }
                        PlSqlFragment childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.PARAMETER);
                        childFrag.setFirstToken(tk);
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PARAMETER);
                        break;
                    }
                    case PARAMETER: {
                        while (tk != null && !tk.matches(PUNC_COMMA) && !tk.matches(PUNC_RPAREN)) {
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk.getPrevCodeToken());
                        if (tk.matches(PUNC_COMMA)) {
                            tk = tk.getNextCodeToken();
                        }
                        return tk;
                    }
                }
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        return tk;
    }

    public int getLineNumber(int offset) {
        if (this.m_sourceByLines == null) {
            this.m_sourceByLines = this.m_source.split("\n");
        }
        int lineNum = 0;
        int currEnd = this.m_sourceByLines[lineNum].length();
        while (lineNum < this.m_sourceByLines.length && currEnd < offset) {
            currEnd = currEnd + this.m_sourceByLines[++lineNum].length() + 1;
        }
        return lineNum + 1;
    }

    public PlSqlFragment getFragmentAtOffset(int offset) {
        return this.getFragmentAtOffset(offset, this.m_rootFrag);
    }

    private PlSqlFragment getFragmentAtOffset(int offset, PlSqlFragment parent) {
        if (parent.getFirstToken().getStart() <= offset && (parent.getLastToken() == null || parent.getLastToken().getEnd() >= offset)) {
            if (parent.getChildren() == null || parent.getChildren().length == 0) {
                return parent;
            }
            for (PlSqlFragment frag : parent.getChildren()) {
                if (frag.getLastToken() != null && frag.getLastToken().getEnd() < offset) continue;
                PlSqlFragment ret = this.getFragmentAtOffset(offset, frag);
                return ret == null ? parent : ret;
            }
        }
        return null;
    }

    public PlSqlToken getTokenAtOffset(int offset) {
        PlSqlFragment fragAtOffset = this.getFragmentAtOffset(offset, this.m_rootFrag);
        if (fragAtOffset != null) {
            PlSqlToken tok = fragAtOffset.getFirstToken();
            while (tok.getEnd() < offset) {
                tok = tok.getNextToken();
            }
            return tok;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlsqlError[] getPlSqlErrors() {
        if (this.m_errors == null) {
            PlSqlFragment rootFrag = null;
            ReadTextBuffer realBuffer = null;
            PlsqlRoot root = null;
            StringBuffer sb = new StringBuffer();
            rootFrag = this.m_evolvedType ? this.getRoot().getChildren()[0] : (this.m_objType.equals(KW_TRIGGER) ? this.getRoot().findChild(PlSqlFragment.Type.PLSQL_BLOCK, true) : this.getRoot());
            if (rootFrag != null) {
                int start = rootFrag.getFirstToken().getStart();
                for (int i = 0; i < start; ++i) {
                    sb.append(" ");
                }
            }
            if (this.m_optionalNews.isEmpty()) {
                if (rootFrag != null) {
                    sb.append(rootFrag.getSource());
                }
            } else {
                String threeSpaces = "   ";
                int start = rootFrag.getFirstToken().getStart();
                int end = this.m_optionalNews.get(0).getStart();
                sb.append(this.m_source.substring(start, end));
                sb.append("   ");
                for (int i = 0; i < this.m_optionalNews.size() - 1; ++i) {
                    start = this.m_optionalNews.get(i).getEnd() + 1;
                    end = this.m_optionalNews.get(i + 1).getStart();
                    sb.append(this.m_source.substring(start, end));
                    sb.append("   ");
                }
                start = this.m_optionalNews.get(this.m_optionalNews.size() - 1).getEnd() + 1;
                sb.append(this.m_source.substring(start));
            }
            realBuffer = TextBufferFactory.createReadTextBuffer((String)sb.toString());
            realBuffer.readLock();
            try {
                root = PlsqlParser.parsePlsql((ReadTextBuffer)realBuffer);
            }
            finally {
                realBuffer.readUnlock();
            }
            this.m_errors = root.getErrors();
        }
        return this.m_errors;
    }

    public boolean hasParseErrors() {
        PlsqlError[] errors = this.getPlSqlErrors();
        return errors.length > 0;
    }

    public boolean containsToDo() {
        if (this.m_containsTodo == null) {
            this.m_containsTodo = Boolean.FALSE;
            PlSqlToken tk = this.m_tokenizer.getStartMarker().getNextToken();
            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                if ((tk.getType() == PlSqlToken.Type.SINGLE_LINE_COMMENT || tk.getType() == PlSqlToken.Type.MULTI_LINE_COMMENT) && tk.getSource().toUpperCase().contains("TODO")) {
                    this.m_containsTodo = Boolean.TRUE;
                    break;
                }
                tk = tk.getNextToken();
            }
        }
        return this.m_containsTodo;
    }

    public String getRenamedSource(String newName) {
        return this.getRenamedSource(newName, false);
    }

    public String getRenamedSource(String newName, boolean includeSchema) {
        StringBuilder newSource = new StringBuilder();
        if (this.m_nameToken != null) {
            int start = includeSchema ? this.m_schemaDotNameStart : this.m_nameToken.getStart();
            newSource.append(this.m_source.substring(0, start));
            newSource.append(newName);
            PlSqlToken nToken = this.m_tokenizer.getEndMarker().getPrevCodeToken();
            PlSqlToken n1Token = nToken.getPrevCodeToken();
            PlSqlToken n2Token = n1Token.getPrevCodeToken();
            if (nToken.matches(PUNC_SEMICOLON) && n1Token.matches(this.m_nameToken.getSource()) && n2Token.matches(KW_END)) {
                newSource.append(this.m_source.substring(this.m_nameToken.getEnd() + 1, n1Token.getStart()));
                if (newName.indexOf(PUNC_DOT) > -1 && includeSchema) {
                    newSource.append(newName.substring(newName.indexOf(PUNC_DOT) + 1));
                } else {
                    newSource.append(newName);
                }
                newSource.append(this.m_source.substring(n1Token.getEnd() + 1));
            } else {
                newSource.append(this.m_source.substring(this.m_nameToken.getEnd() + 1));
            }
        }
        return newSource.toString();
    }

    public boolean isEvolvedType() {
        return this.m_evolvedType;
    }

    public String getUpdatedSourceForRelationRename(String newRelationName) {
        if (this.m_triggerBaseItemFragment == null) {
            return this.m_source;
        }
        StringBuilder newSource = new StringBuilder();
        newSource.append(this.m_source.substring(0, this.m_triggerBaseItemFragment.getStartOffset()));
        newSource.append(newRelationName);
        newSource.append(this.m_source.substring(this.m_triggerBaseItemFragment.getEndOffset() + 1));
        return newSource.toString();
    }

    public String getSource(PlSqlToken start, PlSqlToken end) {
        return start.getSource(false, end);
    }

    int getSourceLength() {
        return this.m_source == null ? 0 : this.m_source.length();
    }

    public PlSqlToken skipToCodeToken(PlSqlFragment frag, PlSqlToken tk, String ... tkStrs) {
        int limit = frag != null ? frag.getLastToken().getEnd() : this.getSourceLength();
        do {
            for (String tkStr : tkStrs) {
                if (!tk.matches(tkStr)) continue;
                return tk;
            }
        } while ((tk = tk.getNextCodeToken()) != null && tk.getType() != PlSqlToken.Type.END_MARKER && tk.getStart() <= limit);
        return null;
    }

    static {
        s_knownTypes.add(KW_PROCEDURE);
        s_knownTypes.add(KW_FUNCTION);
        s_knownTypes.add(KW_TRIGGER);
        s_knownTypes.add(KW_PACKAGE);
        s_knownTypes.add(KW_TYPE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InterrogateState {
        PROCEDURE,
        FUNCTION,
        TRIGGER,
        PLSQL_BLOCK,
        DECLARATIVE_SECTION,
        STATEMENT_BLOCK,
        EXCEPTION_BLOCK,
        SIMPLE_STATEMENT,
        LABEL,
        PARAMETER,
        PARAMETER_LIST,
        TRIGGER_EVENTS,
        TRIGGER_COLUMNS,
        CASE_STATEMENT,
        ORACLE_TYPE_DECLN,
        TYPE_SPEC;


        public String toString() {
            return super.toString().replaceAll("_", " ");
        }
    }
}

