/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import oracle.javatools.db.plsql.PlSqlArb;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;

public class PlSqlFragment
implements PlsqlRoot {
    private Type m_type;
    private AlterSubType m_alterSubType;
    private PlSqlToken m_firstToken;
    private PlSqlToken m_lastToken;
    private ArrayList<PlSqlFragment> m_subFragments;
    private PlSqlFragment m_parent;
    private WeakReference<PlSqlInterrogator> m_plsInt;
    private static final Type m_packageSpec = Type.PACKAGE_SPEC;
    public static final int TYPE_PACKAGE_SPEC = m_packageSpec.ordinal();
    private static final Type m_packageBody = Type.PACKAGE_BODY;
    public static final int TYPE_PACKAGE_BODY = m_packageBody.ordinal();

    PlSqlFragment(PlSqlInterrogator plsInt, PlSqlFragment parent) {
        this.initialise(plsInt, parent);
    }

    PlSqlFragment(PlSqlInterrogator plsInt) {
        this.initialise(plsInt, null);
    }

    private void initialise(PlSqlInterrogator plsInt, PlSqlFragment parent) {
        this.m_plsInt = new WeakReference<PlSqlInterrogator>(plsInt);
        this.m_type = Type.UNKNOWN;
        this.m_firstToken = null;
        this.m_lastToken = null;
        this.m_subFragments = new ArrayList();
        this.m_parent = parent;
        if (parent != null) {
            parent.m_subFragments.add(this);
        }
    }

    public PlSqlFragment getParent() {
        return this.m_parent;
    }

    @Deprecated
    public int getType() {
        return this.m_type.ordinal();
    }

    public Type getFramentType() {
        return this.m_type;
    }

    public void setFragmentType(Type type) {
        this.m_type = type;
    }

    public PlSqlToken getFirstToken() {
        return this.m_firstToken;
    }

    public void setAlterSubType(AlterSubType alterSubType) {
        this.m_alterSubType = alterSubType;
    }

    public AlterSubType getAlterSubType() {
        return this.m_alterSubType;
    }

    public void setFirstToken(PlSqlToken firstToken) {
        this.m_firstToken = firstToken;
    }

    public PlSqlToken getLastToken() {
        if (this.m_lastToken == null && this.m_firstToken != null) {
            this.m_lastToken = this.m_firstToken;
            while (this.m_lastToken.getNextCodeToken() != null && this.m_lastToken.getNextCodeToken().getType() != PlSqlToken.Type.END_MARKER) {
                this.m_lastToken = this.m_lastToken.getNextCodeToken();
            }
        }
        return this.m_lastToken;
    }

    public void setLastToken(PlSqlToken lastToken) {
        this.m_lastToken = lastToken;
    }

    @Deprecated
    public final ArrayList getSubFragments() {
        return this.m_subFragments;
    }

    public PlSqlFragment[] getChildren() {
        return this.m_subFragments.toArray(new PlSqlFragment[this.m_subFragments.size()]);
    }

    public String getSource() {
        PlSqlToken lastTk = this.m_lastToken;
        if (lastTk == null) {
            lastTk = this.m_firstToken;
            while (lastTk.getType() != PlSqlToken.Type.END_MARKER) {
                lastTk = lastTk.getNextToken();
            }
            lastTk = lastTk.getPrevCodeToken();
        }
        return this.m_firstToken.getSource(false, lastTk);
    }

    public String getSourceSnippet(int maxChars) {
        PlSqlToken tk = this.m_firstToken;
        PlSqlToken lastTk = this.m_lastToken;
        boolean lastWasCode = true;
        if (lastTk == null) {
            lastTk = this.m_firstToken;
            while (lastTk.getType() != PlSqlToken.Type.END_MARKER) {
                lastTk = lastTk.getNextToken();
            }
            lastTk = lastTk.getPrevCodeToken();
        }
        String retval = "";
        while (tk.getType() != PlSqlToken.Type.END_MARKER && tk.getStart() <= lastTk.getStart()) {
            if (retval.length() + tk.getSource().length() < maxChars - 4) {
                if (tk.isCode()) {
                    if (!lastWasCode) {
                        retval = retval + " ";
                    }
                    lastWasCode = true;
                    retval = retval + tk.getSource();
                } else {
                    lastWasCode = false;
                }
            } else {
                retval = retval + "...";
                break;
            }
            tk = tk.getNextToken();
        }
        return retval;
    }

    public PlsqlError[] getErrors() {
        return new PlsqlError[0];
    }

    public PlsqlNode[] getUnits() {
        PlsqlNode[] retval = new PlsqlNode[this.m_subFragments.size()];
        for (int i = 0; i < this.m_subFragments.size(); ++i) {
            retval[i] = (PlsqlNode)this.m_subFragments.get(i);
        }
        return retval;
    }

    public int getTreeKind() {
        return this.m_type.ordinal();
    }

    public int getStartOffset() {
        return this.m_firstToken.getStart();
    }

    public int getEndOffset() {
        if (this.m_lastToken == null) {
            return ((PlSqlInterrogator)this.m_plsInt.get()).getSourceLength();
        }
        return this.m_lastToken.getEnd();
    }

    public String getTypeString() {
        return PlSqlFragment.getTypeString(this.m_type);
    }

    public static String getTypeString(Type type) {
        switch (type) {
            case ROOT: {
                return PlSqlArb.getString(0);
            }
            case LABEL: {
                return PlSqlArb.getString(1);
            }
            case DECLARE: {
                return PlSqlArb.getString(2);
            }
            case BEGIN: {
                return PlSqlArb.getString(3);
            }
            case EXCEPTION: {
                return PlSqlArb.getString(4);
            }
            case TYPE_SPEC: {
                return PlSqlArb.getString(5);
            }
            case TYPE_BODY: {
                return PlSqlArb.getString(6);
            }
            case PACKAGE_SPEC: {
                return PlSqlArb.getString(7);
            }
            case PACKAGE_BODY: {
                return PlSqlArb.getString(8);
            }
            case PROCEDURE: 
            case PROCEDURE_FD: {
                return PlSqlArb.getString(9);
            }
            case FUNCTION: 
            case FUNCTION_FD: {
                return PlSqlArb.getString(10);
            }
            case TRIGGER: {
                return PlSqlArb.getString(11);
            }
            case PLSQL_BLOCK: {
                return PlSqlArb.getString(12);
            }
            case IF: {
                return PlSqlArb.getString(13);
            }
            case ELSIF: {
                return PlSqlArb.getString(14);
            }
            case ELSE: {
                return PlSqlArb.getString(15);
            }
            case LOOP: {
                return PlSqlArb.getString(16);
            }
            case FOR_LOOP: {
                return PlSqlArb.getString(17);
            }
            case WHILE_LOOP: {
                return PlSqlArb.getString(18);
            }
            case STATEMENT: {
                return PlSqlArb.getString(19);
            }
            case DECLARATION: {
                return PlSqlArb.getString(20);
            }
            case EX_WHEN: {
                return PlSqlArb.getString(21);
            }
            case PARAMETER_LIST: {
                return PlSqlArb.getString(22);
            }
            case PARAMETER: {
                return PlSqlArb.getString(23);
            }
            case PRAGMA: {
                return PlSqlArb.getString(24);
            }
            case TRIGGER_TIMING: {
                return PlSqlArb.getString(25);
            }
            case TRIGGER_EVENTS: {
                return PlSqlArb.getString(26);
            }
            case TRIGGER_COLUMNS: {
                return PlSqlArb.getString(27);
            }
            case TRIGGER_TABLE: {
                return PlSqlArb.getString(28);
            }
            case TRIGGER_REFERENCING: {
                return PlSqlArb.getString(29);
            }
            case TRIGGER_ROW_LEVEL: {
                return PlSqlArb.getString(30);
            }
            case TRIGGER_WHEN: {
                return PlSqlArb.getString(31);
            }
            case CASE: {
                return PlSqlArb.getString(32);
            }
            case CASE_WHEN: {
                return PlSqlArb.getString(33);
            }
            case CASE_ELSE: {
                return PlSqlArb.getString(34);
            }
            case TYPE_ALTER_STATEMENT: {
                return PlSqlArb.getString(35);
            }
        }
        return PlSqlArb.getString(36);
    }

    public String getDescriptionString() {
        String retval = PlSqlFragment.getTypeString(this.m_type);
        switch (this.m_type) {
            case PARAMETER: {
                retval = this.getFirstToken().getSource();
                break;
            }
            case DECLARATION: {
                if (this.getFirstToken().matches("TYPE") || this.getFirstToken().matches("SUBTYPE")) {
                    retval = this.getFirstToken().getNextCodeToken().getSource();
                    break;
                }
                if (this.getAlterSubType() != null && this.getFirstToken().matches("(")) {
                    retval = this.getFirstToken().getNextCodeToken().getSource() + "...";
                    break;
                }
                retval = this.getFirstToken().getSource();
                break;
            }
            case TRIGGER_TIMING: 
            case TRIGGER_TABLE: {
                retval = retval + ": " + this.getSource();
                break;
            }
            case TYPE_SPEC: 
            case PACKAGE_SPEC: 
            case TRIGGER: {
                PlSqlToken tk = this.getFirstToken().getNextCodeToken();
                retval = retval + ": " + this.getSourceToWS(tk);
                break;
            }
            case TYPE_BODY: 
            case PACKAGE_BODY: {
                PlSqlToken tk = this.getFirstToken().getNextCodeToken().getNextCodeToken();
                retval = retval + ": " + this.getSourceToWS(tk);
                break;
            }
            case PROCEDURE: 
            case PROCEDURE_FD: 
            case FUNCTION: 
            case FUNCTION_FD: {
                try {
                    PlSqlToken tk = this.getFirstToken();
                    while (!tk.matches("PROCEDURE") && !tk.matches("FUNCTION")) {
                        tk = tk.getNextCodeToken();
                    }
                    tk = tk.getNextCodeToken();
                    retval = tk.getSource();
                    if ((tk = tk.getNextCodeToken()).matches(".")) {
                        retval = retval + tk.getSource();
                        tk = tk.getNextCodeToken();
                        retval = retval + tk.getSource();
                        tk = tk.getNextCodeToken();
                    }
                    if (tk.matches("(")) {
                        retval = retval + tk.getSource();
                        tk = tk.getNextCodeToken();
                        while (!(tk.matches(")") || tk.matches("IS") || tk.matches("AS") || tk.matches("RETURN") || tk.matches(";"))) {
                            tk = tk.getNextCodeToken();
                            while (tk.matches("IN") || tk.matches("OUT") || tk.matches("NOCOPY")) {
                                tk = tk.getNextCodeToken();
                            }
                            while (!(tk.matches(")") || tk.matches("DEFAULT") || tk.matches(":=") || tk.matches(","))) {
                                retval = retval + tk.getSource();
                                tk = tk.getNextCodeToken();
                            }
                            while (!tk.matches(")") && !tk.matches(",")) {
                                tk = tk.getNextCodeToken();
                            }
                            retval = retval + tk.getSource() + " ";
                            if (tk.matches(")")) continue;
                            tk = tk.getNextCodeToken();
                        }
                        tk = tk.getNextCodeToken();
                    } else {
                        retval = retval + " ";
                    }
                    if (!tk.matches("RETURN")) break;
                    retval = retval + ": ";
                    tk = tk.getNextCodeToken();
                    while (tk.isCode() && !tk.matches(";")) {
                        retval = retval + tk.getSource();
                        tk = tk.getNextToken();
                    }
                    break;
                }
                catch (NullPointerException npe) {
                    break;
                }
            }
            case EX_WHEN: {
                PlSqlToken tk = this.getFirstToken().getNextCodeToken();
                retval = retval + ": " + this.getSourceToWS(tk);
                break;
            }
            case LABEL: {
                retval = this.getSource();
                break;
            }
            case PLSQL_BLOCK: 
            case IF: 
            case ELSIF: 
            case ELSE: 
            case LOOP: 
            case FOR_LOOP: 
            case WHILE_LOOP: 
            case STATEMENT: 
            case PRAGMA: 
            case CASE: 
            case CASE_WHEN: 
            case CASE_ELSE: 
            case TYPE_ALTER_STATEMENT: {
                String suffix = "";
                int numOfThisType = 0;
                int posWithinType = 0;
                for (int j = 0; j < this.m_parent.getChildren().length; ++j) {
                    PlSqlFragment sibling = this.m_parent.getChildren()[j];
                    if (sibling.getFramentType() == this.m_type) {
                        ++numOfThisType;
                    }
                    if (sibling != this) continue;
                    posWithinType = numOfThisType;
                }
                if (numOfThisType <= true) break;
                retval = retval + ": #" + String.valueOf(posWithinType);
            }
        }
        return retval;
    }

    private String getSourceToWS(PlSqlToken tk) {
        String retval = "";
        while (tk.isCode()) {
            retval = retval + tk.getSource();
            tk = tk.getNextToken();
        }
        return retval;
    }

    public PlSqlFragment findChild(Type type, boolean deep) {
        if (this.getFramentType() == type) {
            return this;
        }
        for (PlSqlFragment frag : this.getChildren()) {
            PlSqlFragment frag2;
            if (frag.getFramentType() == type) {
                return frag;
            }
            if (!deep || (frag2 = frag.findChild(type, true)) == null) continue;
            return frag2;
        }
        return null;
    }

    final void replaceChildWithGrandChildren(PlSqlFragment child) {
        ArrayList<PlSqlFragment> grandkids = child.m_subFragments;
        this.m_subFragments.remove(child);
        this.m_subFragments.addAll(grandkids);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AlterSubType {
        ADD_ATTRIBUTE,
        DROP_ATTRIBUTE,
        MODIFY_ATTRIBUTE,
        ADD_METHOD,
        DROP_METHOD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        UNKNOWN,
        ROOT,
        LABEL,
        DECLARE,
        BEGIN,
        EXCEPTION,
        PACKAGE_SPEC,
        PACKAGE_BODY,
        PRAGMA,
        PROCEDURE,
        FUNCTION,
        TRIGGER,
        PLSQL_BLOCK,
        IF,
        ELSIF,
        ELSE,
        LOOP,
        FOR_LOOP,
        WHILE_LOOP,
        CASE,
        CASE_WHEN,
        CASE_ELSE,
        STATEMENT,
        DECLARATION,
        EX_WHEN,
        PARAMETER_LIST,
        PARAMETER,
        TRIGGER_TIMING,
        TRIGGER_EVENTS,
        TRIGGER_COLUMNS,
        TRIGGER_TABLE,
        TRIGGER_REFERENCING,
        TRIGGER_ROW_LEVEL,
        TRIGGER_WHEN,
        PROCEDURE_FD,
        FUNCTION_FD,
        TYPE_SPEC,
        TYPE_BODY,
        TYPE_ALTER_STATEMENT;

    }
}

