/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.xml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import oracle.ide.Version;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Encodings;
import oracle.ide.xml.RootElementHandler;
import oracle.ide.xml.SAXParserDoneException;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLPrinter;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.PrintDriver;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLUtil {
    public static StartElementPacket getXMLRootElement(URL url) throws FileNotFoundException {
        try {
            return XMLUtil.getXMLRootElement(URLFileSystem.openInputStream((URL)url));
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static StartElementPacket getXMLRootElement(InputStream in) {
        return XMLUtil.getXMLRootElementImpl(in, null);
    }

    public static StartElementPacket getXMLRootElement(Reader reader) {
        return XMLUtil.getXMLRootElementImpl(null, reader);
    }

    public static XSLStylesheet loadXSLT(URL xslt) throws IOException, SAXException, XSLException {
        DOMParser xslDom = new DOMParser();
        xslDom.setPreserveWhitespace(false);
        xslDom.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
        xslDom.parse(xslt);
        XMLDocument xslDoc = xslDom.getDocument();
        Element xslRootElem = xslDoc.getDocumentElement();
        NodeList xslOutputNodes = xslRootElem.getElementsByTagNameNS("http://www.w3.org/1999/XSL/Transform", "output");
        int n = xslOutputNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = xslOutputNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element elem = (Element)node;
            elem.setAttribute("encoding", Encodings.getDefaultIanaEncoding());
        }
        return new XSLProcessor().newXSLStylesheet(xslDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transformXML(URL xml, URL xslt) throws IOException, SAXException, XSLException {
        XSLStylesheet style = XMLUtil.loadXSLT(xslt);
        DOMParser domParser = new DOMParser();
        domParser.setPreserveWhitespace(false);
        domParser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
        domParser.parse(xml);
        XSLProcessor xslp = new XSLProcessor();
        OutputStream out = null;
        try {
            out = URLFileSystem.openOutputStream((URL)xml);
            xslp.processXSL(style, domParser.getDocument(), out);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static void writeXML(XMLDocument xmlDocument, URL url) throws IOException {
        OutputStream out = URLFileSystem.openOutputStream((URL)url);
        XMLUtil.writeXML(xmlDocument, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXML(XMLDocument xmlDocument, OutputStream out) throws IOException {
        if (xmlDocument == null || out == null) {
            return;
        }
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(out);
            xmlDocument.print((OutputStream)bos);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void writeXML(XMLDocument xmlDocument, PrintWriter printWriter) throws IOException {
        XMLUtil.writeXML(xmlDocument, printWriter, -1);
    }

    public static void writeXML(XMLDocument xmlDocument, PrintWriter printWriter, int indentIncr) throws IOException {
        XMLUtil.writeXML(xmlDocument, printWriter, indentIncr, false, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXML(XMLDocument xmlDocument, PrintWriter printWriter, int indentIncr, boolean useTabs, int tabSize) throws IOException {
        if (xmlDocument == null || printWriter == null) {
            return;
        }
        try {
            if (indentIncr >= 0) {
                xmlDocument.print((PrintDriver)new XMLPrinter(printWriter, indentIncr, useTabs, tabSize));
            } else {
                xmlDocument.print(printWriter);
            }
        }
        finally {
            printWriter.close();
        }
    }

    public static String toNamespaceURI(String documentID) {
        StringBuffer buf = new StringBuffer(Version.BASE_NAMESPACE_URI);
        buf.append(documentID);
        return buf.toString();
    }

    public static String toString(XMLDocument xmlDocument) {
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            xmlDocument.print(printWriter);
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String getElementValue(URL url, String element) {
        try {
            return XMLUtil.getElementValue(new InputSource(url.openStream()), element);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public static String getElementValue(File file, String element) {
        try {
            return XMLUtil.getElementValue(file.toURL(), element);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StartElementPacket getXMLRootElementImpl(InputStream in, Reader reader) {
        SAXParser saxParser = new SAXParser();
        saxParser.setValidationMode(0);
        RootElementHandler handler = new RootElementHandler();
        saxParser.setContentHandler((ContentHandler)handler);
        saxParser.setEntityResolver((EntityResolver)handler);
        try {
            if (in != null) {
                saxParser.parse(in);
            } else {
                saxParser.parse(reader);
            }
        }
        catch (SAXParserDoneException e) {
        }
        catch (XMLParseException e) {
            StartElementPacket startElementPacket = null;
            return startElementPacket;
        }
        catch (Exception e) {
            StartElementPacket startElementPacket = null;
            return startElementPacket;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        StartElementPacket rootElement = handler.getRootElement();
        return rootElement;
    }

    private static String getElementValue(InputSource inSrc, String element) {
        ElementValueHandler handler = new ElementValueHandler();
        handler.setTargetElement(element);
        try {
            SAXParser parser = new SAXParser();
            parser.setContentHandler((ContentHandler)handler);
            parser.parse(inSrc);
        }
        catch (SAXParserDoneException e) {
            return handler.getValue();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    private XMLUtil() {
    }

    private static class ElementValueHandler
    extends DefaultHandler {
        private String _targetElement;
        private String _currentElement;
        private String _value;

        private ElementValueHandler() {
        }

        @Override
        public void startElement(String nsURI, String localName, String qName, Attributes attributes) {
            this._currentElement = localName;
        }

        @Override
        public void characters(char[] text, int s, int l) throws SAXException {
            String value = new String(text, s, l);
            if (this._currentElement.equals(this._targetElement)) {
                this._value = value;
                throw new SAXParserDoneException();
            }
        }

        public String getValue() {
            return this._value;
        }

        public void setTargetElement(String target) {
            this._targetElement = target;
        }
    }
}

