/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.PanelsArb;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.util.SwingUtils;

class ExceptionPanel
extends DefaultTraversablePanel {
    private static final Logger LOG = Logger.getLogger(ExceptionPanel.class.getName());
    public static final String EXCEPTION_KEY = "ExceptionPanel.exception.key";
    private final JTextArea textArea = new JTextArea();
    private Throwable lastException;

    ExceptionPanel() {
        this((Exception)null);
        this.textArea.setEditable(false);
    }

    ExceptionPanel(Exception exception) {
        JLabel label = new JLabel(PanelsArb.getString(1));
        this.maybeSetExceptionText(exception);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add((Component)this.textArea, null);
        this.setLayout(new GridBagLayout());
        Insets in5555 = new Insets(5, 5, 5, 5);
        this.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, in5555, 0, 0));
        this.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, in5555, 0, 0));
    }

    @Override
    public void onEntry(TraversableContext tc) {
        this.maybeSetExceptionText((Exception)tc.getDesignTimeObject(EXCEPTION_KEY));
        if (this.lastException != null) {
            Object container = tc.getDesignTimeObject("navigable-ui-container");
            Frame parent = null;
            if (container instanceof Frame) {
                parent = (Frame)container;
            }
            if (parent == null) {
                parent = SwingUtils.getMainWindow();
            }
            LOG.log(Level.SEVERE, "Error entering panel", this.lastException);
        }
    }

    private void maybeSetExceptionText(Exception e) {
        Throwable t = e;
        if (t != null) {
            while (t.getCause() != null) {
                t = t.getCause();
            }
            this.textArea.setEditable(true);
            this.textArea.setText(ExceptionPanel.getThrowableText(t));
            this.textArea.setEditable(false);
            this.lastException = t;
        }
    }

    private static String getThrowableText(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

