/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.ObjectWrapper;
import oracle.ide.marshal.xml.ToDomConverter;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;

class URL2Dom
implements ToDomConverter {
    private static final boolean INTERN_STRINGS = Boolean.parseBoolean(System.getProperty("ide.hashstructure.internStrings", "true"));
    private static final Class _urlClass = URL.class;
    private static final String JAR_ENTRY_TAG = "jar-entry";
    private static final String ATTR_PROTOCOL = "protocol";
    private static final String ATTR_USERINFO = "userinfo";
    private static final String ATTR_HOST = "host";
    private static final String ATTR_PORT = "port";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_QUERY = "query";
    private static final String ATTR_REF = "ref";

    URL2Dom() {
    }

    protected static final String intern(String s) {
        if (!INTERN_STRINGS || s == null) {
            return s;
        }
        return s.intern();
    }

    @Override
    public boolean toElement(ObjectWrapper wrapper, Element element, Class type, Object2Dom o2d) {
        if (_urlClass != type) {
            return false;
        }
        URL url = (URL)wrapper.getObject();
        if (url == null) {
            return true;
        }
        URL documentURL = o2d.getDocumentURL();
        return URL2Dom.toElement(url, documentURL, element);
    }

    static boolean toElement(URL url, URL documentURL, Element element) {
        String relativeSpec;
        String jarEntrySpec;
        if (documentURL == null) {
            URL2Dom.marshalAbsoluteURL(element, url);
            return true;
        }
        if (url.getProtocol().equals("jar")) {
            jarEntrySpec = JarUtil.getJarEntry((URL)url);
            URL jarFileURL = JarUtil.getJarFileURL((URL)url);
            relativeSpec = URLFileSystem.toRelativeSpec((URL)jarFileURL, (URL)documentURL);
        } else {
            jarEntrySpec = null;
            relativeSpec = URLFileSystem.toRelativeSpec((URL)url, (URL)documentURL);
        }
        if (relativeSpec == null || relativeSpec.length() == 0) {
            relativeSpec = ".";
        }
        int endOfProtocol = relativeSpec.indexOf(":");
        int firstSlash = relativeSpec.indexOf("/");
        if (endOfProtocol >= 0 && endOfProtocol < firstSlash || firstSlash == 0) {
            URL2Dom.marshalAbsoluteURL(element, url);
        } else {
            String ref;
            element.setAttribute(ATTR_PATH, relativeSpec);
            String query = url.getQuery();
            if (query != null) {
                element.setAttribute(ATTR_QUERY, query);
            }
            if ((ref = url.getRef()) != null) {
                element.setAttribute(ATTR_REF, ref);
            }
            if (jarEntrySpec != null) {
                element.setAttribute(JAR_ENTRY_TAG, jarEntrySpec);
            }
        }
        return true;
    }

    @Override
    public boolean toObject(ObjectWrapper wrapper, Element element, Class type, Object2Dom o2d) {
        if (_urlClass != type) {
            return false;
        }
        URL documentURL = o2d.getDocumentURL();
        URL url = URL2Dom.toURL(element, documentURL);
        wrapper.setObject(url);
        return true;
    }

    static URL toURL(Element element, URL documentURL) {
        CharacterData textNode = null;
        NodeList elementChildren = element.getChildNodes();
        int elementChildrenLen = elementChildren.getLength();
        for (int i = 0; i < elementChildrenLen; ++i) {
            Node tempNode = elementChildren.item(i);
            if (tempNode == null || tempNode.getNodeType() != 3) continue;
            textNode = (Text)tempNode;
            break;
        }
        if (textNode != null) {
            String jarEntry;
            String urlText = textNode.getData();
            Attr jarEntryTag = element.getAttributeNode(JAR_ENTRY_TAG);
            String string = jarEntry = jarEntryTag != null && jarEntryTag.getValue() != null ? jarEntryTag.getValue() : null;
            if (documentURL == null) {
                throw new IllegalStateException("null document URL when unmarshalling an old format for URL persistence");
            }
            return URL2Dom._getObjectURL(urlText, jarEntry, documentURL);
        }
        return URL2Dom.toURL(URL2Dom.attributes(element), documentURL);
    }

    static URL toURL(Attributes attributes, URL documentURL) {
        String protocol = URL2Dom.intern(attributes.getValue(ATTR_PROTOCOL));
        if (protocol != null) {
            return URL2Dom.toAbsoluteURL(attributes);
        }
        if (documentURL == null) {
            throw new IllegalStateException("no protocol specified when unmarshalling a URL, and the base document URL is null");
        }
        String path = URL2Dom.intern(attributes.getValue(ATTR_PATH));
        if (path == null) {
            return null;
        }
        String query = URL2Dom.intern(attributes.getValue(ATTR_QUERY));
        String ref = URL2Dom.intern(attributes.getValue(ATTR_REF));
        URL url = null;
        if (path.startsWith("/")) {
            String docProtocol = documentURL.getProtocol();
            url = "jar".equals(docProtocol) ? URLFactory.newFileURL((String)path) : URLFactory.newURL((String)docProtocol, (String)documentURL.getUserInfo(), (String)documentURL.getHost(), (int)documentURL.getPort(), (String)path, (String)query, (String)ref);
        } else {
            URL documentDir = URLFileSystem.getParent((URL)documentURL);
            URL tempURL = URLFactory.newURL((URL)documentDir, (String)path);
            url = URLFactory.newURL((String)tempURL.getProtocol(), (String)tempURL.getUserInfo(), (String)tempURL.getHost(), (int)tempURL.getPort(), (String)tempURL.getPath(), (String)query, (String)ref);
        }
        String jarEntry = URL2Dom.intern(attributes.getValue(JAR_ENTRY_TAG));
        if (jarEntry == null) {
            return url;
        }
        return URLFactory.newJarURL((URL)url, (String)jarEntry);
    }

    private static URL toAbsoluteURL(Attributes attributes) {
        return URLFactory.newURL((String)URL2Dom.intern(attributes.getValue(ATTR_PROTOCOL)), (String)URL2Dom.intern(attributes.getValue(ATTR_USERINFO)), (String)URL2Dom.intern(attributes.getValue(ATTR_HOST)), (int)URL2Dom.toInt(attributes.getValue(ATTR_PORT), -1), (String)URL2Dom.intern(attributes.getValue(ATTR_PATH)), (String)URL2Dom.intern(attributes.getValue(ATTR_QUERY)), (String)URL2Dom.intern(attributes.getValue(ATTR_REF)));
    }

    private static Attributes attributes(final Element e) {
        return new Attributes(){

            @Override
            public int getLength() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getURI(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getLocalName(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getQName(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getType(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getValue(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getIndex(String uri, String localName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getIndex(String qName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getType(String uri, String localName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getType(String qName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getValue(String uri, String localName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getValue(String qName) {
                Attr attr = e.getAttributeNode(qName);
                return attr == null ? null : attr.getValue();
            }
        };
    }

    private static int toInt(String s, int defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return Integer.parseInt(s);
    }

    private static final void marshalAbsoluteURL(Element element, URL url) {
        String ref;
        String query;
        String path;
        int port;
        String host;
        String protocol = url.getProtocol();
        element.setAttribute(ATTR_PROTOCOL, protocol);
        String userInfo = url.getUserInfo();
        if (userInfo != null) {
            element.setAttribute(ATTR_USERINFO, url.getUserInfo());
        }
        if ((host = url.getHost()) != null && host.length() > 0) {
            element.setAttribute(ATTR_HOST, host);
        }
        if ((port = url.getPort()) >= 0) {
            element.setAttribute(ATTR_PORT, new Integer(port).toString());
        }
        if ((path = url.getPath()) != null) {
            element.setAttribute(ATTR_PATH, path);
        }
        if ((query = url.getQuery()) != null) {
            element.setAttribute(ATTR_QUERY, query);
        }
        if ((ref = url.getRef()) != null) {
            element.setAttribute(ATTR_REF, ref);
        }
    }

    private static final URL _getObjectURL(String urlText, String jarEntry, URL documentURL) {
        URL url = URL2Dom._getFileObjectURL(urlText, jarEntry);
        if (url == null) {
            try {
                URL u = new URL(urlText);
                url = jarEntry != null ? URLFactory.newJarURL((URL)u, (String)jarEntry) : u;
            }
            catch (MalformedURLException e1) {
                try {
                    URL documentDir = URLFileSystem.getParent((URL)documentURL);
                    URL u = URLFactory.newURL((URL)documentDir, (String)urlText);
                    url = jarEntry != null ? URLFactory.newJarURL((URL)u, (String)jarEntry) : u;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    url = null;
                }
            }
        }
        return url;
    }

    private static final URL _getFileObjectURL(String urlText, String jarEntry) {
        URL url = null;
        if (urlText.startsWith("file:")) {
            String path = urlText.substring(5);
            URL fileURL = URLFactory.newFileURL((String)path);
            url = jarEntry != null ? URLFactory.newJarURL((URL)fileURL, (String)jarEntry) : fileURL;
        }
        return url;
    }
}

