/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.checkboxlist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import oracle.ide.controls.checkboxlist.CheckBoxListCellData;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public class CheckBoxListModel
extends AbstractListModel
implements Copyable {
    private ArrayList _dataList = new ArrayList();

    public CheckBoxListModel() {
    }

    public CheckBoxListModel(Object[] userObjects) {
        for (int i = 0; i < userObjects.length; ++i) {
            this.addElement(userObjects[i], null, false, false);
        }
    }

    public CheckBoxListModel(Object[] userObjects, Icon icon, boolean hasCheckBox) {
        this(userObjects, icon, hasCheckBox, false);
    }

    public CheckBoxListModel(Object[] userObjects, Icon icon, boolean hasCheckBox, boolean checkBoxState) {
        for (int i = 0; i < userObjects.length; ++i) {
            this.addElement(userObjects[i], icon, hasCheckBox, checkBoxState);
        }
    }

    public CheckBoxListModel(Object[] userObjects, boolean hasCheckBox) {
        this(userObjects, null, hasCheckBox);
    }

    public CheckBoxListModel(Object[] userObjects, boolean hasCheckBox, boolean checkBoxState) {
        this(userObjects, null, hasCheckBox, checkBoxState);
    }

    public void addElement(Object userObject, Icon icon, String label, String toolTipText) {
        this.addElementAt(-1, userObject, icon, false, false, label, toolTipText);
    }

    public void addElementAt(int position, Object userObject, Icon icon, String label, String toolTipText) {
        this.addElementAt(position, userObject, icon, false, false, label, toolTipText);
    }

    public void addElement(Object userObject, Icon icon, boolean hasCheckBox, boolean checkBoxState) {
        this.addElementAt(-1, userObject, icon, hasCheckBox, checkBoxState, userObject.toString());
    }

    public void addElement(Object userObject, Icon icon, String groupId, boolean hasCheckBox, boolean checkBoxState, boolean isGroupTitle, String toolTip) {
        this.addElementAt(-1, userObject, icon, groupId, hasCheckBox, checkBoxState, isGroupTitle, toolTip);
    }

    public void addElementAt(int position, Object userObject, Icon icon, String groupId, boolean hasCheckBox, boolean checkBoxState, boolean isGroupTitle, String toolTip) {
        String label = userObject.toString();
        String tooltipText = toolTip;
        if (tooltipText == null || tooltipText.length() == 0) {
            tooltipText = label;
        }
        TriStateBoolean triStateBoolean = checkBoxState ? TriStateBoolean.TRUE : TriStateBoolean.FALSE;
        int addedPosition = 0;
        CheckBoxListCellData data = new CheckBoxListCellData(icon, label, hasCheckBox, triStateBoolean, userObject, tooltipText);
        data.setGroupId(groupId);
        data.setGroupTitle(isGroupTitle);
        if (position == -1) {
            this._dataList.add(data);
            addedPosition = this._dataList.size() - 1;
        } else {
            this._dataList.add(position, data);
            addedPosition = position;
        }
        this.fireIntervalAdded(this, addedPosition, addedPosition);
    }

    public void addElementAt(int position, Object userObject, Icon icon, boolean hasCheckBox, boolean checkBoxState) {
        this.addElementAt(position, userObject, icon, hasCheckBox, checkBoxState, userObject.toString());
    }

    public void addElement(Object userObject, Icon icon, boolean hasCheckBox, boolean checkBoxState, String label) {
        this.addElementAt(-1, userObject, icon, hasCheckBox, checkBoxState, label, null);
    }

    public void addElementAt(int position, Object userObject, Icon icon, boolean hasCheckBox, boolean checkBoxState, String label) {
        this.addElementAt(position, userObject, icon, hasCheckBox, checkBoxState, label, null);
    }

    public void addElement(Object userObject, Icon icon, boolean hasCheckBox, boolean checkBoxState, String label, String toolTipText) {
        this.addElementAt(-1, userObject, icon, hasCheckBox, checkBoxState, label, toolTipText);
    }

    public void addElement(Object userObject, Icon icon, boolean hasCheckBox, boolean checkBoxState, String groupId, String label, String toolTipText) {
        this.addElementAt(-1, userObject, icon, hasCheckBox, checkBoxState, groupId, label, toolTipText);
    }

    public void addElementAt(int position, Object userObject, Icon icon, boolean hasCheckBox, boolean checkBoxState, String label, String toolTipText) {
        TriStateBoolean triStateBoolean = checkBoxState ? TriStateBoolean.TRUE : TriStateBoolean.FALSE;
        int addedPosition = 0;
        if (position == -1) {
            this._dataList.add(new CheckBoxListCellData(icon, label, hasCheckBox, triStateBoolean, userObject, toolTipText));
            addedPosition = this._dataList.size() - 1;
        } else {
            this._dataList.add(position, new CheckBoxListCellData(icon, label, hasCheckBox, triStateBoolean, userObject, toolTipText));
            addedPosition = position;
        }
        this.fireIntervalAdded(this, addedPosition, addedPosition);
    }

    public void addElementAt(int position, Object userObject, Icon icon, boolean hasCheckBox, boolean checkBoxState, String groupId, String label, String toolTipText) {
        TriStateBoolean triStateBoolean = checkBoxState ? TriStateBoolean.TRUE : TriStateBoolean.FALSE;
        int addedPosition = 0;
        CheckBoxListCellData data = new CheckBoxListCellData(icon, label, hasCheckBox, triStateBoolean, userObject, toolTipText);
        data.setGroupId(groupId);
        data.setCheckBoxSelectable(false);
        data.setCheckBoxEnabled(false);
        if (position == -1) {
            this._dataList.add(data);
            addedPosition = this._dataList.size() - 1;
        } else {
            this._dataList.add(position, data);
            addedPosition = position;
        }
        this.fireIntervalAdded(this, addedPosition, addedPosition);
    }

    public void addCheckBoxStateListener(CheckBoxListItemStateListener listener) {
        if (listener != null) {
            for (CheckBoxListCellData listCellData : this._dataList) {
                listCellData.setStateListener(listener);
            }
        }
    }

    public void selectAll() {
        for (CheckBoxListCellData listCellData : this._dataList) {
            listCellData.setCheckBoxState(true);
        }
        this.fireContentsChanged(this, 0, this._dataList.size() - 1);
    }

    public void selectAllSelectables() {
        for (CheckBoxListCellData listCellData : this._dataList) {
            if (!listCellData.isCheckBoxSelectable()) continue;
            listCellData.setCheckBoxState(true);
        }
        this.fireContentsChanged(this, 0, this._dataList.size() - 1);
    }

    public void deselectAll() {
        for (CheckBoxListCellData listCellData : this._dataList) {
            listCellData.setCheckBoxState(false);
        }
        this.fireContentsChanged(this, 0, this._dataList.size() - 1);
    }

    public void deselectAllSelectables() {
        for (CheckBoxListCellData listCellData : this._dataList) {
            if (!listCellData.isCheckBoxSelectable()) continue;
            listCellData.setCheckBoxState(false);
        }
        this.fireContentsChanged(this, 0, this._dataList.size() - 1);
    }

    public List getSelectionList() {
        ArrayList<Object> selectedList = new ArrayList<Object>();
        for (CheckBoxListCellData listCellData : this._dataList) {
            TriStateBoolean triStateBoolean = listCellData.getCheckBoxState();
            if (!triStateBoolean.isTrue()) continue;
            selectedList.add(listCellData.getUserObject());
        }
        if (selectedList.size() > 0) {
            return selectedList;
        }
        return null;
    }

    public int elementsWithCheckBoxCount() {
        Iterator iterator = this._dataList.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            CheckBoxListCellData data = (CheckBoxListCellData)iterator.next();
            if (!data.getHasCheckBox()) continue;
            ++count;
        }
        return count;
    }

    public void findUserObjectAndMark(Object findObject, boolean selectObject) {
        for (CheckBoxListCellData listCellData : this._dataList) {
            if (!listCellData.getUserObject().equals(findObject)) continue;
            listCellData.setCheckBoxState(selectObject);
            return;
        }
    }

    public boolean isElementSelected(int index) {
        CheckBoxListCellData listCellData = (CheckBoxListCellData)this._dataList.get(index);
        TriStateBoolean triStateBoolean = listCellData.getCheckBoxState();
        return triStateBoolean.isTrue();
    }

    public void setElementSelected(int index) {
        CheckBoxListCellData listCellData = (CheckBoxListCellData)this._dataList.get(index);
        listCellData.setCheckBoxState(true);
    }

    public Object getUserObjectAt(int index) {
        CheckBoxListCellData listCellData = (CheckBoxListCellData)this._dataList.get(index);
        return listCellData.getUserObject();
    }

    public void setCheckBoxVisible(boolean checkboxVisible, boolean checkboxState) {
        int numElements = this._dataList.size();
        for (int i = 0; i < numElements; ++i) {
            CheckBoxListCellData listCellData = (CheckBoxListCellData)this._dataList.get(i);
            listCellData.setHasCheckBox(checkboxVisible);
            listCellData.setCheckBoxState(checkboxState);
        }
    }

    public void sort() {
        List group;
        Object groupId;
        ArrayList<CheckBoxListCellData> topLevel = new ArrayList<CheckBoxListCellData>();
        HashMap<Object, ArrayList<CheckBoxListCellData>> groups = new HashMap<Object, ArrayList<CheckBoxListCellData>>();
        for (Object o : this._dataList) {
            if (!(o instanceof CheckBoxListCellData)) continue;
            CheckBoxListCellData data = (CheckBoxListCellData)o;
            groupId = data.getGroupId();
            if (groupId == null) {
                topLevel.add(data);
                continue;
            }
            if (data.isGroupTitle()) {
                topLevel.add(data);
                continue;
            }
            group = (ArrayList<CheckBoxListCellData>)groups.get(groupId);
            if (group == null) {
                group = new ArrayList<CheckBoxListCellData>();
                groups.put(groupId, (ArrayList<CheckBoxListCellData>)group);
            }
            group.add(data);
        }
        Collections.sort(topLevel);
        Collection groupLists = groups.values();
        for (List group2 : groupLists) {
            Collections.sort(group2);
        }
        this._dataList.clear();
        for (CheckBoxListCellData data : topLevel) {
            groupId = data.getGroupId();
            if (groupId == null) {
                this._dataList.add(data);
                continue;
            }
            this._dataList.add(data);
            group = (List)groups.get(groupId);
            for (CheckBoxListCellData grouped : group) {
                this._dataList.add(grouped);
            }
        }
        this.fireContentsChanged(this, 0, this._dataList.size());
    }

    public void clear() {
        int numElements = this._dataList.size();
        if (numElements > 0) {
            this._dataList.clear();
            this.fireIntervalRemoved(this, 0, numElements - 1);
        }
    }

    public void removeElementByText(String value) {
        int position = this.findElementByText(value);
        if (position != -1) {
            this._dataList.remove(position);
            this.fireIntervalRemoved(this, position, position);
        }
    }

    public void removeElementByIndex(int index) {
        this._dataList.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public int findElementByText(String value) {
        int numElements = this._dataList.size();
        for (int i = 0; i < numElements; ++i) {
            CheckBoxListCellData listCellData = (CheckBoxListCellData)this._dataList.get(i);
            if (!listCellData.getText().equals(value)) continue;
            return i;
        }
        return -1;
    }

    public String findTextForElement(int index) {
        CheckBoxListCellData listCellData = (CheckBoxListCellData)this._dataList.get(index);
        return listCellData.getText();
    }

    public String getToolTipTextForElement(int index) {
        CheckBoxListCellData listCellData = (CheckBoxListCellData)this._dataList.get(index);
        return listCellData.getToolTipText();
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((CheckBoxListModel)o);
    }

    protected final boolean equalsImpl(CheckBoxListModel other) {
        return other._dataList.equals(this._dataList);
    }

    public void putCheckBoxListCellDataAt(int index, CheckBoxListCellData data) {
        this._dataList.add(index, data);
    }

    @Override
    public Object getElementAt(int index) {
        return this._dataList.get(index);
    }

    @Override
    public int getSize() {
        return this._dataList.size();
    }

    public Object copyTo(Object target) {
        CheckBoxListModel copy = target != null ? (CheckBoxListModel)target : new CheckBoxListModel();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(CheckBoxListModel copy) {
        ModelUtil.deepCopy((List)this._dataList, (List)copy._dataList);
    }
}

