/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class WaitCursor {
    private static final int DEFAULT_DELAY = 500;
    private static final MouseAdapter BEEPER = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            Toolkit.getDefaultToolkit().beep();
        }
    };
    private final List<Component> _glassPanes = new ArrayList<Component>(1);
    private boolean _disposed = false;
    private final LinkedList<DisplayCursorTask> _taskQueue = new LinkedList();
    private static final Timer _timer = new Timer("WaitCursor-Timer");

    public WaitCursor() {
    }

    public WaitCursor(Component component) {
        if (component == null) {
            return;
        }
        this.attach(this.findRootPaneContainer(component));
    }

    protected final RootPaneContainer findRootPaneContainer(Component component) {
        if (component instanceof RootPaneContainer) {
            return (RootPaneContainer)((Object)component);
        }
        return (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, component));
    }

    protected void finalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(RootPaneContainer rootPaneContainer) {
        Component glassPane;
        this.checkDisposed();
        if (rootPaneContainer != null && (glassPane = rootPaneContainer.getGlassPane()) != null) {
            List<Component> list = this._glassPanes;
            synchronized (list) {
                this._glassPanes.add(glassPane);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDisposed() {
        List<Component> list = this._glassPanes;
        synchronized (list) {
            if (this._disposed) {
                throw new IllegalStateException("WaitCursor has been disposed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(RootPaneContainer rootPaneContainer) {
        this.checkDisposed();
        if (rootPaneContainer != null) {
            Component glassPane = rootPaneContainer.getGlassPane();
            boolean containsGlassPane = false;
            List<Component> list = this._glassPanes;
            synchronized (list) {
                containsGlassPane = this._glassPanes.contains(glassPane);
                if (containsGlassPane) {
                    this._glassPanes.remove(glassPane);
                }
            }
            if (containsGlassPane) {
                this.setWaitCursor(glassPane, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<Component> list = this._glassPanes;
        synchronized (list) {
            try {
                for (Component c : this._glassPanes) {
                    this.setWaitCursor(c, false);
                }
            }
            finally {
                this._disposed = true;
                this._glassPanes.clear();
            }
        }
    }

    public void show() {
        this.show(500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void show(int delay) {
        this.checkDisposed();
        WaitCursor waitCursor = this;
        synchronized (waitCursor) {
            DisplayCursorTask task = new DisplayCursorTask();
            this._taskQueue.addLast(task);
            if (delay > 0) {
                _timer.schedule((TimerTask)task, delay);
            } else {
                task.run();
            }
        }
    }

    public void show(long delay) {
        if (delay > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Delay is too long.");
        }
        this.show((int)delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide() {
        this.checkDisposed();
        WaitCursor waitCursor = this;
        synchronized (waitCursor) {
            DisplayCursorTask task;
            DisplayCursorTask displayCursorTask = task = !this._taskQueue.isEmpty() ? this._taskQueue.removeFirst() : null;
            if (task != null) {
                task.cancel();
            }
            this.setWaitCursor(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWaitCursor(boolean bWait) {
        Component[] glasses;
        int n;
        List<Component> list = this._glassPanes;
        synchronized (list) {
            n = this._glassPanes.size();
            glasses = new Component[n];
            this._glassPanes.toArray(glasses);
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.setWaitCursor(glasses[i], bWait);
            }
        }
    }

    private void setWaitCursor(final Component glass, final boolean bWait) {
        int cursorType = bWait ? 3 : 0;
        final Cursor c = Cursor.getPredefinedCursor(cursorType);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (glass.isVisible() == bWait) {
                    return;
                }
                glass.setCursor(c);
                glass.setVisible(bWait);
                if (bWait) {
                    glass.addMouseListener(BEEPER);
                } else {
                    glass.removeMouseListener(BEEPER);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private class DisplayCursorTask
    extends TimerTask {
        private DisplayCursorTask() {
        }

        @Override
        public void run() {
            WaitCursor.this.setWaitCursor(true);
        }
    }
}

