/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plugin;

import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.extension.ExtensionProcessorContext;
import oracle.ide.extension.ExtensionProcessorPlugin;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.natives.registry.RegistryNotAvailableException;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Version;

public class JdbcDriverLocator
extends ExtensionProcessorPlugin {
    private static Logger s_logger = Logger.getLogger(JdbcDriverLocator.class.getName());
    private static ResourceBundle s_bundle = ResourceBundle.getBundle("oracle.dbtools.raptor.plugin.JdbcDriverLocatorResources");
    private static URLPath s_path = URLPath.newURLPathFromString((String)System.getProperty("java.library.path"));
    public static final String JDBC_PATH_MACRO = "jdbc.library";
    public static final String ORAI18N_PATH_MACRO = "orai18n.library";
    public static final String ORACLE_HOME_MACRO = "oracle.home";
    public static final String DRIVER_HOME_KEY = "jdbc.driver.home";
    private static final String ORACLE_HOME = "ORACLE_HOME";
    private static final String[] DRIVER_JARS_DEBUG = new String[]{"ojdbc6_g.jar", "ojdbc5_g.jar"};
    private static final String[] DRIVER_JARS = new String[]{"ojdbc6.jar", "ojdbc6dms.jar", "ojdbc5.jar", "ojdbc5dms.jar"};
    private static final String ORA1I8N_JAR = "orai18n.jar";
    private static final String JDBC_VERSION_PROPERTY = "jdbc.version";
    private static final Version MIN_VERSION = new Version(System.getProperty("jdbc.version", "11.0"));
    private Map<String, String> m_macros = new HashMap<String, String>();
    private Set<String> m_keys;

    public JdbcDriverLocator() {
        this.m_macros.put(JDBC_PATH_MACRO, null);
        this.m_macros.put(ORAI18N_PATH_MACRO, null);
        this.m_keys = new HashSet<String>(this.m_macros.keySet());
    }

    public Set<String> getSupportedMacros(ExtensionProcessorContext extensionProcessorContext) {
        return this.m_keys;
    }

    public String expandValue(ExtensionProcessorContext extensionProcessorContext, String string) {
        if (!this.m_macros.containsKey(ORACLE_HOME_MACRO)) {
            this.initPaths();
        }
        return this.m_macros.get(string);
    }

    private void initPaths() {
        String string = Ide.getOracleHomeDirectory();
        URL uRL = URLFactory.newDirURL((String)string);
        s_logger.fine(JdbcDriverLocator.formatString("ENVIRONMENT_CHECK_MESSAGE", ORACLE_HOME));
        if (!this.checkHome(System.getenv().get(ORACLE_HOME), true) && !this.checkHome(JdbcDriverLocator.checkRegistry(), true)) {
            s_logger.fine(s_bundle.getString("PARENT_HOME_CHECK_MESSAGE"));
            if (!this.checkHome(URLFileSystem.getParent((URL)uRL), true)) {
                s_logger.fine(s_bundle.getString("DEFAULT_LOCATION_MESSAGE"));
                this.checkHome(uRL, false);
            }
        }
    }

    private boolean checkHome(List<URL> list, boolean bl) {
        for (int i = 0; i < list.size(); ++i) {
            URL uRL = list.get(i);
            if (!this.checkHome(uRL, bl)) continue;
            int n = JdbcDriverLocator.getPathIndex(uRL);
            for (int j = 0; j < i; ++j) {
                URL uRL2 = list.get(j);
                int n2 = JdbcDriverLocator.getPathIndex(uRL2);
                if (n2 < 0 || n2 >= n) continue;
                s_logger.warning(JdbcDriverLocator.formatString("INCOMPATIBLE_HOME_WARNING", URLFileSystem.getPlatformPathName((URL)uRL2)));
            }
            return true;
        }
        return false;
    }

    private boolean checkHome(String string, boolean bl) {
        return string != null && this.checkHome(URLFactory.newDirURL((String)string), bl);
    }

    private boolean checkHome(URL uRL, boolean bl) {
        s_logger.fine(JdbcDriverLocator.formatString("CHECK_HOME_MESSAGE", URLFileSystem.getPlatformPathName((URL)uRL)));
        boolean bl2 = false;
        URL uRL2 = JdbcDriverLocator.expandJdbcPath(uRL);
        URL uRL3 = JdbcDriverLocator.expandI18nPath(uRL);
        if (uRL2 != null && uRL3 != null && (!bl || JdbcDriverLocator.verifyDriver(uRL2, uRL3))) {
            s_logger.fine(JdbcDriverLocator.formatString("USING_HOME_MESSAGE", URLFileSystem.getPlatformPathName((URL)uRL)));
            this.m_macros.put(ORACLE_HOME_MACRO, URLFileSystem.getPath((URL)uRL));
            if (bl) {
                System.setProperty(DRIVER_HOME_KEY, URLFileSystem.getPath((URL)uRL));
            }
            this.m_macros.put(JDBC_PATH_MACRO, URLFileSystem.getPath((URL)uRL2));
            System.setProperty(JDBC_PATH_MACRO, URLFileSystem.getPath((URL)uRL2));
            this.m_macros.put(ORAI18N_PATH_MACRO, URLFileSystem.getPath((URL)uRL3));
            System.setProperty(ORAI18N_PATH_MACRO, URLFileSystem.getPath((URL)uRL3));
            bl2 = true;
        }
        return bl2;
    }

    private static boolean verifyDriver(URL uRL, URL uRL2) {
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{JdbcDriverLocator.convertJarURL(uRL), JdbcDriverLocator.convertJarURL(uRL2)});
        try {
            s_logger.finer(JdbcDriverLocator.formatString("JDBC_DRIVER_CHECK_MESSAGE", URLFileSystem.getPlatformPathName((URL)uRL)));
            Class<?> clazz = uRLClassLoader.loadClass("oracle.jdbc.OracleDriver");
            Driver driver = (Driver)clazz.newInstance();
            int n = driver.getMajorVersion();
            int n2 = driver.getMinorVersion();
            if (MIN_VERSION.compareTo((Object)new Version(new int[]{n, n2})) > 0) {
                s_logger.finer(s_bundle.getString("JDBC_VERSION_FAILURE_MESSAGE"));
                return false;
            }
        }
        catch (Throwable throwable) {
            s_logger.finer(s_bundle.getString("JDBC_DRIVER_LOAD_FAILURE_MESSAGE"));
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return false;
        }
        try {
            s_logger.finer(JdbcDriverLocator.formatString("I18N_CHECK_MESSAGE", URLFileSystem.getPlatformPathName((URL)uRL2)));
            uRLClassLoader.loadClass("oracle.i18n.util.LocaleMapper");
            uRLClassLoader.loadClass("oracle.i18n.util.OraLocaleInfo");
        }
        catch (Throwable throwable) {
            s_logger.finer(s_bundle.getString("I18N_LOAD_FAILURE_MESSAGE"));
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<URL> checkRegistry() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (System.getProperty("os.name").startsWith("Windows")) {
            s_logger.fine(s_bundle.getString("REGISTRY_CHECK_MESSAGE"));
            RegistryKey registryKey = null;
            RegistryKey registryKey2 = null;
            try {
                String string = "SOFTWARE\\ORACLE";
                NativeHandler nativeHandler = new NativeHandler();
                nativeHandler.initialize();
                registryKey = NativeHandler.getRegistry().getLocalMachineKey();
                try {
                    registryKey2 = registryKey.openKey(string, 131097L);
                }
                catch (RegistryException registryException) {
                    ArrayList<URL> arrayList2 = arrayList;
                    try {
                        if (registryKey2 != null) {
                            registryKey2.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (registryKey != null) {
                            registryKey.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return arrayList2;
                }
                Iterator iterator = registryKey2.iterateSubKeys();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    e.toString();
                    String string2 = null;
                    RegistryKey registryKey3 = null;
                    try {
                        String string3;
                        block51: {
                            string2 = string + "\\" + e.toString();
                            registryKey3 = registryKey.openKey(string2, 131097L);
                            try {
                                string3 = registryKey3.getStringValue("ORACLE_HOME_KEY");
                                if (string2.equalsIgnoreCase(string3)) break block51;
                                RegistryKey registryKey4 = registryKey.openKey(string2, 131097L);
                                try {
                                    registryKey3.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                registryKey3 = registryKey4;
                            }
                            catch (RegistryException registryException) {
                                // empty catch block
                            }
                        }
                        if ((string3 = registryKey3.getStringValue(ORACLE_HOME)) == null) continue;
                        s_logger.finer(JdbcDriverLocator.formatString("REGISTRY_ENTRY_FOUND_MESSAGE", string3));
                        arrayList.add(URLFactory.newDirURL((String)string3));
                    }
                    catch (RegistryException registryException) {}
                    continue;
                    finally {
                        try {
                            if (registryKey3 == null) continue;
                            registryKey3.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (RegistryNotAvailableException registryNotAvailableException) {
                s_logger.severe(registryNotAvailableException.getLocalizedMessage());
            }
            catch (RegistryException registryException) {
                s_logger.severe(registryException.getLocalizedMessage());
            }
            finally {
                try {
                    if (registryKey2 != null) {
                        registryKey2.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (registryKey != null) {
                        registryKey.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        Collections.sort(arrayList, new HomeComparator());
        return arrayList;
    }

    private static int getPathIndex(URL uRL) {
        List list = s_path.asList();
        for (int i = 0; i < list.size(); ++i) {
            if (!URLFileSystem.isBaseURLFor((URL)uRL, (URL)((URL)list.get(i)))) continue;
            return i;
        }
        return -1;
    }

    private static URL expandJdbcPath(URL uRL) {
        URL uRL2;
        URL uRL3 = URLFactory.newDirURL((URL)URLFactory.newDirURL((URL)uRL, (String)"jdbc"), (String)"lib");
        if (Boolean.getBoolean("sqldev.debug")) {
            for (String string : DRIVER_JARS_DEBUG) {
                uRL2 = URLFactory.newURL((URL)uRL3, (String)string);
                if (!URLFileSystem.exists((URL)uRL2)) continue;
                return uRL2;
            }
        }
        for (String string : DRIVER_JARS) {
            uRL2 = URLFactory.newURL((URL)uRL3, (String)string);
            if (!URLFileSystem.exists((URL)uRL2)) continue;
            return uRL2;
        }
        return null;
    }

    private static URL expandI18nPath(URL uRL) {
        URL uRL2 = URLFactory.newDirURL((URL)uRL, (String)"jlib");
        URL uRL3 = URLFactory.newURL((URL)uRL2, (String)ORA1I8N_JAR);
        return URLFileSystem.exists((URL)uRL3) ? uRL3 : null;
    }

    private static URL convertJarURL(URL uRL) {
        if (JarUtil.isJarURL((URL)uRL) && !ModelUtil.hasLength((String)JarUtil.getJarEntry((URL)uRL))) {
            uRL = JarUtil.getJarFileURL((URL)uRL);
        }
        return uRL;
    }

    private static String formatString(String string, Object ... objectArray) {
        return MessageFormat.format(s_bundle.getString(string), objectArray);
    }

    private static class HomeComparator
    implements Comparator<URL> {
        private HomeComparator() {
        }

        @Override
        public int compare(URL uRL, URL uRL2) {
            int n = JdbcDriverLocator.getPathIndex(uRL);
            int n2 = JdbcDriverLocator.getPathIndex(uRL2);
            if (n2 >= 0) {
                return n >= 0 ? n - n2 : n2;
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof HomeComparator;
        }
    }
}

