/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import java.io.IOException;
import java.io.RandomAccessFile;
import oracle.xml.scalable.AbstractPageManager;
import oracle.xml.scalable.PageManager;

public class FilePageManager
extends AbstractPageManager {
    RandomAccessFile file;
    String fileName;

    public FilePageManager(String string, String string2) {
        this.open(string, string2);
    }

    public void seek(long l) throws IOException {
        this.file.seek(l);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.file.read(byArray, n, n2);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.file.write(byArray, n, n2);
    }

    public void deletePage(PageManager.PageId pageId) {
        long l = this.lastOffset;
        super.deletePage(pageId);
        try {
            if (l != this.lastOffset) {
                this.file.setLength(this.lastOffset);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        if (this.file == null) {
            return;
        }
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void open(String string, String string2) {
        try {
            this.fileName = string;
            this.file = new RandomAccessFile(this.fileName, "rw");
            this.init();
            this.currentOffset = this.file.getFilePointer();
        }
        catch (IOException iOException) {
            return;
        }
    }
}

