/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.file;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import oracle.ide.model.Project;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarIndexEntry;
import oracle.ide.net.JarUtil;
import oracle.ide.util.ArraySortedSet;
import oracle.ide.util.PatternFilters;
import oracle.ideimpl.index.file.ActiveRootManager;
import oracle.ideimpl.index.file.DifferenceFileTable;
import oracle.ideimpl.index.file.DirEntry;
import oracle.ideimpl.index.file.FileEntry;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectFactory;

public class JarFileTable
extends DifferenceFileTable {
    private static final char[] EMPTY_CHARS = new char[0];
    private long lastModified;

    static JarFileTable newInstance(Project project, URL root, PatternFilters filters) {
        JarFileTable instance = new JarFileTable(project, root, filters);
        ActiveRootManager.getInstance().addRootListener(instance.root, instance.rootListener);
        return instance;
    }

    protected JarFileTable(Project project, URL root, PatternFilters filters) {
        super(project, root, filters);
    }

    @Override
    public boolean isModified() {
        URL jarFileURL = JarUtil.getJarFileURL((URL)this.root.getURL());
        return this.lastModified != JarIndex.getInstance((URL)jarFileURL).getTimestamp();
    }

    @Override
    public ArraySortedSet<DirEntry> getDirEntries() {
        final ArraySortedSet dirs = new ArraySortedSet(DIR_COMPARATOR);
        try {
            this.bailIfCancelled();
            final String rootPrefix = JarUtil.getJarEntry((URL)this.root.getURL());
            final int rootLen = rootPrefix != null ? rootPrefix.length() : 0;
            this.bailIfCancelled();
            JarIndex jarIndex = JarUtil.getJarIndex((URL)this.root.getURL());
            this.lastModified = jarIndex.getTimestamp();
            jarIndex.visit(new JarIndex.Visitor(){

                public boolean visit(JarIndexEntry entry) {
                    char[] filename;
                    char[] directory;
                    JarFileTable.this.bailIfCancelled();
                    String entryName = entry.getName();
                    if (rootLen > 0) {
                        if (!entryName.startsWith(rootPrefix)) {
                            return true;
                        }
                        entryName = entryName.substring(rootLen);
                    }
                    if (entryName.length() == 0) {
                        return true;
                    }
                    int lastSlash = entryName.lastIndexOf(47);
                    if (lastSlash == -1) {
                        directory = EMPTY_CHARS;
                        filename = entryName.toCharArray();
                    } else {
                        directory = JarFileTable.this.charPool.add(entryName.substring(0, lastSlash + 1));
                        filename = JarFileTable.this.charPool.add(entryName.substring(lastSlash + 1));
                    }
                    if (filename.length == 0) {
                        return true;
                    }
                    int lastDot = entryName.lastIndexOf(46);
                    char[] extension = lastDot >= 0 && lastDot > lastSlash ? JarFileTable.this.charPool.add(entryName.substring(lastDot)) : EMPTY_CHARS;
                    if (filename[0] == '.') {
                        return true;
                    }
                    JarFileTable.this.lookupDir.path = directory;
                    DirEntry dir = (DirEntry)dirs.lookup((Object)JarFileTable.this.lookupDir);
                    if (dir == null) {
                        dir = new DirEntry(directory);
                        dirs.add((Object)dir);
                    }
                    int size = entry.getSize();
                    dir.files.add((Object)new FileEntry(filename, directory, extension, JarFileTable.this.lastModified, size));
                    return true;
                }
            });
        }
        catch (IOException e) {
            dirs.clear();
        }
        return dirs;
    }

    @Override
    protected AssemblyFactory getStorageFactory() {
        return new JarFileTableStorageFactory(super.getStorageFactory());
    }

    @Override
    protected void loadFromStorage(Object object) {
        JarFileTableStorage storage = (JarFileTableStorage)object;
        this.lastModified = storage.lastModified;
        super.loadFromStorage(storage.parentData);
    }

    @Override
    protected Object saveToStorage() {
        return new JarFileTableStorage(super.saveToStorage(), this.lastModified);
    }

    private static final class JarFileTableStorageFactory
    extends ObjectFactory {
        private AssemblyFactory parentFactory;

        public JarFileTableStorageFactory(AssemblyFactory parentFactory) {
            this.parentFactory = parentFactory;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            Object parentData = this.parentFactory.assemble(input);
            long lastModified = input.readLong();
            return new JarFileTableStorage(parentData, lastModified);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            JarFileTableStorage storage = (JarFileTableStorage)object;
            this.parentFactory.disassemble(storage.parentData, output);
            output.writeLong(storage.lastModified);
        }
    }

    private static final class JarFileTableStorage {
        private Object parentData;
        private long lastModified;

        public JarFileTableStorage(Object parentData, long lastModified) {
            this.parentData = parentData;
            this.lastModified = lastModified;
        }
    }
}

