/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.file;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.ide.model.Project;
import oracle.ide.util.ArraySortedSet;
import oracle.ide.util.PatternFilters;
import oracle.ideimpl.index.file.AbstractFileTable;
import oracle.ideimpl.index.file.DirEntry;
import oracle.ideimpl.index.file.FileEntry;

public abstract class DifferenceFileTable
extends AbstractFileTable {
    protected DifferenceFileTable(Project project, URL root, PatternFilters filters) {
        super(project, root, filters);
    }

    public abstract ArraySortedSet<DirEntry> getDirEntries();

    public boolean isModified() {
        return true;
    }

    @Override
    public boolean updateFileTable() {
        if (!this.isModified()) {
            return false;
        }
        ArraySortedSet<DirEntry> newDirs = this.getDirEntries();
        this.bailIfCancelled();
        boolean hasChanges = false;
        Iterator oldDirs = this.directories.iterator();
        ArrayList<DirEntry> changedDirs = new ArrayList<DirEntry>();
        ArrayList<FileEntry> changedFiles = new ArrayList<FileEntry>();
        while (oldDirs.hasNext()) {
            DirEntry oldDir = (DirEntry)oldDirs.next();
            DirEntry newDir = (DirEntry)newDirs.lookup((Object)oldDir);
            if (newDir == null) {
                oldDirs.remove();
                this.files.removeAll(oldDir.files);
                hasChanges = true;
                continue;
            }
            if (this.compareDirs(oldDir, newDir, changedFiles)) {
                oldDirs.remove();
                hasChanges = true;
                newDirs.remove((Object)newDir);
                changedDirs.add(newDir);
                continue;
            }
            newDirs.remove((Object)newDir);
        }
        if (hasChanges || !newDirs.isEmpty()) {
            ++this.version;
        }
        for (DirEntry dir : changedDirs) {
            dir.version = this.version;
            this.directories.add((Object)dir);
        }
        for (DirEntry dir : newDirs) {
            dir.version = this.version;
            this.directories.add((Object)dir);
            changedFiles.addAll((Collection<FileEntry>)dir.files);
        }
        for (FileEntry file : changedFiles) {
            file.version = this.version;
            file.id = this.getNextFileId();
            this.files.add((Object)file);
        }
        return hasChanges || !newDirs.isEmpty();
    }

    private boolean compareDirs(DirEntry oldDir, DirEntry newDir, List<FileEntry> changedFiles) {
        boolean hasChanges = false;
        ArraySortedSet newFiles = new ArraySortedSet(newDir.files, FILE_NAME_COMPARATOR);
        for (FileEntry oldFile : oldDir.files) {
            FileEntry newFile = (FileEntry)newFiles.lookup((Object)oldFile);
            if (newFile == null) {
                this.files.remove((Object)oldFile);
                hasChanges = true;
                continue;
            }
            if (oldFile.lastModified != newFile.lastModified) {
                this.files.remove((Object)oldFile);
                hasChanges = true;
                continue;
            }
            newFile.id = oldFile.id;
            newFile.version = oldFile.version;
            newFiles.remove((Object)newFile);
        }
        changedFiles.addAll((Collection<FileEntry>)newFiles);
        return hasChanges || !newFiles.isEmpty();
    }
}

