/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.file;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.zip.CRC32;
import oracle.ide.index.file.FileChange;
import oracle.ide.index.file.FileTable;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.Storage;
import oracle.ide.persistence.Storages;
import oracle.ide.util.ArraySortedSet;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.TriStateBoolean;
import oracle.ideimpl.index.IndexLogger;
import oracle.ideimpl.index.IndexThreadFactory;
import oracle.ideimpl.index.file.ActiveRootManager;
import oracle.ideimpl.index.file.ContentSetRootListener;
import oracle.ideimpl.index.file.DirEntry;
import oracle.ideimpl.index.file.DirEntryComparator;
import oracle.ideimpl.index.file.DirNameComparator;
import oracle.ideimpl.index.file.FileEntry;
import oracle.ideimpl.index.file.FileIdComparator;
import oracle.ideimpl.index.file.FileNameComparator;
import oracle.ideimpl.index.file.FileTableManagerImpl;
import oracle.ideimpl.index.file.FileTableSnapshot;
import oracle.ideimpl.index.file.GlobalFilters;
import oracle.ideimpl.index.task.BackgroundTaskImpl;
import oracle.ideimpl.index.task.SimpleProgressMonitor;
import oracle.ideimpl.index.util.CharArrayPool;
import oracle.ideimpl.index.util.ContentSetRoot;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.CharArrayFactory;
import oracle.javatools.assembly.ObjectArrayFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.data.HashStructure;

public abstract class AbstractFileTable {
    static final String NAMESPACE_KEY = "$index.FileTable$";
    private static final int FILE_STORAGE_FORMAT_VERSION = 3;
    public static final byte STORAGE_CODE = -31;
    public static final byte DIR_ENTRY_CODE = -30;
    public static final byte FILE_ENTRY_CODE = -29;
    public static final byte CHECKSUM_STORAGE_CODE = -28;
    protected static final Comparator<FileEntry> DIR_NAME_COMPARATOR = new DirNameComparator();
    protected static final Comparator<FileEntry> FILE_NAME_COMPARATOR = new FileNameComparator();
    protected static final Comparator<FileEntry> FILE_ID_COMPARATOR = new FileIdComparator();
    protected static final Comparator<DirEntry> DIR_COMPARATOR = new DirEntryComparator();
    public static final ExecutorService FILE_TABLE_UPDATE_SCHEDULER = Executors.newSingleThreadExecutor(new IndexThreadFactory("file-table"));
    private static final PatternFilters PROJECT_WORKSPACE_FILTERS = PatternFilters.getInstance((HashStructure)HashStructure.newInstance());
    protected final ContentSetRoot root;
    protected final ContentSetRootListener rootListener;
    private IntersectedFilters intersectedFilters;
    protected long version = 0L;
    protected ArraySortedSet<DirEntry> directories = new ArraySortedSet(50, DIR_COMPARATOR);
    protected ArraySortedSet<FileEntry> files = new ArraySortedSet(100, FILE_ID_COMPARATOR);
    protected DirEntry lookupDir = new DirEntry();
    protected FileEntry lookupFile = new FileEntry();
    protected CharArrayPool charPool = new CharArrayPool(100);
    protected final AssemblyFactory STORAGE_FACTORY = new FileTableStorageFactory();
    private final AssemblyFactory DIR_ENTRY_FACTORY = new DirEntryFactory();
    private final AssemblyFactory FILE_ENTRY_FACTORY = new FileEntryFactory();
    private final AssemblyFactory CHAR_ARRAY_FACTORY = new PooledCharArrayFactory();
    private final AssemblyFactory DIR_ENTRY_ARRAY_FACTORY = new ObjectArrayFactory(this.DIR_ENTRY_FACTORY);
    private final AssemblyFactory FILE_ENTRY_ARRAY_FACTORY = new ObjectArrayFactory(this.FILE_ENTRY_FACTORY);
    protected final AssemblyFactory CHECKSUM_FACTORY = new ChecksumFactory();
    private String storageKey;
    private String checksumKey;
    private boolean loaded;
    private long checksum;
    private int nextFileId = 1;
    private BackgroundTaskImpl<FileTable> runningUpdater;
    private Object updateLock = new Object();
    int refCount;

    public AbstractFileTable(Project project, URL url, PatternFilters filters) {
        this.root = new ContentSetRoot(project, url, filters);
        this.storageKey = AbstractFileTable.getStorageKey(this.root);
        this.checksumKey = "CRC32-" + this.storageKey;
        this.rootListener = new ContentSetRootListener(){

            @Override
            public void filesChanged(Collection<FileChange> changes) {
                for (FileChange change : changes) {
                    AbstractFileTable.this.invalidateFile(change.getURL());
                }
            }
        };
    }

    protected ContentSetRoot getContentSetRoot() {
        return this.root;
    }

    public long getVersion() {
        return this.version;
    }

    public URL getFileURL(int id) {
        FileEntry entry = this.lookupFileEntry(id);
        return this.getFileURL(entry);
    }

    public abstract boolean updateFileTable();

    public void invalidateFile(URL file) {
    }

    public void invalidateDir(URL directory, boolean subdirs) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundTask<FileTable> getUpdateTask() {
        Object object = this.updateLock;
        synchronized (object) {
            if (this.runningUpdater == null || this.runningUpdater.isDone()) {
                SimpleProgressMonitor progress = new SimpleProgressMonitor();
                FileTableUpdater updater = new FileTableUpdater(progress);
                Future<FileTable> future = FILE_TABLE_UPDATE_SCHEDULER.submit(updater);
                this.runningUpdater = new BackgroundTaskImpl<FileTable>(future, progress);
            } else {
                this.runningUpdater.addReference();
            }
            return this.runningUpdater;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update(SimpleProgressMonitor progress) {
        block10: {
            boolean cancelled = false;
            PerformanceLogger.get().startTiming("AbstractFileTable.updateImpl");
            PatternFilters filters = this.root.getFilters();
            this.intersectedFilters = filters == null ? GlobalFilters.getFilters() : GlobalFilters.getFilters().intersectWith(filters);
            Storage storage = Storages.getProjectStorage((Project)this.root.getProject());
            storage.open();
            try {
                NameSpace namespace = storage.getNameSpace(NAMESPACE_KEY, 1);
                if (namespace == null) break block10;
                try {
                    this.loadFileTable(namespace);
                    progress.setProgress(20);
                    if (this.updateFileTable()) {
                        progress.setProgress(90);
                        this.saveFileTable(namespace);
                    }
                    progress.setProgress(100);
                }
                finally {
                    namespace.close();
                }
            }
            catch (UpdateCancelledException uce) {
                cancelled = true;
                IndexLogger.getLogger().finer("File table update cancelled for " + URLFileSystem.getPlatformPathName((URL)this.root.getURL()));
                PerformanceLogger.get().stopTiming("AbstractFileTable.updateImpl", null);
            }
            finally {
                storage.close();
                if (!cancelled) {
                    String path = URLFileSystem.getPlatformPathName((URL)this.root.getURL());
                    PerformanceLogger.get().stopTiming("AbstractFileTable.updateImpl", "Updated file table for " + path, 500);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Map<ContentSetRoot, AbstractFileTable> map = FileTableManagerImpl.TABLES;
        synchronized (map) {
            if (--this.refCount == 0) {
                this.close();
            }
        }
    }

    protected void close() {
        FileTableManagerImpl.TABLES.remove(this.root);
        IndexLogger.getLogger().finer("Closed file table for " + URLFileSystem.getPlatformPathName((URL)this.root.getURL()));
        ActiveRootManager.getInstance().removeRootListener(this.root, this.rootListener);
    }

    protected URL getFileURL(FileEntry entry) {
        if (entry != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(entry.directory);
            buffer.append(entry.name);
            return URLFactory.newURL((URL)this.root.getURL(), (String)buffer.toString());
        }
        return null;
    }

    protected URL getDirURL(DirEntry entry) {
        if (entry != null) {
            return this.getDirURL(entry.path);
        }
        return null;
    }

    protected URL getDirURL(char[] path) {
        return URLFactory.newDirURL((URL)this.root.getURL(), (String)new String(path));
    }

    protected FileEntry lookupFileEntry(int id) {
        this.lookupFile.id = id;
        return (FileEntry)this.files.lookup((Object)this.lookupFile);
    }

    protected AssemblyFactory getStorageFactory() {
        return this.STORAGE_FACTORY;
    }

    protected void clear() {
        this.files.clear();
        this.directories.clear();
        this.charPool = new CharArrayPool(100);
        this.loaded = false;
        this.checksum = 0L;
        this.version = 0L;
    }

    protected void loadFromStorage(Object object) {
        FileTableStorage storage = (FileTableStorage)object;
        if (storage.format != 3) {
            IndexLogger.getLogger().finer("Obsolete file table for " + URLFileSystem.getPlatformPathName((URL)this.root.getURL()));
        } else {
            for (int i = 0; i < storage.entries.length; ++i) {
                DirEntry dir = (DirEntry)storage.entries[i];
                this.directories.add((Object)dir);
                this.files.addAll(dir.files);
            }
        }
        this.version = storage.version;
        this.nextFileId = storage.nextFileId;
    }

    protected Object saveToStorage() {
        return new FileTableStorage(3, this.directories.toArray(), this.version, this.nextFileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFileTable(NameSpace namespace) {
        byte[] data;
        long newChecksum = 0L;
        if (namespace != null && (data = namespace.getRecord(this.checksumKey)) != null) {
            try {
                Long l = (Long)this.CHECKSUM_FACTORY.assemble(data);
                newChecksum = l;
            }
            catch (AssemblyException e) {
                // empty catch block
            }
        }
        if (this.loaded && newChecksum != this.checksum) {
            this.clear();
            IndexLogger.getLogger().finer("Checksum mismatch for " + URLFileSystem.getPlatformPathName((URL)this.root.getURL()) + " - reloading file table from disk.");
        }
        if (!this.loaded) {
            this.checksum = newChecksum;
            if (namespace != null && (data = namespace.getRecord(this.storageKey)) != null) {
                boolean success = false;
                PerformanceLogger.get().startTiming("AbstractFileTable.loadFileTable");
                try {
                    AssemblyFactory factory = this.getStorageFactory();
                    this.loadFromStorage(factory.assemble(data));
                    success = true;
                }
                catch (AssemblyException e) {
                    IndexLogger.getLogger().log(Level.INFO, "Unable to load file table for " + URLFileSystem.getPlatformPathName((URL)this.root.getURL()), e);
                }
                finally {
                    if (success) {
                        PerformanceLogger.get().stopTiming("AbstractFileTable.loadFileTable", "Loaded file table for " + URLFileSystem.getPlatformPathName((URL)this.root.getURL()) + ": " + this.files.size() + " files in " + this.directories.size() + " directories", 500);
                    } else {
                        PerformanceLogger.get().stopTiming("AbstractFileTable.loadFileTable", null);
                    }
                }
            }
            this.loaded = true;
        }
    }

    protected void saveFileTable(NameSpace namespace) {
        if (namespace != null) {
            try {
                AssemblyFactory factory = this.getStorageFactory();
                byte[] data = factory.disassemble(this.saveToStorage());
                namespace.putRecord(this.storageKey, data);
                CRC32 crc = new CRC32();
                crc.update(data);
                this.checksum = crc.getValue();
                data = this.CHECKSUM_FACTORY.disassemble((Object)this.checksum);
                namespace.putRecord(this.checksumKey, data);
                namespace.flush();
            }
            catch (AssemblyException e) {
                IndexLogger.getLogger().log(Level.INFO, "Unable to save file table for " + URLFileSystem.getPlatformPathName((URL)this.root.getURL()), e);
            }
        }
    }

    protected void removeDirEntry(DirEntry entry) {
        this.directories.remove((Object)entry);
        for (FileEntry file : entry.files) {
            this.files.remove((Object)file);
        }
    }

    protected int getNextFileId() {
        int startId = this.nextFileId;
        do {
            ++this.nextFileId;
            this.lookupFile.id = this.lookupFile.id;
            if (this.files.contains((Object)this.lookupFile)) continue;
            return this.lookupFile.id;
        } while (startId != this.nextFileId);
        IndexLogger.getLogger().warning("Ran out of file ids for " + URLFileSystem.getPlatformPathName((URL)this.root.getURL()));
        return 0;
    }

    protected boolean filePassesFilters(String path) {
        return this.intersectedFilters.isIncluded(path);
    }

    protected boolean dirPassesFilters(String path) {
        TriStateBoolean tsb = this.intersectedFilters.inferFromFilters(path);
        return tsb.isTrue() || tsb.isTriState();
    }

    protected void bailIfCancelled() {
        if (Thread.interrupted()) {
            throw new UpdateCancelledException();
        }
    }

    private static String getStorageKey(ContentSetRoot root) {
        PatternFilter[] filterArray;
        StringBuffer buffer = new StringBuffer();
        URL projectDir = URLFileSystem.getParent((URL)root.getProject().getURL());
        String relativePath = URLFileSystem.toRelativeSpec((URL)root.getURL(), (URL)projectDir, (boolean)false);
        if (relativePath != null) {
            buffer.append(relativePath);
        } else {
            buffer.append(root.toString());
        }
        PatternFilters filters = root.getFilters();
        if (filters != null && (filterArray = filters.getFilters()) != null) {
            for (PatternFilter filter : filterArray) {
                buffer.append(filter.toStr());
            }
        }
        return buffer.toString();
    }

    static {
        PROJECT_WORKSPACE_FILTERS.addInclude("**");
        PROJECT_WORKSPACE_FILTERS.addExclude("**/*.jpr");
        PROJECT_WORKSPACE_FILTERS.addExclude("**/*.jws");
    }

    private static class UpdateCancelledException
    extends RuntimeException {
        private UpdateCancelledException() {
        }
    }

    private class FileTableUpdater
    implements Callable<FileTable> {
        private SimpleProgressMonitor progress;

        public FileTableUpdater(SimpleProgressMonitor progress) {
            this.progress = progress;
        }

        @Override
        public FileTable call() {
            AbstractFileTable.this.update(this.progress);
            return new FileTableSnapshot(AbstractFileTable.this);
        }
    }

    protected static class ChecksumFactory
    extends ObjectFactory {
        protected ChecksumFactory() {
        }

        public byte getObjectCode() {
            return -28;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            return input.readLong();
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            long checksum = (Long)object;
            output.writeLong(checksum);
        }
    }

    private final class PooledCharArrayFactory
    extends CharArrayFactory {
        private PooledCharArrayFactory() {
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            char[] array = (char[])super.assembleImpl(input);
            return AbstractFileTable.this.charPool.add(array);
        }
    }

    private final class FileEntryFactory
    extends ObjectFactory {
        private FileEntryFactory() {
        }

        public byte getObjectCode() {
            return -29;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            char[] name = (char[])AbstractFileTable.this.CHAR_ARRAY_FACTORY.assemble(input);
            char[] directory = (char[])AbstractFileTable.this.CHAR_ARRAY_FACTORY.assemble(input);
            char[] extension = (char[])AbstractFileTable.this.CHAR_ARRAY_FACTORY.assemble(input);
            long lastModified = input.readLong();
            long length = input.readLong();
            int id = input.readInt();
            long version = input.readLong();
            return new FileEntry(name, directory, extension, lastModified, length, id, version);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            FileEntry file = (FileEntry)object;
            AbstractFileTable.this.CHAR_ARRAY_FACTORY.disassemble((Object)file.name, output);
            AbstractFileTable.this.CHAR_ARRAY_FACTORY.disassemble((Object)file.directory, output);
            AbstractFileTable.this.CHAR_ARRAY_FACTORY.disassemble((Object)file.extension, output);
            output.writeLong(file.lastModified);
            output.writeLong(file.length);
            output.writeInt(file.id);
            output.writeLong(file.version);
        }
    }

    private final class DirEntryFactory
    extends ObjectFactory {
        private DirEntryFactory() {
        }

        public byte getObjectCode() {
            return -30;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            Object[] files = (Object[])AbstractFileTable.this.FILE_ENTRY_ARRAY_FACTORY.assemble(input);
            char[] path = (char[])AbstractFileTable.this.CHAR_ARRAY_FACTORY.assemble(input);
            long version = input.readLong();
            return new DirEntry(path, version, files);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            DirEntry dir = (DirEntry)object;
            AbstractFileTable.this.FILE_ENTRY_ARRAY_FACTORY.disassemble((Object)dir.files.toArray(), output);
            CharArrayFactory.CHAR_ARRAY_FACTORY.disassemble((Object)dir.path, output);
            output.writeLong(dir.version);
        }
    }

    protected class FileTableStorageFactory
    extends ObjectFactory {
        protected FileTableStorageFactory() {
        }

        public byte getObjectCode() {
            return -31;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            Object[] entries = (Object[])AbstractFileTable.this.DIR_ENTRY_ARRAY_FACTORY.assemble(input);
            int format = input.readInt();
            long version = input.readLong();
            int nextFileId = input.readInt();
            return new FileTableStorage(format, entries, version, nextFileId);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            FileTableStorage storage = (FileTableStorage)object;
            AbstractFileTable.this.DIR_ENTRY_ARRAY_FACTORY.disassemble((Object)storage.entries, output);
            output.writeInt(storage.format);
            output.writeLong(storage.version);
            output.writeInt(storage.nextFileId);
        }
    }

    protected static class FileTableStorage {
        public int format;
        public Object[] entries;
        public long version;
        public int nextFileId;

        public FileTableStorage(int format, Object[] entries, long version, int nextFileId) {
            this.format = format;
            this.entries = entries;
            this.version = version;
            this.nextFileId = nextFileId;
        }
    }
}

