/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import oracle.ide.index.DataCollector;
import oracle.ide.index.IndexManager;
import oracle.ide.index.Indexer;
import oracle.ide.index.IndexingContext;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.UnrecognizedTextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideimpl.index.FileTextBuffer;
import oracle.ideimpl.index.IndexLogger;
import oracle.ideimpl.index.IndexManagerImpl;
import oracle.ideimpl.index.IndexerStatistics;
import oracle.ideimpl.index.extension.IndexerInfo;
import oracle.ideimpl.index.extension.IndexingExtensionHook;
import oracle.ideimpl.index.extension.IndexingInfo;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.util.MultiMap;

public class IndexingContextImpl
implements IndexingContext {
    private Project project;
    private Node node;
    private URL url;
    private TextBuffer buffer;
    private long timestamp = -1L;
    private Object filterKey;
    private Object filterValue;
    private HashMap<String, Object> items = new HashMap();
    private ArrayList<Indexer> genericIndexers = new ArrayList();
    private MultiMap<Class<? extends Node>, Indexer> indexers = new MultiMap();
    private static final HashSet<String> invalidIndexers = new HashSet(3);
    private static final boolean USE_FILE_BUFFER = Boolean.getBoolean("ide.index.use.file.buffer");
    private final FileTextBuffer fileBuffer = USE_FILE_BUFFER ? new FileTextBuffer() : null;

    public IndexingContextImpl(Project project) {
        this.project = project;
        this.createIndexerInstances();
    }

    public IndexingContextImpl(TextBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public TextBuffer getTextBuffer() {
        return this.buffer;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Object getFilterKey() {
        return this.filterKey;
    }

    @Override
    public Object getFilterValue() {
        return this.filterValue;
    }

    @Override
    public Object get(String key) {
        return this.items.get(key);
    }

    @Override
    public void put(String key, Object item) {
        this.items.put(key, item);
    }

    protected void setNode(Node node) {
        this.node = node;
        this.setURL(node.getURL());
    }

    protected void setURL(URL url) {
        this.url = url;
    }

    protected void setTextBuffer(TextBuffer buffer) {
        this.buffer = buffer;
    }

    protected void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setFilterKey(Object filterKey) {
        this.filterKey = filterKey;
    }

    protected void setFilterValue(Object filterValue) {
        this.filterValue = filterValue;
    }

    public void startIndexing() {
        for (Indexer indexer : this.genericIndexers) {
            indexer.startIndexing(this);
        }
        for (Class key : this.indexers.keySet()) {
            for (Indexer indexer : this.indexers.get((Object)key)) {
                indexer.startIndexing(this);
            }
        }
    }

    public void endIndexing() {
        for (Indexer indexer : this.genericIndexers) {
            indexer.endIndexing(this);
        }
        for (Class key : this.indexers.keySet()) {
            for (Indexer indexer : this.indexers.get((Object)key)) {
                indexer.endIndexing(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(URL url, long timestamp, final DataCollector data) {
        block9: {
            try {
                Collection<Indexer> indexers;
                long start = System.nanoTime();
                Node node = NodeFactory.findOrCreate((URL)url);
                IndexerStatistics.addNodeTime(System.nanoTime() - start);
                if (node instanceof TextNode && !(node instanceof UnrecognizedTextNode)) {
                    this.setNode(node);
                    this.setTimestamp(timestamp);
                    final Collection<Indexer> nodeIndexers = this.getIndexers(node);
                    final TextNode textNode = (TextNode)node;
                    final boolean[] success = new boolean[]{false};
                    if (node.isOpen()) {
                        textNode.tryRunUnderReadLock(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                block7: {
                                    TextBuffer buffer = textNode.tryAcquireTextBuffer();
                                    if (buffer != null) {
                                        try {
                                            if (!buffer.tryReadLock()) break block7;
                                            try {
                                                IndexingContextImpl.this.indexBuffer(buffer, nodeIndexers, data);
                                                success[0] = true;
                                            }
                                            finally {
                                                buffer.readUnlock();
                                            }
                                        }
                                        finally {
                                            textNode.releaseTextBuffer();
                                        }
                                    }
                                }
                            }
                        });
                    }
                    if (success[0]) break block9;
                    TextBuffer buffer = this.getTextBuffer(textNode);
                    buffer.readLock();
                    try {
                        this.indexBuffer(buffer, nodeIndexers, data);
                        break block9;
                    }
                    finally {
                        buffer.readUnlock();
                    }
                }
                if (!(node instanceof TextNode) && !(indexers = this.getIndexers(node)).isEmpty()) {
                    this.setNode(node);
                    this.setTextBuffer(null);
                    this.setTimestamp(timestamp);
                    node.tryRunUnderReadLock(new Runnable(){

                        @Override
                        public void run() {
                            if (IndexLogger.getLogger().isLoggable(Level.FINEST)) {
                                String path = URLFileSystem.getPlatformPathName((URL)IndexingContextImpl.this.url);
                                IndexLogger.getLogger().finest("Indexing " + path);
                            }
                            for (Indexer indexer : indexers) {
                                IndexingContextImpl.this.invokeIndexer(indexer, data);
                            }
                        }
                    });
                }
            }
            catch (FileNotFoundException fnfe) {
                IndexLogger.getLogger().finest("File does not exist: " + URLFileSystem.getPlatformPathName((URL)url));
            }
            catch (Exception e) {
                IndexLogger.getLogger().log(Level.SEVERE, "Unable to index " + URLFileSystem.getPlatformPathName((URL)url), e);
            }
        }
    }

    private void indexBuffer(TextBuffer buffer, Collection<Indexer> indexers, DataCollector data) {
        if (IndexLogger.getLogger().isLoggable(Level.FINEST)) {
            String path = URLFileSystem.getPlatformPathName((URL)this.url);
            IndexLogger.getLogger().finest("Indexing " + path);
        }
        this.setTextBuffer(buffer);
        for (Indexer indexer : this.genericIndexers) {
            this.invokeIndexer(indexer, data);
        }
        for (Indexer indexer : indexers) {
            this.invokeIndexer(indexer, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeIndexer(Indexer indexer, DataCollector data) {
        long start = System.nanoTime();
        try {
            indexer.index(this, data);
        }
        catch (Throwable t) {
            IndexLogger.getLogger().log(Level.SEVERE, "Exception in " + indexer.getClass().getName() + " while indexing " + URLFileSystem.getPlatformPathName((URL)this.url), t);
        }
        finally {
            long time = System.nanoTime() - start;
            PerformanceLogger.get().log("Indexer.index", indexer.getClass().getName(), time);
            IndexerStatistics.addIndexerTiming(indexer, time);
        }
    }

    private void createIndexerInstances() {
        IndexManagerImpl manager = (IndexManagerImpl)IndexManager.getIndexManager();
        IndexingInfo ii = IndexingExtensionHook.getIndexingInfo();
        for (IndexerInfo info : ii.getIndexers()) {
            String classname = info.getIndexerClass();
            String type = info.getNodeClass();
            try {
                Class<?> clazz = Class.forName(classname);
                if (type != null) {
                    Class<?> typeClass = Class.forName(type);
                    this.indexers.add(typeClass, clazz.newInstance());
                    continue;
                }
                this.genericIndexers.add((Indexer)clazz.newInstance());
            }
            catch (Throwable t) {
                this.reportInstantiationException(t, classname);
            }
        }
        List<Class<? extends Indexer>> classes = manager.getIndexers();
        for (Class<? extends Indexer> clazz : classes) {
            try {
                this.genericIndexers.add(clazz.newInstance());
            }
            catch (Throwable t) {
                this.reportInstantiationException(t, clazz.getName());
            }
        }
        MultiMap<Class<? extends Node>, Class<? extends Indexer>> classMap = manager.getIndexerMap();
        for (Class key : classMap.keySet()) {
            for (Class clazz : classMap.get((Object)key)) {
                try {
                    this.indexers.add((Object)key, clazz.newInstance());
                }
                catch (Throwable t) {
                    this.reportInstantiationException(t, clazz.getName());
                }
            }
        }
    }

    private void reportInstantiationException(Throwable t, String classname) {
        if (!invalidIndexers.contains(classname)) {
            invalidIndexers.add(classname);
            IndexLogger.getLogger().log(Level.SEVERE, "Unable to create Indexer: " + classname, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextBuffer getTextBuffer(TextNode node) throws IOException {
        URL url = node.getURL();
        if (USE_FILE_BUFFER && "file".equals(url.getProtocol()) && ".java".equals(URLFileSystem.getSuffix((URL)url))) {
            this.fileBuffer.load(url);
            return this.fileBuffer;
        }
        InputStream is = null;
        try {
            long start = System.nanoTime();
            is = URLFileSystem.openInputStream((URL)url);
            InputStreamReader isr = new InputStreamReader(is, node.getLoadEncoding());
            IndexerStatistics.addOpenTime(System.nanoTime() - start);
            TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
            start = System.nanoTime();
            textBuffer.read((Reader)isr);
            IndexerStatistics.addBufferTime(System.nanoTime() - start);
            TextBuffer textBuffer2 = textBuffer;
            return textBuffer2;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private Collection<Indexer> getIndexers(Node node) {
        for (Class<?> clazz = node.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Collection list = this.indexers.get(clazz);
            if (list == null) continue;
            ArrayList<Indexer> copy = new ArrayList<Indexer>();
            copy.addAll(list);
            return copy;
        }
        return Collections.emptyList();
    }
}

