/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import oracle.jdevimpl.db.adapter.PasswordPrompter;
import oracle.security.misc.Checksum;

public final class DatabaseProviderHelper {
    public static final String STRINGS_TO_FILE = "INTERNAL_STRINGS_TO_FILE";
    private static final int DEFAULT = 0;
    private static final int TOFILE = 1;
    private static int s_mode = 0;
    private static PasswordPrompter s_pp;

    public static void setUTMode(boolean s) {
        s_mode = s ? 1 : 0;
    }

    public static boolean useMe() {
        return s_mode != 0;
    }

    public static void setPasswordPrompter(PasswordPrompter pp) {
        s_pp = pp;
    }

    public static PasswordPrompter getPasswordPrompter() {
        return s_pp;
    }

    private DatabaseProviderHelper() {
    }

    public static String goingOut(String value) {
        try {
            byte[] b = value.toString().getBytes();
            byte[] b2 = Checksum.MD5((byte[])b, null);
            return RepConversion.bArray2String(b2);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String comingIn(String value) {
        try {
            byte[] enc = RepConversion.convertHexStringToByte(value);
            byte[] decPwd = Checksum.SHA((byte[])enc, null);
            return new String(decPwd);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static class RepConversion {
        private RepConversion() {
        }

        private static byte nibbleToHex(byte nibble) {
            return (byte)((nibble = (byte)(nibble & 0xF)) < 10 ? nibble + 48 : nibble - 10 + 65);
        }

        private static String bArray2String(byte[] array) {
            StringBuffer result = new StringBuffer(array.length * 2);
            for (int i = 0; i < array.length; ++i) {
                result.append((char)RepConversion.nibbleToHex((byte)((array[i] & 0xF0) >> 4)));
                result.append((char)RepConversion.nibbleToHex((byte)(array[i] & 0xF)));
            }
            return result.toString();
        }

        private static int convertCharToInt(char charVal) {
            switch (charVal) {
                case '0': {
                    return 0;
                }
                case '1': {
                    return 1;
                }
                case '2': {
                    return 2;
                }
                case '3': {
                    return 3;
                }
                case '4': {
                    return 4;
                }
                case '5': {
                    return 5;
                }
                case '6': {
                    return 6;
                }
                case '7': {
                    return 7;
                }
                case '8': {
                    return 8;
                }
                case '9': {
                    return 9;
                }
                case 'A': 
                case 'a': {
                    return 10;
                }
                case 'B': 
                case 'b': {
                    return 11;
                }
                case 'C': 
                case 'c': {
                    return 12;
                }
                case 'D': 
                case 'd': {
                    return 13;
                }
                case 'E': 
                case 'e': {
                    return 14;
                }
                case 'F': 
                case 'f': {
                    return 15;
                }
            }
            return 48;
        }

        private static byte[] convertHexStringToByte(String refString) {
            byte[] byteArray = new byte[refString.length() / 2];
            for (int i = 0; i < refString.length(); i += 2) {
                int intVal = RepConversion.convertCharToInt(refString.charAt(i));
                Integer newInt = new Integer(0xF0 & intVal << 4);
                byteArray[i / 2] = newInt.byteValue();
                intVal = RepConversion.convertCharToInt(refString.charAt(i + 1));
                newInt = new Integer(0xF & intVal);
                int n = i / 2;
                byteArray[n] = (byte)(byteArray[n] | newInt.byteValue());
            }
            return byteArray;
        }
    }
}

