/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.SQLException;
import java.util.Properties;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;

public class SQLServerConnectionCreator
extends AbstractConnectionCreator {
    public static final String SQLSERVER_DRIVER_CLASS = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String SUBTYPE_SQLSERVER = "SQLServer";

    @Override
    public String getDriverClassName(Properties props) throws SQLException {
        String driverClassName = super.getDriverClassName(props);
        if (this.hasLength(driverClassName)) {
            return driverClassName;
        }
        return SQLSERVER_DRIVER_CLASS;
    }

    @Override
    public String getConnectionURL(Properties props) throws SQLException {
        String customURL = super.getConnectionURL(props);
        if (this.hasLength(customURL)) {
            return customURL;
        }
        String server = this.getPropertyOrThrow(props, "hostname");
        String port = props.getProperty("port");
        String dbase = props.getProperty("dataSourceName");
        String dbInstance = props.getProperty("instanceName");
        String url = "jdbc:sqlserver://";
        if (server != null) {
            url = url + server + (dbInstance != null ? "\\" + dbInstance : "");
            if (port != null) {
                url = url + ":" + port;
            }
            if (dbase != null) {
                url = url + ";databaseName=" + dbase;
            }
            return url;
        }
        if (!this.hasLength(customURL) && !this.hasLength(server)) {
            throw new SQLException("No URL specified for SQLServer JDBC driver");
        }
        return customURL;
    }
}

