/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Properties;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;

public abstract class AbstractOracleConnCreator
extends AbstractConnectionCreator {
    protected AbstractOracleConnCreator() {
    }

    @Override
    protected void setCustomProperties(Properties connProps, Properties jdbcProps) {
        super.setCustomProperties(connProps, jdbcProps);
        AbstractOracleConnCreator.setSessionProps(jdbcProps);
    }

    private static void setSessionProps(Properties jdbcProps) {
        String osuser = System.getProperty("user.name", null);
        String terminal = System.getProperty("jdbc.terminal", null);
        String machine = null;
        try {
            machine = System.getProperty("jdbc.machine", InetAddress.getLocalHost().getHostName());
        }
        catch (Exception e) {
            // empty catch block
        }
        String programDefault = null;
        try {
            Class<?> ide = Class.forName("oracle.ide.Ide");
            Method m = ide.getMethod("getProgramShortName", null);
            programDefault = (String)m.invoke(ide, null);
        }
        catch (Throwable t) {
            // empty catch block
        }
        String program = System.getProperty("jdbc.program", programDefault);
        String pidDefault = null;
        String jvm = System.getProperty("java.vm.name");
        if (!(System.getProperty("disablePIDCheck") != null || jvm != null && jvm.equals("OJVM Client VM"))) {
            try {
                int at;
                pidDefault = ManagementFactory.getRuntimeMXBean().getName();
                if (pidDefault != null && (at = pidDefault.indexOf(64)) >= 0) {
                    pidDefault = pidDefault.substring(0, at);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String process = System.getProperty("jdbc.process", pidDefault);
        AbstractOracleConnCreator.setProperty(jdbcProps, "v$session.terminal", terminal);
        AbstractOracleConnCreator.setProperty(jdbcProps, "v$session.machine", machine);
        AbstractOracleConnCreator.setProperty(jdbcProps, "v$session.osuser", osuser);
        AbstractOracleConnCreator.setProperty(jdbcProps, "v$session.program", program);
        AbstractOracleConnCreator.setProperty(jdbcProps, "v$session.process", process);
        AbstractOracleConnCreator.setProperty(jdbcProps, "oracle.net.CONNECT_TIMEOUT", "300000");
    }

    private static void setProperty(Properties jdbcProps, String propName, String value) {
        if (value != null) {
            jdbcProps.setProperty(propName, value);
        }
    }

    public static void main(String[] args) {
        Properties props = new Properties();
        AbstractOracleConnCreator.setSessionProps(props);
        AbstractOracleConnCreator.dumpProps(props);
        System.out.println("\nSystem Properties:");
        AbstractOracleConnCreator.dumpProps(System.getProperties());
    }

    private static void dumpProps(Properties props) {
        for (Object key : props.keySet()) {
            System.out.println(key + "\t => \t" + props.get(key));
        }
    }
}

