/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapumpCloud.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapumpCloud.DpWizCommon;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapumpCloud.DpWizardArb;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;

public abstract class CommonScheduleOptions
extends DefaultTraversablePanel {
    private CalendarPopupButton _fromButton = new CalendarPopupButton();
    private CalendarPanel _fromCp;
    private DateTimeEditor _fromDe;
    private CalendarPopupButton _fromButtonRU = new CalendarPopupButton();
    private CalendarPanel _fromCpRU;
    private DateTimeEditor _fromDeRU;
    private static final long serialVersionUID = 1L;
    private ExtractListModel _listModel = null;
    private JTextField _jName = new JTextField(20);
    private JTextField _jDescription = new JTextField(20);
    private JTextField _frequency = new JTextField(2);
    private JRadioButton _immediateButton_immediate = new JRadioButton();
    private JRadioButton _immediateButton_indefinate = new JRadioButton();
    private JRadioButton _laterButton_immediate = new JRadioButton();
    private JRadioButton _laterButton_indefinate = new JRadioButton();
    private JPanel _start = null;
    private JPanel _repeat = null;
    private JPanel _repeatUntil = null;
    private JLabel _date_start = null;
    private JLabel _date_immediate = null;
    private JLabel _freqLabel = null;
    private JRadioButton _oneTimeButton = new JRadioButton();
    private JRadioButton _intervalButton = new JRadioButton();
    private JRadioButton _monthlyButton = new JRadioButton();
    private JRadioButton _yearlyButton = new JRadioButton();
    private JComboBox _freqCb = new JComboBox<String>(new String[]{DpWizardArb.getString("EXP_MINUTES"), DpWizardArb.getString("EXP_HOURS"), DpWizardArb.getString("EXP_DAYS"), DpWizardArb.getString("EXP_WEEKS")});

    public CommonScheduleOptions() {
        this.buildUI();
    }

    public void buildUI() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(null, DpWizardArb.getString("EXP_JOB_PARAMETERS"), 0, 0, null, null));
        this.addLabelandText2(jPanel, 0, new JLabel(DpWizardArb.getString("EXP_JOB_NAME")), this._jName);
        this.addLabelandText2(jPanel, 1, new JLabel(DpWizardArb.getString("EXP_JOB_DESCRIPTION")), this._jDescription);
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(3, 0, 1, 1, 10.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(null, DpWizardArb.getString("EXP_JOB_SCHEDULE"), 0, 0, null, null));
        this._start = this.getTimePanelBuild(true);
        jPanel2.add((Component)this._start, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._repeat = this.getRepeatPanelBuild();
        jPanel2.add((Component)this._repeat, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._repeatUntil = this.getTimePanelBuild(false);
        jPanel2.add((Component)this._repeatUntil, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jPanel2, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(3, 0, 1, 1, 10.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 3, 1, 1, 0.0, 10.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._immediateButton_immediate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CommonScheduleOptions.this._immediateButton_immediate.isSelected()) {
                    CommonScheduleOptions.this.enableAll(false);
                } else {
                    CommonScheduleOptions.this.enableAll(true);
                }
            }
        });
        this._laterButton_immediate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CommonScheduleOptions.this._immediateButton_immediate.isSelected()) {
                    CommonScheduleOptions.this.enableAll(false);
                } else {
                    CommonScheduleOptions.this.enableAll(true);
                }
            }
        });
    }

    private void calSetupBuild() {
        this._fromCp = this._fromButton.getCalendarPanel();
        this._fromDe = new DateTimeEditor();
        this._fromCp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Date[] dateArray;
                if (actionEvent.getActionCommand() == "SELECTION_CHANGED_COMMAND" && (dateArray = CommonScheduleOptions.this._fromCp.getSelectedDates()).length > 0) {
                    CommonScheduleOptions.this._fromDe.setDate(dateArray[0]);
                }
            }
        });
        this._fromButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonScheduleOptions.this._fromCp.setSelectedDate(CommonScheduleOptions.this._fromDe.getDate());
                CommonScheduleOptions.this._fromCp.makeDateVisible(CommonScheduleOptions.this._fromDe.getDate());
            }
        });
    }

    private void calSetupSet() {
        this._fromDe.setDate((Date)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_CALFROM", CommonScheduleOptions.getSysdate(this._listModel)));
    }

    public static Date getSysdate(ExtractListModel extractListModel) {
        return (Date)DpWizCommon.getOrInitializeList(extractListModel, "DP_EXP_SYSDATE", null);
    }

    private void calSetupRepeatUntilBuild() {
        this._fromCpRU = this._fromButtonRU.getCalendarPanel();
        this._fromDeRU = new DateTimeEditor();
        this._fromCpRU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Date[] dateArray;
                if (actionEvent.getActionCommand() == "SELECTION_CHANGED_COMMAND" && (dateArray = CommonScheduleOptions.this._fromCpRU.getSelectedDates()).length > 0) {
                    CommonScheduleOptions.this._fromDeRU.setDate(dateArray[0]);
                }
            }
        });
        this._fromButtonRU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonScheduleOptions.this._fromCpRU.setSelectedDate(CommonScheduleOptions.this._fromDeRU.getDate());
                CommonScheduleOptions.this._fromCpRU.makeDateVisible(CommonScheduleOptions.this._fromDeRU.getDate());
            }
        });
    }

    private void calSetupRepeatUntilSet() {
        this._fromDeRU.setDate((Date)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_REPEAT_UNTIL", CommonScheduleOptions.getSysdate(this._listModel)));
    }

    private void addLabelandTextOne(JPanel jPanel, int n, JComponent jComponent) {
        jPanel.add((Component)jComponent, new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 18, 1, new Insets(5, 2, 0, 0), 0, 0));
    }

    private void addLabelandText2(JPanel jPanel, int n, JComponent jComponent, JComponent jComponent2) {
        jPanel.add((Component)jComponent, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 2, 0, 0), 0, 0));
        jPanel.add((Component)jComponent2, new GridBagConstraints(1, n, 2, 1, 0.0, 0.0, 18, 1, new Insets(5, 2, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this._listModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        this._jName.setText((String)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_JNAME", ""));
        this._jDescription.setText((String)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_JDESCRIPTION", ""));
        this.getTimePanelSet(true);
        this.getRepeatPanelSet();
        this.getTimePanelSet(false);
        if (this._immediateButton_immediate.isSelected()) {
            this.enableAll(false);
        } else {
            this.enableAll(true);
        }
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    private JPanel getTimePanelBuild(boolean bl) {
        if (!bl) {
            this.calSetupRepeatUntilBuild();
        } else {
            this.calSetupBuild();
        }
        String string = DpWizardArb.getString("EXP_START");
        if (!bl) {
            string = DpWizardArb.getString("EXP_REPEAT_UNTIL");
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(null, string, 0, 0, null, null));
        String string2 = DpWizardArb.getString("EXP_IMMEDIATELY");
        String string3 = DpWizardArb.getString("EXP_LATER");
        if (!bl) {
            string2 = DpWizardArb.getString("EXP_INDEFINATE");
            string3 = DpWizardArb.getString("EXP_CUSTOM");
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        if (bl) {
            this._immediateButton_immediate.setText(string2);
            buttonGroup.add(this._immediateButton_immediate);
            this.addLabelandTextOne(jPanel, 0, this._immediateButton_immediate);
            this._laterButton_immediate.setText(string3);
            buttonGroup.add(this._laterButton_immediate);
            this.addLabelandTextOne(jPanel, 1, this._laterButton_immediate);
            this._date_immediate = new JLabel(DpWizardArb.getString("EXP_DATE"));
        } else {
            this._immediateButton_indefinate.setText(string2);
            buttonGroup.add(this._immediateButton_indefinate);
            this.addLabelandTextOne(jPanel, 0, this._immediateButton_indefinate);
            this._laterButton_indefinate.setText(string3);
            buttonGroup.add(this._laterButton_indefinate);
            this.addLabelandTextOne(jPanel, 1, this._laterButton_indefinate);
            this._date_start = new JLabel(DpWizardArb.getString("EXP_DATE"));
        }
        if (!bl) {
            this.getCalPanelRU(this._date_start, jPanel, 0, 2);
        } else {
            this.getCalPanel(this._date_immediate, jPanel, 0, 2);
        }
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(3, 0, 1, 1, 10.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 3, 1, 1, 0.0, 10.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private void getTimePanelSet(boolean bl) {
        if (!bl) {
            this.calSetupRepeatUntilSet();
        } else {
            this.calSetupSet();
        }
        if (bl) {
            if (Boolean.valueOf(DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_RBIMMEDIATE", Boolean.TRUE).equals(Boolean.TRUE)).booleanValue()) {
                this._immediateButton_immediate.setSelected(true);
                this._laterButton_immediate.setSelected(false);
            } else {
                this._immediateButton_immediate.setSelected(false);
                this._laterButton_immediate.setSelected(true);
            }
        }
        if (!bl) {
            if (Boolean.valueOf(DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_RBINDEFINATE", Boolean.TRUE).equals(Boolean.TRUE)).booleanValue()) {
                this._immediateButton_indefinate.setSelected(true);
                this._laterButton_indefinate.setSelected(false);
            } else {
                this._immediateButton_indefinate.setSelected(false);
                this._laterButton_indefinate.setSelected(true);
            }
        }
    }

    private JPanel getRepeatPanelBuild() {
        String string = DpWizardArb.getString("EXP_REPEAT");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(null, string, 0, 0, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._oneTimeButton);
        buttonGroup.add(this._intervalButton);
        buttonGroup.add(this._monthlyButton);
        buttonGroup.add(this._yearlyButton);
        this._oneTimeButton.setText(DpWizardArb.getString("EXP_ONE_TIME_ONLY"));
        this._intervalButton.setText(DpWizardArb.getString("EXP_INTERVAL"));
        this._monthlyButton.setText(DpWizardArb.getString("EXP_MONTHLY"));
        this._yearlyButton.setText(DpWizardArb.getString("EXP_YEARLY"));
        this.addLabelandTextOne(jPanel, 0, this._oneTimeButton);
        this.addLabelandTextOne(jPanel, 1, this._intervalButton);
        this.addLabelandTextOne(jPanel, 3, this._monthlyButton);
        this.addLabelandTextOne(jPanel, 4, this._yearlyButton);
        this._freqLabel = new JLabel(DpWizardArb.getString("EXP_FREQUENCY"));
        JPanel jPanel2 = this.threeComponentsIndented(this._freqLabel, this._frequency, this._freqCb);
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private void getRepeatPanelSet() {
        Integer n = (Integer)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_MONTHLY_YEARLY", new Integer(1));
        if (n == 1) {
            this._oneTimeButton.setSelected(true);
        } else if (n == 2) {
            this._intervalButton.setSelected(true);
        } else if (n == 3) {
            this._monthlyButton.setSelected(true);
        } else if (n == 4) {
            this._yearlyButton.setSelected(true);
        }
        this._frequency.setText((String)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_FREQUENCY", new String("1")));
        this._freqCb.setSelectedIndex((Integer)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_FREQCOMBO", new Integer(0)));
    }

    private void getCalPanel(JComponent jComponent, JPanel jPanel, int n, int n2) {
        this._fromCp = this._fromButton.getCalendarPanel();
        jPanel.add((Component)this.threeComponentsIndented(jComponent, (JComponent)this._fromDe, (JComponent)this._fromButton), new GridBagConstraints(n, n2, 3, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._fromButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonScheduleOptions.this._fromCp.setSelectedDate(CommonScheduleOptions.this._fromDe.getDate());
                CommonScheduleOptions.this._fromCp.makeDateVisible(CommonScheduleOptions.this._fromDe.getDate());
            }
        });
    }

    private void getCalPanelRU(JComponent jComponent, JPanel jPanel, int n, int n2) {
        this._fromCpRU = this._fromButtonRU.getCalendarPanel();
        jPanel.add((Component)this.threeComponentsIndented(jComponent, (JComponent)this._fromDeRU, (JComponent)this._fromButtonRU), new GridBagConstraints(n, n2, 3, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._fromButtonRU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonScheduleOptions.this._fromCpRU.setSelectedDate(CommonScheduleOptions.this._fromDeRU.getDate());
                CommonScheduleOptions.this._fromCpRU.makeDateVisible(CommonScheduleOptions.this._fromDeRU.getDate());
            }
        });
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        super.onExit(traversableContext);
        if (traversableContext.getDirection() == 1 && !this._jName.getText().equals("")) {
            if (!this._immediateButton_immediate.isSelected()) {
                if (("SCH_" + this._jName.getText()).length() > 30) {
                    throw new TraversalException(DpWizardArb.getString("EXP_JNAME_TOO_LONG_SCHEDULED"), DpWizardArb.getString("EXP_JNAME_TOO_LONG"));
                }
            } else if (this._jName.getText().length() > 30) {
                throw new TraversalException(DpWizardArb.getString("EXP_JNAME_TOO_LONG_NOT_SCHEDULED"), DpWizardArb.getString("EXP_JNAME_TOO_LONG"));
            }
        }
        this._listModel.setProperty("DP_EXP_CALFROM", (Object)this._fromDe.getDate());
        this._listModel.setProperty("DP_EXP_REPEAT_UNTIL", (Object)this._fromDeRU.getDate());
        this._listModel.setProperty("DP_EXP_FREQUENCY", (Object)this._frequency.getText());
        this._listModel.setProperty("DP_EXP_JNAME", (Object)this._jName.getText());
        this._listModel.setProperty("DP_EXP_JDESCRIPTION", (Object)this._jDescription.getText());
        this._listModel.setProperty("DP_EXP_RBIMMEDIATE", (Object)this._immediateButton_immediate.isSelected());
        this._listModel.setProperty("DP_EXP_RBINDEFINATE", (Object)this._immediateButton_indefinate.isSelected());
        this._listModel.setProperty("DP_EXP_FREQCOMBO", (Object)this._freqCb.getSelectedIndex());
        Integer n = 1;
        if (this._intervalButton.isSelected()) {
            n = 2;
        } else if (this._monthlyButton.isSelected()) {
            n = 3;
        } else if (this._yearlyButton.isSelected()) {
            n = 4;
        }
        this._listModel.setProperty("DP_EXP_MONTHLY_YEARLY", (Object)n);
    }

    public abstract Object getExitTransition();

    public void enableAll(boolean bl) {
        this._immediateButton_indefinate.setEnabled(bl);
        this._laterButton_indefinate.setEnabled(bl);
        this._oneTimeButton.setEnabled(bl);
        this._intervalButton.setEnabled(bl);
        this._monthlyButton.setEnabled(bl);
        this._yearlyButton.setEnabled(bl);
        this._freqCb.setEnabled(bl);
        this._fromDe.setEnabled(bl);
        this._fromDeRU.setEnabled(bl);
        this._frequency.setEnabled(bl);
        this._date_start.setEnabled(bl);
        this._date_immediate.setEnabled(bl);
        this._fromButton.setEnabled(bl);
        this._fromButtonRU.setEnabled(bl);
        this._freqLabel.setEnabled(bl);
    }

    private JPanel threeComponentsIndented(JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jComponent, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(5, 3, 0, 3), 0, 0));
        jPanel.add((Component)jComponent2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 3), 0, 0));
        jPanel.add((Component)jComponent3, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 3), 0, 0));
        return jPanel;
    }
}

