/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OracleConnection;

public class DbaUtil {
    public static boolean isSysdbaRole(Connection connection) {
        Properties properties = ((OracleConnection)connection).getProperties();
        if (properties == null) {
            return false;
        }
        String string = (String)properties.get("internal_logon");
        return string != null && string.equals("SYSDBA");
    }

    public static int getDatabaseMajorVersion(Connection connection) {
        int n = -1;
        try {
            n = connection.getMetaData().getDatabaseMajorVersion();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(DbaUtil.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isArchiveLogMode(Connection connection) {
        boolean bl = false;
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                HashMap hashMap = new HashMap();
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                resultSetWrapper = dBUtil.executeOracleQuery(DbaUtil.getQuery(connection, "getArchiveLogMode"), hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        bl = resultSet.getString("LOG_MODE").equals("ARCHIVELOG");
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(DbaUtil.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPDB(Connection connection) {
        boolean bl;
        block9: {
            bl = false;
            if (Connections.getInstance().lock(connection)) {
                try {
                    String string = DbaUtil.getQuery(connection, "isPDB");
                    if (string == null) break block9;
                    try {
                        CallableStatement callableStatement = connection.prepareCall(string);
                        try {
                            ResultSet resultSet = callableStatement.executeQuery();
                            resultSet.next();
                            bl = resultSet.getInt("FLAG") > 0;
                        }
                        finally {
                            callableStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        bl = false;
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServerHome(Connection connection) {
        String string = null;
        if (Connections.getInstance().lock(connection)) {
            String string2 = DbaUtil.getQuery(connection, "retrieveServerHome");
            try {
                CallableStatement callableStatement = connection.prepareCall(string2);
                callableStatement.registerOutParameter("HOME", 12);
                callableStatement.execute();
                string = callableStatement.getString("HOME");
            }
            catch (SQLException sQLException) {
                Logger.getLogger(DbaUtil.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                ExceptionHandler.handleException((Exception)sQLException, (String)string2, (int)-1);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createNewCredential(Connection connection) {
        String string = null;
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(DbaNavigatorResources.getString("NEW_CREDENTIAL_NAME_LABEL"));
        JTextField jTextField = new JTextField(30);
        JLabel jLabel2 = new JLabel(DbaNavigatorResources.getString("OS_USER_NAME_LABEL"));
        JTextField jTextField2 = new JTextField(30);
        JLabel jLabel3 = new JLabel(DbaNavigatorResources.getString("PASSWORD_TEXT_LABEL"));
        JPasswordField jPasswordField = new JPasswordField(30);
        JLabel jLabel4 = new JLabel(DbaNavigatorResources.getString("CONFIRM_PASSWORD_TEXT_LABEL"));
        JPasswordField jPasswordField2 = new JPasswordField(30);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)jTextField, gridBagConstraints2);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        jPanel.add((Component)jTextField2, gridBagConstraints2);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        jPanel.add((Component)jPasswordField, gridBagConstraints2);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        jPanel.add((Component)jPasswordField2, gridBagConstraints2);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_createnewcredential_html");
        if (OnePageWizardDialogFactory.runDialog((Component)jPanel, (Component)jPanel, (String)DbaNavigatorResources.getString("NEW_CREDENTIAL_TITLE"))) {
            char[] cArray;
            char[] cArray2 = jPasswordField.getPassword();
            boolean bl = cArray2.length == (cArray = jPasswordField2.getPassword()).length;
            for (int i = 0; bl && i < cArray2.length; ++i) {
                bl = cArray2[i] == cArray[i];
            }
            if (!bl) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbaNavigatorResources.getString("PASSWORDS_NOT_MATCH"), (String)DbaNavigatorResources.getString("ERROR_TITLE"), null);
            } else if (Connections.getInstance().lock(connection)) {
                try {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("CREDENTIAL_NAME", jTextField.getText());
                    hashMap.put("OS_USER_NAME", jTextField2.getText());
                    hashMap.put("PASSWORD", new String(cArray2));
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    if (dBUtil.execute(DbaUtil.getQuery(connection, "newCredential"), hashMap)) {
                        string = jTextField.getText();
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
        }
        return string;
    }

    public static JTextComponent createMultiLineLabel(JPanel jPanel, String string) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setBorder(null);
        jTextArea.setBackground(jPanel.getBackground());
        return jTextArea;
    }

    private static String getQuery(Connection connection, String string) {
        String string2 = "/oracle/dbtools/raptor/dba/navigator/util/DbaUtilSql.xml";
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)string2);
        Query query = queryXMLSupport.getQuery(string, connection);
        return query != null ? query.getSql() : null;
    }
}

