/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.BinaryObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

public class DBAURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static ObjectQueries s_queries;
    private static Set<String> SOURCE_TYPE;

    @Override
    public URLStreamHandler createURLStreamHandler(String string) {
        return string.startsWith("sqldev.dbanav") ? new DBURLStreamHandler() : null;
    }

    private static synchronized Query getQuery(String string) {
        if (s_queries == null) {
            DBAURLStreamHandlerFactory.initQueries();
        }
        return s_queries.getQuery(string);
    }

    private static synchronized void initQueries() {
        URL uRL;
        if (s_queries == null && (uRL = DBAURLStreamHandlerFactory.class.getResource("source.xml")) != null) {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(false);
            try {
                dOMParser.parse(uRL.openStream());
                XMLDocument xMLDocument = dOMParser.getDocument();
                Node node = XMLHelper.getChildNode((Node)xMLDocument, (String)"/source");
                if (node != null) {
                    s_queries = new ObjectQueries((XMLNode)XMLHelper.getChildNode((Node)node, (String)"queries"));
                }
            }
            catch (Exception exception) {
                Logger.getLogger(DBAURLStreamHandlerFactory.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    static boolean isOracleSource(URL uRL) {
        return Connections.getInstance().isOracle(DBURLFormatHelper.getConnectionName((URL)uRL)) && SOURCE_TYPE.contains(DBURLFormatHelper.getBaseType((URL)uRL));
    }

    static boolean isOracleTimesTenSource(URL uRL) {
        return Connections.getInstance().isTimesTen(DBURLFormatHelper.getConnectionName((URL)uRL)) && SOURCE_TYPE.contains(DBURLFormatHelper.getBaseType((URL)uRL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static char[] fetchSource(URL uRL) {
        String string = DBURLFormatHelper.getConnectionName((URL)uRL);
        String string2 = DBURLFormatHelper.getSchema((URL)uRL);
        String string3 = DBURLFormatHelper.getName((URL)uRL);
        Query query = DBAURLStreamHandlerFactory.getQuery(string);
        assert (query != null);
        if (query == null) {
            return new char[0];
        }
        String string4 = DBURLFormatHelper.getBaseType((URL)uRL);
        StringBuffer stringBuffer = new StringBuffer("create or replace\n");
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TYPE", string4);
        hashMap.put("OWNER", string2);
        hashMap.put("NAME", string3);
        try {
            if (!Connections.getInstance().lock(string)) {
                char[] cArray = stringBuffer.toString().toCharArray();
                return cArray;
            }
            resultSetWrapper = DBUtil.getInstance((String)string).executeQuery(query.getSql(), hashMap);
            ResultSet resultSet = resultSetWrapper.getResultSet();
            while (resultSet.next()) {
                String string5 = resultSet.getString(1);
                stringBuffer.append(string5);
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(DBAURLStreamHandlerFactory.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        finally {
            Connections.getInstance().unlock(string);
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
        }
        return stringBuffer.toString().toCharArray();
    }

    static {
        SOURCE_TYPE = new HashSet<String>(Arrays.asList("PACKAGE", "PACKAGE BODY", "TYPE", "TYPE BODY", "PROCEDURE", "FUNCTION"));
    }

    private static class DBURLConnection
    extends URLConnection {
        private Database m_db;

        private DBURLConnection(URL uRL) {
            super(uRL);
        }

        @Override
        public void connect() throws IOException {
            if (!this.connected) {
                try {
                    this.m_db = Connections.getInstance().getDatabase(DBURLFormatHelper.getConnectionName((URL)this.url));
                }
                catch (DBException dBException) {
                    throw new IOException(dBException.getLocalizedMessage());
                }
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (!this.connected) {
                this.connect();
            }
            InputStream inputStream = null;
            String string = DBURLFormatHelper.getSchema((URL)this.url);
            String string2 = DBURLFormatHelper.getName((URL)this.url);
            String string3 = DBURLFormatHelper.getBaseType((URL)this.url);
            if (DBAURLStreamHandlerFactory.isOracleSource(this.url) || DBAURLStreamHandlerFactory.isOracleTimesTenSource(this.url)) {
                char[] cArray = DBAURLStreamHandlerFactory.fetchSource(this.url);
                if (cArray != null) {
                    String string4 = new String(cArray);
                    inputStream = this.getInputStreamFromString(string4);
                }
            } else {
                String string5 = null;
                if ("PACKAGE".equals(string3) || "TYPE".equals(string3)) {
                    string5 = "Spec";
                } else if ("PACKAGE BODY".equals(string3) || "TYPE BODY".equals(string3)) {
                    string3 = "PACKAGE BODY".equals(string3) ? "PACKAGE" : "TYPE";
                    string5 = "Body";
                }
                try {
                    SchemaObject schemaObject;
                    Schema schema = this.m_db.getSchema(string);
                    String string6 = this.m_db.getDatabaseSource(string3, schema, string2, string5);
                    inputStream = string6 != null ? this.getInputStreamFromString(string6) : ((schemaObject = this.m_db.getObject(string3, schema, string2)) instanceof BinaryObject ? ((BinaryObject)schemaObject).getInputStream() : new ByteArrayInputStream(new byte[0]));
                }
                catch (DBException dBException) {
                    throw new IOException(dBException.getLocalizedMessage());
                }
            }
            return inputStream;
        }

        private InputStream getInputStreamFromString(String string) {
            byte[] byArray;
            try {
                byArray = string.getBytes(IdeUtil.getIdeEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string.getBytes();
            }
            return new ByteArrayInputStream(byArray);
        }
    }

    private static class DBURLStreamHandler
    extends URLStreamHandler {
        private DBURLStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL uRL) throws IOException {
            return new DBURLConnection(uRL);
        }
    }
}

