/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.securitydialog;

import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.securitydialog.QuotaObject;
import oracle.dbtools.raptor.dba.navigator.actions.securitydialog.QuotaPanel;
import oracle.dbtools.raptor.dba.navigator.actions.securitydialog.SubjectDialog;
import oracle.dbtools.raptor.dba.navigator.actions.securitydialog.SubjectObject;
import oracle.dbtools.raptor.dba.navigator.actions.securitydialog.UserObject;
import oracle.dbtools.raptor.dba.navigator.actions.securitydialog.UserPanel;

public class UserDialog
extends SubjectDialog {
    private UserObject user;
    private UserPanel userPanel;
    private QuotaPanel quotaPanel;

    @Override
    protected boolean subjectIsUser() {
        return true;
    }

    @Override
    protected String getTitle(SubjectDialog.Operation operation) {
        if (operation == SubjectDialog.Operation.EDIT) {
            return DbaNavigatorResources.getString("EDIT_USER_TITLE");
        }
        return DbaNavigatorResources.getString("CREATE_USER_TITLE");
    }

    @Override
    protected void onApply() {
        super.onApply();
        this.userPanel.userName.setEnabled(false);
    }

    @Override
    protected void initialize(SubjectDialog.Operation operation, String string) {
        Object object;
        this.user = new UserObject(this.connection, string, operation == SubjectDialog.Operation.EDIT);
        this.userPanel = new UserPanel(this.connection);
        this.userPanel.setPreferredSize(new Dimension(600, 400));
        this.quotaPanel = new QuotaPanel();
        this.userPanel.userName.setText(this.operation == SubjectDialog.Operation.EDIT ? this.user.getSubjectName() : null);
        this.userPanel.userName.setEnabled(!this.user.isAlter());
        this.userPanel.userPass1.setText(this.user.getPassword());
        this.userPanel.userPass2.setText(this.user.getPassword());
        this.userPanel.accountLocked.setSelected(this.user.isLocked());
        this.userPanel.editionEnabled.setSelected(this.user.getEdition());
        this.userPanel.passExpired.setSelected(this.user.isExpired());
        QuotaPanel.QuotaTableTableModel quotaTableTableModel = this.quotaPanel.getTableModel();
        Map<String, QuotaObject> map = this.user.getQuotas();
        for (String object22 : map.keySet()) {
            if (this.user.getQuotas().get(object22).getContents().equals("TEMPORARY")) {
                this.userPanel.tempTablespace.addItem(object22);
            }
            this.userPanel.defTablespace.addItem(object22);
            object = map.get(object22);
            quotaTableTableModel.addRow(object22, ((QuotaObject)object).isUnlimited(), ((QuotaObject)object).getQuota(), ((QuotaObject)object).getUnit());
        }
        List<String> list = this.user.getTablespaceGroups();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.userPanel.tempTablespace.addItem(object);
        }
        this.userPanel.tempTablespace.setSelectedItem(this.user.getTempTableSpace());
        this.userPanel.defTablespace.setSelectedItem(this.user.getDefTableSpace());
    }

    @Override
    protected SubjectObject getSubject() {
        return this.user;
    }

    @Override
    protected JPanel[] getPanels() {
        JPanel[] jPanelArray = new JPanel[]{this.userPanel, this.grantedRolePanel, this.sysPrivPanel, this.quotaPanel, this.sqlPanel};
        return jPanelArray;
    }

    @Override
    protected String[] getTabNames() {
        String[] stringArray = new String[]{DbaNavigatorResources.getString("USER_TAB"), DbaNavigatorResources.getString("ROLES_TAB"), DbaNavigatorResources.getString("SYS_PRIV_TAB"), DbaNavigatorResources.getString("QUOTAS_TAB"), DbaNavigatorResources.getString("SQL_LABEL")};
        return stringArray;
    }

    @Override
    protected boolean updateUI() {
        this.user.setSubjectName(this.userPanel.userName.getText());
        this.user.setLocked(this.userPanel.accountLocked.isSelected());
        this.user.setExpired(this.userPanel.passExpired.isSelected());
        String string = new String(this.userPanel.userPass1.getPassword());
        String string2 = new String(this.userPanel.userPass2.getPassword());
        if (string.equals(string2) && !string.equals("")) {
            this.user.setPassword(string);
        }
        this.user.setDefTableSpace((String)this.userPanel.defTablespace.getSelectedItem());
        this.user.setTempTableSpace((String)this.userPanel.tempTablespace.getSelectedItem());
        if (this.userPanel.accountLocked.isSelected()) {
            this.user.setLocked(true);
        } else {
            this.user.setLocked(false);
        }
        if (this.userPanel.editionEnabled.isSelected()) {
            this.user.setEdition(true);
        } else {
            this.user.setEdition(false);
        }
        for (QuotaObject quotaObject : this.quotaPanel.getTableModel().getData()) {
            this.user.updateQuota(quotaObject);
        }
        return super.updateUI();
    }
}

