/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.securitydialog;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.dba.navigator.actions.securitydialog.GrantedRoleObject;
import oracle.dbtools.raptor.dba.navigator.actions.securitydialog.PrivilegeObject;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;

public abstract class SubjectObject {
    private Connection conn;
    private String subjectName = null;
    private Map<String, GrantedRoleObject> roles = new HashMap<String, GrantedRoleObject>();
    private Map<String, PrivilegeObject> privs = new HashMap<String, PrivilegeObject>();
    private boolean isUser = true;
    private boolean alter;

    private final Query getQueryFromFile(String string) {
        String string2 = "/oracle/dbtools/raptor/dba/navigator/actions/securitydialog/SubjectQueries.xml";
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)string2);
        Query query = queryXMLSupport.getQuery(string, this.conn);
        return query;
    }

    protected final String getQuery(String string) {
        Query query = this.getQueryFromFile(string);
        return query.getSql();
    }

    public SubjectObject(Connection connection, String string, boolean bl) {
        this.alter = bl;
        this.subjectName = string;
        this.conn = connection;
        this.loadPrivs(bl);
        this.loadRoles(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPrivs(boolean bl) {
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = this.conn.prepareCall(this.getQuery("get_privs"));
            callableStatement.setString(1, this.subjectName);
            callableStatement.setString(2, this.subjectName);
            resultSet = callableStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                PrivilegeObject privilegeObject = new PrivilegeObject(string, string2, string3, bl);
                this.privs.put(string, privilegeObject);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRoles(boolean bl) {
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = this.conn.prepareCall(this.getQuery("get_roles"));
            callableStatement.setString(1, this.subjectName);
            resultSet = callableStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                GrantedRoleObject grantedRoleObject = new GrantedRoleObject(string, string2, string3, string4, bl);
                this.roles.put(string, grantedRoleObject);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
        }
    }

    protected abstract void appendSubjectSql(StringBuffer var1);

    protected void appendRoleSql(StringBuffer stringBuffer) {
        String string = null;
        stringBuffer.append("-- ROLES\n");
        for (String string2 : this.roles.keySet()) {
            GrantedRoleObject grantedRoleObject = this.roles.get(string2);
            if (grantedRoleObject.doGrant()) {
                stringBuffer.append("GRANT \"");
                stringBuffer.append(string2);
                stringBuffer.append("\" TO ");
                if (this.isAlter()) {
                    stringBuffer.append("\"" + this.subjectName + "\"");
                } else {
                    stringBuffer.append(this.subjectName);
                }
                stringBuffer.append(" ");
                if (grantedRoleObject.isAdmin()) {
                    stringBuffer.append("WITH ADMIN OPTION");
                }
                stringBuffer.append(";\n");
            }
            if (grantedRoleObject.doRevoke()) {
                stringBuffer.append("REVOKE \"");
                stringBuffer.append(string2);
                stringBuffer.append("\" FROM ");
                if (this.isAlter()) {
                    stringBuffer.append("\"" + this.subjectName + "\"");
                } else {
                    stringBuffer.append(this.subjectName);
                }
                stringBuffer.append(";\n");
            }
            if (!grantedRoleObject.isDef()) continue;
            if (string == null) {
                string = "\"" + string2 + "\"";
                continue;
            }
            string = string + ",\"" + string2 + "\"";
        }
        if (this.getIsUser() && string != null) {
            stringBuffer.append("ALTER USER ");
            if (this.isAlter()) {
                stringBuffer.append("\"" + this.subjectName + "\"");
            } else {
                stringBuffer.append(this.subjectName);
            }
            stringBuffer.append(" DEFAULT ROLE " + string + ";\n");
        }
        stringBuffer.append("\n");
    }

    protected void appendSystemPrivsSql(StringBuffer stringBuffer) {
        stringBuffer.append("-- SYSTEM PRIVILEGES\n");
        for (String string : this.privs.keySet()) {
            PrivilegeObject privilegeObject = this.privs.get(string);
            if (privilegeObject.doRevoke()) {
                stringBuffer.append("REVOKE ");
                stringBuffer.append(string);
                stringBuffer.append(" FROM ");
                if (this.isAlter()) {
                    stringBuffer.append("\"" + this.subjectName + "\"");
                } else {
                    stringBuffer.append(this.subjectName);
                }
                stringBuffer.append(";\n");
            }
            if (!privilegeObject.doGrant()) continue;
            stringBuffer.append("GRANT ");
            stringBuffer.append(string);
            stringBuffer.append(" TO ");
            if (this.isAlter()) {
                stringBuffer.append("\"" + this.subjectName + "\"");
            } else {
                stringBuffer.append(this.subjectName);
            }
            stringBuffer.append(" ");
            if (privilegeObject.isAdmin()) {
                stringBuffer.append("WITH ADMIN OPTION");
            }
            stringBuffer.append(";\n");
        }
        stringBuffer.append("\n");
    }

    public String getSql() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendSubjectSql(stringBuffer);
        this.appendRoleSql(stringBuffer);
        this.appendSystemPrivsSql(stringBuffer);
        return stringBuffer.toString();
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(String string) {
        this.subjectName = string;
    }

    public void updateRole(String string, boolean bl, boolean bl2, boolean bl3) {
        this.roles.get(string).setGranted(bl);
        this.roles.get(string).setAdmin(bl2);
        this.roles.get(string).setDef(bl3);
    }

    public void updateRole(GrantedRoleObject grantedRoleObject) {
        GrantedRoleObject grantedRoleObject2 = this.roles.get(grantedRoleObject.getName());
        grantedRoleObject2.setAdmin(grantedRoleObject.isAdmin());
        grantedRoleObject2.setDef(grantedRoleObject.isDef());
        grantedRoleObject2.setGranted(grantedRoleObject.isGranted());
    }

    public void updatePriv(String string, boolean bl, boolean bl2) {
        this.privs.get(string).setGranted(bl);
        this.privs.get(string).setAdmin(bl2);
    }

    public void updatePrivs(PrivilegeObject privilegeObject) {
        PrivilegeObject privilegeObject2 = this.privs.get(privilegeObject.getName());
        privilegeObject2.setAdmin(privilegeObject.isAdmin());
        privilegeObject2.setGranted(privilegeObject.isGranted());
    }

    public Map<String, PrivilegeObject> getPrivs() {
        return this.privs;
    }

    public Map<String, GrantedRoleObject> getRoles() {
        return this.roles;
    }

    public void setIsUser(boolean bl) {
        this.isUser = bl;
    }

    public boolean getIsUser() {
        return this.isUser;
    }

    public boolean isAlter() {
        return this.alter;
    }

    public void setAlter(boolean bl) {
        this.alter = bl;
    }
}

