/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.securitydialog;

import java.awt.Dimension;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.securitydialog.RoleObject;
import oracle.dbtools.raptor.dba.navigator.actions.securitydialog.RolePanel;
import oracle.dbtools.raptor.dba.navigator.actions.securitydialog.SubjectDialog;
import oracle.dbtools.raptor.dba.navigator.actions.securitydialog.SubjectObject;

public class RoleDialog
extends SubjectDialog {
    private RoleObject role;
    private RolePanel rolePanel;

    @Override
    protected boolean subjectIsUser() {
        return false;
    }

    @Override
    protected String getTitle(SubjectDialog.Operation operation) {
        if (operation == SubjectDialog.Operation.EDIT) {
            return DbaNavigatorResources.getString("EDIT_ROLE_TITLE");
        }
        return DbaNavigatorResources.getString("CREATE_ROLE_TITLE");
    }

    @Override
    protected void onApply() {
        super.onApply();
        this.rolePanel.roleName.setEnabled(false);
    }

    @Override
    protected void initialize(SubjectDialog.Operation operation, String string) {
        this.role = new RoleObject(this.connection, string, operation == SubjectDialog.Operation.EDIT);
        this.role.setIsUser(this.subjectIsUser());
        this.rolePanel = new RolePanel();
        this.rolePanel.setPreferredSize(new Dimension(600, 400));
        this.rolePanel.roleName.setText(this.operation == SubjectDialog.Operation.EDIT ? this.role.getSubjectName() : null);
        this.rolePanel.roleName.setEnabled(!this.role.isAlter());
        this.rolePanel.rolePass1.setText(this.role.getPassword());
        this.rolePanel.rolePass2.setText(this.role.getPassword());
    }

    @Override
    protected SubjectObject getSubject() {
        return this.role;
    }

    @Override
    protected JPanel[] getPanels() {
        JPanel[] jPanelArray = new JPanel[]{this.rolePanel, this.grantedRolePanel, this.sysPrivPanel, this.sqlPanel};
        return jPanelArray;
    }

    @Override
    protected String[] getTabNames() {
        String[] stringArray = new String[]{DbaNavigatorResources.getString("ROLE_TAB"), DbaNavigatorResources.getString("ROLES_TAB"), DbaNavigatorResources.getString("SYS_PRIV_TAB"), DbaNavigatorResources.getString("SQL_LABEL")};
        return stringArray;
    }

    @Override
    protected boolean updateUI() {
        this.role.setSubjectName(this.rolePanel.roleName.getText());
        String string = new String(this.rolePanel.rolePass1.getPassword());
        String string2 = new String(this.rolePanel.rolePass2.getPassword());
        if (string.equals(string2)) {
            if (!string.equals("")) {
                this.role.setPassword(string);
            }
        } else {
            JOptionPane.showMessageDialog(this.rolePanel, DbaNavigatorResources.getString("PASSWORDS_NOT_MATCH"), DbaNavigatorResources.getString("ERROR_TITLE"), 0);
            return false;
        }
        return super.updateUI();
    }
}

