/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.securitydialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.securitydialog.PrivilegeObject;
import oracle.dbtools.raptor.utils.TableSorter;
import oracle.ide.help.HelpSystem;

public class PrivilegesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private PrivTableTableModel myTableModel = new PrivTableTableModel();

    public PrivilegesPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_userdialogprivs_html");
        this.setLayout(new GridBagLayout());
        JButton jButton = new JButton();
        jButton.setName("grantAllButton");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < PrivilegesPanel.this.myTableModel.getRowCount(); ++i) {
                    PrivilegesPanel.this.myTableModel.setValueAt(true, i, 1);
                }
            }
        });
        jButton.setMargin(new Insets(2, 3, 2, 3));
        jButton.setText(DbaNavigatorResources.getString("GRANT_ALL_BUTTON"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton();
        jButton2.setName("revokeAllButton");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < PrivilegesPanel.this.myTableModel.getRowCount(); ++i) {
                    PrivilegesPanel.this.myTableModel.setValueAt(false, i, 1);
                }
            }
        });
        jButton2.setMargin(new Insets(2, 3, 2, 3));
        jButton2.setText(DbaNavigatorResources.getString("REVOKE_ALL_BUTTON"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 1;
        this.add((Component)jButton2, gridBagConstraints2);
        JButton jButton3 = new JButton();
        jButton3.setName("adminAllButton");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < PrivilegesPanel.this.myTableModel.getRowCount(); ++i) {
                    PrivilegesPanel.this.myTableModel.setValueAt(true, i, 2);
                }
            }
        });
        jButton3.setMargin(new Insets(2, 3, 2, 3));
        jButton3.setText(DbaNavigatorResources.getString("ADMIN_ALL_BUTTON"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridx = 2;
        this.add((Component)jButton3, gridBagConstraints3);
        JButton jButton4 = new JButton();
        jButton4.setName("adminNoneButton");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < PrivilegesPanel.this.myTableModel.getRowCount(); ++i) {
                    PrivilegesPanel.this.myTableModel.setValueAt(false, i, 2);
                }
            }
        });
        jButton4.setMargin(new Insets(2, 3, 2, 3));
        jButton4.setText(DbaNavigatorResources.getString("ADMIN_NONE_BUTTON"));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.gridx = 3;
        this.add((Component)jButton4, gridBagConstraints4);
        JScrollPane jScrollPane = new JScrollPane();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints5.weighty = 1.0;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.gridwidth = 5;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.gridx = 0;
        this.add((Component)jScrollPane, gridBagConstraints5);
        TableSorter tableSorter = new TableSorter((TableModel)this.myTableModel);
        this.table = new JTable((TableModel)tableSorter);
        this.table.setName("table");
        tableSorter.setTableHeader(this.table.getTableHeader());
        tableSorter.setSortingStatus(0, 1);
        TableColumn tableColumn = null;
        for (int i = 0; i < 3; ++i) {
            tableColumn = this.table.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(150);
                continue;
            }
            tableColumn.setPreferredWidth(15);
        }
        jScrollPane.setViewportView(this.table);
    }

    PrivTableTableModel getTableModel() {
        return this.myTableModel;
    }

    class PrivTableTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public static final int NAME_INDEX = 0;
        public static final int GRANTED_INDEX = 1;
        public static final int ADMIN_INDEX = 2;
        private final String[] COLUMN_NAMES = new String[]{DbaNavigatorResources.getString("PRIVILEGE_LABEL"), DbaNavigatorResources.getString("GRANTED_LABEL"), DbaNavigatorResources.getString("ADMIN_OPTION_LABEL")};
        protected List<PrivilegeObject> dataVector = new ArrayList<PrivilegeObject>();

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 1: 
                case 2: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        public PrivilegeObject getRowObject(int n) {
            PrivilegeObject privilegeObject = this.dataVector.get(n);
            return privilegeObject;
        }

        public List<PrivilegeObject> getData() {
            return this.dataVector;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PrivilegeObject privilegeObject = this.dataVector.get(n);
            switch (n2) {
                case 1: {
                    return privilegeObject.isGranted();
                }
                case 2: {
                    return privilegeObject.isAdmin();
                }
                case 0: {
                    return privilegeObject.getName();
                }
            }
            return new Object();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            PrivilegeObject privilegeObject = this.dataVector.get(n);
            switch (n2) {
                case 1: {
                    privilegeObject.setGranted((Boolean)object);
                    break;
                }
                case 2: {
                    privilegeObject.setAdmin((Boolean)object);
                    break;
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public int getRowCount() {
            return this.dataVector.size();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public void addRow(String string, Boolean bl, Boolean bl2) {
            this.dataVector.add(new PrivilegeObject(string, bl, bl2, false));
            this.fireTableRowsInserted(this.dataVector.size() - 1, this.dataVector.size() - 1);
        }
    }
}

