/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.redologgroups;

import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.FileSizeActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class CreateGroupAction
extends ActionDialog {
    private static final String GROUP_NO = "GroupNo";
    private static final String MEMBERS = "Members";
    private static final String FILE_SIZE = "FileSize";

    protected String getTitle() {
        return DbaNavigatorResources.getString("CREATE_GROUP_TITLE");
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        ResultSet resultSet;
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        ResultSetWrapper resultSetWrapper;
        if (DbaUtil.isPDB(connection)) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbaNavigatorResources.getString("NOT_SUPPORTED_FOR_PDB"), (String)DbaNavigatorResources.getString("ERROR_TITLE"), null);
            throw new RuntimeException("not supported for pluggable database");
        }
        Operation operation = this.getOperation();
        String string = this.getObjectName();
        HashSet<Long> hashSet = new HashSet<Long>();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper2 = null;
            try {
                HashMap hashMap = new HashMap();
                DBUtil dBUtil2 = DBUtil.getInstance((Connection)connection);
                dBUtil2.setRaiseError(true);
                resultSetWrapper2 = dBUtil2.executeOracleQuery(this.getQuery(connection, "getLogGroups"), hashMap);
                if (resultSetWrapper2 != null) {
                    ResultSet resultSet2 = resultSetWrapper2.getResultSet();
                    while (resultSet2.next()) {
                        long l = resultSet2.getLong("GROUP#");
                        hashSet.add(l);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper2 != null) {
                    resultSetWrapper2.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        long l = -1L;
        long l2 = 1L;
        while (l < 0L) {
            if (hashSet.contains(l2)) {
                ++l2;
                continue;
            }
            l = l2;
        }
        ArrayList<PathRow> arrayList = new ArrayList<PathRow>();
        long l3 = 100L;
        if (operation == Operation.CREATE_NEW) {
            arrayList.add(new PathRow(DbaNavigatorResources.getString("ENTER_VALUE_PROMPT") + '/', DbaNavigatorResources.getString("ENTER_VALUE_PROMPT")));
        } else if (Connections.getInstance().lock(connection)) {
            resultSetWrapper = null;
            try {
                textBoxActionControl = new HashMap();
                textBoxActionControl.put("GROUPNO", string.substring(1));
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                resultSetWrapper = dBUtil.executeOracleQuery(this.getQuery(connection, "getLogMembers"), (Map)textBoxActionControl);
                if (resultSetWrapper != null) {
                    resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        object = resultSet.getString("MEMBER");
                        int n = ((String)object).lastIndexOf(47);
                        if (n < 0) {
                            n = ((String)object).lastIndexOf(92);
                        }
                        n = n < 0 ? 0 : ++n;
                        String string2 = ((String)object).substring(0, n);
                        arrayList.add(new PathRow(string2, DbaNavigatorResources.getString("ENTER_VALUE_PROMPT")));
                        l3 = resultSet.getLong("NUM_BLOCKS");
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        resultSetWrapper = new ArrayList();
        resultSetWrapper.add(DbaNavigatorResources.getString("DIRECTORY_LABEL"));
        resultSetWrapper.add(DbaNavigatorResources.getString("FILE_NAME_LABEL"));
        textBoxActionControl = new TextBoxActionControl(GROUP_NO, DbaNavigatorResources.getString("GROUP_LABEL"), Long.toString(l), TextBoxActionControl.getIntegerFormat());
        dBUtil = new TableActionControl(MEMBERS, DbaNavigatorResources.getString("MEMBERS_LABEL"), (TableActionControl.RowFactory)new PathRowFactory(), (List)resultSetWrapper, arrayList, 3);
        resultSet = new FileSizeActionControl(FILE_SIZE, DbaNavigatorResources.getString("FILE_SIZE_LABEL"), l3 * 1024L);
        object = new ArrayList();
        ((ArrayList)object).add(textBoxActionControl);
        ((ArrayList)object).add(dBUtil);
        ((ArrayList)object).add(resultSet);
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER DATABASE\nADD LOGFILE GROUP " + values.get(GROUP_NO));
        stringBuffer.append(" (");
        List list = values.getList(MEMBERS, DbaNavigatorResources.getString("DIRECTORY_LABEL"));
        List list2 = values.getList(MEMBERS, DbaNavigatorResources.getString("FILE_NAME_LABEL"));
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                stringBuffer.append('\'');
            } else {
                stringBuffer.append(", '");
            }
            stringBuffer.append((String)list.get(i));
            stringBuffer.append((String)list2.get(i));
            stringBuffer.append('\'');
        }
        stringBuffer.append(")\nSIZE ");
        stringBuffer.append(values.get(FILE_SIZE, "SizeClause"));
        return stringBuffer.toString();
    }

    private class PathRow
    implements TableActionControl.Row {
        private String[] _cols;

        PathRow(String string, String string2) {
            this._cols = new String[]{string, string2};
        }

        String[] getCols() {
            return this._cols;
        }

        public String getValue(int n) {
            return this._cols[n];
        }

        public boolean isValueEditable(int n) {
            return true;
        }

        public void setValue(int n, String string) {
            this._cols[n] = string;
        }
    }

    private class PathRowFactory
    implements TableActionControl.RowFactory {
        private PathRowFactory() {
        }

        public TableActionControl.Row createRow(int n, TableActionControl.Row row) {
            PathRow pathRow = null;
            pathRow = row != null ? new PathRow(row.getValue(0), DbaNavigatorResources.getString("ENTER_VALUE_PROMPT")) : new PathRow(DbaNavigatorResources.getString("ENTER_VALUE_PROMPT"), DbaNavigatorResources.getString("ENTER_VALUE_PROMPT"));
            return pathRow;
        }
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE;

    }
}

