/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.recovery;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.recovery.RecoverControlGroup;
import oracle.dbtools.raptor.dba.navigator.actions.recovery.RecoveryScriptGenerator;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.SelectionActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class RecoverTablespacesAction
extends ActionDialog {
    public static final String TABLESPACES = "TABLESPACES";
    private List<RecoveryScriptGenerator.TargetTablespaceData> targetTablespacesData;

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor();
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("RECOVER_TABLESPACES_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        Object object2;
        SelectionActionControl selectionActionControl;
        this.targetTablespacesData = new ArrayList<RecoveryScriptGenerator.TargetTablespaceData>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (Connections.getInstance().lock(connection)) {
            selectionActionControl = null;
            try {
                object2 = new HashMap();
                object = DBUtil.getInstance((Connection)connection);
                object.setRaiseError(true);
                selectionActionControl = object.executeOracleQuery(this.getQuery(connection, "getTablespacesInfo"), object2);
                if (selectionActionControl != null) {
                    HashMap<Object, ArrayList<String>> hashMap = new HashMap<Object, ArrayList<String>>();
                    ResultSet resultSet = selectionActionControl.getResultSet();
                    while (resultSet.next()) {
                        String string = resultSet.getString("NAME");
                        String string2 = resultSet.getString("DATAFILE");
                        ArrayList<String> arrayList2 = (ArrayList<String>)hashMap.get(string);
                        if (arrayList2 == null) {
                            arrayList.add(string);
                            arrayList2 = new ArrayList<String>();
                            hashMap.put(string, arrayList2);
                        }
                        arrayList2.add(string2);
                    }
                    for (String string : arrayList) {
                        this.targetTablespacesData.add(new RecoveryScriptGenerator.TargetTablespaceData(string, (List)hashMap.get(string)));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (selectionActionControl != null) {
                    selectionActionControl.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        selectionActionControl = new SelectionActionControl(TABLESPACES, DbaNavigatorResources.getString("TABLESPACES_LABEL"), new ArrayList(), arrayList);
        object2 = new RecoverControlGroup(connection);
        object = new ArrayList();
        ((ArrayList)object).add(selectionActionControl);
        ((ArrayList)object).add(object2);
        ((ArrayList)object).add(new SeperatorActionControl());
        ((ArrayList)object).add(new RMANScriptProcessorActionControl(connection, "sqldev.rman", DbaUtil.isArchiveLogMode(connection)));
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        HashSet hashSet = new HashSet(values.getList(TABLESPACES, "SELECTED_ITEMS"));
        ArrayList<RecoveryScriptGenerator.TargetTablespaceData> arrayList = new ArrayList<RecoveryScriptGenerator.TargetTablespaceData>();
        for (RecoveryScriptGenerator.TargetTablespaceData targetTablespaceData : this.targetTablespacesData) {
            if (!hashSet.contains(targetTablespaceData.tablespace)) continue;
            arrayList.add(targetTablespaceData);
        }
        RecoveryScriptGenerator recoveryScriptGenerator = new RecoveryScriptGenerator(this, (ActionDialog.Lookup)values, null, null, arrayList);
        return recoveryScriptGenerator.generateScript();
    }
}

