/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.profiles;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class CreateEditProfileAction
extends ActionDialog {
    private static final String PROFILE_NAME = "ProfileName";
    private static final String CPU_PER_SESSION = "CPUPerSession";
    private static final String CPU_PER_CALL = "CPUPerCall";
    private static final String CONNECT_TIME = "ConnectTime";
    private static final String IDLE_TIME = "IdleTime";
    private static final String CONCURRENT_SESSIONS = "ConcurrentSessions";
    private static final String READS_PER_SESSION = "ReadsPerSession";
    private static final String READS_PER_CALL = "ReadsPerCall";
    private static final String PRIVATE_SGA = "PrivateSGA";
    private static final String COMPOSITE_LIMIT = "CompositeLimit";
    private static final String EXPIRE_IN_DAYS = "ExpireIn";
    private static final String LOCK_DAYS_PAST_EXPIRATION = "LockPastExpiration";
    private static final String NUM_PASSWORDS_TO_KEEP = "NumberPasswords";
    private static final String NUM_DAYS_KEPT = "NumberKeepDays";
    private static final String COMPLEXITY_FUNCTION = "ComplexityFunction";
    private static final String NUM_FAILED_LOGINS = "NumFailedLogins";
    private static final String NUM_DAYS_LOCK_FOR = "NumLockDays";
    private ActionControl profileNameCtl;
    private ProfileItemControl cpuPerSessionCtl;
    private ProfileItemControl cpuPerCallCtl;
    private ProfileItemControl connectTimeCtl;
    private ProfileItemControl idleTimeCtl;
    private ProfileItemControl concurrentSessionsCtl;
    private ProfileItemControl readsPerSessionCtl;
    private ProfileItemControl readsPerCallCtl;
    private ProfileItemControl privateSgaCtl;
    private ProfileItemControl compositeLimitCtl;
    private ProfileItemControl expireInDaysCtl;
    private ProfileItemControl lockDaysPastExpirationCtl;
    private ProfileItemControl numPasswordsToKeepCtl;
    private ProfileItemControl numDaysKeptCtl;
    private ProfileItemControl complexityFunctionCtl;
    private ProfileItemControl numFailedLoginsCtl;
    private ProfileItemControl numDaysLockForCtl;

    protected String getTitle() {
        String string = null;
        Operation operation = this.getOperation();
        string = operation == Operation.EDIT ? DbaNavigatorResources.getString("EDIT_PROFILE_TITLE") : DbaNavigatorResources.getString("CREATE_PROFILE_TITLE");
        return string;
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        Operation operation = this.getOperation();
        String string = operation != Operation.EDIT ? DbaNavigatorResources.getString("ENTER_VALUE_PROMPT") : this.getObjectName();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        String string15 = null;
        String string16 = null;
        String string17 = null;
        if (operation != Operation.CREATE_NEW && Connections.getInstance().lock(connection)) {
            object = null;
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("NAME", this.getObjectName());
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object = dBUtil.executeOracleQuery(this.getQuery(connection, "getProfile"), hashMap);
                if (object != null) {
                    ResultSet resultSet = object.getResultSet();
                    while (resultSet.next()) {
                        Resource resource = Resource.valueOf(resultSet.getString(1));
                        String string18 = resultSet.getString(2);
                        switch (resource) {
                            case CPU_PER_SESSION: {
                                string2 = string18;
                                break;
                            }
                            case CPU_PER_CALL: {
                                string3 = string18;
                                break;
                            }
                            case CONNECT_TIME: {
                                string4 = string18;
                                break;
                            }
                            case IDLE_TIME: {
                                string5 = string18;
                                break;
                            }
                            case SESSIONS_PER_USER: {
                                string6 = string18;
                                break;
                            }
                            case LOGICAL_READS_PER_SESSION: {
                                string7 = string18;
                                break;
                            }
                            case LOGICAL_READS_PER_CALL: {
                                string8 = string18;
                                break;
                            }
                            case PRIVATE_SGA: {
                                string9 = string18;
                                break;
                            }
                            case COMPOSITE_LIMIT: {
                                string10 = string18;
                                break;
                            }
                            case PASSWORD_LIFE_TIME: {
                                string11 = string18;
                                break;
                            }
                            case PASSWORD_GRACE_TIME: {
                                string12 = string18;
                                break;
                            }
                            case PASSWORD_REUSE_MAX: {
                                string13 = string18;
                                break;
                            }
                            case PASSWORD_REUSE_TIME: {
                                string14 = string18;
                                break;
                            }
                            case PASSWORD_LOCK_TIME: {
                                string17 = string18;
                                break;
                            }
                            case FAILED_LOGIN_ATTEMPTS: {
                                string16 = string18;
                                break;
                            }
                            case PASSWORD_VERIFY_FUNCTION: {
                                string15 = string18;
                            }
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (object != null) {
                    object.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        this.profileNameCtl = new TextBoxActionControl(PROFILE_NAME, DbaNavigatorResources.getString("PROFILE_NAME_LABEL"), string);
        this.cpuPerSessionCtl = new ProfileItemControl(CPU_PER_SESSION, DbaNavigatorResources.getString("CPU_PER_SESSION"), new String[]{"DEFAULT", "UNLIMITED"}, string2);
        this.cpuPerCallCtl = new ProfileItemControl(CPU_PER_CALL, DbaNavigatorResources.getString("CPU_PER_CALL"), new String[]{"DEFAULT", "UNLIMITED"}, string3);
        this.connectTimeCtl = new ProfileItemControl(CONNECT_TIME, DbaNavigatorResources.getString("CONNECT_TIME"), new String[]{"DEFAULT", "UNLIMITED"}, string4);
        this.idleTimeCtl = new ProfileItemControl(IDLE_TIME, DbaNavigatorResources.getString("IDLE_TIME"), new String[]{"DEFAULT", "UNLIMITED"}, string5);
        this.concurrentSessionsCtl = new ProfileItemControl(CONCURRENT_SESSIONS, DbaNavigatorResources.getString("CONCURRENT_SESSIONS"), new String[]{"DEFAULT", "UNLIMITED"}, string6);
        this.readsPerSessionCtl = new ProfileItemControl(READS_PER_SESSION, DbaNavigatorResources.getString("READS_PER_SESSION"), new String[]{"DEFAULT", "UNLIMITED"}, string7);
        this.readsPerCallCtl = new ProfileItemControl(READS_PER_CALL, DbaNavigatorResources.getString("READS_PER_CALL"), new String[]{"DEFAULT", "UNLIMITED"}, string8);
        this.privateSgaCtl = new ProfileItemControl(PRIVATE_SGA, DbaNavigatorResources.getString("PRIVATE_SGA"), new String[]{"DEFAULT", "UNLIMITED"}, string9);
        this.compositeLimitCtl = new ProfileItemControl(COMPOSITE_LIMIT, DbaNavigatorResources.getString("COMPOSITE_LIMIT"), new String[]{"DEFAULT", "UNLIMITED"}, string10);
        this.expireInDaysCtl = new ProfileItemControl(EXPIRE_IN_DAYS, DbaNavigatorResources.getString("EXPIRE_IN_DAYS"), new String[]{"DEFAULT", "UNLIMITED"}, string11);
        this.lockDaysPastExpirationCtl = new ProfileItemControl(LOCK_DAYS_PAST_EXPIRATION, DbaNavigatorResources.getString("LOCK_DAYS_PAST_EXPIRATION"), new String[]{"DEFAULT", "UNLIMITED"}, string12);
        this.numPasswordsToKeepCtl = new ProfileItemControl(NUM_PASSWORDS_TO_KEEP, DbaNavigatorResources.getString("NUM_PASSWORDS_TO_KEEP"), new String[]{"DEFAULT", "UNLIMITED"}, string13);
        this.numDaysKeptCtl = new ProfileItemControl(NUM_DAYS_KEPT, DbaNavigatorResources.getString("NUM_DAYS_KEPT"), new String[]{"DEFAULT", "UNLIMITED"}, string14);
        this.complexityFunctionCtl = new ProfileItemControl(COMPLEXITY_FUNCTION, DbaNavigatorResources.getString("COMPLEXITY_FUNCTION"), new String[]{"DEFAULT", "UNLIMITED"}, string15);
        this.numFailedLoginsCtl = new ProfileItemControl(NUM_FAILED_LOGINS, DbaNavigatorResources.getString("NUM_FAILED_LOGINS"), new String[]{"DEFAULT", "UNLIMITED"}, string16);
        this.numDaysLockForCtl = new ProfileItemControl(NUM_DAYS_LOCK_FOR, DbaNavigatorResources.getString("NUM_DAYS_LOCK_FOR"), new String[]{"DEFAULT", "UNLIMITED"}, string17);
        if (operation == Operation.EDIT) {
            this.profileNameCtl.enableUI(false);
        }
        object = new ArrayList();
        ((ArrayList)object).add(this.profileNameCtl);
        ((ArrayList)object).add(this.cpuPerSessionCtl);
        ((ArrayList)object).add(this.cpuPerCallCtl);
        ((ArrayList)object).add(this.connectTimeCtl);
        ((ArrayList)object).add(this.idleTimeCtl);
        ((ArrayList)object).add(this.concurrentSessionsCtl);
        ((ArrayList)object).add(this.readsPerSessionCtl);
        ((ArrayList)object).add(this.readsPerCallCtl);
        ((ArrayList)object).add(this.privateSgaCtl);
        ((ArrayList)object).add(this.compositeLimitCtl);
        ((ArrayList)object).add(this.expireInDaysCtl);
        ((ArrayList)object).add(this.lockDaysPastExpirationCtl);
        ((ArrayList)object).add(this.numPasswordsToKeepCtl);
        ((ArrayList)object).add(this.numDaysKeptCtl);
        ((ArrayList)object).add(this.complexityFunctionCtl);
        ((ArrayList)object).add(this.numFailedLoginsCtl);
        ((ArrayList)object).add(this.numDaysLockForCtl);
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getOperation() != Operation.EDIT) {
            stringBuffer.append("CREATE PROFILE \"");
            stringBuffer.append(values.get(PROFILE_NAME));
            stringBuffer.append("\" LIMIT");
            stringBuffer.append("\nCPU_PER_SESSION ");
            stringBuffer.append(values.get(CPU_PER_SESSION));
            stringBuffer.append("\nCPU_PER_CALL ");
            stringBuffer.append(values.get(CPU_PER_CALL));
            stringBuffer.append("\nCONNECT_TIME ");
            stringBuffer.append(values.get(CONNECT_TIME));
            stringBuffer.append("\nIDLE_TIME ");
            stringBuffer.append(values.get(IDLE_TIME));
            stringBuffer.append("\nSESSIONS_PER_USER ");
            stringBuffer.append(values.get(CONCURRENT_SESSIONS));
            stringBuffer.append("\nLOGICAL_READS_PER_SESSION ");
            stringBuffer.append(values.get(READS_PER_SESSION));
            stringBuffer.append("\nLOGICAL_READS_PER_CALL ");
            stringBuffer.append(values.get(READS_PER_CALL));
            stringBuffer.append("\nPRIVATE_SGA ");
            stringBuffer.append(values.get(PRIVATE_SGA));
            stringBuffer.append("\nCOMPOSITE_LIMIT ");
            stringBuffer.append(values.get(COMPOSITE_LIMIT));
            stringBuffer.append("\nPASSWORD_LIFE_TIME ");
            stringBuffer.append(values.get(EXPIRE_IN_DAYS));
            stringBuffer.append("\nPASSWORD_GRACE_TIME ");
            stringBuffer.append(values.get(LOCK_DAYS_PAST_EXPIRATION));
            stringBuffer.append("\nPASSWORD_REUSE_MAX ");
            stringBuffer.append(values.get(NUM_PASSWORDS_TO_KEEP));
            stringBuffer.append("\nPASSWORD_REUSE_TIME ");
            stringBuffer.append(values.get(NUM_DAYS_KEPT));
            stringBuffer.append("\nPASSWORD_VERIFY_FUNCTION ");
            stringBuffer.append(values.get(COMPLEXITY_FUNCTION));
            stringBuffer.append("\nFAILED_LOGIN_ATTEMPTS ");
            stringBuffer.append(values.get(NUM_FAILED_LOGINS));
            stringBuffer.append("\nPASSWORD_LOCK_TIME ");
            stringBuffer.append(values.get(NUM_DAYS_LOCK_FOR));
        } else {
            stringBuffer.append("ALTER PROFILE \"");
            stringBuffer.append(values.get(PROFILE_NAME));
            stringBuffer.append("\" LIMIT");
            if (this.cpuPerSessionCtl.hasChanged()) {
                stringBuffer.append("\nCPU_PER_SESSION ");
                stringBuffer.append(values.get(CPU_PER_SESSION));
            }
            if (this.cpuPerCallCtl.hasChanged()) {
                stringBuffer.append("\nCPU_PER_CALL ");
                stringBuffer.append(values.get(CPU_PER_CALL));
            }
            if (this.connectTimeCtl.hasChanged()) {
                stringBuffer.append("\nCONNECT_TIME ");
                stringBuffer.append(values.get(CONNECT_TIME));
            }
            if (this.idleTimeCtl.hasChanged()) {
                stringBuffer.append("\nIDLE_TIME ");
                stringBuffer.append(values.get(IDLE_TIME));
            }
            if (this.concurrentSessionsCtl.hasChanged()) {
                stringBuffer.append("\nSESSIONS_PER_USER ");
                stringBuffer.append(values.get(CONCURRENT_SESSIONS));
            }
            if (this.readsPerSessionCtl.hasChanged()) {
                stringBuffer.append("\nLOGICAL_READS_PER_SESSION ");
                stringBuffer.append(values.get(READS_PER_SESSION));
            }
            if (this.readsPerCallCtl.hasChanged()) {
                stringBuffer.append("\nLOGICAL_READS_PER_CALL ");
                stringBuffer.append(values.get(READS_PER_CALL));
            }
            if (this.privateSgaCtl.hasChanged()) {
                stringBuffer.append("\nPRIVATE_SGA ");
                stringBuffer.append(values.get(PRIVATE_SGA));
            }
            if (this.compositeLimitCtl.hasChanged()) {
                stringBuffer.append("\nCOMPOSITE_LIMIT ");
                stringBuffer.append(values.get(COMPOSITE_LIMIT));
            }
            if (this.expireInDaysCtl.hasChanged()) {
                stringBuffer.append("\nPASSWORD_LIFE_TIME ");
                stringBuffer.append(values.get(EXPIRE_IN_DAYS));
            }
            if (this.lockDaysPastExpirationCtl.hasChanged()) {
                stringBuffer.append("\nPASSWORD_GRACE_TIME ");
                stringBuffer.append(values.get(LOCK_DAYS_PAST_EXPIRATION));
            }
            if (this.numPasswordsToKeepCtl.hasChanged()) {
                stringBuffer.append("\nPASSWORD_REUSE_MAX ");
                stringBuffer.append(values.get(NUM_PASSWORDS_TO_KEEP));
            }
            if (this.numDaysKeptCtl.hasChanged()) {
                stringBuffer.append("\nPASSWORD_REUSE_TIME ");
                stringBuffer.append(values.get(NUM_DAYS_KEPT));
            }
            if (this.complexityFunctionCtl.hasChanged()) {
                stringBuffer.append("\nPASSWORD_VERIFY_FUNCTION ");
                stringBuffer.append(values.get(COMPLEXITY_FUNCTION));
            }
            if (this.numFailedLoginsCtl.hasChanged()) {
                stringBuffer.append("\nFAILED_LOGIN_ATTEMPTS ");
                stringBuffer.append(values.get(NUM_FAILED_LOGINS));
            }
            if (this.numDaysLockForCtl.hasChanged()) {
                stringBuffer.append("\nPASSWORD_LOCK_TIME ");
                stringBuffer.append(values.get(NUM_DAYS_LOCK_FOR));
            }
        }
        return stringBuffer.toString();
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        EDIT;

    }

    private static enum Resource {
        CPU_PER_SESSION,
        CPU_PER_CALL,
        CONNECT_TIME,
        IDLE_TIME,
        SESSIONS_PER_USER,
        LOGICAL_READS_PER_SESSION,
        LOGICAL_READS_PER_CALL,
        PRIVATE_SGA,
        COMPOSITE_LIMIT,
        PASSWORD_LIFE_TIME,
        PASSWORD_GRACE_TIME,
        PASSWORD_REUSE_MAX,
        PASSWORD_REUSE_TIME,
        PASSWORD_LOCK_TIME,
        FAILED_LOGIN_ATTEMPTS,
        PASSWORD_VERIFY_FUNCTION;

    }

    private static class ProfileItemControl
    extends ComboBoxActionControl {
        private String _initialValue;

        ProfileItemControl(String string, String string2, String[] stringArray, String string3) {
            super(string, string2, ProfileItemControl.getSelections(stringArray, string3), ProfileItemControl.getDefault(stringArray, string3));
            this.enableEditBox();
            this._initialValue = string3;
        }

        boolean hasChanged() {
            return !this.getValue().get().equals(this._initialValue);
        }

        private static String[] getSelections(String[] stringArray, String string) {
            String[] stringArray2 = stringArray;
            if (string != null) {
                boolean bl = false;
                for (String string2 : stringArray) {
                    if (!string2.equals(string)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    stringArray2 = new String[stringArray.length + 1];
                    stringArray2[0] = string;
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray2[i + 1] = stringArray[i];
                    }
                }
            }
            return stringArray2;
        }

        private static String getDefault(String[] stringArray, String string) {
            return string != null ? string : stringArray[0];
        }
    }
}

