/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionValuesLookup;
import oracle.dbtools.raptor.ui.controls.CardLayoutActionControl;
import oracle.dbtools.raptor.ui.controls.LabelActionControl;
import oracle.dbtools.raptor.ui.controls.PropertyPanelActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControl;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.raptor.utils.Connections;

public class FileNameConvertControl
extends CardLayoutActionControl {
    private static final String FILE_NAMES = "FileNames";
    private static final String FILE_EXPRESSIONS = "FileExpressions";
    private static final String SOURCE_FILE_NAMES = DbaNavigatorResources.getString("SOURCE_FILE_NAMES");
    private static final String TARGET_FILE_NAMES = DbaNavigatorResources.getString("TARGET_FILE_NAMES");
    private static final String SOURCE_FILE_EXPRESSIONS = DbaNavigatorResources.getString("SOURCE_FILE_EXPRESSIONS");
    private static final String TARGET_FILE_EXPRESSIONS = DbaNavigatorResources.getString("TARGET_FILE_EXPRESSIONS");

    public FileNameConvertControl(String string, String string2, Connection connection, boolean bl) {
        super(string, string2, CardLayoutPanel.Type.TITLE_BORDER, FileNameConvertControl.createControlMap(connection, bl));
    }

    public static String getFileNameConvertClause(String string, ActionValuesLookup actionValuesLookup, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        List list = null;
        List list2 = null;
        String string2 = actionValuesLookup.get(string);
        if (string2.equals(FileNameConvertTypes.NAME_LIST.toString())) {
            list = actionValuesLookup.getList(string, "FileNames/" + SOURCE_FILE_NAMES);
            list2 = actionValuesLookup.getList(string, "FileNames/" + TARGET_FILE_NAMES);
        } else if (string2.equals(FileNameConvertTypes.EXPRESSION_LIST.toString())) {
            list = actionValuesLookup.getList(string, "FileExpressions/" + SOURCE_FILE_EXPRESSIONS);
            list2 = actionValuesLookup.getList(string, "FileExpressions/" + TARGET_FILE_EXPRESSIONS);
        }
        if (bl) {
            stringBuffer.append(" SOURCE_FILE_NAME_CONVERT=");
        } else {
            stringBuffer.append(" FILE_NAME_CONVERT=");
        }
        if (list != null && list2 != null) {
            stringBuffer.append("(\n");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(",\n");
                }
                stringBuffer.append("  '");
                stringBuffer.append((String)list.get(i));
                stringBuffer.append("', '");
                stringBuffer.append((String)list2.get(i));
                stringBuffer.append("'");
            }
            stringBuffer.append("\n  )");
        } else {
            stringBuffer.append("NONE");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<?, ActionControl> createControlMap(Connection connection, boolean bl) {
        Object object;
        Object object2;
        ResultSetWrapper resultSetWrapper;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Connections.getInstance().lock(connection)) {
            resultSetWrapper = null;
            try {
                object2 = DBUtil.getInstance((Connection)connection);
                object2.setRaiseError(true);
                resultSetWrapper = object2.executeOracleQuery(Utils.getQuery(FileNameConvertControl.class, (Connection)connection, (String)"getSeedFiles"), null);
                if (resultSetWrapper != null) {
                    object = resultSetWrapper.getResultSet();
                    while (object.next()) {
                        arrayList.add(object.getString(1));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(FileNameConvertControl.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        resultSetWrapper = new EnumMap(FileNameConvertTypes.class);
        if (bl) {
            object2 = new ArrayList();
            ((ArrayList)object2).add(new LabelActionControl(null, DbaNavigatorResources.getString("FILE_NAME_CONVERT_NONE_DESC")));
            object = new PropertyPanelActionControl((List)object2);
            resultSetWrapper.put(FileNameConvertTypes.NONE, object);
        }
        object2 = new ArrayList();
        ((ArrayList)object2).add(FileNameConvertControl.createFileNameConvertNameListTable(arrayList));
        object = new PropertyPanelActionControl((List)object2);
        resultSetWrapper.put(FileNameConvertTypes.NAME_LIST, object);
        ArrayList<TableActionControl> arrayList2 = new ArrayList<TableActionControl>();
        arrayList2.add(FileNameConvertControl.createFileNameConvertExpressionListTable());
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl(arrayList2);
        resultSetWrapper.put(FileNameConvertTypes.EXPRESSION_LIST, propertyPanelActionControl);
        return resultSetWrapper;
    }

    private static TableActionControl createFileNameConvertNameListTable(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(SOURCE_FILE_NAMES);
        arrayList.add(TARGET_FILE_NAMES);
        ArrayList<1> arrayList2 = new ArrayList<1>();
        for (String string : list) {
            arrayList2.add(new FileRow(string, string + ".clone"){

                public boolean isValueEditable(int n) {
                    return n == 1;
                }
            });
        }
        return new TableActionControl(FILE_NAMES, null, arrayList, arrayList2, 4);
    }

    private static TableActionControl createFileNameConvertExpressionListTable() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(SOURCE_FILE_EXPRESSIONS);
        arrayList.add(TARGET_FILE_EXPRESSIONS);
        ArrayList arrayList2 = new ArrayList();
        return new TableActionControl(FILE_EXPRESSIONS, null, (TableActionControl.RowFactory)new FileRowFactory(), arrayList, arrayList2, 4);
    }

    private static class FileRowFactory
    implements TableActionControl.RowFactory {
        private FileRowFactory() {
        }

        public TableActionControl.Row createRow(int n, TableActionControl.Row row) {
            return new FileRow(DbaNavigatorResources.getString("ENTER_VALUE_PROMPT"), DbaNavigatorResources.getString("ENTER_VALUE_PROMPT")){

                public boolean isValueEditable(int n) {
                    return true;
                }
            };
        }
    }

    private static abstract class FileRow
    implements TableActionControl.Row {
        private String[] _cols = new String[2];

        FileRow(String string, String string2) {
            this._cols[0] = string;
            this._cols[1] = string2;
        }

        String[] getCols() {
            return this._cols;
        }

        public String getValue(int n) {
            return this._cols[n];
        }

        public void setValue(int n, String string) {
            this._cols[n] = string;
        }
    }

    private static enum FileNameConvertTypes {
        NONE(DbaNavigatorResources.getString("FILE_NAME_CONVERT_NONE")),
        NAME_LIST(DbaNavigatorResources.getString("FILE_NAME_CONVERT_NAME_LIST")),
        EXPRESSION_LIST(DbaNavigatorResources.getString("FILE_NAME_CONVERT_EXPRESSION_LIST"));

        private String _display;

        private FileNameConvertTypes(String string2) {
            this._display = string2;
        }

        public String toString() {
            return this._display;
        }
    }
}

