/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.containerrmplans;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class CreateEditAction
extends ActionDialog {
    private static final String PLAN_NAME = "PlanName";
    private static final String DESCRIPTION = "Description";
    private static final String COPY_DIRECTIVES = "CopyDirectives";
    private ArrayList<Directive> directives;

    protected String getTitle() {
        String string = null;
        Operation operation = this.getOperation();
        string = operation == Operation.EDIT ? DbaNavigatorResources.getString("EDIT_PLAN_TITLE") : DbaNavigatorResources.getString("CREATE_PLAN_TITLE");
        return string;
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        TextBoxActionControl textBoxActionControl2;
        Operation operation = this.getOperation();
        String string = this.getObjectName();
        String string2 = DbaNavigatorResources.getString("ENTER_VALUE_PROMPT");
        String string3 = "";
        if (operation != Operation.CREATE_NEW && Connections.getInstance().lock(connection)) {
            textBoxActionControl2 = null;
            try {
                textBoxActionControl = new HashMap();
                textBoxActionControl.put("PLANNAME", string);
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                textBoxActionControl2 = dBUtil.executeOracleQuery(this.getQuery(connection, "getPlan"), (Map)textBoxActionControl);
                if (textBoxActionControl2 != null) {
                    object = textBoxActionControl2.getResultSet();
                    while (object.next()) {
                        string3 = object.getString("COMMENTS");
                        if (operation != Operation.EDIT) continue;
                        string2 = string;
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (textBoxActionControl2 != null) {
                    textBoxActionControl2.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        textBoxActionControl2 = new TextBoxActionControl(PLAN_NAME, DbaNavigatorResources.getString("PLAN_NAME_LABEL"), string2);
        textBoxActionControl = new TextBoxActionControl(DESCRIPTION, DbaNavigatorResources.getString("DESCRIPTION_LABEL"), string3);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = dBUtil = operation == Operation.CREATE_LIKE ? new BooleanCheckBoxActionControl(COPY_DIRECTIVES, DbaNavigatorResources.getString("COPY_DIRECTIVES_LABEL"), true) : null;
        if (operation == Operation.EDIT) {
            textBoxActionControl2.setEditable(false);
        }
        object = new ArrayList<TextBoxActionControl>();
        ((ArrayList)object).add(textBoxActionControl2);
        ((ArrayList)object).add(textBoxActionControl);
        if (dBUtil != null) {
            ((ArrayList)object).add(dBUtil);
            this.loadDirectives(connection);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDirectives(Connection connection) {
        this.directives = new ArrayList();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("PLAN", this.getObjectName());
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                resultSetWrapper = dBUtil.executeOracleQuery(this.getQuery(connection, "getDirectives"), hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        Directive directive = new Directive();
                        directive.pdbName = resultSet.getString("PLUGGABLE_DATABASE");
                        directive.type = directive.pdbName.equals("ORA$DEFAULT_PDB_DIRECTIVE") ? DirectiveType.DEFAULT : (directive.pdbName.equals("ORA$AUTOTASK") ? DirectiveType.AUTOTASK : DirectiveType.NORMAL);
                        directive.shares = this.getDirective(resultSet, "SHARES");
                        directive.utilizationLimit = this.getDirective(resultSet, "UTILIZATION_LIMIT");
                        directive.parallelServerLimit = this.getDirective(resultSet, "PARALLEL_SERVER_LIMIT");
                        this.directives.add(directive);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    private Integer getDirective(ResultSet resultSet, String string) throws SQLException {
        Integer n = null;
        try {
            n = Integer.parseInt(resultSet.getString(string));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    protected boolean allowApplyScript() {
        String string = this.getValues().get(PLAN_NAME);
        String string2 = " \n\r\f\t";
        boolean bl = false;
        for (int i = 0; i < string2.length(); ++i) {
            if (string.indexOf(string2.charAt(i)) < 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.showErrorDialog(DbaNavigatorResources.getString("PLAN_NAME_CONTAINS_SPACE_ERROR"));
            return false;
        }
        return true;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BEGIN\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.CLEAR_PENDING_AREA();\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.CREATE_PENDING_AREA();\n");
        if (this.getOperation() != Operation.EDIT) {
            stringBuffer.append("    DBMS_RESOURCE_MANAGER.CREATE_CDB_PLAN(\n");
            stringBuffer.append("        PLAN => '");
            stringBuffer.append(values.get(PLAN_NAME));
            stringBuffer.append("',\n");
            stringBuffer.append("        COMMENT => '");
            stringBuffer.append(values.get(DESCRIPTION));
            stringBuffer.append("');\n");
        } else {
            stringBuffer.append("    DBMS_RESOURCE_MANAGER.UPDATE_CDB_PLAN(\n");
            stringBuffer.append("        PLAN => '");
            stringBuffer.append(values.get(PLAN_NAME));
            stringBuffer.append("',\n");
            stringBuffer.append("        NEW_COMMENT => '");
            stringBuffer.append(values.get(DESCRIPTION));
            stringBuffer.append("');\n");
        }
        if (this.getOperation() == Operation.CREATE_LIKE) {
            boolean bl = Boolean.parseBoolean(values.get(COPY_DIRECTIVES));
            block4: for (Directive directive : this.directives) {
                switch (directive.type) {
                    case DEFAULT: {
                        stringBuffer.append("    DBMS_RESOURCE_MANAGER.UPDATE_CDB_DEFAULT_DIRECTIVE(\n");
                        stringBuffer.append("        PLAN => '");
                        stringBuffer.append(values.get(PLAN_NAME));
                        stringBuffer.append("',\n");
                        stringBuffer.append("        NEW_SHARES => ");
                        stringBuffer.append(directive.shares);
                        stringBuffer.append(",\n");
                        stringBuffer.append("        NEW_UTILIZATION_LIMIT => ");
                        stringBuffer.append(directive.utilizationLimit);
                        stringBuffer.append(",\n");
                        stringBuffer.append("        NEW_PARALLEL_SERVER_LIMIT => ");
                        stringBuffer.append(directive.parallelServerLimit);
                        stringBuffer.append(");\n");
                        continue block4;
                    }
                    case AUTOTASK: {
                        stringBuffer.append("    DBMS_RESOURCE_MANAGER.UPDATE_CDB_AUTOTASK_DIRECTIVE(\n");
                        stringBuffer.append("        PLAN => '");
                        stringBuffer.append(values.get(PLAN_NAME));
                        stringBuffer.append("',\n");
                        stringBuffer.append("        NEW_SHARES => ");
                        stringBuffer.append(directive.shares);
                        stringBuffer.append(",\n");
                        stringBuffer.append("        NEW_UTILIZATION_LIMIT => ");
                        stringBuffer.append(directive.utilizationLimit);
                        stringBuffer.append(",\n");
                        stringBuffer.append("        NEW_PARALLEL_SERVER_LIMIT => ");
                        stringBuffer.append(directive.parallelServerLimit);
                        stringBuffer.append(");\n");
                        continue block4;
                    }
                }
                if (!bl) continue;
                stringBuffer.append("    DBMS_RESOURCE_MANAGER.CREATE_CDB_PLAN_DIRECTIVE(\n");
                stringBuffer.append("        PLAN => '");
                stringBuffer.append(values.get(PLAN_NAME));
                stringBuffer.append("',\n");
                stringBuffer.append("        PLUGGABLE_DATABASE => '");
                stringBuffer.append(directive.pdbName);
                stringBuffer.append("',\n");
                stringBuffer.append("        COMMENT => ''");
                stringBuffer.append(",\n");
                stringBuffer.append("        SHARES => ");
                stringBuffer.append(directive.shares);
                stringBuffer.append(",\n");
                stringBuffer.append("        UTILIZATION_LIMIT => ");
                stringBuffer.append(directive.utilizationLimit);
                stringBuffer.append(",\n");
                stringBuffer.append("        PARALLEL_SERVER_LIMIT => ");
                stringBuffer.append(directive.parallelServerLimit);
                stringBuffer.append(");\n");
            }
        }
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.VALIDATE_PENDING_AREA();\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.SUBMIT_PENDING_AREA();\n");
        stringBuffer.append("END;\n");
        return stringBuffer.toString();
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        EDIT;

    }

    private class Directive {
        String pdbName;
        DirectiveType type;
        int shares;
        int utilizationLimit;
        int parallelServerLimit;

        private Directive() {
        }
    }

    private static enum DirectiveType {
        NORMAL,
        DEFAULT,
        AUTOTASK;

    }
}

