/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupsettings;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditInstanceRecoverySettingsAction
extends ActionDialog {
    private static final String DESIRED_RECOVERY_TIME = "DESIRED_RECOVERY_TIME";
    private static final String SPFILE_ONLY = "SPFILE_ONLY";

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_INSTANCE_RECOVERY_SETTINGS_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        BooleanCheckBoxActionControl booleanCheckBoxActionControl;
        TextBoxActionControl textBoxActionControl;
        int n = 0;
        if (Connections.getInstance().lock(connection)) {
            textBoxActionControl = null;
            try {
                booleanCheckBoxActionControl = new HashMap();
                object = DBUtil.getInstance((Connection)connection);
                object.setRaiseError(true);
                textBoxActionControl = object.executeOracleQuery(this.getQuery(connection, "getInstanceRecoverySettings"), (Map)booleanCheckBoxActionControl);
                if (textBoxActionControl != null) {
                    ResultSet resultSet = textBoxActionControl.getResultSet();
                    while (resultSet.next()) {
                        n = resultSet.getInt(DESIRED_RECOVERY_TIME);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (textBoxActionControl != null) {
                    textBoxActionControl.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        textBoxActionControl = new TextBoxActionControl(DESIRED_RECOVERY_TIME, DbaNavigatorResources.getString("DESIRED_RECOVERY_TIME_LABEL"), Integer.toString(n), TextBoxActionControl.getIntegerFormat());
        booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(SPFILE_ONLY, DbaNavigatorResources.getString("SPFILE_ONLY_LABEL"), false);
        object = new ArrayList();
        ((ArrayList)object).add(textBoxActionControl);
        ((ArrayList)object).add(booleanCheckBoxActionControl);
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = Integer.parseInt(values.get(DESIRED_RECOVERY_TIME));
        boolean bl = Boolean.parseBoolean(values.get(SPFILE_ONLY));
        stringBuffer.append("ALTER SYSTEM SET fast_start_mttr_target = ");
        stringBuffer.append(n);
        stringBuffer.append(" SCOPE=");
        if (bl) {
            stringBuffer.append("SPFILE");
        } else {
            stringBuffer.append("BOTH");
        }
        return stringBuffer.toString();
    }
}

