/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backups;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class ChangeBackupSetStatusAction
extends ActionDialog {
    private static final String BACKUP_SET = "BackupSet";
    private static final String STATUS = "Status";
    private String backupSet = null;

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor();
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("CHANGE_STATUS_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        ComboBoxActionControl comboBoxActionControl;
        TextBoxActionControl textBoxActionControl;
        this.backupSet = this.getObjectName().substring(1);
        Status status = null;
        if (Connections.getInstance().lock(connection)) {
            textBoxActionControl = null;
            try {
                comboBoxActionControl = new HashMap();
                comboBoxActionControl.put("KEY", this.backupSet);
                object = DBUtil.getInstance((Connection)connection);
                object.setRaiseError(true);
                textBoxActionControl = object.executeOracleQuery(this.getQuery(connection, "getBackupStatus"), (Map)comboBoxActionControl);
                if (textBoxActionControl != null) {
                    ResultSet resultSet = textBoxActionControl.getResultSet();
                    while (resultSet.next()) {
                        status = Status.parseStatus(resultSet.getString("BS_STATUS"));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (textBoxActionControl != null) {
                    textBoxActionControl.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        textBoxActionControl = new TextBoxActionControl(BACKUP_SET, DbaNavigatorResources.getString("BACKUP_SET_LABEL"), this.backupSet);
        comboBoxActionControl = new ComboBoxActionControl(STATUS, DbaNavigatorResources.getString("STATUS_LABEL"), status.validOptions(), status.toString());
        textBoxActionControl.setEditable(false);
        object = new ArrayList();
        ((ArrayList)object).add(textBoxActionControl);
        ((ArrayList)object).add(comboBoxActionControl);
        ((ArrayList)object).add(new SeperatorActionControl());
        ((ArrayList)object).add(new RMANScriptProcessorActionControl(connection, "sqldev.rman"));
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        Status status = Status.parseStatus(values.get(STATUS));
        stringBuffer.append("CHANGE BACKUPSET ");
        stringBuffer.append(this.backupSet);
        stringBuffer.append(" ");
        stringBuffer.append(status.toString());
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    private static enum Status {
        AVAILABLE,
        UNAVAILABLE,
        EXPIRED,
        OTHER;


        static Status parseStatus(String string) {
            Status status = null;
            try {
                status = Status.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                status = OTHER;
            }
            return status;
        }

        String[] validOptions() {
            String[] stringArray = null;
            switch (this) {
                case AVAILABLE: 
                case UNAVAILABLE: {
                    stringArray = new String[]{"AVAILABLE", "UNAVAILABLE"};
                    break;
                }
                case EXPIRED: {
                    stringArray = new String[]{"EXPIRED"};
                    break;
                }
                case OTHER: {
                    stringArray = new String[]{"OTHER"};
                }
            }
            return stringArray;
        }
    }
}

