/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupjobs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.backupjobs.CreateCustomBackupAction;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;

public class CreateWholeDatabaseBackupAction
extends CreateCustomBackupAction {
    public static final String BACKUP_MODE = "BACKUP_MODE";
    private static final String onlineBackup = DbaNavigatorResources.getString("ONLINE_BACKUP");
    private static final String offlineBackup = DbaNavigatorResources.getString("OFFLINE_BACKUP");
    private ActionControl backupTypeCtl;
    private RMANScriptProcessorActionControl _getScriptProcessorActionControl;

    protected String getTitle() {
        return DbaNavigatorResources.getString("CREATE_WHOLE_DATABASE_BACKUP_TITLE");
    }

    @Override
    protected RMANScriptProcessorActionControl getScriptProcessorActionControl() {
        return this._getScriptProcessorActionControl;
    }

    @Override
    protected int getOptionsControlGroupsMask() {
        return 7;
    }

    @Override
    protected boolean isScriptProcessorDetached() {
        return this.backupTypeCtl.getValue().get().equals(offlineBackup);
    }

    protected List<ActionControl> createControls(Connection connection) {
        this.onCreateControls(connection);
        this._getScriptProcessorActionControl = new RMANScriptProcessorActionControl(connection, "sqldev.rman");
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        this.backupTypeCtl = new ComboBoxActionControl(BACKUP_MODE, DbaNavigatorResources.getString("BACKUP_MODE_LABEL"), new String[]{onlineBackup, offlineBackup}, this.isArchiveLogMode() ? onlineBackup : offlineBackup);
        this.backupTypeCtl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CreateWholeDatabaseBackupAction.this.onChangeScriptProcessorDetached();
            }
        });
        if (!this.isArchiveLogMode()) {
            this.backupTypeCtl.enableUI(false);
        }
        arrayList.add(this.backupTypeCtl);
        arrayList.add((ActionControl)new SeperatorActionControl());
        arrayList.add(this._getScriptProcessorActionControl);
        return arrayList;
    }
}

