/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.auditsettings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SelectionActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditAuditedStatements
extends ActionDialog {
    private static final String CLIENT_TYPES = "CLIENT_TYPES";
    private static final String CLIENTS = "CLIENTS";
    private static final String EXEC_CONDS = "EXEC_CONDS";
    private static final String GRANULARITIES = "GRANULARITIES";
    private static final String SELECTIONS = "SELECTIONS";
    private ComboBoxActionControl _clientTypesCtl;
    private ComboBoxActionControl _clientsCtl;
    private ComboBoxActionControl _execCondsCtl;
    private ComboBoxActionControl _granularitiesCtl;
    private SelectionActionControl _selectionCtl;
    private ArrayList<String> _initialValues;
    private boolean sqlEnabled;

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_AUDITED_STATEMENTS_TITLE");
    }

    protected List<ActionControl> createControls(final Connection connection) {
        this.sqlEnabled = true;
        this._clientTypesCtl = new ComboBoxActionControl(CLIENT_TYPES, DbaNavigatorResources.getString("CLIENT_TYPE_LABEL"), this.toStringArray(this.getClientTypes()));
        this._clientsCtl = new ComboBoxActionControl(CLIENTS, DbaNavigatorResources.getString("CLIENT_NAME_LABEL"), this.toStringArray(this.getClients(connection, this._clientTypesCtl.getValue().get())));
        this._execCondsCtl = new ComboBoxActionControl(EXEC_CONDS, DbaNavigatorResources.getString("EXEC_COND_LABEL"), this.toStringArray(this.getExecConditions()));
        this._granularitiesCtl = new ComboBoxActionControl(GRANULARITIES, DbaNavigatorResources.getString("DML_AUDIT_GRANULARITY_LABEL"), this.toStringArray(this.getGranularities()));
        this._selectionCtl = new SelectionActionControl(SELECTIONS, DbaNavigatorResources.getString("STATEMENTS_LABEL"), this.getInitialItems(connection), this.getSourceItems(connection));
        this._clientTypesCtl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EditAuditedStatements.this._clientsCtl.reset(EditAuditedStatements.this.toStringArray(EditAuditedStatements.this.getClients(connection, EditAuditedStatements.this._clientTypesCtl.getValue().get())));
                EditAuditedStatements.this.sqlEnabled = EditAuditedStatements.this._clientsCtl.getNumSelections() > 0;
                EditAuditedStatements.this._clientsCtl.enableUI(EditAuditedStatements.this.sqlEnabled);
                EditAuditedStatements.this._execCondsCtl.enableUI(EditAuditedStatements.this.sqlEnabled);
                EditAuditedStatements.this._granularitiesCtl.enableUI(EditAuditedStatements.this.sqlEnabled);
                EditAuditedStatements.this._selectionCtl.enableUI(EditAuditedStatements.this.sqlEnabled);
                if (EditAuditedStatements.this.sqlEnabled) {
                    if (EditAuditedStatements.this._clientTypesCtl.getValue().get().equals(DbaNavigatorResources.getString("PROXY_ITEM"))) {
                        EditAuditedStatements.this._granularitiesCtl.reset(DbaNavigatorResources.getString("BY_DEFAULT_ITEM"));
                        EditAuditedStatements.this._granularitiesCtl.setEditable(false);
                    } else {
                        EditAuditedStatements.this._granularitiesCtl.setEditable(true);
                    }
                    EditAuditedStatements.this._selectionCtl.resetListContents(EditAuditedStatements.this.getInitialItems(connection), EditAuditedStatements.this.getSourceItems(connection));
                }
            }
        });
        this._clientsCtl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (EditAuditedStatements.this._clientsCtl.getNumSelections() > 0) {
                    EditAuditedStatements.this._selectionCtl.resetListContents(EditAuditedStatements.this.getInitialItems(connection), EditAuditedStatements.this.getSourceItems(connection));
                }
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)this._clientTypesCtl);
        arrayList.add((ActionControl)this._clientsCtl);
        arrayList.add((ActionControl)this._execCondsCtl);
        arrayList.add((ActionControl)this._granularitiesCtl);
        arrayList.add((ActionControl)this._selectionCtl);
        return arrayList;
    }

    protected String[] toStringArray(List<String> list) {
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    protected List<String> getClientTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DbaNavigatorResources.getString("USER_ITEM"));
        arrayList.add(DbaNavigatorResources.getString("PROXY_ITEM"));
        return arrayList;
    }

    protected List<String> getExecConditions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DbaNavigatorResources.getString("SUCCESS_OR_FAILURE_ITEM"));
        arrayList.add(DbaNavigatorResources.getString("SUCCESS_ITEM"));
        arrayList.add(DbaNavigatorResources.getString("FAILURE_ITEM"));
        return arrayList;
    }

    protected List<String> getGranularities() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DbaNavigatorResources.getString("BY_DEFAULT_ITEM"));
        arrayList.add(DbaNavigatorResources.getString("BY_SESSION_ITEM"));
        arrayList.add(DbaNavigatorResources.getString("BY_ACCESS_ITEM"));
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getClients(Connection connection, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                HashMap hashMap = new HashMap();
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                resultSetWrapper = string.equals(DbaNavigatorResources.getString("USER_ITEM")) ? dBUtil.executeOracleQuery(this.getQuery(connection, "getUsers"), hashMap) : dBUtil.executeOracleQuery(this.getQuery(connection, "getProxies"), hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString("NAME"));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getSourceItems(Connection connection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                HashMap hashMap = new HashMap();
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                resultSetWrapper = dBUtil.executeOracleQuery(this.getQuery(connection, "getAuditableStatements"), hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString("NAME"));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        arrayList.removeAll(this.getInitialItems(connection));
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getInitialItems(Connection connection) {
        String string = this._clientTypesCtl.getValue().get();
        String string2 = this._clientsCtl.getValue().get();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                if (string.equals(DbaNavigatorResources.getString("USER_ITEM"))) {
                    if (string2.equals("*")) {
                        resultSetWrapper = dBUtil.executeOracleQuery(this.getQuery(connection, "getStatementsForSystem"), hashMap);
                    } else {
                        hashMap.put("USERNAME", string2);
                        resultSetWrapper = dBUtil.executeOracleQuery(this.getQuery(connection, "getStatementsForUser"), hashMap);
                    }
                } else {
                    int n = string2.indexOf(40);
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1, string2.length() - 1);
                    if (string4.equals("*")) {
                        string4 = "ANY CLIENT";
                    }
                    hashMap.put("USERNAME", string4);
                    hashMap.put("PROXYNAME", string3);
                    resultSetWrapper = dBUtil.executeOracleQuery(this.getQuery(connection, "getStatementsForProxy"), hashMap);
                }
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString("AUDIT_OPTION"));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        this._initialValues = arrayList;
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sqlEnabled) {
            List list = values.getList(SELECTIONS, "SELECTED_ITEMS");
            if (this._initialValues != null) {
                String string2;
                boolean bl = true;
                for (String string2 : this._initialValues) {
                    if (list.contains(string2)) continue;
                    if (bl) {
                        stringBuffer.append("NOAUDIT\n    ");
                        bl = false;
                    } else {
                        stringBuffer.append(",\n    ");
                    }
                    stringBuffer.append(string2);
                }
                String string3 = values.get(CLIENT_TYPES);
                string2 = values.get(CLIENTS);
                if (!bl) {
                    this.addByUserOrProxy(stringBuffer, string3, string2);
                    stringBuffer.append(";\n");
                }
                boolean bl2 = true;
                for (String string4 : list) {
                    if (this._initialValues.contains(string4)) continue;
                    if (bl2) {
                        stringBuffer.append("AUDIT\n    ");
                        bl2 = false;
                    } else {
                        stringBuffer.append(",\n    ");
                    }
                    stringBuffer.append(string4);
                }
                if (!bl2) {
                    String string4;
                    this.addByUserOrProxy(stringBuffer, string3, string2);
                    String string5 = values.get(GRANULARITIES);
                    string4 = values.get(EXEC_CONDS);
                    if (string5.equals(DbaNavigatorResources.getString("BY_SESSION_ITEM"))) {
                        stringBuffer.append("\nBY SESSION");
                    } else if (string5.equals(DbaNavigatorResources.getString("BY_ACCESS_ITEM"))) {
                        stringBuffer.append("\nBY ACCESS");
                    }
                    if (string4.equals(DbaNavigatorResources.getString("SUCCESS_ITEM"))) {
                        stringBuffer.append("\nWHENEVER SUCCESSFUL");
                    } else if (string4.equals(DbaNavigatorResources.getString("FAILURE_ITEM"))) {
                        stringBuffer.append("\nWHENEVER NOT SUCCESSFUL");
                    }
                    stringBuffer.append(";\n");
                }
            }
        }
        return stringBuffer.toString();
    }

    protected void addByUserOrProxy(StringBuffer stringBuffer, String string, String string2) {
        if (string.equals(DbaNavigatorResources.getString("USER_ITEM"))) {
            if (!string2.equals("*")) {
                stringBuffer.append("\nBY \"");
                stringBuffer.append(string2);
                stringBuffer.append("\"");
            }
        } else {
            int n = string2.indexOf(40);
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1, string2.length() - 1);
            string4 = string4.equals("*") ? "ANY" : "\"" + string4 + "\"";
            stringBuffer.append("\nBY \"");
            stringBuffer.append(string3);
            stringBuffer.append("\" ON BEHALF OF ");
            stringBuffer.append(string4);
        }
    }
}

