/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.tree.DefaultTreeModel;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.dba.navigator.Databases;
import oracle.dbtools.raptor.dba.navigator.DbaConnection;
import oracle.dbtools.raptor.dba.navigator.DbaNavWindow;
import oracle.dbtools.raptor.dba.navigator.DbaNavigatorManager;
import oracle.dbtools.raptor.dba.navigator.editors.DbControlEditor;
import oracle.dbtools.raptor.navigator.AbstractDatabaseFilter;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorController;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.view.View;

class DbaNavController
implements Controller {
    private static final String TOOLBAR_MENU = "DbaNavigator.TOOLBAR_MENU";
    private static final String REFRESH_CONNECTION = "DbaNavigator.REFRESH_CONNECTION";
    private static final String ADD_CONNECTION = "DbaNavigator.ADD_CONNECTION";
    private static final String MANAGE_CONNECTION = "DbaNavigator.MANAGE_CONNECTION";
    private static final String REMOVE_CONNECTION = "DbaNavigator.REMOVE_CONNECTION";
    public static final int ADD_CONNECTION_ID = Ide.findOrCreateCmdID((String)"DbaNavigator.ADD_CONNECTION");
    public static final int REFRESH_CONNECTION_ID = Ide.findOrCreateCmdID((String)"DbaNavigator.REFRESH_CONNECTION");
    public static final int MANAGE_CONNECTION_ID = Ide.findOrCreateCmdID((String)"DbaNavigator.MANAGE_CONNECTION");
    public static final int REMOVE_CONNECTION_ID = Ide.findOrCreateCmdID((String)"DbaNavigator.REMOVE_CONNECTION");
    public static final int COLLAPSEALL_CONNECTIONS_ID = Ide.findOrCreateCmdID((String)"DbaNavigator.COLLAPSEALL_CONNECTIONS");
    public static final int TOOLBAR_MENU_ID = Ide.findOrCreateCmdID((String)"DbaNavigator.TOOLBAR_MENU");
    private Controller m_parent;

    DbaNavController(Controller controller) {
        this.m_parent = controller;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        if (DbaNavigatorManager.isDatabaseNavigatorContext((Context)context)) {
            int n = ideAction.getCommandId();
            if (n == REFRESH_CONNECTION_ID || n == 51) {
                bl = true;
                this.refreshParent(context);
            } else if (n == DatabaseNavigatorController.CLEAR_FILTER_CMD_ID) {
                TNode tNode = ExplorerContext.getFirstTNode((Context)context);
                if (tNode != null) {
                    boolean bl2 = false;
                    ChildFilter childFilter = tNode.getChildFilter();
                    if (childFilter instanceof AbstractDatabaseFilter) {
                        ((AbstractDatabaseFilter)childFilter).getFolderInstance().clearFilter();
                        bl2 = true;
                    }
                    if (bl2) {
                        DatabaseOverlayClient.updateOverlay((Element)tNode.getData());
                        IdeAction ideAction2 = IdeAction.find((int)51);
                        if (ideAction2 != null) {
                            this.handleEvent(ideAction2, context);
                        }
                    }
                }
                bl = true;
            } else if (n == ADD_CONNECTION_ID) {
                String string = ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_TITLE"), (String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_LABEL"), null, (boolean)true, (boolean)true);
                Databases.getInstance().addConnection(string);
                bl = true;
            } else if (n == COLLAPSEALL_CONNECTIONS_ID) {
                TreeExplorer treeExplorer = ((DbaNavWindow)context.getView()).getTreeExplorer();
                if (treeExplorer != null) {
                    TNode tNode = treeExplorer.getRoot();
                    DefaultTreeModel defaultTreeModel = treeExplorer.getTreeModel();
                    if (tNode != null && defaultTreeModel.getChildCount(tNode) > 0) {
                        Enumeration enumeration = tNode.getChildTNodes();
                        while (enumeration.hasMoreElements()) {
                            TNode tNode2 = (TNode)enumeration.nextElement();
                            if (tNode2 == null) continue;
                            treeExplorer.collapse(tNode2, false);
                        }
                    }
                }
                bl = true;
            } else if (n == MANAGE_CONNECTION_ID) {
                Element element;
                Element[] elementArray = context.getSelection();
                if (elementArray != null && elementArray.length == 1 && (element = context.getElement()) instanceof DbaConnection) {
                    DbControlEditor.openNewEditor((DbaConnection)element);
                }
                bl = true;
            } else if (n == REMOVE_CONNECTION_ID) {
                Element[] elementArray = context.getSelection();
                if (elementArray != null) {
                    for (Element element : elementArray) {
                        if (!(element instanceof DbaConnection)) continue;
                        String string = ((DbaConnection)element).getQualifiedConnectionName();
                        Databases.getInstance().removeConnection(string);
                    }
                }
                bl = true;
            }
        }
        return bl || this.m_parent.handleEvent(ideAction, context);
    }

    public void refreshParent(Context context) {
        View view;
        TNode tNode = ExplorerContext.getSingleTNode((Context)context);
        TNode tNode2 = null;
        if (tNode != null && (view = context.getView()) instanceof NavigatorWindow) {
            tNode2 = tNode.getAncestorTNode(Object.class, true);
            if (tNode2 == null) {
                this.refreshNode(context);
            } else {
                TreeExplorer treeExplorer = ((NavigatorWindow)view).getTreeExplorer();
                treeExplorer.refresh(tNode2);
            }
        }
    }

    public void refreshNode(Context context) {
        View view;
        TNode tNode = ExplorerContext.getSingleTNode((Context)context);
        if (tNode != null && (view = context.getView()) instanceof NavigatorWindow) {
            TreeExplorer treeExplorer = ((NavigatorWindow)view).getTreeExplorer();
            treeExplorer.refresh(tNode);
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        if (DbaNavigatorManager.isDatabaseNavigatorContext((Context)context)) {
            int n = ideAction.getCommandId();
            if (n == REFRESH_CONNECTION_ID || n == 51) {
                TNode tNode = ExplorerContext.getSingleTNode((Context)context);
                if (tNode != null) {
                    boolean bl2 = false;
                    bl2 = true;
                    ideAction.setEnabled(bl2);
                    bl = true;
                }
            } else if (n == DatabaseNavigatorController.CLEAR_FILTER_CMD_ID) {
                boolean bl3 = false;
                TNode tNode = ExplorerContext.getFirstTNode((Context)context);
                if (tNode != null) {
                    ChildFilter childFilter = tNode.getChildFilter();
                    if (childFilter instanceof AbstractDatabaseFilter) {
                        bl3 = ((AbstractDatabaseFilter)childFilter).getFolderInstance().isFiltered();
                    }
                    ideAction.setEnabled(bl3);
                }
                bl = true;
            } else if (n == DatabaseNavigatorController.FILTER_CMD_ID) {
                boolean bl4 = false;
                TNode tNode = ExplorerContext.getFirstTNode((Context)context);
                if (tNode != null) {
                    ChildFilter childFilter = tNode.getChildFilter();
                    if (childFilter instanceof AbstractDatabaseFilter) {
                        bl4 = ((AbstractDatabaseFilter)childFilter).getFolderInstance().canHaveFilter();
                    }
                    ideAction.setEnabled(bl4);
                }
                bl = true;
            } else if (n == 55) {
                ideAction.setEnabled(true);
            } else if (n == 20) {
                ideAction.setEnabled(false);
                bl = true;
            }
        }
        return bl || this.m_parent.update(ideAction, context);
    }

    void initButton(JButton jButton) {
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbaNavController.this.handleButtonEvent();
            }
        });
    }

    public void handleButtonEvent() {
    }
}

