/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dba.navigator.DbaConnection;
import oracle.dbtools.raptor.dba.navigator.Messages;
import oracle.dbtools.raptor.navigator.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.DummyElement;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.ObjectFactoryRegistry;
import oracle.dbtools.raptor.navigator.TypeContainerFilter;
import oracle.dbtools.raptor.navigator.WrappedException;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.CategoryInstance;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.db.DBException;

public class DbaFilter
extends TypeContainerFilter {
    private String m_tooltip;

    protected ObjectFactory getFactory() throws IOException, DBException {
        ObjectFactoryRegistry objectFactoryRegistry = ObjectFactoryRegistry.getRegistry((String)"sqldev.dbanav");
        DbaConnection dbaConnection = (DbaConnection)this.getOwner().getData();
        return objectFactoryRegistry.getFactory(dbaConnection.getQualifiedConnectionName(), dbaConnection.getConnection());
    }

    public String getToolTipText() {
        if (this.m_tooltip == null) {
            AbstractConnectionNode abstractConnectionNode = (AbstractConnectionNode)this.getOwner().getData();
            this.m_tooltip = abstractConnectionNode.getShortLabel();
        }
        return this.m_tooltip;
    }

    protected Object getKey(Object object) {
        return null;
    }

    protected boolean loadInThread() {
        return true;
    }

    protected List<Element> loadChildrenImpl() throws IOException {
        final AbstractConnectionNode abstractConnectionNode = (AbstractConnectionNode)this.getOwner().getData();
        RaptorTask<List<Element>> raptorTask = new RaptorTask<List<Element>>(Messages.getString("DbaFilter.0"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            private void checkStatus(String string) throws AbortException {
                try {
                    this.checkCanProceed();
                }
                catch (ExecutionException executionException) {
                    throw new AbortException(string);
                }
            }

            protected List<Element> doWork() throws TaskException {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                try {
                    ObjectFactory objectFactory = null;
                    try {
                        this.checkStatus("getFactory");
                        objectFactory = DbaFilter.this.getFactory();
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                    DbaFilter.this.m_tooltip = abstractConnectionNode.getShortLabel() + Messages.getString("DbaFilter.2");
                    if (objectFactory != null) {
                        String string = DbaFilter.this.getURLProtocol();
                        String string2 = objectFactory.getConnectionName();
                        String string3 = objectFactory.getSchema();
                        for (Object object : objectFactory.listTypes(null)) {
                            String string4 = object.getType();
                            for (DatabaseFolder databaseFolder : object.getFolders()) {
                                DBFolderInstance dBFolderInstance = objectFactory.createFolderInstance(string4, databaseFolder);
                                if (dBFolderInstance == null) continue;
                                dBFolderInstance.setProperty("ConnectionType", (Object)objectFactory.getConnectionType());
                                URL uRL = DBURLFormatHelper.getURL((String)string, (String)string2, null, (String)string3, (String)dBFolderInstance.getType());
                                Folder folder = DatabaseNavigatorElementFactory.getTypeFolder((URL)uRL, (DBFolderInstance)dBFolderInstance);
                                arrayList.add((Element)folder);
                            }
                        }
                        DBSchemaInstance dBSchemaInstance = objectFactory.createSchemaInstance(null);
                        for (CategoryInstance categoryInstance : dBSchemaInstance.listCategories()) {
                            Object object;
                            object = DBURLFormatHelper.getURL((String)string, (String)string2, null, (String)string3, (String)categoryInstance.getDescriptor().getType());
                            arrayList.add((Element)new CategoryFolder((URL)object, categoryInstance));
                        }
                    }
                }
                catch (IOException iOException) {
                    Throwable throwable = iOException;
                    if (iOException instanceof WrappedException) {
                        throwable = iOException.getCause();
                    }
                    throw new TaskException(throwable);
                }
                catch (AbortException abortException) {
                    throw new TaskException((Throwable)abortException);
                }
                return arrayList;
            }

            public boolean cancel() {
                return true;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((RaptorTask)raptorTask){
            final /* synthetic */ RaptorTask val$task;
            {
                this.val$task = raptorTask;
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                DbaFilter.this.cleanupOnError((Element)abstractConnectionNode);
            }

            private boolean isCancel(Throwable throwable) {
                return throwable instanceof ConnectionCanceledException || throwable instanceof CancellationException;
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Throwable throwable;
                Throwable throwable2 = throwable = raptorTaskEvent.getThrowable();
                while (throwable instanceof DBException) {
                    if ((throwable = throwable.getCause()) == null) continue;
                    throwable2 = throwable;
                }
                if (!this.isCancel(throwable2)) {
                    TypeContainerFilter.ExceptionDialogRunnable exceptionDialogRunnable = new TypeContainerFilter.ExceptionDialogRunnable(Messages.getString("DbaFilter.3"), throwable);
                    if (SwingUtilities.isEventDispatchThread()) {
                        exceptionDialogRunnable.run();
                    } else {
                        try {
                            SwingUtilities.invokeAndWait((Runnable)exceptionDialogRunnable);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                DbaFilter.this.cleanupOnError((Element)abstractConnectionNode);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                UpdateMessage.fireChildRemoved((Subject)abstractConnectionNode, (Element)DummyElement.INSTANCE);
                try {
                    List list = (List)this.val$task.getResult();
                    UpdateMessage.fireChildrenAdded((Subject)abstractConnectionNode, (Collection)list);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        return Collections.singletonList(DummyElement.INSTANCE);
    }

    protected void fillInInitialProperties(DBItemInstance dBItemInstance) {
    }

    private Element createTypeFolder(DBFolderInstance dBFolderInstance, URL uRL) {
        return DatabaseNavigatorElementFactory.getTypeFolder((URL)uRL, (DBFolderInstance)dBFolderInstance);
    }
}

