/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Properties;
import javax.swing.Icon;
import oracle.dbtools.raptor.dba.navigator.DbaNavigatorManager;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.navigator.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.WrappedException;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.net.project.TransientNodeFactory;
import oracle.dbtools.raptor.navigator.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.xml.NavigatorHook;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.ide.db.model.DatabaseNode;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.db.DBException;
import oracle.javatools.util.WeakCache;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;

public final class DbaConnection
extends AbstractConnectionNode
implements DatabaseNode {
    private static ConnectionDisconnectListener s_listener;
    private static WeakCache<String, DbaConnection> s_cache;
    private Icon m_icon;
    private String m_type;
    private Project m_proj;

    protected static WeakCache<String, DbaConnection> getNodeCache() {
        if (s_cache == null) {
            s_cache = new WeakCache();
        }
        return s_cache;
    }

    protected static void cacheNode(String string, DbaConnection dbaConnection) {
        WeakCache<String, DbaConnection> weakCache = DbaConnection.getNodeCache();
        weakCache.put((Object)string, (Object)dbaConnection);
    }

    protected static void uncacheNode(String string) {
        WeakCache<String, DbaConnection> weakCache = DbaConnection.getNodeCache();
        weakCache.remove((Object)string);
    }

    public static DbaConnection findConnectionNode(URL uRL) {
        DbaConnection dbaConnection = null;
        String string = DBURLFormatHelper.getConnectionName((URL)uRL);
        if (string != null) {
            dbaConnection = (DbaConnection)((Object)DbaConnection.getNodeCache().get((Object)string));
        }
        return dbaConnection;
    }

    public static DbaConnection findOrCreateConnectionNode(URL uRL) {
        DbaConnection dbaConnection = null;
        String string = DBURLFormatHelper.getConnectionName((URL)uRL);
        if (string != null) {
            boolean bl;
            WeakCache<String, DbaConnection> weakCache = DbaConnection.getNodeCache();
            dbaConnection = (DbaConnection)((Object)weakCache.get((Object)string));
            Properties properties = Connections.getInstance().getConnectionInfo(string);
            boolean bl2 = bl = properties != null && "Oracle".equals(properties.getProperty("RaptorConnectionType"));
            if (dbaConnection == null) {
                if (bl) {
                    dbaConnection = new DbaConnection();
                    dbaConnection.setURL(uRL);
                }
            } else if (!bl) {
                weakCache.remove((Object)string);
                dbaConnection = null;
            }
        }
        return dbaConnection;
    }

    private static synchronized void initListener() {
        if (s_listener == null) {
            s_listener = new ConnectionDisconnectListener(){

                public void connectionDisconnected(ConnectionDetails connectionDetails) {
                    String string = connectionDetails.getQualifiedConnectionName();
                    URL uRL = DBURLFormatHelper.getURL((String)"sqldev.dbanav", (String)string);
                    DbaConnection dbaConnection = DbaConnection.findConnectionNode(uRL);
                    if (dbaConnection != null) {
                        dbaConnection.closeConnection();
                        UpdateMessage.fireObjectClosed((Subject)dbaConnection);
                    }
                }

                public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
                }
            };
            Connections.getInstance().addConnectionDisconnectListener(s_listener);
        }
    }

    public void setURL(URL uRL) {
        String string;
        boolean bl = false;
        URL uRL2 = this.getURL();
        if (uRL2 != null) {
            bl = uRL != null;
            string = DBURLFormatHelper.getConnectionName((URL)uRL2);
            if (string != null) {
                DbaConnection.uncacheNode(string);
            }
        }
        super.setURL(uRL);
        if (uRL != null && (string = DBURLFormatHelper.getConnectionName((URL)uRL)) != null) {
            DbaConnection.cacheNode(string, this);
        }
        if (bl) {
            UpdateMessage.fireObjectRenamed((Subject)this);
        }
    }

    public DbaConnection() {
        DbaConnection.initListener();
        Attributes attributes = this.getAttributes();
        attributes.clear();
        attributes.set(ElementAttributes.CLOSEABLE | ElementAttributes.NAVIGABLE);
    }

    public DbaConnection(String string) {
        this();
        this.setURL(DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string));
    }

    protected boolean closeConnectionImpl() {
        return Connections.getInstance().closeConnection(this.getQualifiedConnectionName());
    }

    protected Connection openConnectionImpl() throws IOException {
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(this.getQualifiedConnectionName());
            if (connection == null) {
                throw new WrappedException((Throwable)new ConnectionCanceledException());
            }
        }
        catch (DBException dBException) {
            throw new WrappedException((Throwable)dBException);
        }
        catch (RuntimeException runtimeException) {
            throw new WrappedException((Throwable)runtimeException);
        }
        return connection;
    }

    public String getQualifiedConnectionName() {
        return DBURLFormatHelper.getConnectionName((URL)this.getURL());
    }

    public String getConnectionName() {
        return Connections.getConnectionName((String)this.getQualifiedConnectionName());
    }

    public String getStoreName() {
        return Connections.getStoreName((String)this.getQualifiedConnectionName());
    }

    public String getShortLabel() {
        return this.getConnectionName();
    }

    public Icon getIcon() {
        Properties properties = Connections.getInstance().getConnectionInfo(this.getQualifiedConnectionName());
        if (properties == null) {
            return null;
        }
        String string = properties.getProperty("RaptorConnectionType");
        if (this.m_type == null || !this.m_type.equals(string) || this.m_icon == null) {
            this.m_icon = DbaConnection.loadIcon(this.getQualifiedConnectionName());
            this.m_type = properties.getProperty("RaptorConnectionType");
        }
        return this.m_icon;
    }

    public static Icon loadIcon(String string) {
        ConnectionType connectionType;
        String string2;
        Icon icon = null;
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties != null && (string2 = properties.getProperty("RaptorConnectionType")) != null && (connectionType = NavigatorHook.getConnectionType((String)string2)) != null) {
            icon = connectionType.getIcon();
        }
        if (icon == null) {
            icon = RaptorImage.getIcon((String)"db.png");
        }
        return icon;
    }

    public String getToolTipText() {
        return this.getShortLabel();
    }

    public String getLongLabel() {
        String string = this.getQualifiedConnectionName();
        return Connections.getDisplayName((String)string);
    }

    public String getMetaData(String string) {
        try {
            String string2 = null;
            Connection connection = Connections.getInstance().getConnection(this.getQualifiedConnectionName());
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            string2 = databaseMetaData.getDatabaseProductName();
            string2 = string2 + " " + databaseMetaData.getDatabaseMajorVersion();
            string2 = string2 + "." + databaseMetaData.getDatabaseMinorVersion();
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Project getProject() {
        if (this.m_proj == null) {
            try {
                this.m_proj = (Project)TransientNodeFactory.findOrCreate(Project.class, (String)(this.getQualifiedConnectionName() + ".jpr"));
                String string = RunConfigurations.getActiveName((Project)this.m_proj);
                RunConfiguration runConfiguration = RunConfigurations.getRunConfigurationByName((Project)this.m_proj, (String)string);
                if (runConfiguration == null) {
                    runConfiguration = new RunConfiguration();
                    runConfiguration.setName(string);
                    RunConfigurations.addRunConfiguration((Project)this.m_proj, (RunConfiguration)runConfiguration);
                }
                runConfiguration.setCompileBeforeRun(false);
            }
            catch (IllegalAccessException illegalAccessException) {
                DbaNavigatorManager.LOGGER.severe(illegalAccessException.getLocalizedMessage());
            }
            catch (InstantiationException instantiationException) {
                DbaNavigatorManager.LOGGER.severe(instantiationException.getLocalizedMessage());
            }
        }
        return this.m_proj;
    }
}

