/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Ide;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.LockFailedException;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.net.URLPath;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchProgress;
import oracle.jdeveloper.library.Library;
import oracle.jdevimpl.library.LibrarySearchQueryFilter;
import oracle.jdevimpl.library.ListNode;

class LibrarySearchQueryFilterClassImpl
extends LibrarySearchQueryFilter {
    Boolean m_containsWildcardAnywhere = false;
    Boolean m_containsWildcardAtEnd = false;
    Boolean m_containsWildcardAtFront = false;
    Boolean m_containsDot;
    private Boolean m_filterAllResults = false;
    private LibraryJAR2TreeNodeCache m_libsJAR2TreeNode = null;
    private URLPath m_allJARsURLPath = null;
    private Pattern m_pattern;

    public LibrarySearchQueryFilterClassImpl(String queryText) {
        super(queryText);
        int indexOfWildcardFromStart;
        int indexOfDot = this.m_queryText.lastIndexOf(".");
        if (indexOfDot != -1) {
            this.m_containsDot = true;
            if (indexOfDot == this.m_queryText.length() - 1) {
                this.m_queryText = new StringBuffer().append(this.m_queryText).append("*").toString();
            }
        } else {
            this.m_containsDot = false;
        }
        if ((indexOfWildcardFromStart = LibrarySearchQueryFilterClassImpl.firstIndexOfAnyWildcard(this.m_queryText)) != -1) {
            this.m_containsWildcardAnywhere = true;
            int indexOfWildcardFromEnd = LibrarySearchQueryFilterClassImpl.lastIndexOfAnyWildcard(this.m_queryText);
            if (indexOfWildcardFromEnd == indexOfWildcardFromStart) {
                this.m_containsWildcardAtFront = indexOfWildcardFromStart == 0;
                this.m_containsWildcardAtEnd = indexOfWildcardFromEnd == this.m_queryText.length() - 1;
                if (!this.m_containsDot.booleanValue()) {
                    if (this.m_queryText.charAt(indexOfWildcardFromEnd) == '?') {
                        this.m_queryText = this.prependStarDot(this.m_queryText);
                    } else if (!this.m_containsWildcardAtFront.booleanValue()) {
                        this.m_queryText = this.prependStarDot(this.m_queryText);
                    }
                }
            } else if (!this.m_containsDot.booleanValue() && !this.m_containsWildcardAtFront.booleanValue()) {
                this.m_queryText = this.prependStarDot(this.m_queryText);
            }
        }
    }

    private static int firstIndexOfAnyWildcard(String source) {
        int indexOfStar = source.indexOf("*");
        int indexOfQuestionMark = source.indexOf("?");
        if (indexOfStar != -1) {
            return indexOfQuestionMark != -1 ? Math.min(indexOfStar, indexOfQuestionMark) : indexOfStar;
        }
        if (indexOfQuestionMark != -1) {
            return indexOfStar != -1 ? Math.min(indexOfStar, indexOfQuestionMark) : indexOfQuestionMark;
        }
        return -1;
    }

    private static int lastIndexOfAnyWildcard(String source) {
        int indexOfStar = source.lastIndexOf("*");
        int indexOfQuestionMark = source.lastIndexOf("?");
        if (indexOfStar != -1) {
            return indexOfQuestionMark != -1 ? Math.max(indexOfStar, indexOfQuestionMark) : indexOfStar;
        }
        if (indexOfQuestionMark != -1) {
            return indexOfStar != -1 ? Math.max(indexOfStar, indexOfQuestionMark) : indexOfQuestionMark;
        }
        return -1;
    }

    private String prependStarDot(String source) {
        return new StringBuffer().append("*.").append(source).toString();
    }

    private QueryCriteria createQueryCriteria() {
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.put((Object)"file.extension", (Object)".class");
        if (!this.m_containsDot.booleanValue()) {
            if (this.m_containsWildcardAnywhere.booleanValue()) {
                if (this.m_containsWildcardAtEnd.booleanValue()) {
                    this.m_filterAllResults = true;
                    queryCriteria.put((Object)"file.name.starts.with", (Object)this.m_originalQueryText.substring(0, this.m_originalQueryText.length() - 1));
                } else if (this.m_containsWildcardAtFront.booleanValue()) {
                    this.m_filterAllResults = true;
                    queryCriteria.put((Object)"file.name.ends.with", (Object)this.m_originalQueryText.substring(1, this.m_originalQueryText.length()));
                } else {
                    this.m_filterAllResults = true;
                }
            } else {
                this.m_filterAllResults = false;
                queryCriteria.put((Object)"file.name", (Object)this.m_originalQueryText);
            }
        } else if (!this.m_containsWildcardAnywhere.booleanValue()) {
            int lastIndexOfDot = this.m_originalQueryText.lastIndexOf(".");
            if (lastIndexOfDot < this.m_originalQueryText.length() - 1) {
                this.m_filterAllResults = true;
                queryCriteria.put((Object)"file.name", (Object)this.m_originalQueryText.substring(lastIndexOfDot + 1));
            } else {
                this.m_filterAllResults = true;
            }
        } else {
            this.m_filterAllResults = true;
        }
        return queryCriteria;
    }

    @Override
    public void filterSearchResults(DefaultMutableTreeNode treeRoot) {
        ArrayList<DefaultMutableTreeNode> treeNodesToRemove = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < treeRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode rootChild = (DefaultMutableTreeNode)treeRoot.getChildAt(i);
            if (rootChild.getChildCount() > 0) {
                this.filterSearchResults(rootChild);
                if (rootChild.getChildCount() != 0 || rootChild instanceof ListNode) continue;
                treeNodesToRemove.add(rootChild);
                continue;
            }
            if (rootChild instanceof ListNode) continue;
            String className = (String)rootChild.getUserObject();
            if (this.m_containsWildcardAnywhere.booleanValue()) {
                if (this.m_filterAllResults.booleanValue()) {
                    if (!this.isAnonymousClass(className) && this.m_pattern.matcher(className).matches()) continue;
                    treeNodesToRemove.add(rootChild);
                    continue;
                }
                if (!this.isAnonymousClass(className)) continue;
                treeNodesToRemove.add(rootChild);
                continue;
            }
            if (!this.m_filterAllResults.booleanValue() || className.endsWith(this.m_originalQueryText)) continue;
            treeNodesToRemove.add(rootChild);
        }
        for (DefaultMutableTreeNode nodeToBeRemoved : treeNodesToRemove) {
            nodeToBeRemoved.removeFromParent();
        }
    }

    private boolean isAnonymousClass(String source) {
        int lastIndexOfDollarSign = source.lastIndexOf("$");
        if (lastIndexOfDollarSign != -1 && lastIndexOfDollarSign < source.length() - 1) {
            String suffix = source.substring(lastIndexOfDollarSign + 1);
            Boolean isAnonymous = true;
            for (int i = 0; i < suffix.length(); ++i) {
                if (Character.isDigit(suffix.charAt(i))) continue;
                isAnonymous = false;
                break;
            }
            return isAnonymous;
        }
        return false;
    }

    @Override
    public void preSearch(DefaultMutableTreeNode root) {
        if (this.m_containsWildcardAnywhere.booleanValue()) {
            this.m_pattern = this.compilePattern();
        }
        this.buildAllJARsURLPath(root);
    }

    private void buildAllJARsURLPath(DefaultMutableTreeNode root) {
        this.m_libsJAR2TreeNode = new LibraryJAR2TreeNodeCache();
        this.m_allJARsURLPath = new URLPath();
        List<Library> allLibraries = this.extractLibraries(root);
        for (Library library : allLibraries) {
            this.m_allJARsURLPath.add(library.getClassPath());
        }
    }

    private Index getIndex() {
        IndexManager indexManager = IndexManager.getIndexManager();
        return indexManager.getIndex(Ide.getDefaultProject(), this.m_allJARsURLPath);
    }

    private List<Library> extractLibraries(DefaultMutableTreeNode root) {
        ArrayList<Library> allChildrenUnderRoot = new ArrayList<Library>();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode nextChild = (DefaultMutableTreeNode)root.getChildAt(i);
            if (nextChild.getUserObject() instanceof Library) {
                allChildrenUnderRoot.add((Library)nextChild.getUserObject());
            }
            if (nextChild.getChildCount() <= 0) continue;
            allChildrenUnderRoot.addAll(this.extractLibraries(nextChild));
        }
        return allChildrenUnderRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean queryLibraries(DefaultMutableTreeNode root, SearchProgress searchProgress) {
        URL[] urls;
        block17: {
            int POLL_INTERVAL = 100;
            Index index = this.getIndex();
            QueryCriteria criteria = this.createQueryCriteria();
            urls = new URL[]{};
            if (this.wasStoppedByUser(searchProgress)) {
                return false;
            }
            try {
                index.lock();
                if (this.wasStoppedByUser(searchProgress)) {
                    boolean bl = false;
                    return bl;
                }
                BackgroundTask queryTask = index.query(criteria);
                while (!this.shouldTerminatePolling(queryTask, searchProgress) && !searchProgress.isStopped()) {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                if (!this.wasStoppedByUser(searchProgress)) {
                    urls = (URL[])queryTask.get();
                    break block17;
                }
                queryTask.cancel(true);
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException e) {
            }
            catch (LockFailedException e) {
            }
            catch (ExecutionException e) {
            }
            finally {
                index.unlock();
                index.release();
            }
        }
        ArrayList<DefaultMutableTreeNode> libraryTreeNodesToBeRemoved = new ArrayList<DefaultMutableTreeNode>();
        libraryTreeNodesToBeRemoved.addAll(this.getLibraryTreeNodeSubset(root));
        for (URL nextHitURL : urls) {
            ArrayList<DefaultMutableTreeNode> treeChildrenThatContainTheHit = this.m_libsJAR2TreeNode.getTreeNodes(this.getJarFileNameFromFileInJarUrl(nextHitURL));
            if (treeChildrenThatContainTheHit == null) continue;
            for (DefaultMutableTreeNode libraryTreeNode : treeChildrenThatContainTheHit) {
                DefaultMutableTreeNode classChild = new DefaultMutableTreeNode();
                classChild.setUserObject(this.formatToFullyQualifiedClassName(this.getFileNameFromFileInJarUrl(nextHitURL)));
                this.removeLibraryTreeNodeByLibraryName(libraryTreeNodesToBeRemoved, ((Library)libraryTreeNode.getUserObject()).getName());
                libraryTreeNode.insert(classChild, libraryTreeNode.getChildCount());
            }
        }
        for (DefaultMutableTreeNode libraryTreeNode : libraryTreeNodesToBeRemoved) {
            libraryTreeNode.removeFromParent();
        }
        return true;
    }

    private boolean shouldTerminatePolling(BackgroundTask task, SearchProgress searchProgress) {
        return task.isDone() || task.isCancelled() || searchProgress.isStopped() || Thread.currentThread().isInterrupted();
    }

    private boolean wasStoppedByUser(SearchProgress searchProgress) {
        return searchProgress.isStopped() || Thread.currentThread().isInterrupted();
    }

    private String getJarFileNameFromFileInJarUrl(URL fileInJAR) {
        String jarClassFromJarNameSeparator = "!/";
        String fileInJARAsString = fileInJAR.getFile();
        int indexOfSeparator = fileInJARAsString.indexOf("!/");
        if (indexOfSeparator != -1) {
            return fileInJARAsString.substring(0, indexOfSeparator + "!/".length());
        }
        return null;
    }

    private String getFileNameFromFileInJarUrl(URL fileInJAR) {
        String jarClassFromJarNameSeparator = "!/";
        String fileInJARAsString = fileInJAR.getFile();
        int indexOfSeparator = fileInJARAsString.indexOf("!/");
        if (indexOfSeparator != -1) {
            return fileInJARAsString.substring(indexOfSeparator + "!/".length());
        }
        return null;
    }

    private String formatToFullyQualifiedClassName(String classNameFromJarFile) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(classNameFromJarFile.replace('/', '.').substring(0, classNameFromJarFile.length() - ".class".length()));
        return buffer.toString();
    }

    private void removeLibraryTreeNodeByLibraryName(ArrayList<DefaultMutableTreeNode> libraryTreeNodes, String libraryName) {
        for (int i = 0; i < libraryTreeNodes.size(); ++i) {
            String libraryNameFromUserObject;
            DefaultMutableTreeNode libraryNode = libraryTreeNodes.get(i);
            if (!(libraryNode.getUserObject() instanceof Library) || !libraryName.equals(libraryNameFromUserObject = ((Library)libraryNode.getUserObject()).getName())) continue;
            libraryTreeNodes.remove(i);
            return;
        }
    }

    @Override
    public final List<DefaultMutableTreeNode> getLibraryTreeNodeSubset(DefaultMutableTreeNode root) {
        ArrayList<DefaultMutableTreeNode> allChildrenUnderRoot = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode nextChild = (DefaultMutableTreeNode)root.getChildAt(i);
            if (nextChild.getUserObject() instanceof Library) {
                allChildrenUnderRoot.add(nextChild);
                this.m_libsJAR2TreeNode.register(nextChild, (Library)nextChild.getUserObject());
            }
            if (nextChild.getChildCount() <= 0) continue;
            allChildrenUnderRoot.addAll(this.getLibraryTreeNodeSubset(nextChild));
        }
        return allChildrenUnderRoot;
    }

    @Override
    public void postSearch() {
        this.m_libsJAR2TreeNode.clear();
    }

    @Override
    public Icon getHitChildIcon() {
        return OracleIcons.getIcon((String)"class.png");
    }

    final class LibraryJAR2TreeNodeCache {
        private Map<String, ArrayList<DefaultMutableTreeNode>> jarURL2TreeNode = new HashMap<String, ArrayList<DefaultMutableTreeNode>>();

        LibraryJAR2TreeNodeCache() {
        }

        void register(DefaultMutableTreeNode root, Library library) {
            List allFiles = library.getClassPath().asList();
            for (URL jarURL : allFiles) {
                String jarURLAsString = jarURL.getFile();
                if (this.jarURL2TreeNode.containsKey(jarURLAsString)) {
                    this.jarURL2TreeNode.get(jarURLAsString).add(root);
                    continue;
                }
                ArrayList<DefaultMutableTreeNode> value = new ArrayList<DefaultMutableTreeNode>();
                value.add(root);
                this.jarURL2TreeNode.put(jarURLAsString, value);
            }
        }

        ArrayList<DefaultMutableTreeNode> getTreeNodes(String jarFileUrlAsString) {
            return this.jarURL2TreeNode.get(jarFileUrlAsString);
        }

        private void clear() {
            this.jarURL2TreeNode.clear();
        }
    }
}

