/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import oracle.javatools.ui.search.SearchCategory;
import oracle.jdevimpl.library.LibraryArb;
import oracle.jdevimpl.library.LibrarySearchQueryFilter;
import oracle.jdevimpl.library.LibrarySearchQueryFilterClassImpl;
import oracle.jdevimpl.library.LibrarySearchQueryFilterJarImpl;
import oracle.jdevimpl.library.LibrarySearchQueryFilterLibraryNameImpl;

class LibrarySearchQueryFactory {
    static final SearchCategory CLASS_CATEGORY = new SearchCategory(LibraryArb.getString(85));
    static final SearchCategory JAR_CATEGORY = new SearchCategory(LibraryArb.getString(86));
    static final SearchCategory LIBRARY_CATEGORY = new SearchCategory(LibraryArb.getString(87));
    static final SearchCategory[] SEARCH_CATEGORIES = new SearchCategory[]{CLASS_CATEGORY, JAR_CATEGORY, LIBRARY_CATEGORY};

    private LibrarySearchQueryFactory() {
    }

    public static LibrarySearchQueryFilter createFilter(SearchCategory category, String queryText) {
        if (CLASS_CATEGORY.getLabel().equals(category.getLabel())) {
            return new LibrarySearchQueryFilterClassImpl(queryText);
        }
        if (JAR_CATEGORY.getLabel().equals(category.getLabel())) {
            return new LibrarySearchQueryFilterJarImpl(queryText);
        }
        if (LIBRARY_CATEGORY.getLabel().equals(category.getLabel())) {
            return new LibrarySearchQueryFilterLibraryNameImpl(queryText);
        }
        return null;
    }
}

